%------------------------------------------------------------------------------
% File     : CSR116+22 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Who was the first black president elected in South Africa?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_010_mira_news_1784_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.25 v9.1.0, 0.47 v9.0.0, 0.25 v8.2.0, 0.20 v8.1.0, 0.36 v7.5.0, 0.52 v7.4.0, 0.38 v7.3.0, 0.57 v7.2.0, 0.50 v7.0.0, 0.43 v6.4.0, 0.36 v6.3.0, 0.38 v6.2.0, 0.55 v6.1.0, 0.68 v6.0.0, 0.50 v5.5.0, 0.67 v5.4.0, 0.65 v5.3.0, 0.74 v5.2.0, 0.57 v5.0.0, 0.65 v4.1.0, 0.67 v4.0.1, 0.74 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10803 (   0 equ)
%            Maximal formula atoms :   90 (   1 avg)
%            Number of connectives :  614 (   0   ~;  18   |; 470   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   90 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16648 (16648 usr;16647 con; 0-2 aty)
%            Number of variables   :  478 ( 405   !;  73   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_010_mira_news_1784,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7,X8,X9] :
      ( in(X5,X6)
      & arg1(X3,X0)
      & arg2(X3,X4)
      & attr(X0,X1)
      & attr(X0,X2)
      & attr(X6,X7)
      & obj(X8,X0)
      & sub(X1,familiename_1_1)
      & sub(X2,eigenname_1_1)
      & sub(X4,X9)
      & sub(X7,name_1_1)
      & subr(X3,rprs_0)
      & val(X1,mandela_0)
      & val(X2,nelson_0)
      & val(X7,s__374dafrika_0) ) ).

fof(ave07_era5_synth_qa07_010_mira_news_1784,hypothesis,
    ( pars(c124,c9)
    & pred(c124,autobiographie_1_1)
    & attch(c133,c124)
    & attr(c133,c134)
    & attr(c133,c135)
    & prop(c133,s__374dafrikanisch_1_1)
    & sub(c133,pr__344sident_1_1)
    & sub(c134,eigenname_1_1)
    & val(c134,nelson_0)
    & sub(c135,familiename_1_1)
    & val(c135,mandela_0)
    & name(c9,ein_f__374hrer_ist_ein_hirte_0)
    & sort(c124,d)
    & sort(c124,io)
    & card(c124,cons(x_constant,cons(int1,nil)))
    & etype(c124,int1)
    & fact(c124,real)
    & gener(c124,sp)
    & quant(c124,mult)
    & refer(c124,det)
    & varia(c124,con)
    & sort(c9,o)
    & card(c9,int1)
    & etype(c9,int0)
    & fact(c9,real)
    & gener(c9,gener_c)
    & quant(c9,one)
    & refer(c9,refer_c)
    & varia(c9,varia_c)
    & sort(autobiographie_1_1,d)
    & sort(autobiographie_1_1,io)
    & card(autobiographie_1_1,int1)
    & etype(autobiographie_1_1,int0)
    & fact(autobiographie_1_1,real)
    & gener(autobiographie_1_1,ge)
    & quant(autobiographie_1_1,one)
    & refer(autobiographie_1_1,refer_c)
    & varia(autobiographie_1_1,varia_c)
    & sort(c133,d)
    & card(c133,int1)
    & etype(c133,int0)
    & fact(c133,real)
    & gener(c133,sp)
    & quant(c133,one)
    & refer(c133,det)
    & varia(c133,con)
    & sort(c134,na)
    & card(c134,int1)
    & etype(c134,int0)
    & fact(c134,real)
    & gener(c134,sp)
    & quant(c134,one)
    & refer(c134,indet)
    & varia(c134,varia_c)
    & sort(c135,na)
    & card(c135,int1)
    & etype(c135,int0)
    & fact(c135,real)
    & gener(c135,sp)
    & quant(c135,one)
    & refer(c135,indet)
    & varia(c135,varia_c)
    & sort(s__374dafrikanisch_1_1,nq)
    & sort(pr__344sident_1_1,d)
    & card(pr__344sident_1_1,int1)
    & etype(pr__344sident_1_1,int0)
    & fact(pr__344sident_1_1,real)
    & gener(pr__344sident_1_1,ge)
    & quant(pr__344sident_1_1,one)
    & refer(pr__344sident_1_1,refer_c)
    & varia(pr__344sident_1_1,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(nelson_0,fe)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(mandela_0,fe)
    & sort(ein_f__374hrer_ist_ein_hirte_0,fe) ) ).

%------------------------------------------------------------------------------
