%------------------------------------------------------------------------------
% File     : CSR116+20 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Who was the first black president elected in South Africa?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_010_mira_news_1772_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.47 v9.0.0, 0.25 v8.2.0, 0.27 v8.1.0, 0.36 v7.5.0, 0.52 v7.4.0, 0.38 v7.3.0, 0.57 v7.2.0, 0.50 v6.4.0, 0.36 v6.3.0, 0.38 v6.2.0, 0.64 v6.1.0, 0.68 v6.0.0, 0.50 v5.5.0, 0.67 v5.4.0, 0.65 v5.3.0, 0.74 v5.2.0, 0.50 v5.0.0, 0.60 v4.1.0, 0.67 v4.0.1, 0.68 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 11007 (   0 equ)
%            Maximal formula atoms :  295 (   1 avg)
%            Number of connectives :  818 (   0   ~;  18   |; 674   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  295 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   88 (  88 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16671 (16671 usr;16670 con; 0-2 aty)
%            Number of variables   :  477 ( 405   !;  72   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_010_mira_news_1772,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7,X8] :
      ( arg1(X3,X0)
      & arg2(X3,X4)
      & attr(X0,X1)
      & attr(X0,X2)
      & attr(X5,X6)
      & obj(X7,X0)
      & sub(X1,familiename_1_1)
      & sub(X2,eigenname_1_1)
      & sub(X4,X8)
      & sub(X6,name_1_1)
      & subr(X3,rprs_0)
      & val(X1,mandela_0)
      & val(X2,nelson_0)
      & val(X6,s__374dafrika_0) ) ).

fof(ave07_era5_synth_qa07_010_mira_news_1772,hypothesis,
    ( obj(c1706,c1710)
    & subs(c1706,bildung_1_1)
    & sub(c1710,regierung_1_1)
    & attch(c19,c26)
    & attr(c19,c20)
    & prop(c19,afrikanisch__1_1)
    & sub(c19,nationalkongre__337_1_1)
    & sub(c20,name_1_1)
    & val(c20,anc_0)
    & agt(c2016,c19)
    & circ(c2016,c1706)
    & modl(c2016,wollen_0)
    & obj(c2016,c54)
    & ornt(c2016,c2058)
    & subs(c2016,lassen_1_4)
    & attch(c2054,c1710)
    & attr(c2054,c2055)
    & prop(c2054,frei_1_1)
    & prop(c2054,national__1_1)
    & sub(c2054,einheit_1_2)
    & sub(c2055,familiename_1_1)
    & val(c2055,hand_0)
    & itms(c2058,c26,c40)
    & sub(c26,parteibo__337_1_1)
    & pred(c40,pr__344sident_1_1)
    & prop(c40,c41)
    & modp(c41,voraussichtlich_1_1,kuenftig_1_1)
    & attch(c46,c2058)
    & attr(c46,c47)
    & sub(c46,land_1_1)
    & sub(c47,name_1_1)
    & val(c47,s__374dafrika_0)
    & attr(c54,c55)
    & attr(c54,c56)
    & sub(c54,mensch_1_1)
    & sub(c55,eigenname_1_1)
    & val(c55,nelson_0)
    & sub(c56,familiename_1_1)
    & val(c56,mandela_0)
    & assoc(nationalkongre__337_1_1,national__1_1)
    & sub(nationalkongre__337_1_1,kongre__337_1_1)
    & assoc(parteibo__337_1_1,partei_1_1)
    & sub(parteibo__337_1_1,an_f__374hrer_1_1)
    & sort(c1706,ad)
    & card(c1706,int1)
    & etype(c1706,int0)
    & fact(c1706,real)
    & gener(c1706,sp)
    & quant(c1706,one)
    & refer(c1706,det)
    & varia(c1706,con)
    & sort(c1710,d)
    & sort(c1710,io)
    & card(c1710,int1)
    & etype(c1710,int1)
    & fact(c1710,real)
    & gener(c1710,sp)
    & quant(c1710,one)
    & refer(c1710,indet)
    & varia(c1710,varia_c)
    & sort(bildung_1_1,ad)
    & card(bildung_1_1,int1)
    & etype(bildung_1_1,int0)
    & fact(bildung_1_1,real)
    & gener(bildung_1_1,ge)
    & quant(bildung_1_1,one)
    & refer(bildung_1_1,refer_c)
    & varia(bildung_1_1,varia_c)
    & sort(regierung_1_1,d)
    & sort(regierung_1_1,io)
    & card(regierung_1_1,card_c)
    & etype(regierung_1_1,int1)
    & fact(regierung_1_1,real)
    & gener(regierung_1_1,ge)
    & quant(regierung_1_1,quant_c)
    & refer(regierung_1_1,refer_c)
    & varia(regierung_1_1,varia_c)
    & sort(c19,d)
    & sort(c19,io)
    & card(c19,int1)
    & etype(c19,int0)
    & fact(c19,real)
    & gener(c19,sp)
    & quant(c19,one)
    & refer(c19,det)
    & varia(c19,con)
    & sort(c26,d)
    & card(c26,int1)
    & etype(c26,int0)
    & fact(c26,real)
    & gener(c26,sp)
    & quant(c26,one)
    & refer(c26,det)
    & varia(c26,varia_c)
    & sort(c20,na)
    & card(c20,int1)
    & etype(c20,int0)
    & fact(c20,real)
    & gener(c20,sp)
    & quant(c20,one)
    & refer(c20,indet)
    & varia(c20,varia_c)
    & sort(afrikanisch__1_1,nq)
    & sort(nationalkongre__337_1_1,d)
    & sort(nationalkongre__337_1_1,io)
    & card(nationalkongre__337_1_1,int1)
    & etype(nationalkongre__337_1_1,int0)
    & fact(nationalkongre__337_1_1,real)
    & gener(nationalkongre__337_1_1,ge)
    & quant(nationalkongre__337_1_1,one)
    & refer(nationalkongre__337_1_1,refer_c)
    & varia(nationalkongre__337_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(anc_0,fe)
    & sort(c2016,da)
    & fact(c2016,real)
    & gener(c2016,sp)
    & sort(wollen_0,md)
    & fact(wollen_0,real)
    & gener(wollen_0,gener_c)
    & sort(c54,d)
    & card(c54,int1)
    & etype(c54,int0)
    & fact(c54,real)
    & gener(c54,sp)
    & quant(c54,one)
    & refer(c54,det)
    & varia(c54,con)
    & sort(c2058,d)
    & card(c2058,int2)
    & etype(c2058,int1)
    & fact(c2058,real)
    & gener(c2058,sp)
    & quant(c2058,nfquant)
    & refer(c2058,det)
    & varia(c2058,varia_c)
    & sort(lassen_1_4,da)
    & fact(lassen_1_4,real)
    & gener(lassen_1_4,ge)
    & sort(c2054,d)
    & card(c2054,int1)
    & etype(c2054,int1)
    & fact(c2054,real)
    & gener(c2054,sp)
    & quant(c2054,one)
    & refer(c2054,det)
    & varia(c2054,con)
    & sort(c2055,na)
    & card(c2055,int1)
    & etype(c2055,int0)
    & fact(c2055,real)
    & gener(c2055,sp)
    & quant(c2055,one)
    & refer(c2055,indet)
    & varia(c2055,varia_c)
    & sort(frei_1_1,nq)
    & sort(national__1_1,nq)
    & sort(einheit_1_2,d)
    & card(einheit_1_2,card_c)
    & etype(einheit_1_2,int1)
    & fact(einheit_1_2,real)
    & gener(einheit_1_2,ge)
    & quant(einheit_1_2,quant_c)
    & refer(einheit_1_2,refer_c)
    & varia(einheit_1_2,varia_c)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(hand_0,fe)
    & sort(c40,d)
    & card(c40,cons(x_constant,cons(int1,nil)))
    & etype(c40,int1)
    & fact(c40,real)
    & gener(c40,sp)
    & quant(c40,mult)
    & refer(c40,det)
    & varia(c40,varia_c)
    & sort(parteibo__337_1_1,d)
    & card(parteibo__337_1_1,int1)
    & etype(parteibo__337_1_1,int0)
    & fact(parteibo__337_1_1,real)
    & gener(parteibo__337_1_1,ge)
    & quant(parteibo__337_1_1,one)
    & refer(parteibo__337_1_1,refer_c)
    & varia(parteibo__337_1_1,varia_c)
    & sort(pr__344sident_1_1,d)
    & card(pr__344sident_1_1,int1)
    & etype(pr__344sident_1_1,int0)
    & fact(pr__344sident_1_1,real)
    & gener(pr__344sident_1_1,ge)
    & quant(pr__344sident_1_1,one)
    & refer(pr__344sident_1_1,refer_c)
    & varia(pr__344sident_1_1,varia_c)
    & sort(c41,tq)
    & sort(voraussichtlich_1_1,tq)
    & sort(kuenftig_1_1,tq)
    & sort(c46,d)
    & sort(c46,io)
    & card(c46,int1)
    & etype(c46,int0)
    & fact(c46,real)
    & gener(c46,sp)
    & quant(c46,one)
    & refer(c46,det)
    & varia(c46,con)
    & sort(c47,na)
    & card(c47,int1)
    & etype(c47,int0)
    & fact(c47,real)
    & gener(c47,sp)
    & quant(c47,one)
    & refer(c47,indet)
    & varia(c47,varia_c)
    & sort(land_1_1,d)
    & sort(land_1_1,io)
    & card(land_1_1,int1)
    & etype(land_1_1,int0)
    & fact(land_1_1,real)
    & gener(land_1_1,ge)
    & quant(land_1_1,one)
    & refer(land_1_1,refer_c)
    & varia(land_1_1,varia_c)
    & sort(s__374dafrika_0,fe)
    & sort(c55,na)
    & card(c55,int1)
    & etype(c55,int0)
    & fact(c55,real)
    & gener(c55,sp)
    & quant(c55,one)
    & refer(c55,indet)
    & varia(c55,varia_c)
    & sort(c56,na)
    & card(c56,int1)
    & etype(c56,int0)
    & fact(c56,real)
    & gener(c56,sp)
    & quant(c56,one)
    & refer(c56,indet)
    & varia(c56,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(nelson_0,fe)
    & sort(mandela_0,fe)
    & sort(kongre__337_1_1,d)
    & sort(kongre__337_1_1,io)
    & card(kongre__337_1_1,int1)
    & etype(kongre__337_1_1,int0)
    & fact(kongre__337_1_1,real)
    & gener(kongre__337_1_1,ge)
    & quant(kongre__337_1_1,one)
    & refer(kongre__337_1_1,refer_c)
    & varia(kongre__337_1_1,varia_c)
    & sort(partei_1_1,d)
    & sort(partei_1_1,io)
    & card(partei_1_1,card_c)
    & etype(partei_1_1,int1)
    & fact(partei_1_1,real)
    & gener(partei_1_1,ge)
    & quant(partei_1_1,quant_c)
    & refer(partei_1_1,refer_c)
    & varia(partei_1_1,varia_c)
    & sort(an_f__374hrer_1_1,d)
    & card(an_f__374hrer_1_1,int1)
    & etype(an_f__374hrer_1_1,int0)
    & fact(an_f__374hrer_1_1,real)
    & gener(an_f__374hrer_1_1,ge)
    & quant(an_f__374hrer_1_1,one)
    & refer(an_f__374hrer_1_1,refer_c)
    & varia(an_f__374hrer_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
