%------------------------------------------------------------------------------
% File     : CSR116+2 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Who was the first black president elected in South Africa?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_010_mira_news_1591_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.40 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.29 v7.5.0, 0.48 v7.4.0, 0.31 v7.3.0, 0.43 v7.2.0, 0.33 v7.1.0, 0.25 v7.0.0, 0.36 v6.4.0, 0.29 v6.3.0, 0.38 v6.2.0, 0.64 v6.1.0, 0.56 v6.0.0, 0.50 v5.5.0, 0.58 v5.4.0, 0.57 v5.3.0, 0.70 v5.2.0, 0.43 v5.0.0, 0.55 v4.1.0, 0.61 v4.0.1, 0.63 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 11059 (   0 equ)
%            Maximal formula atoms :  346 (   1 avg)
%            Number of connectives :  870 (   0   ~;  18   |; 726   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  346 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   89 (  89 usr;   0 prp; 2-10 aty)
%            Number of functors    : 16674 (16674 usr;16673 con; 0-2 aty)
%            Number of variables   :  477 ( 405   !;  72   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_010_mira_news_1591,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7,X8] :
      ( pmod(X8,erst_1_1,pr__344sident_1_1)
      & arg1(X3,X0)
      & attr(X0,X1)
      & attr(X0,X2)
      & attr(X5,X6)
      & obj(X7,X0)
      & prop(X4,schwarz_1_1)
      & sub(X1,familiename_1_1)
      & sub(X2,eigenname_1_1)
      & sub(X4,X8)
      & sub(X6,name_1_1)
      & subr(X3,rprs_0)
      & val(X1,mandela_0)
      & val(X2,nelson_0)
      & val(X6,s__374dafrika_0) ) ).

fof(ave07_era5_synth_qa07_010_mira_news_1591,hypothesis,
    ( assoc(apartheidsstaat_1_1,apartheid_1_1)
    & sub(apartheidsstaat_1_1,land_1_1)
    & attr(c6477,c6478)
    & attr(c6477,c6479)
    & sub(c6477,mensch_1_1)
    & sub(c6478,eigenname_1_1)
    & val(c6478,nelson_0)
    & sub(c6479,familiename_1_1)
    & val(c6479,mandela_0)
    & prop(c6485,schwarz_1_1)
    & sub(c6485,c6492)
    & pmod(c6492,erst_1_1,pr__344sident_1_1)
    & sub(c6496,abschlu__337_1_1)
    & attch(c6499,c6496)
    & sub(c6499,apartheidsstaat_1_1)
    & sub(c6500,von_2_1)
    & attr(c6506,c6507)
    & attr(c6506,c6508)
    & sub(c6506,mensch_1_1)
    & sub(c6507,eigenname_1_1)
    & val(c6507,hans_0)
    & sub(c6508,familiename_1_1)
    & val(c6508,brandt_0)
    & sub(c6509,in_2_1)
    & attr(c6515,c6516)
    & sub(c6515,land_1_1)
    & sub(c6516,name_1_1)
    & val(c6516,s__374dafrika_0)
    & sub(c6519,montag__1_1)
    & quant_p3(c6528,c6523,jahr__1_1)
    & agt(c6529,c6536)
    & dur(c6529,c6528)
    & subs(c6529,hegemonie_1_1)
    & prop(c6536,wei__337_1_1)
    & sub(c6536,minderheit_1_2)
    & tupl_p10(c6617,c6477,c6485,c6496,c6500,c6506,c6509,c6515,c6519,c6529)
    & assoc(hegemonie_1_1,pr__344_1_1)
    & subs(hegemonie_1_1,dominanz_1_1)
    & sort(apartheidsstaat_1_1,d)
    & sort(apartheidsstaat_1_1,io)
    & card(apartheidsstaat_1_1,int1)
    & etype(apartheidsstaat_1_1,int0)
    & fact(apartheidsstaat_1_1,real)
    & gener(apartheidsstaat_1_1,ge)
    & quant(apartheidsstaat_1_1,one)
    & refer(apartheidsstaat_1_1,refer_c)
    & varia(apartheidsstaat_1_1,varia_c)
    & sort(apartheid_1_1,io)
    & card(apartheid_1_1,int1)
    & etype(apartheid_1_1,int0)
    & fact(apartheid_1_1,real)
    & gener(apartheid_1_1,ge)
    & quant(apartheid_1_1,one)
    & refer(apartheid_1_1,refer_c)
    & varia(apartheid_1_1,varia_c)
    & sort(land_1_1,d)
    & sort(land_1_1,io)
    & card(land_1_1,int1)
    & etype(land_1_1,int0)
    & fact(land_1_1,real)
    & gener(land_1_1,ge)
    & quant(land_1_1,one)
    & refer(land_1_1,refer_c)
    & varia(land_1_1,varia_c)
    & sort(c6477,d)
    & card(c6477,int1)
    & etype(c6477,int0)
    & fact(c6477,real)
    & gener(c6477,sp)
    & quant(c6477,one)
    & refer(c6477,det)
    & varia(c6477,con)
    & sort(c6478,na)
    & card(c6478,int1)
    & etype(c6478,int0)
    & fact(c6478,real)
    & gener(c6478,sp)
    & quant(c6478,one)
    & refer(c6478,indet)
    & varia(c6478,varia_c)
    & sort(c6479,na)
    & card(c6479,int1)
    & etype(c6479,int0)
    & fact(c6479,real)
    & gener(c6479,sp)
    & quant(c6479,one)
    & refer(c6479,indet)
    & varia(c6479,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(nelson_0,fe)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(mandela_0,fe)
    & sort(c6485,d)
    & card(c6485,int1)
    & etype(c6485,int0)
    & fact(c6485,real)
    & gener(c6485,sp)
    & quant(c6485,one)
    & refer(c6485,det)
    & varia(c6485,con)
    & sort(schwarz_1_1,tq)
    & sort(c6492,d)
    & card(c6492,int1)
    & etype(c6492,int0)
    & fact(c6492,real)
    & gener(c6492,ge)
    & quant(c6492,one)
    & refer(c6492,refer_c)
    & varia(c6492,varia_c)
    & sort(erst_1_1,oq)
    & card(erst_1_1,int1)
    & sort(pr__344sident_1_1,d)
    & card(pr__344sident_1_1,int1)
    & etype(pr__344sident_1_1,int0)
    & fact(pr__344sident_1_1,real)
    & gener(pr__344sident_1_1,ge)
    & quant(pr__344sident_1_1,one)
    & refer(pr__344sident_1_1,refer_c)
    & varia(pr__344sident_1_1,varia_c)
    & sort(c6496,ad)
    & sort(c6496,io)
    & card(c6496,int1)
    & etype(c6496,int0)
    & fact(c6496,real)
    & gener(c6496,sp)
    & quant(c6496,one)
    & refer(c6496,det)
    & varia(c6496,varia_c)
    & sort(abschlu__337_1_1,ad)
    & sort(abschlu__337_1_1,io)
    & card(abschlu__337_1_1,int1)
    & etype(abschlu__337_1_1,int0)
    & fact(abschlu__337_1_1,real)
    & gener(abschlu__337_1_1,ge)
    & quant(abschlu__337_1_1,one)
    & refer(abschlu__337_1_1,refer_c)
    & varia(abschlu__337_1_1,varia_c)
    & sort(c6499,d)
    & sort(c6499,io)
    & card(c6499,int1)
    & etype(c6499,int0)
    & fact(c6499,real)
    & gener(c6499,sp)
    & quant(c6499,one)
    & refer(c6499,det)
    & varia(c6499,con)
    & sort(c6500,o)
    & card(c6500,int1)
    & etype(c6500,int0)
    & fact(c6500,real)
    & gener(c6500,gener_c)
    & quant(c6500,one)
    & refer(c6500,refer_c)
    & varia(c6500,varia_c)
    & sort(von_2_1,o)
    & card(von_2_1,int1)
    & etype(von_2_1,int0)
    & fact(von_2_1,real)
    & gener(von_2_1,ge)
    & quant(von_2_1,one)
    & refer(von_2_1,refer_c)
    & varia(von_2_1,varia_c)
    & sort(c6506,d)
    & card(c6506,int1)
    & etype(c6506,int0)
    & fact(c6506,real)
    & gener(c6506,sp)
    & quant(c6506,one)
    & refer(c6506,det)
    & varia(c6506,con)
    & sort(c6507,na)
    & card(c6507,int1)
    & etype(c6507,int0)
    & fact(c6507,real)
    & gener(c6507,sp)
    & quant(c6507,one)
    & refer(c6507,indet)
    & varia(c6507,varia_c)
    & sort(c6508,na)
    & card(c6508,int1)
    & etype(c6508,int0)
    & fact(c6508,real)
    & gener(c6508,sp)
    & quant(c6508,one)
    & refer(c6508,indet)
    & varia(c6508,varia_c)
    & sort(hans_0,fe)
    & sort(brandt_0,fe)
    & sort(c6509,o)
    & card(c6509,int1)
    & etype(c6509,int0)
    & fact(c6509,real)
    & gener(c6509,gener_c)
    & quant(c6509,one)
    & refer(c6509,refer_c)
    & varia(c6509,varia_c)
    & sort(in_2_1,o)
    & card(in_2_1,int1)
    & etype(in_2_1,int0)
    & fact(in_2_1,real)
    & gener(in_2_1,ge)
    & quant(in_2_1,one)
    & refer(in_2_1,refer_c)
    & varia(in_2_1,varia_c)
    & sort(c6515,d)
    & sort(c6515,io)
    & card(c6515,int1)
    & etype(c6515,int0)
    & fact(c6515,real)
    & gener(c6515,sp)
    & quant(c6515,one)
    & refer(c6515,det)
    & varia(c6515,con)
    & sort(c6516,na)
    & card(c6516,int1)
    & etype(c6516,int0)
    & fact(c6516,real)
    & gener(c6516,sp)
    & quant(c6516,one)
    & refer(c6516,indet)
    & varia(c6516,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(s__374dafrika_0,fe)
    & sort(c6519,ta)
    & card(c6519,int1)
    & etype(c6519,int0)
    & fact(c6519,real)
    & gener(c6519,sp)
    & quant(c6519,one)
    & refer(c6519,det)
    & varia(c6519,con)
    & sort(montag__1_1,ta)
    & card(montag__1_1,int1)
    & etype(montag__1_1,int0)
    & fact(montag__1_1,real)
    & gener(montag__1_1,ge)
    & quant(montag__1_1,one)
    & refer(montag__1_1,refer_c)
    & varia(montag__1_1,varia_c)
    & sort(c6528,m)
    & sort(c6528,ta)
    & card(c6528,card_c)
    & etype(c6528,etype_c)
    & fact(c6528,real)
    & gener(c6528,gener_c)
    & quant(c6528,quant_c)
    & refer(c6528,refer_c)
    & varia(c6528,varia_c)
    & sort(c6523,nu)
    & card(c6523,int342)
    & sort(jahr__1_1,me)
    & sort(jahr__1_1,oa)
    & sort(jahr__1_1,ta)
    & card(jahr__1_1,card_c)
    & etype(jahr__1_1,etype_c)
    & fact(jahr__1_1,real)
    & gener(jahr__1_1,ge)
    & quant(jahr__1_1,quant_c)
    & refer(jahr__1_1,refer_c)
    & varia(jahr__1_1,varia_c)
    & sort(c6529,ad)
    & card(c6529,int1)
    & etype(c6529,int0)
    & fact(c6529,real)
    & gener(c6529,sp)
    & quant(c6529,one)
    & refer(c6529,det)
    & varia(c6529,con)
    & sort(c6536,d)
    & card(c6536,int1)
    & etype(c6536,int1)
    & fact(c6536,real)
    & gener(c6536,sp)
    & quant(c6536,one)
    & refer(c6536,det)
    & varia(c6536,con)
    & sort(hegemonie_1_1,ad)
    & card(hegemonie_1_1,int1)
    & etype(hegemonie_1_1,int0)
    & fact(hegemonie_1_1,real)
    & gener(hegemonie_1_1,ge)
    & quant(hegemonie_1_1,one)
    & refer(hegemonie_1_1,refer_c)
    & varia(hegemonie_1_1,varia_c)
    & sort(wei__337_1_1,nq)
    & sort(minderheit_1_2,d)
    & card(minderheit_1_2,card_c)
    & etype(minderheit_1_2,int1)
    & fact(minderheit_1_2,real)
    & gener(minderheit_1_2,ge)
    & quant(minderheit_1_2,quant_c)
    & refer(minderheit_1_2,refer_c)
    & varia(minderheit_1_2,varia_c)
    & sort(c6617,ent)
    & card(c6617,card_c)
    & etype(c6617,etype_c)
    & fact(c6617,real)
    & gener(c6617,gener_c)
    & quant(c6617,quant_c)
    & refer(c6617,refer_c)
    & varia(c6617,varia_c)
    & sort(pr__344_1_1,ent)
    & card(pr__344_1_1,card_c)
    & etype(pr__344_1_1,etype_c)
    & fact(pr__344_1_1,real)
    & gener(pr__344_1_1,gener_c)
    & quant(pr__344_1_1,quant_c)
    & refer(pr__344_1_1,refer_c)
    & varia(pr__344_1_1,varia_c)
    & sort(dominanz_1_1,ad)
    & card(dominanz_1_1,int1)
    & etype(dominanz_1_1,int0)
    & fact(dominanz_1_1,real)
    & gener(dominanz_1_1,ge)
    & quant(dominanz_1_1,one)
    & refer(dominanz_1_1,refer_c)
    & varia(dominanz_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
