%------------------------------------------------------------------------------
% File     : CSR116+19 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Who was the first black president elected in South Africa?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_010_mira_news_1755_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.53 v9.0.0, 0.25 v8.2.0, 0.27 v8.1.0, 0.36 v7.5.0, 0.52 v7.4.0, 0.38 v7.3.0, 0.57 v7.2.0, 0.50 v6.4.0, 0.36 v6.3.0, 0.38 v6.2.0, 0.64 v6.1.0, 0.72 v6.0.0, 0.50 v5.5.0, 0.71 v5.4.0, 0.70 v5.3.0, 0.74 v5.2.0, 0.50 v5.0.0, 0.60 v4.1.0, 0.67 v4.0.1, 0.68 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 11011 (   0 equ)
%            Maximal formula atoms :  299 (   1 avg)
%            Number of connectives :  822 (   0   ~;  18   |; 678   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  299 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   88 (  88 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16671 (16671 usr;16670 con; 0-2 aty)
%            Number of variables   :  477 ( 405   !;  72   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_010_mira_news_1755,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7,X8] :
      ( arg1(X3,X0)
      & arg2(X3,X4)
      & attr(X0,X1)
      & attr(X0,X2)
      & attr(X5,X6)
      & obj(X7,X0)
      & sub(X1,familiename_1_1)
      & sub(X2,eigenname_1_1)
      & sub(X4,X8)
      & sub(X6,name_1_1)
      & subr(X3,rprs_0)
      & val(X1,mandela_0)
      & val(X2,nelson_0)
      & val(X6,s__374dafrika_0) ) ).

fof(ave07_era5_synth_qa07_010_mira_news_1755,hypothesis,
    ( sub(c10,name_1_1)
    & val(c10,johannesburg_0)
    & loc(c15,c9401)
    & subs(c15,bekennen_1_1)
    & attr(c9,c10)
    & sub(c9,stadt__1_1)
    & attr(c9235,c9236)
    & attr(c9235,c9237)
    & sub(c9235,putschistenf__374hrer_1_1)
    & sub(c9236,eigenname_1_1)
    & val(c9236,jonas_0)
    & sub(c9237,familiename_1_1)
    & val(c9237,savimbi_0)
    & attch(c9245,c9251)
    & attr(c9245,c9246)
    & sub(c9245,land_1_1)
    & sub(c9246,name_1_1)
    & val(c9246,s__374dafrika_0)
    & attr(c9251,c9252)
    & attr(c9251,c9253)
    & sub(c9251,pr__344sident_1_1)
    & sub(c9252,eigenname_1_1)
    & val(c9252,nelson_0)
    & sub(c9253,familiename_1_1)
    & val(c9253,mandela_0)
    & agt(c9256,c9235)
    & ornt(c9256,c9251)
    & semrel(c9256,c15)
    & subs(c9256,anflehen_1_1)
    & loc(c9372,c9397)
    & sub(c9372,regierung_1_1)
    & attr(c9380,c9381)
    & sub(c9380,stadt__1_1)
    & sub(c9381,name_1_1)
    & val(c9381,luanda_0)
    & preds(c9383,angriff_1_1)
    & prop(c9383,weit_1_1)
    & agt(c9387,c9235)
    & mcont(c9387,c9383)
    & modl(c9387,sollen_0)
    & obj(c9387,c9372)
    & semrel(c9387,c9256)
    & subs(c9387,abhalten_1_1)
    & in(c9397,c9380)
    & in(c9401,c9)
    & assoc(putschistenf__374hrer_1_1,meuterer_1_1)
    & sub(putschistenf__374hrer_1_1,an_f__374hrer_1_1)
    & sort(c10,na)
    & card(c10,int1)
    & etype(c10,int0)
    & fact(c10,real)
    & gener(c10,sp)
    & quant(c10,one)
    & refer(c10,indet)
    & varia(c10,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(johannesburg_0,fe)
    & sort(c15,da)
    & fact(c15,real)
    & gener(c15,sp)
    & sort(c9401,l)
    & card(c9401,int1)
    & etype(c9401,int0)
    & fact(c9401,real)
    & gener(c9401,sp)
    & quant(c9401,one)
    & refer(c9401,det)
    & varia(c9401,con)
    & sort(bekennen_1_1,da)
    & fact(bekennen_1_1,real)
    & gener(bekennen_1_1,ge)
    & sort(c9,d)
    & sort(c9,io)
    & card(c9,int1)
    & etype(c9,int0)
    & fact(c9,real)
    & gener(c9,sp)
    & quant(c9,one)
    & refer(c9,det)
    & varia(c9,con)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(c9235,d)
    & card(c9235,int1)
    & etype(c9235,int0)
    & fact(c9235,real)
    & gener(c9235,sp)
    & quant(c9235,one)
    & refer(c9235,det)
    & varia(c9235,con)
    & sort(c9236,na)
    & card(c9236,int1)
    & etype(c9236,int0)
    & fact(c9236,real)
    & gener(c9236,sp)
    & quant(c9236,one)
    & refer(c9236,indet)
    & varia(c9236,varia_c)
    & sort(c9237,na)
    & card(c9237,int1)
    & etype(c9237,int0)
    & fact(c9237,real)
    & gener(c9237,sp)
    & quant(c9237,one)
    & refer(c9237,indet)
    & varia(c9237,varia_c)
    & sort(putschistenf__374hrer_1_1,d)
    & card(putschistenf__374hrer_1_1,int1)
    & etype(putschistenf__374hrer_1_1,int0)
    & fact(putschistenf__374hrer_1_1,real)
    & gener(putschistenf__374hrer_1_1,ge)
    & quant(putschistenf__374hrer_1_1,one)
    & refer(putschistenf__374hrer_1_1,refer_c)
    & varia(putschistenf__374hrer_1_1,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(jonas_0,fe)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(savimbi_0,fe)
    & sort(c9245,d)
    & sort(c9245,io)
    & card(c9245,int1)
    & etype(c9245,int0)
    & fact(c9245,real)
    & gener(c9245,sp)
    & quant(c9245,one)
    & refer(c9245,det)
    & varia(c9245,con)
    & sort(c9251,d)
    & card(c9251,int1)
    & etype(c9251,int0)
    & fact(c9251,real)
    & gener(c9251,sp)
    & quant(c9251,one)
    & refer(c9251,det)
    & varia(c9251,varia_c)
    & sort(c9246,na)
    & card(c9246,int1)
    & etype(c9246,int0)
    & fact(c9246,real)
    & gener(c9246,sp)
    & quant(c9246,one)
    & refer(c9246,indet)
    & varia(c9246,varia_c)
    & sort(land_1_1,d)
    & sort(land_1_1,io)
    & card(land_1_1,int1)
    & etype(land_1_1,int0)
    & fact(land_1_1,real)
    & gener(land_1_1,ge)
    & quant(land_1_1,one)
    & refer(land_1_1,refer_c)
    & varia(land_1_1,varia_c)
    & sort(s__374dafrika_0,fe)
    & sort(c9252,na)
    & card(c9252,int1)
    & etype(c9252,int0)
    & fact(c9252,real)
    & gener(c9252,sp)
    & quant(c9252,one)
    & refer(c9252,indet)
    & varia(c9252,varia_c)
    & sort(c9253,na)
    & card(c9253,int1)
    & etype(c9253,int0)
    & fact(c9253,real)
    & gener(c9253,sp)
    & quant(c9253,one)
    & refer(c9253,indet)
    & varia(c9253,varia_c)
    & sort(pr__344sident_1_1,d)
    & card(pr__344sident_1_1,int1)
    & etype(pr__344sident_1_1,int0)
    & fact(pr__344sident_1_1,real)
    & gener(pr__344sident_1_1,ge)
    & quant(pr__344sident_1_1,one)
    & refer(pr__344sident_1_1,refer_c)
    & varia(pr__344sident_1_1,varia_c)
    & sort(nelson_0,fe)
    & sort(mandela_0,fe)
    & sort(c9256,da)
    & fact(c9256,real)
    & gener(c9256,sp)
    & sort(anflehen_1_1,da)
    & fact(anflehen_1_1,real)
    & gener(anflehen_1_1,ge)
    & sort(c9372,d)
    & sort(c9372,io)
    & card(c9372,int1)
    & etype(c9372,int1)
    & fact(c9372,real)
    & gener(c9372,sp)
    & quant(c9372,one)
    & refer(c9372,det)
    & varia(c9372,con)
    & sort(c9397,l)
    & card(c9397,int1)
    & etype(c9397,int0)
    & fact(c9397,real)
    & gener(c9397,sp)
    & quant(c9397,one)
    & refer(c9397,det)
    & varia(c9397,con)
    & sort(regierung_1_1,d)
    & sort(regierung_1_1,io)
    & card(regierung_1_1,card_c)
    & etype(regierung_1_1,int1)
    & fact(regierung_1_1,real)
    & gener(regierung_1_1,ge)
    & quant(regierung_1_1,quant_c)
    & refer(regierung_1_1,refer_c)
    & varia(regierung_1_1,varia_c)
    & sort(c9380,d)
    & sort(c9380,io)
    & card(c9380,int1)
    & etype(c9380,int0)
    & fact(c9380,real)
    & gener(c9380,sp)
    & quant(c9380,one)
    & refer(c9380,det)
    & varia(c9380,con)
    & sort(c9381,na)
    & card(c9381,int1)
    & etype(c9381,int0)
    & fact(c9381,real)
    & gener(c9381,sp)
    & quant(c9381,one)
    & refer(c9381,indet)
    & varia(c9381,varia_c)
    & sort(luanda_0,fe)
    & sort(c9383,ad)
    & card(c9383,cons(x_constant,cons(int1,nil)))
    & etype(c9383,int1)
    & fact(c9383,hypo)
    & gener(c9383,sp)
    & quant(c9383,mult)
    & refer(c9383,indet)
    & varia(c9383,varia_c)
    & sort(angriff_1_1,ad)
    & card(angriff_1_1,int1)
    & etype(angriff_1_1,int0)
    & fact(angriff_1_1,real)
    & gener(angriff_1_1,ge)
    & quant(angriff_1_1,one)
    & refer(angriff_1_1,refer_c)
    & varia(angriff_1_1,varia_c)
    & sort(weit_1_1,mq)
    & sort(c9387,da)
    & fact(c9387,real)
    & gener(c9387,sp)
    & sort(sollen_0,md)
    & fact(sollen_0,real)
    & gener(sollen_0,gener_c)
    & sort(abhalten_1_1,da)
    & fact(abhalten_1_1,real)
    & gener(abhalten_1_1,ge)
    & sort(meuterer_1_1,d)
    & card(meuterer_1_1,int1)
    & etype(meuterer_1_1,int0)
    & fact(meuterer_1_1,real)
    & gener(meuterer_1_1,ge)
    & quant(meuterer_1_1,one)
    & refer(meuterer_1_1,refer_c)
    & varia(meuterer_1_1,varia_c)
    & sort(an_f__374hrer_1_1,d)
    & card(an_f__374hrer_1_1,int1)
    & etype(an_f__374hrer_1_1,int0)
    & fact(an_f__374hrer_1_1,real)
    & gener(an_f__374hrer_1_1,ge)
    & quant(an_f__374hrer_1_1,one)
    & refer(an_f__374hrer_1_1,refer_c)
    & varia(an_f__374hrer_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
