%------------------------------------------------------------------------------
% File     : CSR116+18 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Who was the first black president elected in South Africa?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_010_mira_news_1734_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.47 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.36 v7.5.0, 0.52 v7.4.0, 0.38 v7.3.0, 0.57 v7.2.0, 0.50 v7.0.0, 0.43 v6.4.0, 0.36 v6.3.0, 0.38 v6.2.0, 0.55 v6.1.0, 0.68 v6.0.0, 0.50 v5.5.0, 0.67 v5.4.0, 0.65 v5.3.0, 0.70 v5.2.0, 0.50 v5.0.0, 0.60 v4.1.0, 0.67 v4.0.1, 0.74 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10930 (   0 equ)
%            Maximal formula atoms :  217 (   1 avg)
%            Number of connectives :  741 (   0   ~;  18   |; 597   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  217 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   88 (  88 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16659 (16659 usr;16658 con; 0-2 aty)
%            Number of variables   :  478 ( 405   !;  73   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_010_mira_news_1734,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7,X8,X9] :
      ( in(X5,X6)
      & arg1(X3,X0)
      & arg2(X3,X4)
      & attr(X0,X1)
      & attr(X0,X2)
      & attr(X6,X7)
      & obj(X8,X0)
      & sub(X1,familiename_1_1)
      & sub(X2,eigenname_1_1)
      & sub(X4,X9)
      & sub(X7,name_1_1)
      & subr(X3,rprs_0)
      & val(X1,mandela_0)
      & val(X2,nelson_0)
      & val(X7,s__374dafrika_0) ) ).

fof(ave07_era5_synth_qa07_010_mira_news_1734,hypothesis,
    ( assoc(aufnahmeantrag_1_1,aufnahme_2_1)
    & sub(aufnahmeantrag_1_1,antrag_1_1)
    & attr(c11805,c11806)
    & sub(c11805,k__366nigin_1_1)
    & sub(c11806,eigenname_1_1)
    & val(c11806,elisabeth_0)
    & attr(c11815,c11816)
    & attr(c11815,c11817)
    & prop(c11815,s__374dafrikanisch_1_1)
    & sub(c11815,pr__344sident_1_1)
    & sub(c11816,eigenname_1_1)
    & val(c11816,nelson_0)
    & sub(c11817,familiename_1_1)
    & val(c11817,mandela_0)
    & ante(c13598,c13616)
    & subs(c13598,wahl_1_1)
    & attch(c13603,c13598)
    & sub(c13605,aufnahmeantrag_1_1)
    & agt(c13616,c11815)
    & mannr(c13616,direkt_1_1)
    & obj(c13616,c13605)
    & subs(c13616,stellen_1_3)
    & sub(c13631,gl__374ckwunschstelegramm_1_1)
    & agt(c8235,c11805)
    & obj(c8235,c13631)
    & ornt(c8235,c11815)
    & subs(c8235,senden_1_2)
    & assoc(gl__374ckwunschstelegramm_1_1,gl__374ckwunsch_1_1)
    & sub(gl__374ckwunschstelegramm_1_1,depesche_1_1)
    & sort(aufnahmeantrag_1_1,ad)
    & sort(aufnahmeantrag_1_1,d)
    & sort(aufnahmeantrag_1_1,io)
    & card(aufnahmeantrag_1_1,int1)
    & etype(aufnahmeantrag_1_1,int0)
    & fact(aufnahmeantrag_1_1,real)
    & gener(aufnahmeantrag_1_1,ge)
    & quant(aufnahmeantrag_1_1,one)
    & refer(aufnahmeantrag_1_1,refer_c)
    & varia(aufnahmeantrag_1_1,varia_c)
    & sort(aufnahme_2_1,ad)
    & card(aufnahme_2_1,int1)
    & etype(aufnahme_2_1,int0)
    & fact(aufnahme_2_1,real)
    & gener(aufnahme_2_1,ge)
    & quant(aufnahme_2_1,one)
    & refer(aufnahme_2_1,refer_c)
    & varia(aufnahme_2_1,varia_c)
    & sort(antrag_1_1,ad)
    & sort(antrag_1_1,d)
    & sort(antrag_1_1,io)
    & card(antrag_1_1,int1)
    & etype(antrag_1_1,int0)
    & fact(antrag_1_1,real)
    & gener(antrag_1_1,ge)
    & quant(antrag_1_1,one)
    & refer(antrag_1_1,refer_c)
    & varia(antrag_1_1,varia_c)
    & sort(c11805,d)
    & card(c11805,int1)
    & etype(c11805,int0)
    & fact(c11805,real)
    & gener(c11805,sp)
    & quant(c11805,one)
    & refer(c11805,det)
    & varia(c11805,varia_c)
    & sort(c11806,na)
    & card(c11806,int1)
    & etype(c11806,int0)
    & fact(c11806,real)
    & gener(c11806,sp)
    & quant(c11806,one)
    & refer(c11806,det)
    & varia(c11806,varia_c)
    & sort(k__366nigin_1_1,d)
    & card(k__366nigin_1_1,int1)
    & etype(k__366nigin_1_1,int0)
    & fact(k__366nigin_1_1,real)
    & gener(k__366nigin_1_1,ge)
    & quant(k__366nigin_1_1,one)
    & refer(k__366nigin_1_1,refer_c)
    & varia(k__366nigin_1_1,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(elisabeth_0,fe)
    & sort(c11815,d)
    & card(c11815,int1)
    & etype(c11815,int0)
    & fact(c11815,real)
    & gener(c11815,sp)
    & quant(c11815,one)
    & refer(c11815,det)
    & varia(c11815,con)
    & sort(c11816,na)
    & card(c11816,int1)
    & etype(c11816,int0)
    & fact(c11816,real)
    & gener(c11816,sp)
    & quant(c11816,one)
    & refer(c11816,indet)
    & varia(c11816,varia_c)
    & sort(c11817,na)
    & card(c11817,int1)
    & etype(c11817,int0)
    & fact(c11817,real)
    & gener(c11817,sp)
    & quant(c11817,one)
    & refer(c11817,indet)
    & varia(c11817,varia_c)
    & sort(s__374dafrikanisch_1_1,nq)
    & sort(pr__344sident_1_1,d)
    & card(pr__344sident_1_1,int1)
    & etype(pr__344sident_1_1,int0)
    & fact(pr__344sident_1_1,real)
    & gener(pr__344sident_1_1,ge)
    & quant(pr__344sident_1_1,one)
    & refer(pr__344sident_1_1,refer_c)
    & varia(pr__344sident_1_1,varia_c)
    & sort(nelson_0,fe)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(mandela_0,fe)
    & sort(c13598,ad)
    & card(c13598,int1)
    & etype(c13598,int0)
    & fact(c13598,real)
    & gener(c13598,sp)
    & quant(c13598,one)
    & refer(c13598,det)
    & varia(c13598,varia_c)
    & sort(c13616,da)
    & fact(c13616,real)
    & gener(c13616,sp)
    & sort(wahl_1_1,ad)
    & card(wahl_1_1,int1)
    & etype(wahl_1_1,int0)
    & fact(wahl_1_1,real)
    & gener(wahl_1_1,ge)
    & quant(wahl_1_1,one)
    & refer(wahl_1_1,refer_c)
    & varia(wahl_1_1,varia_c)
    & sort(c13603,o)
    & card(c13603,int1)
    & etype(c13603,int0)
    & fact(c13603,real)
    & gener(c13603,sp)
    & quant(c13603,one)
    & refer(c13603,det)
    & varia(c13603,varia_c)
    & sort(c13605,ad)
    & sort(c13605,d)
    & sort(c13605,io)
    & card(c13605,int1)
    & etype(c13605,int0)
    & fact(c13605,real)
    & gener(c13605,sp)
    & quant(c13605,one)
    & refer(c13605,det)
    & varia(c13605,con)
    & sort(direkt_1_1,nq)
    & sort(stellen_1_3,da)
    & fact(stellen_1_3,real)
    & gener(stellen_1_3,ge)
    & sort(c13631,d)
    & sort(c13631,io)
    & card(c13631,int1)
    & etype(c13631,int0)
    & fact(c13631,real)
    & gener(c13631,sp)
    & quant(c13631,one)
    & refer(c13631,indet)
    & varia(c13631,varia_c)
    & sort(gl__374ckwunschstelegramm_1_1,d)
    & sort(gl__374ckwunschstelegramm_1_1,io)
    & card(gl__374ckwunschstelegramm_1_1,int1)
    & etype(gl__374ckwunschstelegramm_1_1,int0)
    & fact(gl__374ckwunschstelegramm_1_1,real)
    & gener(gl__374ckwunschstelegramm_1_1,ge)
    & quant(gl__374ckwunschstelegramm_1_1,one)
    & refer(gl__374ckwunschstelegramm_1_1,refer_c)
    & varia(gl__374ckwunschstelegramm_1_1,varia_c)
    & sort(c8235,da)
    & fact(c8235,real)
    & gener(c8235,sp)
    & sort(senden_1_2,da)
    & fact(senden_1_2,real)
    & gener(senden_1_2,ge)
    & sort(gl__374ckwunsch_1_1,ad)
    & sort(gl__374ckwunsch_1_1,d)
    & sort(gl__374ckwunsch_1_1,io)
    & card(gl__374ckwunsch_1_1,int1)
    & etype(gl__374ckwunsch_1_1,int0)
    & fact(gl__374ckwunsch_1_1,real)
    & gener(gl__374ckwunsch_1_1,ge)
    & quant(gl__374ckwunsch_1_1,one)
    & refer(gl__374ckwunsch_1_1,refer_c)
    & varia(gl__374ckwunsch_1_1,varia_c)
    & sort(depesche_1_1,d)
    & sort(depesche_1_1,io)
    & card(depesche_1_1,int1)
    & etype(depesche_1_1,int0)
    & fact(depesche_1_1,real)
    & gener(depesche_1_1,ge)
    & quant(depesche_1_1,one)
    & refer(depesche_1_1,refer_c)
    & varia(depesche_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
