%------------------------------------------------------------------------------
% File     : CSR116+17 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Who was the first black president elected in South Africa?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_010_mira_news_1729_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.45 v9.1.0, 0.53 v9.0.0, 0.31 v8.2.0, 0.27 v8.1.0, 0.43 v7.5.0, 0.52 v7.4.0, 0.38 v7.3.0, 0.57 v7.2.0, 0.50 v6.4.0, 0.43 v6.3.0, 0.38 v6.2.0, 0.64 v6.1.0, 0.72 v6.0.0, 0.50 v5.5.0, 0.67 v5.4.0, 0.65 v5.3.0, 0.74 v5.2.0, 0.57 v5.0.0, 0.70 v4.1.0, 0.72 v4.0.1, 0.74 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 11036 (   0 equ)
%            Maximal formula atoms :  323 (   1 avg)
%            Number of connectives :  847 (   0   ~;  18   |; 703   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  323 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   88 (  88 usr;   0 prp; 2-8 aty)
%            Number of functors    : 16670 (16670 usr;16669 con; 0-2 aty)
%            Number of variables   :  478 ( 405   !;  73   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_010_mira_news_1729,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7,X8,X9] :
      ( in(X5,X6)
      & arg1(X3,X0)
      & arg2(X3,X4)
      & attr(X0,X1)
      & attr(X0,X2)
      & attr(X6,X7)
      & obj(X8,X0)
      & sub(X1,familiename_1_1)
      & sub(X2,eigenname_1_1)
      & sub(X4,X9)
      & sub(X7,name_1_1)
      & subr(X3,rprs_0)
      & val(X1,mandela_0)
      & val(X2,nelson_0)
      & val(X7,s__374dafrika_0) ) ).

fof(ave07_era5_synth_qa07_010_mira_news_1729,hypothesis,
    ( attr(c13,c14)
    & sub(c13,stadt__1_1)
    & sub(c14,name_1_1)
    & val(c14,johannesburg_0)
    & attr(c22,c23)
    & attr(c22,c24)
    & sub(c23,tag_1_1)
    & val(c23,c20)
    & sub(c24,monat_1_1)
    & val(c24,c21)
    & attr(c2648,c2649)
    & attr(c2648,c2650)
    & sub(c2648,mensch_1_1)
    & sub(c2649,eigenname_1_1)
    & val(c2649,winnie_0)
    & sub(c2650,familiename_1_1)
    & val(c2650,mandela_0)
    & attr(c2724,c2725)
    & attr(c2724,c2726)
    & prop(c2724,s__374dafrikanisch_1_1)
    & sub(c2724,pr__344sident_1_1)
    & sub(c2725,eigenname_1_1)
    & val(c2725,nelson_0)
    & sub(c2726,familiename_1_1)
    & val(c2726,mandela_0)
    & prop(c2736,c2638)
    & sub(c2736,ehefrau_1_1)
    & sub(c2746,donnerstag__1_1)
    & subs(c2753,reise__1_1)
    & pred(c2767,land_1_1)
    & prop(c2767,westafrikanisch_1_1)
    & tupl_p8(c3203,c2648,c2648,c2724,c2736,c2746,c2753,c2767)
    & tupl(c63,c13,c22)
    & assoc(ehefrau_1_1,ehe_2_1)
    & sub(ehefrau_1_1,frau_1_1)
    & chsp1(leben_2_1,c2638)
    & assoc(westafrikanisch_1_1,west__1_1)
    & impl(westafrikanisch_1_1,afrikanisch__1_1)
    & sort(c13,d)
    & sort(c13,io)
    & card(c13,int1)
    & etype(c13,int0)
    & fact(c13,real)
    & gener(c13,sp)
    & quant(c13,one)
    & refer(c13,det)
    & varia(c13,con)
    & sort(c14,na)
    & card(c14,int1)
    & etype(c14,int0)
    & fact(c14,real)
    & gener(c14,sp)
    & quant(c14,one)
    & refer(c14,indet)
    & varia(c14,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(johannesburg_0,fe)
    & sort(c22,t)
    & card(c22,int1)
    & etype(c22,int0)
    & fact(c22,real)
    & gener(c22,sp)
    & quant(c22,one)
    & refer(c22,det)
    & varia(c22,con)
    & sort(c23,me)
    & sort(c23,oa)
    & sort(c23,ta)
    & card(c23,card_c)
    & etype(c23,etype_c)
    & fact(c23,real)
    & gener(c23,sp)
    & quant(c23,quant_c)
    & refer(c23,refer_c)
    & varia(c23,varia_c)
    & sort(c24,me)
    & sort(c24,oa)
    & sort(c24,ta)
    & card(c24,card_c)
    & etype(c24,etype_c)
    & fact(c24,real)
    & gener(c24,sp)
    & quant(c24,quant_c)
    & refer(c24,refer_c)
    & varia(c24,varia_c)
    & sort(tag_1_1,me)
    & sort(tag_1_1,oa)
    & sort(tag_1_1,ta)
    & card(tag_1_1,card_c)
    & etype(tag_1_1,etype_c)
    & fact(tag_1_1,real)
    & gener(tag_1_1,ge)
    & quant(tag_1_1,quant_c)
    & refer(tag_1_1,refer_c)
    & varia(tag_1_1,varia_c)
    & sort(c20,nu)
    & card(c20,int2)
    & sort(monat_1_1,me)
    & sort(monat_1_1,oa)
    & sort(monat_1_1,ta)
    & card(monat_1_1,card_c)
    & etype(monat_1_1,etype_c)
    & fact(monat_1_1,real)
    & gener(monat_1_1,ge)
    & quant(monat_1_1,quant_c)
    & refer(monat_1_1,refer_c)
    & varia(monat_1_1,varia_c)
    & sort(c21,nu)
    & card(c21,int3)
    & sort(c2648,d)
    & card(c2648,int1)
    & etype(c2648,int0)
    & fact(c2648,real)
    & gener(c2648,sp)
    & quant(c2648,one)
    & refer(c2648,det)
    & varia(c2648,con)
    & sort(c2649,na)
    & card(c2649,int1)
    & etype(c2649,int0)
    & fact(c2649,real)
    & gener(c2649,sp)
    & quant(c2649,one)
    & refer(c2649,indet)
    & varia(c2649,varia_c)
    & sort(c2650,na)
    & card(c2650,int1)
    & etype(c2650,int0)
    & fact(c2650,real)
    & gener(c2650,sp)
    & quant(c2650,one)
    & refer(c2650,indet)
    & varia(c2650,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(winnie_0,fe)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(mandela_0,fe)
    & sort(c2724,d)
    & card(c2724,int1)
    & etype(c2724,int0)
    & fact(c2724,real)
    & gener(c2724,sp)
    & quant(c2724,one)
    & refer(c2724,det)
    & varia(c2724,con)
    & sort(c2725,na)
    & card(c2725,int1)
    & etype(c2725,int0)
    & fact(c2725,real)
    & gener(c2725,sp)
    & quant(c2725,one)
    & refer(c2725,indet)
    & varia(c2725,varia_c)
    & sort(c2726,na)
    & card(c2726,int1)
    & etype(c2726,int0)
    & fact(c2726,real)
    & gener(c2726,sp)
    & quant(c2726,one)
    & refer(c2726,indet)
    & varia(c2726,varia_c)
    & sort(s__374dafrikanisch_1_1,nq)
    & sort(pr__344sident_1_1,d)
    & card(pr__344sident_1_1,int1)
    & etype(pr__344sident_1_1,int0)
    & fact(pr__344sident_1_1,real)
    & gener(pr__344sident_1_1,ge)
    & quant(pr__344sident_1_1,one)
    & refer(pr__344sident_1_1,refer_c)
    & varia(pr__344sident_1_1,varia_c)
    & sort(nelson_0,fe)
    & sort(c2736,d)
    & card(c2736,int1)
    & etype(c2736,int0)
    & fact(c2736,real)
    & gener(c2736,gener_c)
    & quant(c2736,one)
    & refer(c2736,refer_c)
    & varia(c2736,varia_c)
    & sort(c2638,tq)
    & sort(ehefrau_1_1,d)
    & card(ehefrau_1_1,int1)
    & etype(ehefrau_1_1,int0)
    & fact(ehefrau_1_1,real)
    & gener(ehefrau_1_1,ge)
    & quant(ehefrau_1_1,one)
    & refer(ehefrau_1_1,refer_c)
    & varia(ehefrau_1_1,varia_c)
    & sort(c2746,ta)
    & card(c2746,int1)
    & etype(c2746,int0)
    & fact(c2746,real)
    & gener(c2746,sp)
    & quant(c2746,one)
    & refer(c2746,det)
    & varia(c2746,con)
    & sort(donnerstag__1_1,ta)
    & card(donnerstag__1_1,int1)
    & etype(donnerstag__1_1,int0)
    & fact(donnerstag__1_1,real)
    & gener(donnerstag__1_1,ge)
    & quant(donnerstag__1_1,one)
    & refer(donnerstag__1_1,refer_c)
    & varia(donnerstag__1_1,varia_c)
    & sort(c2753,ad)
    & card(c2753,int1)
    & etype(c2753,int0)
    & fact(c2753,real)
    & gener(c2753,sp)
    & quant(c2753,one)
    & refer(c2753,indet)
    & varia(c2753,varia_c)
    & sort(reise__1_1,ad)
    & card(reise__1_1,int1)
    & etype(reise__1_1,int0)
    & fact(reise__1_1,real)
    & gener(reise__1_1,ge)
    & quant(reise__1_1,one)
    & refer(reise__1_1,refer_c)
    & varia(reise__1_1,varia_c)
    & sort(c2767,d)
    & sort(c2767,io)
    & card(c2767,cons(x_constant,cons(int1,nil)))
    & etype(c2767,int1)
    & fact(c2767,real)
    & gener(c2767,gener_c)
    & quant(c2767,mult)
    & refer(c2767,refer_c)
    & varia(c2767,varia_c)
    & sort(land_1_1,d)
    & sort(land_1_1,io)
    & card(land_1_1,int1)
    & etype(land_1_1,int0)
    & fact(land_1_1,real)
    & gener(land_1_1,ge)
    & quant(land_1_1,one)
    & refer(land_1_1,refer_c)
    & varia(land_1_1,varia_c)
    & sort(westafrikanisch_1_1,nq)
    & sort(c3203,ent)
    & card(c3203,card_c)
    & etype(c3203,etype_c)
    & fact(c3203,real)
    & gener(c3203,gener_c)
    & quant(c3203,quant_c)
    & refer(c3203,refer_c)
    & varia(c3203,varia_c)
    & sort(c63,ent)
    & card(c63,card_c)
    & etype(c63,etype_c)
    & fact(c63,real)
    & gener(c63,gener_c)
    & quant(c63,quant_c)
    & refer(c63,refer_c)
    & varia(c63,varia_c)
    & sort(ehe_2_1,as)
    & sort(ehe_2_1,re)
    & card(ehe_2_1,int1)
    & etype(ehe_2_1,int0)
    & fact(ehe_2_1,real)
    & gener(ehe_2_1,ge)
    & quant(ehe_2_1,one)
    & refer(ehe_2_1,refer_c)
    & varia(ehe_2_1,varia_c)
    & sort(frau_1_1,d)
    & card(frau_1_1,int1)
    & etype(frau_1_1,int0)
    & fact(frau_1_1,real)
    & gener(frau_1_1,ge)
    & quant(frau_1_1,one)
    & refer(frau_1_1,refer_c)
    & varia(frau_1_1,varia_c)
    & sort(leben_2_1,dn)
    & fact(leben_2_1,real)
    & gener(leben_2_1,ge)
    & sort(west__1_1,d)
    & sort(west__1_1,io)
    & card(west__1_1,int1)
    & etype(west__1_1,int0)
    & fact(west__1_1,real)
    & gener(west__1_1,ge)
    & quant(west__1_1,one)
    & refer(west__1_1,refer_c)
    & varia(west__1_1,varia_c)
    & sort(afrikanisch__1_1,nq) ) ).

%------------------------------------------------------------------------------
