%------------------------------------------------------------------------------
% File     : CSR116+16 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Who was the first black president elected in South Africa?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_010_mira_news_1726_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.47 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.36 v7.5.0, 0.52 v7.4.0, 0.38 v7.3.0, 0.71 v7.2.0, 0.67 v7.1.0, 0.50 v7.0.0, 0.43 v6.4.0, 0.36 v6.3.0, 0.38 v6.2.0, 0.55 v6.1.0, 0.72 v6.0.0, 0.50 v5.5.0, 0.67 v5.4.0, 0.65 v5.3.0, 0.70 v5.2.0, 0.50 v5.0.0, 0.65 v4.1.0, 0.67 v4.0.1, 0.74 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10837 (   0 equ)
%            Maximal formula atoms :  124 (   1 avg)
%            Number of connectives :  648 (   0   ~;  18   |; 504   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  124 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   88 (  88 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16651 (16651 usr;16650 con; 0-2 aty)
%            Number of variables   :  478 ( 405   !;  73   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_010_mira_news_1726,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7,X8,X9] :
      ( in(X5,X6)
      & arg1(X3,X0)
      & arg2(X3,X4)
      & attr(X0,X1)
      & attr(X0,X2)
      & attr(X6,X7)
      & obj(X8,X0)
      & sub(X1,familiename_1_1)
      & sub(X2,eigenname_1_1)
      & sub(X4,X9)
      & sub(X7,name_1_1)
      & subr(X3,rprs_0)
      & val(X1,mandela_0)
      & val(X2,nelson_0)
      & val(X7,s__374dafrika_0) ) ).

fof(ave07_era5_synth_qa07_010_mira_news_1726,hypothesis,
    ( attr(c18,c19)
    & attr(c18,c20)
    & prop(c18,s__374dafrikanisch_1_1)
    & sub(c18,pr__344sident_1_1)
    & sub(c19,eigenname_1_1)
    & val(c19,nelson_0)
    & sub(c20,familiename_1_1)
    & val(c20,mandela_0)
    & agt(c28,c292)
    & subs(c28,besuch_1_1)
    & circ(c31,c9)
    & exp(c31,c292)
    & mannr(c31,c1)
    & subs(c31,zeigen_1_4)
    & attch(c9,c18)
    & ornt(c9,c28)
    & prop(c9,hoch_1_1)
    & reas(c9,c31)
    & subs(c9,interesse_1_1)
    & chsp2(erfreuen_1_2,c1)
    & sort(c18,d)
    & card(c18,int1)
    & etype(c18,int0)
    & fact(c18,real)
    & gener(c18,sp)
    & quant(c18,one)
    & refer(c18,det)
    & varia(c18,con)
    & sort(c19,na)
    & card(c19,int1)
    & etype(c19,int0)
    & fact(c19,real)
    & gener(c19,sp)
    & quant(c19,one)
    & refer(c19,indet)
    & varia(c19,varia_c)
    & sort(c20,na)
    & card(c20,int1)
    & etype(c20,int0)
    & fact(c20,real)
    & gener(c20,sp)
    & quant(c20,one)
    & refer(c20,indet)
    & varia(c20,varia_c)
    & sort(s__374dafrikanisch_1_1,nq)
    & sort(pr__344sident_1_1,d)
    & card(pr__344sident_1_1,int1)
    & etype(pr__344sident_1_1,int0)
    & fact(pr__344sident_1_1,real)
    & gener(pr__344sident_1_1,ge)
    & quant(pr__344sident_1_1,one)
    & refer(pr__344sident_1_1,refer_c)
    & varia(pr__344sident_1_1,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(nelson_0,fe)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(mandela_0,fe)
    & sort(c28,ad)
    & sort(c28,as)
    & card(c28,int1)
    & etype(c28,int0)
    & fact(c28,real)
    & gener(c28,sp)
    & quant(c28,one)
    & refer(c28,det)
    & varia(c28,varia_c)
    & sort(c292,o)
    & card(c292,int1)
    & etype(c292,int0)
    & fact(c292,real)
    & gener(c292,sp)
    & quant(c292,one)
    & refer(c292,det)
    & varia(c292,varia_c)
    & sort(besuch_1_1,ad)
    & sort(besuch_1_1,as)
    & card(besuch_1_1,int1)
    & etype(besuch_1_1,int0)
    & fact(besuch_1_1,real)
    & gener(besuch_1_1,ge)
    & quant(besuch_1_1,one)
    & refer(besuch_1_1,refer_c)
    & varia(besuch_1_1,varia_c)
    & sort(c31,dn)
    & fact(c31,real)
    & gener(c31,sp)
    & sort(c9,as)
    & card(c9,int1)
    & etype(c9,int0)
    & fact(c9,real)
    & gener(c9,sp)
    & quant(c9,one)
    & refer(c9,det)
    & varia(c9,con)
    & sort(c1,tq)
    & sort(zeigen_1_4,dn)
    & fact(zeigen_1_4,real)
    & gener(zeigen_1_4,ge)
    & sort(hoch_1_1,mq)
    & sort(interesse_1_1,as)
    & card(interesse_1_1,int1)
    & etype(interesse_1_1,int0)
    & fact(interesse_1_1,real)
    & gener(interesse_1_1,ge)
    & quant(interesse_1_1,one)
    & refer(interesse_1_1,refer_c)
    & varia(interesse_1_1,varia_c)
    & sort(erfreuen_1_2,da)
    & fact(erfreuen_1_2,real)
    & gener(erfreuen_1_2,ge) ) ).

%------------------------------------------------------------------------------
