%------------------------------------------------------------------------------
% File     : CSR116+15 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Who was the first black president elected in South Africa?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_010_mira_news_1724_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.47 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.36 v7.5.0, 0.52 v7.4.0, 0.38 v7.3.0, 0.57 v7.2.0, 0.50 v7.0.0, 0.43 v6.3.0, 0.38 v6.2.0, 0.64 v6.1.0, 0.72 v6.0.0, 0.50 v5.5.0, 0.62 v5.4.0, 0.61 v5.3.0, 0.74 v5.2.0, 0.50 v5.0.0, 0.60 v4.1.0, 0.67 v4.0.1, 0.68 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 11035 (   0 equ)
%            Maximal formula atoms :  323 (   1 avg)
%            Number of connectives :  846 (   0   ~;  18   |; 702   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  323 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   88 (  88 usr;   0 prp; 2-8 aty)
%            Number of functors    : 16669 (16669 usr;16668 con; 0-2 aty)
%            Number of variables   :  477 ( 405   !;  72   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_010_mira_news_1724,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7,X8] :
      ( arg1(X3,X0)
      & arg2(X3,X4)
      & attr(X0,X1)
      & attr(X0,X2)
      & attr(X5,X6)
      & obj(X7,X0)
      & sub(X1,familiename_1_1)
      & sub(X2,eigenname_1_1)
      & sub(X4,X8)
      & sub(X6,name_1_1)
      & subr(X3,rprs_0)
      & val(X1,mandela_0)
      & val(X2,nelson_0)
      & val(X6,s__374dafrika_0) ) ).

fof(ave07_era5_synth_qa07_010_mira_news_1724,hypothesis,
    ( sub(c37989,attribut__1_1)
    & attch(c38000,c38006)
    & attr(c38000,c38001)
    & sub(c38000,land_1_1)
    & sub(c38001,name_1_1)
    & val(c38001,s__374dafrika_0)
    & attr(c38006,c38007)
    & attr(c38006,c38008)
    & sub(c38006,pr__344sident_1_1)
    & sub(c38007,eigenname_1_1)
    & val(c38007,nelson_0)
    & sub(c38008,familiename_1_1)
    & val(c38008,mandela_0)
    & sub(c38015,schuldenproblem_1_1)
    & attch(c38022,c38015)
    & attr(c38022,c38023)
    & sub(c38022,gebietsinstitution_1_1)
    & sub(c38023,name_1_1)
    & val(c38023,afrika_0)
    & prop(c38029,c37984)
    & rslt(c38029,c38035)
    & subs(c38029,schaffung_1_1)
    & prop(c38035,gemeinsam_1_1)
    & sub(c38035,markt_1_1)
    & predr(c38044,gesch__344ftbeziehung_1_1)
    & attch(c38049,c38044)
    & pred(c38049,land_1_1)
    & prop(c38049,afrikanisch__1_1)
    & attr(c38064,c38065)
    & sub(c38064,einrichtung_1_2)
    & sub(c38065,name_1_1)
    & val(c38065,eu_0)
    & tupl_p8(c38071,c37989,c37993,c38006,c38015,c38029,c38044,c38064)
    & assoc(gesch__344ftbeziehung_1_1,gesch__344ft_1_2)
    & subr(gesch__344ftbeziehung_1_1,be_ziehung_1_1)
    & chsp2(planen_1_1,c37984)
    & assoc(schuldenproblem_1_1,schulden_2_1)
    & sub(schuldenproblem_1_1,problem_1_1)
    & sort(c37989,io)
    & sort(c37989,na)
    & card(c37989,int1)
    & etype(c37989,int0)
    & fact(c37989,real)
    & gener(c37989,sp)
    & quant(c37989,one)
    & refer(c37989,det)
    & varia(c37989,varia_c)
    & sort(attribut__1_1,io)
    & sort(attribut__1_1,na)
    & card(attribut__1_1,int1)
    & etype(attribut__1_1,int0)
    & fact(attribut__1_1,real)
    & gener(attribut__1_1,ge)
    & quant(attribut__1_1,one)
    & refer(attribut__1_1,refer_c)
    & varia(attribut__1_1,varia_c)
    & sort(c38000,d)
    & sort(c38000,io)
    & card(c38000,int1)
    & etype(c38000,int0)
    & fact(c38000,real)
    & gener(c38000,sp)
    & quant(c38000,one)
    & refer(c38000,det)
    & varia(c38000,con)
    & sort(c38006,d)
    & card(c38006,int1)
    & etype(c38006,int0)
    & fact(c38006,real)
    & gener(c38006,sp)
    & quant(c38006,one)
    & refer(c38006,det)
    & varia(c38006,varia_c)
    & sort(c38001,na)
    & card(c38001,int1)
    & etype(c38001,int0)
    & fact(c38001,real)
    & gener(c38001,sp)
    & quant(c38001,one)
    & refer(c38001,indet)
    & varia(c38001,varia_c)
    & sort(land_1_1,d)
    & sort(land_1_1,io)
    & card(land_1_1,int1)
    & etype(land_1_1,int0)
    & fact(land_1_1,real)
    & gener(land_1_1,ge)
    & quant(land_1_1,one)
    & refer(land_1_1,refer_c)
    & varia(land_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(s__374dafrika_0,fe)
    & sort(c38007,na)
    & card(c38007,int1)
    & etype(c38007,int0)
    & fact(c38007,real)
    & gener(c38007,sp)
    & quant(c38007,one)
    & refer(c38007,indet)
    & varia(c38007,varia_c)
    & sort(c38008,na)
    & card(c38008,int1)
    & etype(c38008,int0)
    & fact(c38008,real)
    & gener(c38008,sp)
    & quant(c38008,one)
    & refer(c38008,indet)
    & varia(c38008,varia_c)
    & sort(pr__344sident_1_1,d)
    & card(pr__344sident_1_1,int1)
    & etype(pr__344sident_1_1,int0)
    & fact(pr__344sident_1_1,real)
    & gener(pr__344sident_1_1,ge)
    & quant(pr__344sident_1_1,one)
    & refer(pr__344sident_1_1,refer_c)
    & varia(pr__344sident_1_1,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(nelson_0,fe)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(mandela_0,fe)
    & sort(c38015,as)
    & sort(c38015,io)
    & card(c38015,int1)
    & etype(c38015,int0)
    & fact(c38015,real)
    & gener(c38015,sp)
    & quant(c38015,one)
    & refer(c38015,det)
    & varia(c38015,con)
    & sort(schuldenproblem_1_1,as)
    & sort(schuldenproblem_1_1,io)
    & card(schuldenproblem_1_1,int1)
    & etype(schuldenproblem_1_1,int0)
    & fact(schuldenproblem_1_1,real)
    & gener(schuldenproblem_1_1,ge)
    & quant(schuldenproblem_1_1,one)
    & refer(schuldenproblem_1_1,refer_c)
    & varia(schuldenproblem_1_1,varia_c)
    & sort(c38022,d)
    & sort(c38022,io)
    & card(c38022,int1)
    & etype(c38022,int0)
    & fact(c38022,real)
    & gener(c38022,sp)
    & quant(c38022,one)
    & refer(c38022,det)
    & varia(c38022,con)
    & sort(c38023,na)
    & card(c38023,int1)
    & etype(c38023,int0)
    & fact(c38023,real)
    & gener(c38023,sp)
    & quant(c38023,one)
    & refer(c38023,indet)
    & varia(c38023,varia_c)
    & sort(gebietsinstitution_1_1,d)
    & sort(gebietsinstitution_1_1,io)
    & card(gebietsinstitution_1_1,int1)
    & etype(gebietsinstitution_1_1,int0)
    & fact(gebietsinstitution_1_1,real)
    & gener(gebietsinstitution_1_1,ge)
    & quant(gebietsinstitution_1_1,one)
    & refer(gebietsinstitution_1_1,refer_c)
    & varia(gebietsinstitution_1_1,varia_c)
    & sort(afrika_0,fe)
    & sort(c38029,ad)
    & card(c38029,int1)
    & etype(c38029,int0)
    & fact(c38029,real)
    & gener(c38029,sp)
    & quant(c38029,one)
    & refer(c38029,det)
    & varia(c38029,con)
    & sort(c37984,tq)
    & sort(c38035,d)
    & card(c38035,int1)
    & etype(c38035,int0)
    & fact(c38035,real)
    & gener(c38035,sp)
    & quant(c38035,one)
    & refer(c38035,indet)
    & varia(c38035,varia_c)
    & sort(schaffung_1_1,ad)
    & card(schaffung_1_1,int1)
    & etype(schaffung_1_1,int0)
    & fact(schaffung_1_1,real)
    & gener(schaffung_1_1,ge)
    & quant(schaffung_1_1,one)
    & refer(schaffung_1_1,refer_c)
    & varia(schaffung_1_1,varia_c)
    & sort(gemeinsam_1_1,tq)
    & sort(markt_1_1,d)
    & card(markt_1_1,int1)
    & etype(markt_1_1,int0)
    & fact(markt_1_1,real)
    & gener(markt_1_1,ge)
    & quant(markt_1_1,one)
    & refer(markt_1_1,refer_c)
    & varia(markt_1_1,varia_c)
    & sort(c38044,as)
    & sort(c38044,re)
    & card(c38044,cons(x_constant,cons(int1,nil)))
    & etype(c38044,int1)
    & fact(c38044,real)
    & gener(c38044,sp)
    & quant(c38044,mult)
    & refer(c38044,det)
    & varia(c38044,con)
    & sort(gesch__344ftbeziehung_1_1,as)
    & sort(gesch__344ftbeziehung_1_1,re)
    & card(gesch__344ftbeziehung_1_1,int1)
    & etype(gesch__344ftbeziehung_1_1,int0)
    & fact(gesch__344ftbeziehung_1_1,real)
    & gener(gesch__344ftbeziehung_1_1,ge)
    & quant(gesch__344ftbeziehung_1_1,one)
    & refer(gesch__344ftbeziehung_1_1,refer_c)
    & varia(gesch__344ftbeziehung_1_1,varia_c)
    & sort(c38049,d)
    & sort(c38049,io)
    & card(c38049,cons(x_constant,cons(int1,nil)))
    & etype(c38049,int1)
    & fact(c38049,real)
    & gener(c38049,sp)
    & quant(c38049,mult)
    & refer(c38049,det)
    & varia(c38049,con)
    & sort(afrikanisch__1_1,nq)
    & sort(c38064,d)
    & sort(c38064,io)
    & card(c38064,int1)
    & etype(c38064,int1)
    & fact(c38064,real)
    & gener(c38064,sp)
    & quant(c38064,one)
    & refer(c38064,det)
    & varia(c38064,con)
    & sort(c38065,na)
    & card(c38065,int1)
    & etype(c38065,int0)
    & fact(c38065,real)
    & gener(c38065,sp)
    & quant(c38065,one)
    & refer(c38065,indet)
    & varia(c38065,varia_c)
    & sort(einrichtung_1_2,d)
    & sort(einrichtung_1_2,io)
    & card(einrichtung_1_2,card_c)
    & etype(einrichtung_1_2,int1)
    & fact(einrichtung_1_2,real)
    & gener(einrichtung_1_2,ge)
    & quant(einrichtung_1_2,quant_c)
    & refer(einrichtung_1_2,refer_c)
    & varia(einrichtung_1_2,varia_c)
    & sort(eu_0,fe)
    & sort(c38071,ent)
    & card(c38071,card_c)
    & etype(c38071,etype_c)
    & fact(c38071,real)
    & gener(c38071,gener_c)
    & quant(c38071,quant_c)
    & refer(c38071,refer_c)
    & varia(c38071,varia_c)
    & sort(c37993,o)
    & card(c37993,int1)
    & etype(c37993,int0)
    & fact(c37993,real)
    & gener(c37993,sp)
    & quant(c37993,one)
    & refer(c37993,det)
    & varia(c37993,varia_c)
    & sort(gesch__344ft_1_2,ad)
    & card(gesch__344ft_1_2,int1)
    & etype(gesch__344ft_1_2,int0)
    & fact(gesch__344ft_1_2,real)
    & gener(gesch__344ft_1_2,ge)
    & quant(gesch__344ft_1_2,one)
    & refer(gesch__344ft_1_2,refer_c)
    & varia(gesch__344ft_1_2,varia_c)
    & sort(be_ziehung_1_1,as)
    & sort(be_ziehung_1_1,re)
    & card(be_ziehung_1_1,int1)
    & etype(be_ziehung_1_1,int0)
    & fact(be_ziehung_1_1,real)
    & gener(be_ziehung_1_1,ge)
    & quant(be_ziehung_1_1,one)
    & refer(be_ziehung_1_1,refer_c)
    & varia(be_ziehung_1_1,varia_c)
    & sort(planen_1_1,da)
    & fact(planen_1_1,real)
    & gener(planen_1_1,ge)
    & sort(schulden_2_1,st)
    & fact(schulden_2_1,real)
    & gener(schulden_2_1,ge)
    & sort(problem_1_1,as)
    & sort(problem_1_1,io)
    & card(problem_1_1,int1)
    & etype(problem_1_1,int0)
    & fact(problem_1_1,real)
    & gener(problem_1_1,ge)
    & quant(problem_1_1,one)
    & refer(problem_1_1,refer_c)
    & varia(problem_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
