%------------------------------------------------------------------------------
% File     : CSR116+14 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Who was the first black president elected in South Africa?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_010_mira_news_1721_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.40 v9.1.0, 0.53 v9.0.0, 0.31 v8.2.0, 0.27 v8.1.0, 0.36 v7.5.0, 0.52 v7.4.0, 0.38 v7.3.0, 0.57 v7.2.0, 0.50 v6.4.0, 0.36 v6.3.0, 0.38 v6.2.0, 0.64 v6.1.0, 0.68 v6.0.0, 0.50 v5.5.0, 0.67 v5.4.0, 0.65 v5.3.0, 0.78 v5.2.0, 0.57 v5.0.0, 0.70 v4.1.0, 0.72 v4.0.1, 0.74 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 11028 (   0 equ)
%            Maximal formula atoms :  315 (   1 avg)
%            Number of connectives :  839 (   0   ~;  18   |; 695   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  315 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-7 aty)
%            Number of functors    : 16669 (16669 usr;16668 con; 0-2 aty)
%            Number of variables   :  478 ( 405   !;  73   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_010_mira_news_1721,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7,X8,X9] :
      ( in(X5,X6)
      & arg1(X3,X0)
      & arg2(X3,X4)
      & attr(X0,X1)
      & attr(X0,X2)
      & attr(X6,X7)
      & obj(X8,X0)
      & sub(X1,familiename_1_1)
      & sub(X2,eigenname_1_1)
      & sub(X4,X9)
      & sub(X7,name_1_1)
      & subr(X3,rprs_0)
      & val(X1,mandela_0)
      & val(X2,nelson_0)
      & val(X7,s__374dafrika_0) ) ).

fof(ave07_era5_synth_qa07_010_mira_news_1721,hypothesis,
    ( sub(c106,regierung_1_1)
    & sub(c111,gerichtsbarkeit_1_1)
    & attr(c15,c16)
    & sub(c15,stadt__1_1)
    & sub(c16,name_1_1)
    & val(c16,kapstadt_0)
    & tupl_p7(c160,c71,c87,c93,c99,c106,c111)
    & attr(c21,c22)
    & attr(c21,c23)
    & sub(c22,tag_1_1)
    & val(c22,c19)
    & sub(c23,monat_1_1)
    & val(c23,c20)
    & tupl(c47,c15,c21)
    & prop(c71,anfechtbar_1_1)
    & sub(c71,frau_1_1)
    & attch(c80,c71)
    & attr(c80,c81)
    & attr(c80,c82)
    & prop(c80,s__374dafrikanisch_1_1)
    & sub(c80,pr__344sident_1_1)
    & sub(c81,eigenname_1_1)
    & val(c81,nelson_0)
    & sub(c82,familiename_1_1)
    & val(c82,mandela_0)
    & attr(c87,c88)
    & attr(c87,c89)
    & sub(c87,mensch_1_1)
    & sub(c88,eigenname_1_1)
    & val(c88,winnie_0)
    & sub(c89,familiename_1_1)
    & val(c89,mandela_0)
    & sub(c93,sich_1_1)
    & agt(c99,c103)
    & subs(c99,rueckkehr_1_1)
    & sort(c106,d)
    & sort(c106,io)
    & card(c106,int1)
    & etype(c106,int1)
    & fact(c106,real)
    & gener(c106,sp)
    & quant(c106,one)
    & refer(c106,det)
    & varia(c106,con)
    & sort(regierung_1_1,d)
    & sort(regierung_1_1,io)
    & card(regierung_1_1,card_c)
    & etype(regierung_1_1,int1)
    & fact(regierung_1_1,real)
    & gener(regierung_1_1,ge)
    & quant(regierung_1_1,quant_c)
    & refer(regierung_1_1,refer_c)
    & varia(regierung_1_1,varia_c)
    & sort(c111,d)
    & sort(c111,io)
    & card(c111,int1)
    & etype(c111,int1)
    & fact(c111,real)
    & gener(c111,sp)
    & quant(c111,one)
    & refer(c111,det)
    & varia(c111,con)
    & sort(gerichtsbarkeit_1_1,d)
    & sort(gerichtsbarkeit_1_1,io)
    & card(gerichtsbarkeit_1_1,card_c)
    & etype(gerichtsbarkeit_1_1,int1)
    & fact(gerichtsbarkeit_1_1,real)
    & gener(gerichtsbarkeit_1_1,ge)
    & quant(gerichtsbarkeit_1_1,quant_c)
    & refer(gerichtsbarkeit_1_1,refer_c)
    & varia(gerichtsbarkeit_1_1,varia_c)
    & sort(c15,d)
    & sort(c15,io)
    & card(c15,int1)
    & etype(c15,int0)
    & fact(c15,real)
    & gener(c15,sp)
    & quant(c15,one)
    & refer(c15,det)
    & varia(c15,con)
    & sort(c16,na)
    & card(c16,int1)
    & etype(c16,int0)
    & fact(c16,real)
    & gener(c16,sp)
    & quant(c16,one)
    & refer(c16,indet)
    & varia(c16,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(kapstadt_0,fe)
    & sort(c160,ent)
    & card(c160,card_c)
    & etype(c160,etype_c)
    & fact(c160,real)
    & gener(c160,gener_c)
    & quant(c160,quant_c)
    & refer(c160,refer_c)
    & varia(c160,varia_c)
    & sort(c71,d)
    & card(c71,int1)
    & etype(c71,int0)
    & fact(c71,real)
    & gener(c71,sp)
    & quant(c71,one)
    & refer(c71,det)
    & varia(c71,con)
    & sort(c87,d)
    & card(c87,int1)
    & etype(c87,int0)
    & fact(c87,real)
    & gener(c87,sp)
    & quant(c87,one)
    & refer(c87,det)
    & varia(c87,con)
    & sort(c93,o)
    & card(c93,int1)
    & etype(c93,int0)
    & fact(c93,real)
    & gener(c93,gener_c)
    & quant(c93,one)
    & refer(c93,refer_c)
    & varia(c93,varia_c)
    & sort(c99,ad)
    & card(c99,int1)
    & etype(c99,int0)
    & fact(c99,real)
    & gener(c99,sp)
    & quant(c99,one)
    & refer(c99,det)
    & varia(c99,varia_c)
    & sort(c21,t)
    & card(c21,int1)
    & etype(c21,int0)
    & fact(c21,real)
    & gener(c21,sp)
    & quant(c21,one)
    & refer(c21,det)
    & varia(c21,con)
    & sort(c22,me)
    & sort(c22,oa)
    & sort(c22,ta)
    & card(c22,card_c)
    & etype(c22,etype_c)
    & fact(c22,real)
    & gener(c22,sp)
    & quant(c22,quant_c)
    & refer(c22,refer_c)
    & varia(c22,varia_c)
    & sort(c23,me)
    & sort(c23,oa)
    & sort(c23,ta)
    & card(c23,card_c)
    & etype(c23,etype_c)
    & fact(c23,real)
    & gener(c23,sp)
    & quant(c23,quant_c)
    & refer(c23,refer_c)
    & varia(c23,varia_c)
    & sort(tag_1_1,me)
    & sort(tag_1_1,oa)
    & sort(tag_1_1,ta)
    & card(tag_1_1,card_c)
    & etype(tag_1_1,etype_c)
    & fact(tag_1_1,real)
    & gener(tag_1_1,ge)
    & quant(tag_1_1,quant_c)
    & refer(tag_1_1,refer_c)
    & varia(tag_1_1,varia_c)
    & sort(c19,nu)
    & card(c19,int11)
    & sort(monat_1_1,me)
    & sort(monat_1_1,oa)
    & sort(monat_1_1,ta)
    & card(monat_1_1,card_c)
    & etype(monat_1_1,etype_c)
    & fact(monat_1_1,real)
    & gener(monat_1_1,ge)
    & quant(monat_1_1,quant_c)
    & refer(monat_1_1,refer_c)
    & varia(monat_1_1,varia_c)
    & sort(c20,nu)
    & card(c20,int4)
    & sort(c47,ent)
    & card(c47,card_c)
    & etype(c47,etype_c)
    & fact(c47,real)
    & gener(c47,gener_c)
    & quant(c47,quant_c)
    & refer(c47,refer_c)
    & varia(c47,varia_c)
    & sort(anfechtbar_1_1,nq)
    & sort(frau_1_1,d)
    & card(frau_1_1,int1)
    & etype(frau_1_1,int0)
    & fact(frau_1_1,real)
    & gener(frau_1_1,ge)
    & quant(frau_1_1,one)
    & refer(frau_1_1,refer_c)
    & varia(frau_1_1,varia_c)
    & sort(c80,d)
    & card(c80,int1)
    & etype(c80,int0)
    & fact(c80,real)
    & gener(c80,sp)
    & quant(c80,one)
    & refer(c80,det)
    & varia(c80,con)
    & sort(c81,na)
    & card(c81,int1)
    & etype(c81,int0)
    & fact(c81,real)
    & gener(c81,sp)
    & quant(c81,one)
    & refer(c81,indet)
    & varia(c81,varia_c)
    & sort(c82,na)
    & card(c82,int1)
    & etype(c82,int0)
    & fact(c82,real)
    & gener(c82,sp)
    & quant(c82,one)
    & refer(c82,indet)
    & varia(c82,varia_c)
    & sort(s__374dafrikanisch_1_1,nq)
    & sort(pr__344sident_1_1,d)
    & card(pr__344sident_1_1,int1)
    & etype(pr__344sident_1_1,int0)
    & fact(pr__344sident_1_1,real)
    & gener(pr__344sident_1_1,ge)
    & quant(pr__344sident_1_1,one)
    & refer(pr__344sident_1_1,refer_c)
    & varia(pr__344sident_1_1,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(nelson_0,fe)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(mandela_0,fe)
    & sort(c88,na)
    & card(c88,int1)
    & etype(c88,int0)
    & fact(c88,real)
    & gener(c88,sp)
    & quant(c88,one)
    & refer(c88,indet)
    & varia(c88,varia_c)
    & sort(c89,na)
    & card(c89,int1)
    & etype(c89,int0)
    & fact(c89,real)
    & gener(c89,sp)
    & quant(c89,one)
    & refer(c89,indet)
    & varia(c89,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(winnie_0,fe)
    & sort(sich_1_1,o)
    & card(sich_1_1,int1)
    & etype(sich_1_1,int0)
    & fact(sich_1_1,real)
    & gener(sich_1_1,gener_c)
    & quant(sich_1_1,one)
    & refer(sich_1_1,refer_c)
    & varia(sich_1_1,varia_c)
    & sort(c103,o)
    & card(c103,int1)
    & etype(c103,int0)
    & fact(c103,real)
    & gener(c103,sp)
    & quant(c103,one)
    & refer(c103,det)
    & varia(c103,varia_c)
    & sort(rueckkehr_1_1,ad)
    & card(rueckkehr_1_1,int1)
    & etype(rueckkehr_1_1,int0)
    & fact(rueckkehr_1_1,real)
    & gener(rueckkehr_1_1,ge)
    & quant(rueckkehr_1_1,one)
    & refer(rueckkehr_1_1,refer_c)
    & varia(rueckkehr_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
