%------------------------------------------------------------------------------
% File     : CSR116+13 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Who was the first black president elected in South Africa?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_010_mira_news_1718_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.40 v9.1.0, 0.47 v9.0.0, 0.25 v8.2.0, 0.27 v8.1.0, 0.36 v7.5.0, 0.52 v7.4.0, 0.38 v7.3.0, 0.57 v7.2.0, 0.50 v6.4.0, 0.36 v6.3.0, 0.38 v6.2.0, 0.64 v6.1.0, 0.72 v6.0.0, 0.75 v5.5.0, 0.67 v5.4.0, 0.65 v5.3.0, 0.74 v5.2.0, 0.50 v5.0.0, 0.60 v4.1.0, 0.67 v4.0.1, 0.68 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10934 (   0 equ)
%            Maximal formula atoms :  222 (   1 avg)
%            Number of connectives :  745 (   0   ~;  18   |; 601   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  222 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-7 aty)
%            Number of functors    : 16659 (16659 usr;16658 con; 0-2 aty)
%            Number of variables   :  477 ( 405   !;  72   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_010_mira_news_1718,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7,X8] :
      ( arg1(X3,X0)
      & arg2(X3,X4)
      & attr(X0,X1)
      & attr(X0,X2)
      & attr(X5,X6)
      & obj(X7,X0)
      & sub(X1,familiename_1_1)
      & sub(X2,eigenname_1_1)
      & sub(X4,X8)
      & sub(X6,name_1_1)
      & subr(X3,rprs_0)
      & val(X1,mandela_0)
      & val(X2,nelson_0)
      & val(X6,s__374dafrika_0) ) ).

fof(ave07_era5_synth_qa07_010_mira_news_1718,hypothesis,
    ( assoc(auszeichnungstr__344ger_1_1,auszeichnung_1_1)
    & sub(auszeichnungstr__344ger_1_1,traegerin_1_1)
    & pmod(c1,ehemalig_1_1,auszeichnungstr__344ger_1_1)
    & pred(c345,c1)
    & pred(c355,pr__344sident_1_1)
    & attr(c360,c361)
    & attr(c360,c362)
    & sub(c360,mensch_1_1)
    & sub(c361,eigenname_1_1)
    & val(c361,nelson_0)
    & sub(c362,familiename_1_1)
    & val(c362,mandela_0)
    & attr(c367,c368)
    & sub(c367,land_1_1)
    & sub(c368,name_1_1)
    & val(c368,s__374dafrika_0)
    & attr(c375,c376)
    & attr(c375,c377)
    & sub(c375,mensch_1_1)
    & sub(c376,eigenname_1_1)
    & val(c376,jerry_0)
    & sub(c377,familiename_1_1)
    & val(c377,rawling_0)
    & attr(c382,c383)
    & sub(c382,land_1_1)
    & sub(c383,name_1_1)
    & val(c383,ghana_0)
    & tupl_p7(c636,c345,c355,c360,c367,c375,c382)
    & sort(auszeichnungstr__344ger_1_1,d)
    & card(auszeichnungstr__344ger_1_1,int1)
    & etype(auszeichnungstr__344ger_1_1,int0)
    & fact(auszeichnungstr__344ger_1_1,real)
    & gener(auszeichnungstr__344ger_1_1,ge)
    & quant(auszeichnungstr__344ger_1_1,one)
    & refer(auszeichnungstr__344ger_1_1,refer_c)
    & varia(auszeichnungstr__344ger_1_1,varia_c)
    & sort(auszeichnung_1_1,d)
    & card(auszeichnung_1_1,int1)
    & etype(auszeichnung_1_1,int0)
    & fact(auszeichnung_1_1,real)
    & gener(auszeichnung_1_1,ge)
    & quant(auszeichnung_1_1,one)
    & refer(auszeichnung_1_1,refer_c)
    & varia(auszeichnung_1_1,varia_c)
    & sort(traegerin_1_1,d)
    & card(traegerin_1_1,int1)
    & etype(traegerin_1_1,int0)
    & fact(traegerin_1_1,real)
    & gener(traegerin_1_1,ge)
    & quant(traegerin_1_1,one)
    & refer(traegerin_1_1,refer_c)
    & varia(traegerin_1_1,varia_c)
    & sort(c1,ent)
    & card(c1,card_c)
    & etype(c1,etype_c)
    & fact(c1,fact_c)
    & gener(c1,gener_c)
    & quant(c1,quant_c)
    & refer(c1,refer_c)
    & varia(c1,varia_c)
    & sort(ehemalig_1_1,tq)
    & sort(c345,d)
    & card(c345,cons(x_constant,cons(int1,nil)))
    & etype(c345,int1)
    & fact(c345,real)
    & gener(c345,gener_c)
    & quant(c345,mult)
    & refer(c345,refer_c)
    & varia(c345,varia_c)
    & sort(c355,d)
    & card(c355,cons(x_constant,cons(int1,nil)))
    & etype(c355,int1)
    & fact(c355,real)
    & gener(c355,sp)
    & quant(c355,mult)
    & refer(c355,det)
    & varia(c355,con)
    & sort(pr__344sident_1_1,d)
    & card(pr__344sident_1_1,int1)
    & etype(pr__344sident_1_1,int0)
    & fact(pr__344sident_1_1,real)
    & gener(pr__344sident_1_1,ge)
    & quant(pr__344sident_1_1,one)
    & refer(pr__344sident_1_1,refer_c)
    & varia(pr__344sident_1_1,varia_c)
    & sort(c360,d)
    & card(c360,int1)
    & etype(c360,int0)
    & fact(c360,real)
    & gener(c360,sp)
    & quant(c360,one)
    & refer(c360,det)
    & varia(c360,con)
    & sort(c361,na)
    & card(c361,int1)
    & etype(c361,int0)
    & fact(c361,real)
    & gener(c361,sp)
    & quant(c361,one)
    & refer(c361,indet)
    & varia(c361,varia_c)
    & sort(c362,na)
    & card(c362,int1)
    & etype(c362,int0)
    & fact(c362,real)
    & gener(c362,sp)
    & quant(c362,one)
    & refer(c362,indet)
    & varia(c362,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(nelson_0,fe)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(mandela_0,fe)
    & sort(c367,d)
    & sort(c367,io)
    & card(c367,int1)
    & etype(c367,int0)
    & fact(c367,real)
    & gener(c367,sp)
    & quant(c367,one)
    & refer(c367,det)
    & varia(c367,con)
    & sort(c368,na)
    & card(c368,int1)
    & etype(c368,int0)
    & fact(c368,real)
    & gener(c368,sp)
    & quant(c368,one)
    & refer(c368,indet)
    & varia(c368,varia_c)
    & sort(land_1_1,d)
    & sort(land_1_1,io)
    & card(land_1_1,int1)
    & etype(land_1_1,int0)
    & fact(land_1_1,real)
    & gener(land_1_1,ge)
    & quant(land_1_1,one)
    & refer(land_1_1,refer_c)
    & varia(land_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(s__374dafrika_0,fe)
    & sort(c375,d)
    & card(c375,int1)
    & etype(c375,int0)
    & fact(c375,real)
    & gener(c375,sp)
    & quant(c375,one)
    & refer(c375,det)
    & varia(c375,con)
    & sort(c376,na)
    & card(c376,int1)
    & etype(c376,int0)
    & fact(c376,real)
    & gener(c376,sp)
    & quant(c376,one)
    & refer(c376,indet)
    & varia(c376,varia_c)
    & sort(c377,na)
    & card(c377,int1)
    & etype(c377,int0)
    & fact(c377,real)
    & gener(c377,sp)
    & quant(c377,one)
    & refer(c377,indet)
    & varia(c377,varia_c)
    & sort(jerry_0,fe)
    & sort(rawling_0,fe)
    & sort(c382,d)
    & sort(c382,io)
    & card(c382,int1)
    & etype(c382,int0)
    & fact(c382,real)
    & gener(c382,sp)
    & quant(c382,one)
    & refer(c382,det)
    & varia(c382,con)
    & sort(c383,na)
    & card(c383,int1)
    & etype(c383,int0)
    & fact(c383,real)
    & gener(c383,sp)
    & quant(c383,one)
    & refer(c383,indet)
    & varia(c383,varia_c)
    & sort(ghana_0,fe)
    & sort(c636,ent)
    & card(c636,card_c)
    & etype(c636,etype_c)
    & fact(c636,real)
    & gener(c636,gener_c)
    & quant(c636,quant_c)
    & refer(c636,refer_c)
    & varia(c636,varia_c) ) ).

%------------------------------------------------------------------------------
