%------------------------------------------------------------------------------
% File     : CSR116+12 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Who was the first black president elected in South Africa?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_010_mira_news_1705_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.40 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.36 v7.5.0, 0.52 v7.4.0, 0.38 v7.3.0, 0.57 v7.2.0, 0.50 v6.4.0, 0.43 v6.3.0, 0.38 v6.2.0, 0.64 v6.1.0, 0.72 v6.0.0, 0.50 v5.5.0, 0.67 v5.4.0, 0.65 v5.3.0, 0.70 v5.2.0, 0.50 v5.0.0, 0.60 v4.1.0, 0.67 v4.0.1, 0.68 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 11160 (   0 equ)
%            Maximal formula atoms :  448 (   1 avg)
%            Number of connectives :  971 (   0   ~;  18   |; 827   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  448 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-11 aty)
%            Number of functors    : 16683 (16683 usr;16682 con; 0-2 aty)
%            Number of variables   :  477 ( 405   !;  72   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_010_mira_news_1705,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7,X8] :
      ( arg1(X3,X0)
      & arg2(X3,X4)
      & attr(X0,X1)
      & attr(X0,X2)
      & attr(X5,X6)
      & obj(X7,X0)
      & sub(X1,familiename_1_1)
      & sub(X2,eigenname_1_1)
      & sub(X4,X8)
      & sub(X6,name_1_1)
      & subr(X3,rprs_0)
      & val(X1,mandela_0)
      & val(X2,nelson_0)
      & val(X6,s__374dafrika_0) ) ).

fof(ave07_era5_synth_qa07_010_mira_news_1705,hypothesis,
    ( sub(c102,freiheitspartei_1_1)
    & attr(c11,c12)
    & sub(c11,stadt__1_1)
    & attr(c111,c112)
    & attr(c111,c113)
    & sub(c111,mensch_1_1)
    & sub(c112,eigenname_1_1)
    & val(c112,mangosuthu_0)
    & sub(c113,familiename_1_1)
    & val(c113,buthelezi_0)
    & sub(c12,name_1_1)
    & val(c12,johannesburg_0)
    & subs(c121,treffen_3_1)
    & sub(c127,pr__344sident_1_1)
    & attch(c131,c127)
    & prop(c131,afrikanisch__1_1)
    & sub(c131,national_2_1)
    & sub(c135,kongre__337_1_1)
    & attr(c144,c145)
    & attr(c144,c146)
    & sub(c144,mensch_1_1)
    & sub(c145,eigenname_1_1)
    & val(c145,nelson_0)
    & sub(c146,familiename_1_1)
    & val(c146,mandela_0)
    & subs(c153,absicht_1_1)
    & attch(c169,c153)
    & preds(c177,c179)
    & prop(c177,demokratisch__1_1)
    & pmod(c179,erst_1_1,wahl_1_1)
    & attr(c18,c19)
    & attr(c18,c20)
    & sub(c19,tag_1_1)
    & val(c19,c16)
    & attr(c198,c199)
    & sub(c198,land_1_1)
    & sub(c199,name_1_1)
    & val(c199,s__374dafrika_0)
    & sub(c20,monat_1_1)
    & val(c20,c17)
    & tupl_p11(c355,c94,c102,c111,c121,c127,c135,c144,c153,c177,c198)
    & tupl(c67,c11,c18)
    & sub(c94,an_f__374hrer_1_1)
    & attch(c98,c94)
    & sub(c98,inkatha_1_1)
    & assoc(demokratisch__1_1,demokratie__1_1)
    & assoc(freiheitspartei_1_1,freiheit_1_1)
    & sub(freiheitspartei_1_1,partei_1_1)
    & sort(c102,d)
    & sort(c102,io)
    & card(c102,int1)
    & etype(c102,int1)
    & fact(c102,real)
    & gener(c102,gener_c)
    & quant(c102,one)
    & refer(c102,refer_c)
    & varia(c102,varia_c)
    & sort(freiheitspartei_1_1,d)
    & sort(freiheitspartei_1_1,io)
    & card(freiheitspartei_1_1,card_c)
    & etype(freiheitspartei_1_1,int1)
    & fact(freiheitspartei_1_1,real)
    & gener(freiheitspartei_1_1,ge)
    & quant(freiheitspartei_1_1,quant_c)
    & refer(freiheitspartei_1_1,refer_c)
    & varia(freiheitspartei_1_1,varia_c)
    & sort(c11,d)
    & sort(c11,io)
    & card(c11,int1)
    & etype(c11,int0)
    & fact(c11,real)
    & gener(c11,sp)
    & quant(c11,one)
    & refer(c11,det)
    & varia(c11,con)
    & sort(c12,na)
    & card(c12,int1)
    & etype(c12,int0)
    & fact(c12,real)
    & gener(c12,sp)
    & quant(c12,one)
    & refer(c12,indet)
    & varia(c12,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(c111,d)
    & card(c111,int1)
    & etype(c111,int0)
    & fact(c111,real)
    & gener(c111,sp)
    & quant(c111,one)
    & refer(c111,det)
    & varia(c111,con)
    & sort(c112,na)
    & card(c112,int1)
    & etype(c112,int0)
    & fact(c112,real)
    & gener(c112,sp)
    & quant(c112,one)
    & refer(c112,indet)
    & varia(c112,varia_c)
    & sort(c113,na)
    & card(c113,int1)
    & etype(c113,int0)
    & fact(c113,real)
    & gener(c113,sp)
    & quant(c113,one)
    & refer(c113,indet)
    & varia(c113,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(mangosuthu_0,fe)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(buthelezi_0,fe)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(johannesburg_0,fe)
    & sort(c121,ad)
    & card(c121,int1)
    & etype(c121,int0)
    & fact(c121,real)
    & gener(c121,sp)
    & quant(c121,one)
    & refer(c121,indet)
    & varia(c121,varia_c)
    & sort(treffen_3_1,ad)
    & card(treffen_3_1,int1)
    & etype(treffen_3_1,int0)
    & fact(treffen_3_1,real)
    & gener(treffen_3_1,ge)
    & quant(treffen_3_1,one)
    & refer(treffen_3_1,refer_c)
    & varia(treffen_3_1,varia_c)
    & sort(c127,d)
    & card(c127,int1)
    & etype(c127,int0)
    & fact(c127,real)
    & gener(c127,sp)
    & quant(c127,one)
    & refer(c127,det)
    & varia(c127,con)
    & sort(pr__344sident_1_1,d)
    & card(pr__344sident_1_1,int1)
    & etype(pr__344sident_1_1,int0)
    & fact(pr__344sident_1_1,real)
    & gener(pr__344sident_1_1,ge)
    & quant(pr__344sident_1_1,one)
    & refer(pr__344sident_1_1,refer_c)
    & varia(pr__344sident_1_1,varia_c)
    & sort(c131,o)
    & card(c131,int1)
    & etype(c131,int0)
    & fact(c131,real)
    & gener(c131,sp)
    & quant(c131,one)
    & refer(c131,det)
    & varia(c131,con)
    & sort(afrikanisch__1_1,nq)
    & sort(national_2_1,o)
    & card(national_2_1,int1)
    & etype(national_2_1,int0)
    & fact(national_2_1,real)
    & gener(national_2_1,ge)
    & quant(national_2_1,one)
    & refer(national_2_1,refer_c)
    & varia(national_2_1,varia_c)
    & sort(c135,d)
    & sort(c135,io)
    & card(c135,int1)
    & etype(c135,int0)
    & fact(c135,real)
    & gener(c135,gener_c)
    & quant(c135,one)
    & refer(c135,refer_c)
    & varia(c135,varia_c)
    & sort(kongre__337_1_1,d)
    & sort(kongre__337_1_1,io)
    & card(kongre__337_1_1,int1)
    & etype(kongre__337_1_1,int0)
    & fact(kongre__337_1_1,real)
    & gener(kongre__337_1_1,ge)
    & quant(kongre__337_1_1,one)
    & refer(kongre__337_1_1,refer_c)
    & varia(kongre__337_1_1,varia_c)
    & sort(c144,d)
    & card(c144,int1)
    & etype(c144,int0)
    & fact(c144,real)
    & gener(c144,sp)
    & quant(c144,one)
    & refer(c144,det)
    & varia(c144,con)
    & sort(c145,na)
    & card(c145,int1)
    & etype(c145,int0)
    & fact(c145,real)
    & gener(c145,sp)
    & quant(c145,one)
    & refer(c145,indet)
    & varia(c145,varia_c)
    & sort(c146,na)
    & card(c146,int1)
    & etype(c146,int0)
    & fact(c146,real)
    & gener(c146,sp)
    & quant(c146,one)
    & refer(c146,indet)
    & varia(c146,varia_c)
    & sort(nelson_0,fe)
    & sort(mandela_0,fe)
    & sort(c153,as)
    & card(c153,int1)
    & etype(c153,int0)
    & fact(c153,real)
    & gener(c153,sp)
    & quant(c153,one)
    & refer(c153,det)
    & varia(c153,varia_c)
    & sort(absicht_1_1,as)
    & card(absicht_1_1,int1)
    & etype(absicht_1_1,int0)
    & fact(absicht_1_1,real)
    & gener(absicht_1_1,ge)
    & quant(absicht_1_1,one)
    & refer(absicht_1_1,refer_c)
    & varia(absicht_1_1,varia_c)
    & sort(c169,o)
    & card(c169,int1)
    & etype(c169,int0)
    & fact(c169,real)
    & gener(c169,sp)
    & quant(c169,one)
    & refer(c169,det)
    & varia(c169,varia_c)
    & sort(c177,ad)
    & card(c177,cons(x_constant,cons(int1,nil)))
    & etype(c177,int1)
    & fact(c177,real)
    & gener(c177,sp)
    & quant(c177,mult)
    & refer(c177,det)
    & varia(c177,con)
    & sort(c179,ad)
    & card(c179,int1)
    & etype(c179,int0)
    & fact(c179,real)
    & gener(c179,ge)
    & quant(c179,one)
    & refer(c179,refer_c)
    & varia(c179,varia_c)
    & sort(demokratisch__1_1,nq)
    & sort(erst_1_1,oq)
    & card(erst_1_1,int1)
    & sort(wahl_1_1,ad)
    & card(wahl_1_1,int1)
    & etype(wahl_1_1,int0)
    & fact(wahl_1_1,real)
    & gener(wahl_1_1,ge)
    & quant(wahl_1_1,one)
    & refer(wahl_1_1,refer_c)
    & varia(wahl_1_1,varia_c)
    & sort(c18,t)
    & card(c18,int1)
    & etype(c18,int0)
    & fact(c18,real)
    & gener(c18,sp)
    & quant(c18,one)
    & refer(c18,det)
    & varia(c18,con)
    & sort(c19,me)
    & sort(c19,oa)
    & sort(c19,ta)
    & card(c19,card_c)
    & etype(c19,etype_c)
    & fact(c19,real)
    & gener(c19,sp)
    & quant(c19,quant_c)
    & refer(c19,refer_c)
    & varia(c19,varia_c)
    & sort(c20,me)
    & sort(c20,oa)
    & sort(c20,ta)
    & card(c20,card_c)
    & etype(c20,etype_c)
    & fact(c20,real)
    & gener(c20,sp)
    & quant(c20,quant_c)
    & refer(c20,refer_c)
    & varia(c20,varia_c)
    & sort(tag_1_1,me)
    & sort(tag_1_1,oa)
    & sort(tag_1_1,ta)
    & card(tag_1_1,card_c)
    & etype(tag_1_1,etype_c)
    & fact(tag_1_1,real)
    & gener(tag_1_1,ge)
    & quant(tag_1_1,quant_c)
    & refer(tag_1_1,refer_c)
    & varia(tag_1_1,varia_c)
    & sort(c16,nu)
    & card(c16,int1)
    & sort(c198,d)
    & sort(c198,io)
    & card(c198,int1)
    & etype(c198,int0)
    & fact(c198,real)
    & gener(c198,sp)
    & quant(c198,one)
    & refer(c198,det)
    & varia(c198,con)
    & sort(c199,na)
    & card(c199,int1)
    & etype(c199,int0)
    & fact(c199,real)
    & gener(c199,sp)
    & quant(c199,one)
    & refer(c199,indet)
    & varia(c199,varia_c)
    & sort(land_1_1,d)
    & sort(land_1_1,io)
    & card(land_1_1,int1)
    & etype(land_1_1,int0)
    & fact(land_1_1,real)
    & gener(land_1_1,ge)
    & quant(land_1_1,one)
    & refer(land_1_1,refer_c)
    & varia(land_1_1,varia_c)
    & sort(s__374dafrika_0,fe)
    & sort(monat_1_1,me)
    & sort(monat_1_1,oa)
    & sort(monat_1_1,ta)
    & card(monat_1_1,card_c)
    & etype(monat_1_1,etype_c)
    & fact(monat_1_1,real)
    & gener(monat_1_1,ge)
    & quant(monat_1_1,quant_c)
    & refer(monat_1_1,refer_c)
    & varia(monat_1_1,varia_c)
    & sort(c17,nu)
    & card(c17,int3)
    & sort(c355,ent)
    & card(c355,card_c)
    & etype(c355,etype_c)
    & fact(c355,real)
    & gener(c355,gener_c)
    & quant(c355,quant_c)
    & refer(c355,refer_c)
    & varia(c355,varia_c)
    & sort(c94,d)
    & card(c94,int1)
    & etype(c94,int0)
    & fact(c94,real)
    & gener(c94,sp)
    & quant(c94,one)
    & refer(c94,det)
    & varia(c94,con)
    & sort(c67,ent)
    & card(c67,card_c)
    & etype(c67,etype_c)
    & fact(c67,real)
    & gener(c67,gener_c)
    & quant(c67,quant_c)
    & refer(c67,refer_c)
    & varia(c67,varia_c)
    & sort(an_f__374hrer_1_1,d)
    & card(an_f__374hrer_1_1,int1)
    & etype(an_f__374hrer_1_1,int0)
    & fact(an_f__374hrer_1_1,real)
    & gener(an_f__374hrer_1_1,ge)
    & quant(an_f__374hrer_1_1,one)
    & refer(an_f__374hrer_1_1,refer_c)
    & varia(an_f__374hrer_1_1,varia_c)
    & sort(c98,o)
    & card(c98,int1)
    & etype(c98,int0)
    & fact(c98,real)
    & gener(c98,sp)
    & quant(c98,one)
    & refer(c98,det)
    & varia(c98,con)
    & sort(inkatha_1_1,o)
    & card(inkatha_1_1,int1)
    & etype(inkatha_1_1,int0)
    & fact(inkatha_1_1,real)
    & gener(inkatha_1_1,ge)
    & quant(inkatha_1_1,one)
    & refer(inkatha_1_1,refer_c)
    & varia(inkatha_1_1,varia_c)
    & sort(demokratie__1_1,io)
    & card(demokratie__1_1,int1)
    & etype(demokratie__1_1,int0)
    & fact(demokratie__1_1,real)
    & gener(demokratie__1_1,ge)
    & quant(demokratie__1_1,one)
    & refer(demokratie__1_1,refer_c)
    & varia(demokratie__1_1,varia_c)
    & sort(freiheit_1_1,as)
    & sort(freiheit_1_1,io)
    & card(freiheit_1_1,int1)
    & etype(freiheit_1_1,int0)
    & fact(freiheit_1_1,real)
    & gener(freiheit_1_1,ge)
    & quant(freiheit_1_1,one)
    & refer(freiheit_1_1,refer_c)
    & varia(freiheit_1_1,varia_c)
    & sort(partei_1_1,d)
    & sort(partei_1_1,io)
    & card(partei_1_1,card_c)
    & etype(partei_1_1,int1)
    & fact(partei_1_1,real)
    & gener(partei_1_1,ge)
    & quant(partei_1_1,quant_c)
    & refer(partei_1_1,refer_c)
    & varia(partei_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
