%------------------------------------------------------------------------------
% File     : CSR116+11 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Who was the first black president elected in South Africa?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_010_mira_news_1668_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.47 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.29 v7.5.0, 0.43 v7.4.0, 0.31 v7.3.0, 0.43 v7.2.0, 0.33 v7.1.0, 0.25 v7.0.0, 0.36 v6.4.0, 0.29 v6.3.0, 0.31 v6.2.0, 0.45 v6.1.0, 0.52 v6.0.0, 0.50 v5.5.0, 0.58 v5.4.0, 0.57 v5.3.0, 0.70 v5.2.0, 0.43 v5.0.0, 0.55 v4.1.0, 0.61 v4.0.1, 0.63 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10828 (   0 equ)
%            Maximal formula atoms :  117 (   1 avg)
%            Number of connectives :  639 (   0   ~;  18   |; 495   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  117 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   86 (  86 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16649 (16649 usr;16648 con; 0-2 aty)
%            Number of variables   :  477 ( 405   !;  72   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_010_mira_news_1668,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7,X8] :
      ( pmod(X8,erst_1_1,pr__344sident_1_1)
      & arg1(X3,X0)
      & attr(X0,X1)
      & attr(X0,X2)
      & attr(X5,X6)
      & obj(X7,X0)
      & prop(X4,schwarz_1_1)
      & sub(X1,familiename_1_1)
      & sub(X2,eigenname_1_1)
      & sub(X4,X8)
      & subr(X3,rprs_0)
      & val(X1,mandela_0)
      & val(X2,nelson_0) ) ).

fof(ave07_era5_synth_qa07_010_mira_news_1668,hypothesis,
    ( attr(c5,c6)
    & attr(c5,c7)
    & sub(c5,mensch_1_1)
    & sub(c6,eigenname_1_1)
    & val(c6,nelson_0)
    & sub(c7,familiename_1_1)
    & val(c7,mandela_0)
    & agt(c9,c5)
    & assoc(c9,c5)
    & obj(c9,c90)
    & subs(c9,stellen_1_4)
    & prop(c90,schwarz_1_1)
    & sub(c90,c92)
    & pmod(c92,erst_1_1,pr__344sident_1_1)
    & attch(c98,c90)
    & sub(c98,land_1_1)
    & sort(c5,d)
    & card(c5,int1)
    & etype(c5,int0)
    & fact(c5,real)
    & gener(c5,sp)
    & quant(c5,one)
    & refer(c5,det)
    & varia(c5,con)
    & sort(c6,na)
    & card(c6,int1)
    & etype(c6,int0)
    & fact(c6,real)
    & gener(c6,sp)
    & quant(c6,one)
    & refer(c6,indet)
    & varia(c6,varia_c)
    & sort(c7,na)
    & card(c7,int1)
    & etype(c7,int0)
    & fact(c7,real)
    & gener(c7,sp)
    & quant(c7,one)
    & refer(c7,indet)
    & varia(c7,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(nelson_0,fe)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(mandela_0,fe)
    & sort(c9,da)
    & fact(c9,real)
    & gener(c9,sp)
    & sort(c90,d)
    & card(c90,int1)
    & etype(c90,int0)
    & fact(c90,real)
    & gener(c90,sp)
    & quant(c90,one)
    & refer(c90,det)
    & varia(c90,con)
    & sort(stellen_1_4,da)
    & fact(stellen_1_4,real)
    & gener(stellen_1_4,ge)
    & sort(schwarz_1_1,tq)
    & sort(c92,d)
    & card(c92,int1)
    & etype(c92,int0)
    & fact(c92,real)
    & gener(c92,ge)
    & quant(c92,one)
    & refer(c92,refer_c)
    & varia(c92,varia_c)
    & sort(erst_1_1,oq)
    & card(erst_1_1,int1)
    & sort(pr__344sident_1_1,d)
    & card(pr__344sident_1_1,int1)
    & etype(pr__344sident_1_1,int0)
    & fact(pr__344sident_1_1,real)
    & gener(pr__344sident_1_1,ge)
    & quant(pr__344sident_1_1,one)
    & refer(pr__344sident_1_1,refer_c)
    & varia(pr__344sident_1_1,varia_c)
    & sort(c98,d)
    & sort(c98,io)
    & card(c98,int1)
    & etype(c98,int0)
    & fact(c98,real)
    & gener(c98,sp)
    & quant(c98,one)
    & refer(c98,det)
    & varia(c98,con)
    & sort(land_1_1,d)
    & sort(land_1_1,io)
    & card(land_1_1,int1)
    & etype(land_1_1,int0)
    & fact(land_1_1,real)
    & gener(land_1_1,ge)
    & quant(land_1_1,one)
    & refer(land_1_1,refer_c)
    & varia(land_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
