%------------------------------------------------------------------------------
% File     : CSR116+10 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Who was the first black president elected in South Africa?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_010_mira_news_1665_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.45 v9.1.0, 0.53 v9.0.0, 0.31 v8.2.0, 0.27 v8.1.0, 0.36 v7.5.0, 0.52 v7.4.0, 0.38 v7.3.0, 0.57 v7.2.0, 0.50 v6.4.0, 0.36 v6.3.0, 0.38 v6.2.0, 0.55 v6.1.0, 0.68 v6.0.0, 0.50 v5.5.0, 0.67 v5.4.0, 0.65 v5.3.0, 0.74 v5.2.0, 0.57 v5.0.0, 0.60 v4.1.0, 0.67 v4.0.1, 0.68 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 11080 (   0 equ)
%            Maximal formula atoms :  367 (   1 avg)
%            Number of connectives :  891 (   0   ~;  18   |; 747   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  367 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   88 (  88 usr;   0 prp; 2-12 aty)
%            Number of functors    : 16677 (16677 usr;16676 con; 0-2 aty)
%            Number of variables   :  478 ( 405   !;  73   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_010_mira_news_1665,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7,X8,X9] :
      ( in(X5,X6)
      & arg1(X3,X0)
      & arg2(X3,X4)
      & attr(X0,X1)
      & attr(X0,X2)
      & attr(X6,X7)
      & obj(X8,X0)
      & sub(X1,familiename_1_1)
      & sub(X2,eigenname_1_1)
      & sub(X4,X9)
      & sub(X7,name_1_1)
      & subr(X3,rprs_0)
      & val(X1,mandela_0)
      & val(X2,nelson_0)
      & val(X7,s__374dafrika_0) ) ).

fof(ave07_era5_synth_qa07_010_mira_news_1665,hypothesis,
    ( attr(c28444,c28445)
    & attr(c28444,c28446)
    & prop(c28444,s__374dafrikanisch_1_1)
    & sub(c28444,pr__344sident_1_1)
    & sub(c28445,eigenname_1_1)
    & val(c28445,nelson_0)
    & sub(c28446,familiename_1_1)
    & val(c28446,mandela_0)
    & attr(c28457,c28458)
    & sub(c28457,land_1_1)
    & sub(c28458,name_1_1)
    & val(c28458,botswana_0)
    & sub(c28459,quett_1_1)
    & sub(c28460,masire_1_1)
    & sub(c28468,generalsekretaer_1_1)
    & attch(c28473,c28468)
    & sub(c28473,organisation_1_1)
    & attch(c28477,c28473)
    & prop(c28477,afrikanisch__1_1)
    & sub(c28477,einheit_1_1)
    & attr(c28487,c28488)
    & attr(c28487,c28490)
    & sub(c28487,mensch_1_1)
    & sub(c28488,eigenname_1_1)
    & val(c28488,c28489)
    & tupl(c28489,salim_0,ahmed_0)
    & sub(c28490,familiename_1_1)
    & val(c28490,salim_0)
    & attr(c28496,c28497)
    & sub(c28496,mensch_1_1)
    & sub(c28497,familiename_1_1)
    & val(c28497,mugabe_0)
    & attr(c28502,c28503)
    & sub(c28502,stadt__1_1)
    & sub(c28503,name_1_1)
    & val(c28503,pretoria_0)
    & quant_p3(c28511,c28504,stunde_1_1)
    & subs(c28514,krise_1_1)
    & attr(c28534,c28535)
    & sub(c28534,land_1_1)
    & sub(c28535,name_1_1)
    & val(c28535,lesotho_0)
    & tupl_p12(c28553,c28444,c28457,c28459,c28460,c28468,c28487,c28496,c28502,c28511,c28514,c28534)
    & assoc(generalsekretaer_1_1,allgemein_1_1)
    & sub(generalsekretaer_1_1,sekret__344r_1_1)
    & sort(c28444,d)
    & card(c28444,int1)
    & etype(c28444,int0)
    & fact(c28444,real)
    & gener(c28444,sp)
    & quant(c28444,one)
    & refer(c28444,det)
    & varia(c28444,con)
    & sort(c28445,na)
    & card(c28445,int1)
    & etype(c28445,int0)
    & fact(c28445,real)
    & gener(c28445,sp)
    & quant(c28445,one)
    & refer(c28445,indet)
    & varia(c28445,varia_c)
    & sort(c28446,na)
    & card(c28446,int1)
    & etype(c28446,int0)
    & fact(c28446,real)
    & gener(c28446,sp)
    & quant(c28446,one)
    & refer(c28446,indet)
    & varia(c28446,varia_c)
    & sort(s__374dafrikanisch_1_1,nq)
    & sort(pr__344sident_1_1,d)
    & card(pr__344sident_1_1,int1)
    & etype(pr__344sident_1_1,int0)
    & fact(pr__344sident_1_1,real)
    & gener(pr__344sident_1_1,ge)
    & quant(pr__344sident_1_1,one)
    & refer(pr__344sident_1_1,refer_c)
    & varia(pr__344sident_1_1,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(nelson_0,fe)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(mandela_0,fe)
    & sort(c28457,d)
    & sort(c28457,io)
    & card(c28457,int1)
    & etype(c28457,int0)
    & fact(c28457,real)
    & gener(c28457,sp)
    & quant(c28457,one)
    & refer(c28457,det)
    & varia(c28457,con)
    & sort(c28458,na)
    & card(c28458,int1)
    & etype(c28458,int0)
    & fact(c28458,real)
    & gener(c28458,sp)
    & quant(c28458,one)
    & refer(c28458,indet)
    & varia(c28458,varia_c)
    & sort(land_1_1,d)
    & sort(land_1_1,io)
    & card(land_1_1,int1)
    & etype(land_1_1,int0)
    & fact(land_1_1,real)
    & gener(land_1_1,ge)
    & quant(land_1_1,one)
    & refer(land_1_1,refer_c)
    & varia(land_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(botswana_0,fe)
    & sort(c28459,o)
    & card(c28459,int1)
    & etype(c28459,int0)
    & fact(c28459,real)
    & gener(c28459,gener_c)
    & quant(c28459,one)
    & refer(c28459,refer_c)
    & varia(c28459,varia_c)
    & sort(quett_1_1,o)
    & card(quett_1_1,int1)
    & etype(quett_1_1,int0)
    & fact(quett_1_1,real)
    & gener(quett_1_1,ge)
    & quant(quett_1_1,one)
    & refer(quett_1_1,refer_c)
    & varia(quett_1_1,varia_c)
    & sort(c28460,o)
    & card(c28460,int1)
    & etype(c28460,int0)
    & fact(c28460,real)
    & gener(c28460,gener_c)
    & quant(c28460,one)
    & refer(c28460,refer_c)
    & varia(c28460,varia_c)
    & sort(masire_1_1,o)
    & card(masire_1_1,int1)
    & etype(masire_1_1,int0)
    & fact(masire_1_1,real)
    & gener(masire_1_1,ge)
    & quant(masire_1_1,one)
    & refer(masire_1_1,refer_c)
    & varia(masire_1_1,varia_c)
    & sort(c28468,d)
    & card(c28468,int1)
    & etype(c28468,int0)
    & fact(c28468,real)
    & gener(c28468,sp)
    & quant(c28468,one)
    & refer(c28468,det)
    & varia(c28468,con)
    & sort(generalsekretaer_1_1,d)
    & card(generalsekretaer_1_1,int1)
    & etype(generalsekretaer_1_1,int0)
    & fact(generalsekretaer_1_1,real)
    & gener(generalsekretaer_1_1,ge)
    & quant(generalsekretaer_1_1,one)
    & refer(generalsekretaer_1_1,refer_c)
    & varia(generalsekretaer_1_1,varia_c)
    & sort(c28473,d)
    & sort(c28473,io)
    & card(c28473,int1)
    & etype(c28473,int1)
    & fact(c28473,real)
    & gener(c28473,sp)
    & quant(c28473,one)
    & refer(c28473,det)
    & varia(c28473,con)
    & sort(organisation_1_1,d)
    & sort(organisation_1_1,io)
    & card(organisation_1_1,card_c)
    & etype(organisation_1_1,int1)
    & fact(organisation_1_1,real)
    & gener(organisation_1_1,ge)
    & quant(organisation_1_1,quant_c)
    & refer(organisation_1_1,refer_c)
    & varia(organisation_1_1,varia_c)
    & sort(c28477,io)
    & sort(c28477,oa)
    & card(c28477,int1)
    & etype(c28477,int0)
    & fact(c28477,real)
    & gener(c28477,gener_c)
    & quant(c28477,one)
    & refer(c28477,refer_c)
    & varia(c28477,varia_c)
    & sort(afrikanisch__1_1,nq)
    & sort(einheit_1_1,io)
    & sort(einheit_1_1,oa)
    & card(einheit_1_1,int1)
    & etype(einheit_1_1,int0)
    & fact(einheit_1_1,real)
    & gener(einheit_1_1,ge)
    & quant(einheit_1_1,one)
    & refer(einheit_1_1,refer_c)
    & varia(einheit_1_1,varia_c)
    & sort(c28487,d)
    & card(c28487,int1)
    & etype(c28487,int0)
    & fact(c28487,real)
    & gener(c28487,sp)
    & quant(c28487,one)
    & refer(c28487,det)
    & varia(c28487,con)
    & sort(c28488,na)
    & card(c28488,int1)
    & etype(c28488,int0)
    & fact(c28488,real)
    & gener(c28488,sp)
    & quant(c28488,one)
    & refer(c28488,indet)
    & varia(c28488,varia_c)
    & sort(c28490,na)
    & card(c28490,int1)
    & etype(c28490,int0)
    & fact(c28490,real)
    & gener(c28490,sp)
    & quant(c28490,one)
    & refer(c28490,indet)
    & varia(c28490,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(c28489,fe)
    & sort(salim_0,fe)
    & sort(ahmed_0,fe)
    & sort(c28496,d)
    & card(c28496,int1)
    & etype(c28496,int0)
    & fact(c28496,real)
    & gener(c28496,sp)
    & quant(c28496,one)
    & refer(c28496,det)
    & varia(c28496,con)
    & sort(c28497,na)
    & card(c28497,int1)
    & etype(c28497,int0)
    & fact(c28497,real)
    & gener(c28497,sp)
    & quant(c28497,one)
    & refer(c28497,indet)
    & varia(c28497,varia_c)
    & sort(mugabe_0,fe)
    & sort(c28502,d)
    & sort(c28502,io)
    & card(c28502,int1)
    & etype(c28502,int0)
    & fact(c28502,real)
    & gener(c28502,sp)
    & quant(c28502,one)
    & refer(c28502,det)
    & varia(c28502,con)
    & sort(c28503,na)
    & card(c28503,int1)
    & etype(c28503,int0)
    & fact(c28503,real)
    & gener(c28503,sp)
    & quant(c28503,one)
    & refer(c28503,indet)
    & varia(c28503,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(pretoria_0,fe)
    & sort(c28511,m)
    & sort(c28511,ta)
    & card(c28511,card_c)
    & etype(c28511,etype_c)
    & fact(c28511,real)
    & gener(c28511,gener_c)
    & quant(c28511,quant_c)
    & refer(c28511,refer_c)
    & varia(c28511,varia_c)
    & sort(c28504,nu)
    & card(c28504,int6)
    & sort(stunde_1_1,me)
    & sort(stunde_1_1,oa)
    & sort(stunde_1_1,ta)
    & card(stunde_1_1,card_c)
    & etype(stunde_1_1,etype_c)
    & fact(stunde_1_1,real)
    & gener(stunde_1_1,ge)
    & quant(stunde_1_1,quant_c)
    & refer(stunde_1_1,refer_c)
    & varia(stunde_1_1,varia_c)
    & sort(c28514,ad)
    & card(c28514,int1)
    & etype(c28514,int0)
    & fact(c28514,real)
    & gener(c28514,sp)
    & quant(c28514,one)
    & refer(c28514,det)
    & varia(c28514,con)
    & sort(krise_1_1,ad)
    & card(krise_1_1,int1)
    & etype(krise_1_1,int0)
    & fact(krise_1_1,real)
    & gener(krise_1_1,ge)
    & quant(krise_1_1,one)
    & refer(krise_1_1,refer_c)
    & varia(krise_1_1,varia_c)
    & sort(c28534,d)
    & sort(c28534,io)
    & card(c28534,int1)
    & etype(c28534,int0)
    & fact(c28534,real)
    & gener(c28534,sp)
    & quant(c28534,one)
    & refer(c28534,det)
    & varia(c28534,con)
    & sort(c28535,na)
    & card(c28535,int1)
    & etype(c28535,int0)
    & fact(c28535,real)
    & gener(c28535,sp)
    & quant(c28535,one)
    & refer(c28535,indet)
    & varia(c28535,varia_c)
    & sort(lesotho_0,fe)
    & sort(c28553,ent)
    & card(c28553,card_c)
    & etype(c28553,etype_c)
    & fact(c28553,real)
    & gener(c28553,gener_c)
    & quant(c28553,quant_c)
    & refer(c28553,refer_c)
    & varia(c28553,varia_c)
    & sort(allgemein_1_1,tq)
    & sort(sekret__344r_1_1,d)
    & card(sekret__344r_1_1,int1)
    & etype(sekret__344r_1_1,int0)
    & fact(sekret__344r_1_1,real)
    & gener(sekret__344r_1_1,ge)
    & quant(sekret__344r_1_1,one)
    & refer(sekret__344r_1_1,refer_c)
    & varia(sekret__344r_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
