%------------------------------------------------------------------------------
% File     : CSR116+1 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Who was the first black president elected in South Africa?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_010_mira_news_1588_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.40 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.29 v7.5.0, 0.48 v7.4.0, 0.31 v7.3.0, 0.43 v7.2.0, 0.33 v7.1.0, 0.25 v7.0.0, 0.36 v6.4.0, 0.29 v6.3.0, 0.38 v6.2.0, 0.55 v6.1.0, 0.56 v6.0.0, 0.50 v5.5.0, 0.58 v5.4.0, 0.57 v5.3.0, 0.70 v5.2.0, 0.43 v5.0.0, 0.55 v4.1.0, 0.61 v4.0.1, 0.63 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10943 (   0 equ)
%            Maximal formula atoms :  230 (   1 avg)
%            Number of connectives :  754 (   0   ~;  18   |; 610   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  230 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-7 aty)
%            Number of functors    : 16658 (16658 usr;16657 con; 0-2 aty)
%            Number of variables   :  477 ( 405   !;  72   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_010_mira_news_1588,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7,X8] :
      ( pmod(X8,erst_1_1,pr__344sident_1_1)
      & arg1(X3,X0)
      & attr(X0,X1)
      & attr(X0,X2)
      & attr(X5,X6)
      & obj(X7,X0)
      & prop(X4,schwarz_1_1)
      & sub(X1,familiename_1_1)
      & sub(X2,eigenname_1_1)
      & sub(X4,X8)
      & sub(X6,name_1_1)
      & subr(X3,rprs_0)
      & val(X1,mandela_0)
      & val(X2,nelson_0)
      & val(X6,s__374dafrika_0) ) ).

fof(ave07_era5_synth_qa07_010_mira_news_1588,hypothesis,
    ( attr(c153,c154)
    & sub(c153,mensch_1_1)
    & sub(c154,familiename_1_1)
    & val(c154,klerk_0)
    & prop(c159,schwarz_1_1)
    & sub(c159,c161)
    & pmod(c161,erst_1_1,pr__344sident_1_1)
    & attch(c170,c159)
    & attr(c170,c171)
    & sub(c170,land_1_1)
    & sub(c171,name_1_1)
    & val(c171,s__374dafrika_0)
    & tupl_p7(c228,c41,c47,c54,c59,c153,c159)
    & subs(c41,voraussicht_1_1)
    & attr(c47,c48)
    & sub(c47,einrichtung_1_2)
    & sub(c48,name_1_1)
    & val(c48,anc_0)
    & attr(c54,c55)
    & attr(c54,c56)
    & sub(c54,an_f__374hrer_1_1)
    & sub(c55,eigenname_1_1)
    & val(c55,nelson_0)
    & sub(c56,familiename_1_1)
    & val(c56,mandela_0)
    & sub(c59,nachfolger_1_1)
    & sort(c153,d)
    & card(c153,int1)
    & etype(c153,int0)
    & fact(c153,real)
    & gener(c153,sp)
    & quant(c153,one)
    & refer(c153,det)
    & varia(c153,con)
    & sort(c154,na)
    & card(c154,int1)
    & etype(c154,int0)
    & fact(c154,real)
    & gener(c154,sp)
    & quant(c154,one)
    & refer(c154,indet)
    & varia(c154,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(klerk_0,fe)
    & sort(c159,d)
    & card(c159,int1)
    & etype(c159,int0)
    & fact(c159,real)
    & gener(c159,sp)
    & quant(c159,one)
    & refer(c159,det)
    & varia(c159,con)
    & sort(schwarz_1_1,tq)
    & sort(c161,d)
    & card(c161,int1)
    & etype(c161,int0)
    & fact(c161,real)
    & gener(c161,ge)
    & quant(c161,one)
    & refer(c161,refer_c)
    & varia(c161,varia_c)
    & sort(erst_1_1,oq)
    & card(erst_1_1,int1)
    & sort(pr__344sident_1_1,d)
    & card(pr__344sident_1_1,int1)
    & etype(pr__344sident_1_1,int0)
    & fact(pr__344sident_1_1,real)
    & gener(pr__344sident_1_1,ge)
    & quant(pr__344sident_1_1,one)
    & refer(pr__344sident_1_1,refer_c)
    & varia(pr__344sident_1_1,varia_c)
    & sort(c170,d)
    & sort(c170,io)
    & card(c170,int1)
    & etype(c170,int0)
    & fact(c170,real)
    & gener(c170,sp)
    & quant(c170,one)
    & refer(c170,det)
    & varia(c170,con)
    & sort(c171,na)
    & card(c171,int1)
    & etype(c171,int0)
    & fact(c171,real)
    & gener(c171,sp)
    & quant(c171,one)
    & refer(c171,indet)
    & varia(c171,varia_c)
    & sort(land_1_1,d)
    & sort(land_1_1,io)
    & card(land_1_1,int1)
    & etype(land_1_1,int0)
    & fact(land_1_1,real)
    & gener(land_1_1,ge)
    & quant(land_1_1,one)
    & refer(land_1_1,refer_c)
    & varia(land_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(s__374dafrika_0,fe)
    & sort(c228,ent)
    & card(c228,card_c)
    & etype(c228,etype_c)
    & fact(c228,real)
    & gener(c228,gener_c)
    & quant(c228,quant_c)
    & refer(c228,refer_c)
    & varia(c228,varia_c)
    & sort(c41,ad)
    & card(c41,int1)
    & etype(c41,int0)
    & fact(c41,real)
    & gener(c41,gener_c)
    & quant(c41,one)
    & refer(c41,det)
    & varia(c41,con)
    & sort(c47,d)
    & sort(c47,io)
    & card(c47,int1)
    & etype(c47,int1)
    & fact(c47,real)
    & gener(c47,sp)
    & quant(c47,one)
    & refer(c47,det)
    & varia(c47,con)
    & sort(c54,d)
    & card(c54,int1)
    & etype(c54,int0)
    & fact(c54,real)
    & gener(c54,sp)
    & quant(c54,one)
    & refer(c54,det)
    & varia(c54,varia_c)
    & sort(c59,d)
    & card(c59,int1)
    & etype(c59,int0)
    & fact(c59,real)
    & gener(c59,gener_c)
    & quant(c59,one)
    & refer(c59,refer_c)
    & varia(c59,varia_c)
    & sort(voraussicht_1_1,ad)
    & card(voraussicht_1_1,int1)
    & etype(voraussicht_1_1,int0)
    & fact(voraussicht_1_1,real)
    & gener(voraussicht_1_1,ge)
    & quant(voraussicht_1_1,one)
    & refer(voraussicht_1_1,refer_c)
    & varia(voraussicht_1_1,varia_c)
    & sort(c48,na)
    & card(c48,int1)
    & etype(c48,int0)
    & fact(c48,real)
    & gener(c48,sp)
    & quant(c48,one)
    & refer(c48,indet)
    & varia(c48,varia_c)
    & sort(einrichtung_1_2,d)
    & sort(einrichtung_1_2,io)
    & card(einrichtung_1_2,card_c)
    & etype(einrichtung_1_2,int1)
    & fact(einrichtung_1_2,real)
    & gener(einrichtung_1_2,ge)
    & quant(einrichtung_1_2,quant_c)
    & refer(einrichtung_1_2,refer_c)
    & varia(einrichtung_1_2,varia_c)
    & sort(anc_0,fe)
    & sort(c55,na)
    & card(c55,int1)
    & etype(c55,int0)
    & fact(c55,real)
    & gener(c55,sp)
    & quant(c55,one)
    & refer(c55,indet)
    & varia(c55,varia_c)
    & sort(c56,na)
    & card(c56,int1)
    & etype(c56,int0)
    & fact(c56,real)
    & gener(c56,sp)
    & quant(c56,one)
    & refer(c56,det)
    & varia(c56,varia_c)
    & sort(an_f__374hrer_1_1,d)
    & card(an_f__374hrer_1_1,int1)
    & etype(an_f__374hrer_1_1,int0)
    & fact(an_f__374hrer_1_1,real)
    & gener(an_f__374hrer_1_1,ge)
    & quant(an_f__374hrer_1_1,one)
    & refer(an_f__374hrer_1_1,refer_c)
    & varia(an_f__374hrer_1_1,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(nelson_0,fe)
    & sort(mandela_0,fe)
    & sort(nachfolger_1_1,d)
    & card(nachfolger_1_1,int1)
    & etype(nachfolger_1_1,int0)
    & fact(nachfolger_1_1,real)
    & gener(nachfolger_1_1,ge)
    & quant(nachfolger_1_1,one)
    & refer(nachfolger_1_1,refer_c)
    & varia(nachfolger_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
