%------------------------------------------------------------------------------
% File     : CSR115+98 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mw3_199_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.33 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.21 v7.5.0, 0.33 v7.4.0, 0.25 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.31 v6.2.0, 0.45 v6.1.0, 0.52 v6.0.0, 0.50 v5.5.0, 0.54 v5.4.0, 0.52 v5.3.0, 0.61 v5.2.0, 0.36 v5.0.0, 0.50 v4.1.0, 0.56 v4.0.1, 0.58 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10951 (   0 equ)
%            Maximal formula atoms :  244 (   1 avg)
%            Number of connectives :  762 (   0   ~;  18   |; 618   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  244 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16662 (16662 usr;16661 con; 0-2 aty)
%            Number of variables   :  475 ( 405   !;  70   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mw3_199,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6] :
      ( attr(X0,X1)
      & attr(X3,X2)
      & attr(X5,X6)
      & obj(X4,X0)
      & sub(X1,name_1_1)
      & sub(X0,firma_1_1)
      & sub(X2,name_1_1)
      & val(X1,bmw_0)
      & val(X2,bmw_0) ) ).

fof(ave07_era5_synth_qa07_007_mw3_199,hypothesis,
    ( pred(c11398,auftrag_1_1)
    & attr(c11400,c11401)
    & sub(c11400,mensch_1_1)
    & sub(c11401,familiename_1_1)
    & val(c11401,eicher_0)
    & attch(c11405,c11398)
    & sub(c11405,r__374stungsindustrie_1_1)
    & agt(c11646,c9774)
    & assoc(c11646,c9770)
    & benf(c11646,c11400)
    & obj(c11646,c11398)
    & subs(c11646,akzeptieren_1_1)
    & sub(c11767,kriegesende_1_1)
    & pred(c11770,zwangarbeiter_1_1)
    & circ(c11773,was_1_1)
    & fin(c11773,c11767)
    & obj(c11773,c11770)
    & semrel(c11773,c11646)
    & subs(c11773,besch__344ftigen_1_1)
    & attr(c9770,c9771)
    & sub(c9770,firma_1_1)
    & sub(c9771,name_1_1)
    & val(c9771,bmw_0)
    & sub(c9774,firma_1_1)
    & assoc(kriegesende_1_1,krieg__1_1)
    & sub(kriegesende_1_1,abschlu__337_1_1)
    & assoc(r__374stungsindustrie_1_1,r__374stung_1_1)
    & sub(r__374stungsindustrie_1_1,industrie__1_1)
    & assoc(zwangarbeiter_1_1,zwang_1_1)
    & sub(zwangarbeiter_1_1,arbeiter_1_1)
    & sort(c11398,d)
    & sort(c11398,io)
    & card(c11398,cons(x_constant,cons(int1,nil)))
    & etype(c11398,int1)
    & fact(c11398,real)
    & gener(c11398,sp)
    & quant(c11398,mult)
    & refer(c11398,indet)
    & varia(c11398,varia_c)
    & sort(auftrag_1_1,d)
    & sort(auftrag_1_1,io)
    & card(auftrag_1_1,int1)
    & etype(auftrag_1_1,int0)
    & fact(auftrag_1_1,real)
    & gener(auftrag_1_1,ge)
    & quant(auftrag_1_1,one)
    & refer(auftrag_1_1,refer_c)
    & varia(auftrag_1_1,varia_c)
    & sort(c11400,d)
    & card(c11400,int1)
    & etype(c11400,int0)
    & fact(c11400,real)
    & gener(c11400,sp)
    & quant(c11400,one)
    & refer(c11400,det)
    & varia(c11400,con)
    & sort(c11401,na)
    & card(c11401,int1)
    & etype(c11401,int0)
    & fact(c11401,real)
    & gener(c11401,sp)
    & quant(c11401,one)
    & refer(c11401,indet)
    & varia(c11401,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(eicher_0,fe)
    & sort(c11405,io)
    & card(c11405,int1)
    & etype(c11405,int1)
    & fact(c11405,real)
    & gener(c11405,sp)
    & quant(c11405,one)
    & refer(c11405,det)
    & varia(c11405,con)
    & sort(r__374stungsindustrie_1_1,io)
    & card(r__374stungsindustrie_1_1,card_c)
    & etype(r__374stungsindustrie_1_1,int1)
    & fact(r__374stungsindustrie_1_1,real)
    & gener(r__374stungsindustrie_1_1,ge)
    & quant(r__374stungsindustrie_1_1,quant_c)
    & refer(r__374stungsindustrie_1_1,refer_c)
    & varia(r__374stungsindustrie_1_1,varia_c)
    & sort(c11646,da)
    & fact(c11646,real)
    & gener(c11646,sp)
    & sort(c9774,d)
    & sort(c9774,io)
    & card(c9774,int1)
    & etype(c9774,int0)
    & fact(c9774,real)
    & gener(c9774,sp)
    & quant(c9774,one)
    & refer(c9774,det)
    & varia(c9774,con)
    & sort(c9770,d)
    & sort(c9770,io)
    & card(c9770,int1)
    & etype(c9770,int0)
    & fact(c9770,real)
    & gener(c9770,sp)
    & quant(c9770,one)
    & refer(c9770,det)
    & varia(c9770,con)
    & sort(akzeptieren_1_1,da)
    & fact(akzeptieren_1_1,real)
    & gener(akzeptieren_1_1,ge)
    & sort(c11767,ad)
    & sort(c11767,io)
    & card(c11767,int1)
    & etype(c11767,int0)
    & fact(c11767,real)
    & gener(c11767,gener_c)
    & quant(c11767,one)
    & refer(c11767,refer_c)
    & varia(c11767,varia_c)
    & sort(kriegesende_1_1,ad)
    & sort(kriegesende_1_1,io)
    & card(kriegesende_1_1,int1)
    & etype(kriegesende_1_1,int0)
    & fact(kriegesende_1_1,real)
    & gener(kriegesende_1_1,ge)
    & quant(kriegesende_1_1,one)
    & refer(kriegesende_1_1,refer_c)
    & varia(kriegesende_1_1,varia_c)
    & sort(c11770,d)
    & card(c11770,cons(x_constant,cons(int1,nil)))
    & etype(c11770,int1)
    & fact(c11770,real)
    & gener(c11770,sp)
    & quant(c11770,mult)
    & refer(c11770,indet)
    & varia(c11770,varia_c)
    & sort(zwangarbeiter_1_1,d)
    & card(zwangarbeiter_1_1,int1)
    & etype(zwangarbeiter_1_1,int0)
    & fact(zwangarbeiter_1_1,real)
    & gener(zwangarbeiter_1_1,ge)
    & quant(zwangarbeiter_1_1,one)
    & refer(zwangarbeiter_1_1,refer_c)
    & varia(zwangarbeiter_1_1,varia_c)
    & sort(c11773,da)
    & fact(c11773,real)
    & gener(c11773,sp)
    & sort(was_1_1,o)
    & card(was_1_1,int1)
    & etype(was_1_1,int0)
    & fact(was_1_1,real)
    & gener(was_1_1,sp)
    & quant(was_1_1,one)
    & refer(was_1_1,refer_c)
    & varia(was_1_1,varia_c)
    & sort(besch__344ftigen_1_1,da)
    & fact(besch__344ftigen_1_1,real)
    & gener(besch__344ftigen_1_1,ge)
    & sort(c9771,na)
    & card(c9771,int1)
    & etype(c9771,int0)
    & fact(c9771,real)
    & gener(c9771,sp)
    & quant(c9771,one)
    & refer(c9771,indet)
    & varia(c9771,varia_c)
    & sort(firma_1_1,d)
    & sort(firma_1_1,io)
    & card(firma_1_1,int1)
    & etype(firma_1_1,int0)
    & fact(firma_1_1,real)
    & gener(firma_1_1,ge)
    & quant(firma_1_1,one)
    & refer(firma_1_1,refer_c)
    & varia(firma_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(bmw_0,fe)
    & sort(krieg__1_1,ad)
    & card(krieg__1_1,int1)
    & etype(krieg__1_1,int0)
    & fact(krieg__1_1,real)
    & gener(krieg__1_1,ge)
    & quant(krieg__1_1,one)
    & refer(krieg__1_1,refer_c)
    & varia(krieg__1_1,varia_c)
    & sort(abschlu__337_1_1,ad)
    & sort(abschlu__337_1_1,io)
    & card(abschlu__337_1_1,int1)
    & etype(abschlu__337_1_1,int0)
    & fact(abschlu__337_1_1,real)
    & gener(abschlu__337_1_1,ge)
    & quant(abschlu__337_1_1,one)
    & refer(abschlu__337_1_1,refer_c)
    & varia(abschlu__337_1_1,varia_c)
    & sort(r__374stung_1_1,d)
    & card(r__374stung_1_1,int1)
    & etype(r__374stung_1_1,int0)
    & fact(r__374stung_1_1,real)
    & gener(r__374stung_1_1,ge)
    & quant(r__374stung_1_1,one)
    & refer(r__374stung_1_1,refer_c)
    & varia(r__374stung_1_1,varia_c)
    & sort(industrie__1_1,io)
    & card(industrie__1_1,card_c)
    & etype(industrie__1_1,int1)
    & fact(industrie__1_1,real)
    & gener(industrie__1_1,ge)
    & quant(industrie__1_1,quant_c)
    & refer(industrie__1_1,refer_c)
    & varia(industrie__1_1,varia_c)
    & sort(zwang_1_1,as)
    & card(zwang_1_1,int1)
    & etype(zwang_1_1,int0)
    & fact(zwang_1_1,real)
    & gener(zwang_1_1,ge)
    & quant(zwang_1_1,one)
    & refer(zwang_1_1,refer_c)
    & varia(zwang_1_1,varia_c)
    & sort(arbeiter_1_1,d)
    & card(arbeiter_1_1,int1)
    & etype(arbeiter_1_1,int0)
    & fact(arbeiter_1_1,real)
    & gener(arbeiter_1_1,ge)
    & quant(arbeiter_1_1,one)
    & refer(arbeiter_1_1,refer_c)
    & varia(arbeiter_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
