%------------------------------------------------------------------------------
% File     : CSR115+96 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mn3_277_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.33 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.21 v7.5.0, 0.33 v7.4.0, 0.25 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.31 v6.2.0, 0.45 v6.1.0, 0.52 v6.0.0, 0.50 v5.5.0, 0.58 v5.4.0, 0.52 v5.3.0, 0.61 v5.2.0, 0.36 v5.0.0, 0.45 v4.1.0, 0.56 v4.0.1, 0.63 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10962 (   0 equ)
%            Maximal formula atoms :  255 (   1 avg)
%            Number of connectives :  773 (   0   ~;  18   |; 629   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  255 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-12 aty)
%            Number of functors    : 16664 (16664 usr;16663 con; 0-2 aty)
%            Number of variables   :  475 ( 405   !;  70   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mn3_277,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6] :
      ( attr(X0,X1)
      & attr(X3,X2)
      & attr(X5,X6)
      & obj(X4,X0)
      & sub(X1,name_1_1)
      & sub(X0,firma_1_1)
      & sub(X2,name_1_1)
      & val(X1,bmw_0)
      & val(X2,bmw_0) ) ).

fof(ave07_era5_synth_qa07_007_mn3_277,hypothesis,
    ( attr(c8713,c8714)
    & sub(c8713,mensch_1_1)
    & sub(c8714,familiename_1_1)
    & val(c8714,wellauer_0)
    & sub(c8719,firma_1_1)
    & attr(c8724,c8725)
    & sub(c8724,mensch_1_1)
    & sub(c8725,familiename_1_1)
    & val(c8725,raichle_0)
    & sub(c8733,produktemanagement_1_1)
    & prop(c8740,erdweit_1_1)
    & subs(c8740,absatz_1_2)
    & pred(c8743,dynafit_1_1)
    & sub(c8755,absatzf__366rderung_1_1)
    & pred(c8761,leiter_1_1)
    & attr(c8774,c8775)
    & sub(c8774,firma_1_1)
    & sub(c8775,name_1_1)
    & val(c8775,bmw_0)
    & attr(c8778,c8779)
    & sub(c8778,land_1_1)
    & sub(c8779,name_1_1)
    & val(c8779,schweiz_0)
    & tupl_p12(c9098,c8713,c8719,c8724,c8733,c8740,c8743,c8740,c8755,c8761,c8774,c8778)
    & assoc(produktemanagement_1_1,erzeugnis_1_1)
    & sub(produktemanagement_1_1,management__1_1)
    & sort(c8713,d)
    & card(c8713,int1)
    & etype(c8713,int0)
    & fact(c8713,real)
    & gener(c8713,sp)
    & quant(c8713,one)
    & refer(c8713,det)
    & varia(c8713,con)
    & sort(c8714,na)
    & card(c8714,int1)
    & etype(c8714,int0)
    & fact(c8714,real)
    & gener(c8714,sp)
    & quant(c8714,one)
    & refer(c8714,indet)
    & varia(c8714,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(wellauer_0,fe)
    & sort(c8719,d)
    & sort(c8719,io)
    & card(c8719,int1)
    & etype(c8719,int0)
    & fact(c8719,real)
    & gener(c8719,sp)
    & quant(c8719,one)
    & refer(c8719,det)
    & varia(c8719,con)
    & sort(firma_1_1,d)
    & sort(firma_1_1,io)
    & card(firma_1_1,int1)
    & etype(firma_1_1,int0)
    & fact(firma_1_1,real)
    & gener(firma_1_1,ge)
    & quant(firma_1_1,one)
    & refer(firma_1_1,refer_c)
    & varia(firma_1_1,varia_c)
    & sort(c8724,d)
    & card(c8724,int1)
    & etype(c8724,int0)
    & fact(c8724,real)
    & gener(c8724,sp)
    & quant(c8724,one)
    & refer(c8724,det)
    & varia(c8724,con)
    & sort(c8725,na)
    & card(c8725,int1)
    & etype(c8725,int0)
    & fact(c8725,real)
    & gener(c8725,sp)
    & quant(c8725,one)
    & refer(c8725,indet)
    & varia(c8725,varia_c)
    & sort(raichle_0,fe)
    & sort(c8733,d)
    & sort(c8733,io)
    & card(c8733,int1)
    & etype(c8733,int0)
    & fact(c8733,real)
    & gener(c8733,sp)
    & quant(c8733,one)
    & refer(c8733,det)
    & varia(c8733,con)
    & sort(produktemanagement_1_1,d)
    & sort(produktemanagement_1_1,io)
    & card(produktemanagement_1_1,int1)
    & etype(produktemanagement_1_1,int0)
    & fact(produktemanagement_1_1,real)
    & gener(produktemanagement_1_1,ge)
    & quant(produktemanagement_1_1,one)
    & refer(produktemanagement_1_1,refer_c)
    & varia(produktemanagement_1_1,varia_c)
    & sort(c8740,ad)
    & card(c8740,int1)
    & etype(c8740,int0)
    & fact(c8740,real)
    & gener(c8740,sp)
    & quant(c8740,one)
    & refer(c8740,det)
    & varia(c8740,con)
    & sort(erdweit_1_1,tq)
    & sort(absatz_1_2,ad)
    & card(absatz_1_2,int1)
    & etype(absatz_1_2,int0)
    & fact(absatz_1_2,real)
    & gener(absatz_1_2,ge)
    & quant(absatz_1_2,one)
    & refer(absatz_1_2,refer_c)
    & varia(absatz_1_2,varia_c)
    & sort(c8743,o)
    & card(c8743,cons(x_constant,cons(int1,nil)))
    & etype(c8743,int1)
    & fact(c8743,real)
    & gener(c8743,gener_c)
    & quant(c8743,mult)
    & refer(c8743,indet)
    & varia(c8743,varia_c)
    & sort(dynafit_1_1,o)
    & card(dynafit_1_1,int1)
    & etype(dynafit_1_1,int0)
    & fact(dynafit_1_1,real)
    & gener(dynafit_1_1,ge)
    & quant(dynafit_1_1,one)
    & refer(dynafit_1_1,refer_c)
    & varia(dynafit_1_1,varia_c)
    & sort(c8755,io)
    & card(c8755,int1)
    & etype(c8755,int0)
    & fact(c8755,real)
    & gener(c8755,gener_c)
    & quant(c8755,one)
    & refer(c8755,refer_c)
    & varia(c8755,varia_c)
    & sort(absatzf__366rderung_1_1,io)
    & card(absatzf__366rderung_1_1,int1)
    & etype(absatzf__366rderung_1_1,int0)
    & fact(absatzf__366rderung_1_1,real)
    & gener(absatzf__366rderung_1_1,ge)
    & quant(absatzf__366rderung_1_1,one)
    & refer(absatzf__366rderung_1_1,refer_c)
    & varia(absatzf__366rderung_1_1,varia_c)
    & sort(c8761,d)
    & card(c8761,cons(x_constant,cons(int1,nil)))
    & etype(c8761,int1)
    & fact(c8761,real)
    & gener(c8761,gener_c)
    & quant(c8761,mult)
    & refer(c8761,indet)
    & varia(c8761,varia_c)
    & sort(leiter_1_1,d)
    & card(leiter_1_1,int1)
    & etype(leiter_1_1,int0)
    & fact(leiter_1_1,real)
    & gener(leiter_1_1,ge)
    & quant(leiter_1_1,one)
    & refer(leiter_1_1,refer_c)
    & varia(leiter_1_1,varia_c)
    & sort(c8774,d)
    & sort(c8774,io)
    & card(c8774,int1)
    & etype(c8774,int0)
    & fact(c8774,real)
    & gener(c8774,sp)
    & quant(c8774,one)
    & refer(c8774,det)
    & varia(c8774,con)
    & sort(c8775,na)
    & card(c8775,int1)
    & etype(c8775,int0)
    & fact(c8775,real)
    & gener(c8775,sp)
    & quant(c8775,one)
    & refer(c8775,indet)
    & varia(c8775,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(bmw_0,fe)
    & sort(c8778,d)
    & sort(c8778,io)
    & card(c8778,int1)
    & etype(c8778,int0)
    & fact(c8778,real)
    & gener(c8778,sp)
    & quant(c8778,one)
    & refer(c8778,det)
    & varia(c8778,con)
    & sort(c8779,na)
    & card(c8779,int1)
    & etype(c8779,int0)
    & fact(c8779,real)
    & gener(c8779,sp)
    & quant(c8779,one)
    & refer(c8779,indet)
    & varia(c8779,varia_c)
    & sort(land_1_1,d)
    & sort(land_1_1,io)
    & card(land_1_1,int1)
    & etype(land_1_1,int0)
    & fact(land_1_1,real)
    & gener(land_1_1,ge)
    & quant(land_1_1,one)
    & refer(land_1_1,refer_c)
    & varia(land_1_1,varia_c)
    & sort(schweiz_0,fe)
    & sort(c9098,ent)
    & card(c9098,card_c)
    & etype(c9098,etype_c)
    & fact(c9098,real)
    & gener(c9098,gener_c)
    & quant(c9098,quant_c)
    & refer(c9098,refer_c)
    & varia(c9098,varia_c)
    & sort(erzeugnis_1_1,co)
    & card(erzeugnis_1_1,card_c)
    & etype(erzeugnis_1_1,etype_c)
    & fact(erzeugnis_1_1,real)
    & gener(erzeugnis_1_1,ge)
    & quant(erzeugnis_1_1,quant_c)
    & refer(erzeugnis_1_1,refer_c)
    & varia(erzeugnis_1_1,varia_c)
    & sort(management__1_1,d)
    & sort(management__1_1,io)
    & card(management__1_1,int1)
    & etype(management__1_1,int0)
    & fact(management__1_1,real)
    & gener(management__1_1,ge)
    & quant(management__1_1,one)
    & refer(management__1_1,refer_c)
    & varia(management__1_1,varia_c) ) ).

%------------------------------------------------------------------------------
