%------------------------------------------------------------------------------
% File     : CSR115+94 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mn3_209_a19984_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.33 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.21 v7.5.0, 0.38 v7.4.0, 0.25 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.31 v6.2.0, 0.45 v6.1.0, 0.60 v6.0.0, 0.50 v5.5.0, 0.58 v5.4.0, 0.52 v5.3.0, 0.61 v5.2.0, 0.36 v5.0.0, 0.45 v4.1.0, 0.56 v4.0.1, 0.58 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10982 (   0 equ)
%            Maximal formula atoms :  277 (   1 avg)
%            Number of connectives :  793 (   0   ~;  18   |; 649   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  277 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-8 aty)
%            Number of functors    : 16665 (16665 usr;16664 con; 0-2 aty)
%            Number of variables   :  474 ( 405   !;  69   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mn3_209_a19984,conjecture,
    ? [X0,X1,X2,X3,X4,X5] :
      ( attr(X2,X1)
      & attr(X4,X5)
      & obj(X3,X0)
      & prop(X0,britisch__1_1)
      & sub(X0,firma_1_1)
      & sub(X1,name_1_1)
      & val(X1,bmw_0) ) ).

fof(ave07_era5_synth_qa07_007_mn3_209_a19984,hypothesis,
    ( assoc(autokonzern_1_1,auto__1_1)
    & sub(autokonzern_1_1,firma_1_1)
    & sub(autokonzern_1_1,firmengruppe_1_1)
    & attr(c55721,c55722)
    & prop(c55721,bundesdeutsch_1_1)
    & sub(c55721,autokonzern_1_1)
    & sub(c55722,name_1_1)
    & val(c55722,bmw_0)
    & prop(c55741,pass__351_1_1)
    & sub(c55741,woche_1_1)
    & subs(c55747,ankauf__1_1)
    & attch(c56040,c55747)
    & attr(c56040,c56041)
    & prop(c56040,britisch__1_1)
    & sub(c56040,firma_1_1)
    & sub(c56041,name_1_1)
    & val(c56041,rover_0)
    & subs(c56049,interesse_1_1)
    & subs(c56053,ankauf__1_1)
    & attch(c56062,c56053)
    & prop(c56062,britisch__1_1)
    & sub(c56062,luxusmarke_1_1)
    & attr(c56073,c56062)
    & attr(c56073,c56074)
    & sub(c56073,mensch_1_1)
    & sub(c56074,familiename_1_1)
    & val(c56074,roll_0)
    & attr(c56078,c56079)
    & sub(c56078,mensch_1_1)
    & sub(c56079,eigenname_1_1)
    & val(c56079,royce_0)
    & tupl_p8(c56100,c55721,c55721,c55741,c55747,c56049,c56053,c56078)
    & assoc(luxusmarke_1_1,luxus__1_1)
    & sub(luxusmarke_1_1,marke_1_1)
    & sort(autokonzern_1_1,d)
    & sort(autokonzern_1_1,io)
    & card(autokonzern_1_1,int1)
    & etype(autokonzern_1_1,int0)
    & fact(autokonzern_1_1,real)
    & gener(autokonzern_1_1,ge)
    & quant(autokonzern_1_1,one)
    & refer(autokonzern_1_1,refer_c)
    & varia(autokonzern_1_1,varia_c)
    & sort(auto__1_1,d)
    & card(auto__1_1,int1)
    & etype(auto__1_1,int0)
    & fact(auto__1_1,real)
    & gener(auto__1_1,ge)
    & quant(auto__1_1,one)
    & refer(auto__1_1,refer_c)
    & varia(auto__1_1,varia_c)
    & sort(firma_1_1,d)
    & sort(firma_1_1,io)
    & card(firma_1_1,int1)
    & etype(firma_1_1,int0)
    & fact(firma_1_1,real)
    & gener(firma_1_1,ge)
    & quant(firma_1_1,one)
    & refer(firma_1_1,refer_c)
    & varia(firma_1_1,varia_c)
    & sort(firmengruppe_1_1,d)
    & sort(firmengruppe_1_1,io)
    & card(firmengruppe_1_1,int1)
    & etype(firmengruppe_1_1,int0)
    & fact(firmengruppe_1_1,real)
    & gener(firmengruppe_1_1,ge)
    & quant(firmengruppe_1_1,one)
    & refer(firmengruppe_1_1,refer_c)
    & varia(firmengruppe_1_1,varia_c)
    & sort(c55721,d)
    & sort(c55721,io)
    & card(c55721,int1)
    & etype(c55721,int0)
    & fact(c55721,real)
    & gener(c55721,sp)
    & quant(c55721,one)
    & refer(c55721,det)
    & varia(c55721,con)
    & sort(c55722,na)
    & card(c55722,int1)
    & etype(c55722,int0)
    & fact(c55722,real)
    & gener(c55722,sp)
    & quant(c55722,one)
    & refer(c55722,indet)
    & varia(c55722,varia_c)
    & sort(bundesdeutsch_1_1,tq)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(bmw_0,fe)
    & sort(c55741,me)
    & sort(c55741,oa)
    & sort(c55741,ta)
    & card(c55741,card_c)
    & etype(c55741,etype_c)
    & fact(c55741,real)
    & gener(c55741,sp)
    & quant(c55741,quant_c)
    & refer(c55741,det)
    & varia(c55741,con)
    & sort(pass__351_1_1,tq)
    & sort(woche_1_1,me)
    & sort(woche_1_1,oa)
    & sort(woche_1_1,ta)
    & card(woche_1_1,card_c)
    & etype(woche_1_1,etype_c)
    & fact(woche_1_1,real)
    & gener(woche_1_1,ge)
    & quant(woche_1_1,quant_c)
    & refer(woche_1_1,refer_c)
    & varia(woche_1_1,varia_c)
    & sort(c55747,ad)
    & card(c55747,int1)
    & etype(c55747,int0)
    & fact(c55747,real)
    & gener(c55747,sp)
    & quant(c55747,one)
    & refer(c55747,det)
    & varia(c55747,con)
    & sort(ankauf__1_1,ad)
    & card(ankauf__1_1,int1)
    & etype(ankauf__1_1,int0)
    & fact(ankauf__1_1,real)
    & gener(ankauf__1_1,ge)
    & quant(ankauf__1_1,one)
    & refer(ankauf__1_1,refer_c)
    & varia(ankauf__1_1,varia_c)
    & sort(c56040,d)
    & sort(c56040,io)
    & card(c56040,int1)
    & etype(c56040,int0)
    & fact(c56040,real)
    & gener(c56040,sp)
    & quant(c56040,one)
    & refer(c56040,det)
    & varia(c56040,con)
    & sort(c56041,na)
    & card(c56041,int1)
    & etype(c56041,int0)
    & fact(c56041,real)
    & gener(c56041,sp)
    & quant(c56041,one)
    & refer(c56041,indet)
    & varia(c56041,varia_c)
    & sort(britisch__1_1,nq)
    & sort(rover_0,fe)
    & sort(c56049,as)
    & card(c56049,int1)
    & etype(c56049,int0)
    & fact(c56049,real)
    & gener(c56049,gener_c)
    & quant(c56049,one)
    & refer(c56049,refer_c)
    & varia(c56049,varia_c)
    & sort(interesse_1_1,as)
    & card(interesse_1_1,int1)
    & etype(interesse_1_1,int0)
    & fact(interesse_1_1,real)
    & gener(interesse_1_1,ge)
    & quant(interesse_1_1,one)
    & refer(interesse_1_1,refer_c)
    & varia(interesse_1_1,varia_c)
    & sort(c56053,ad)
    & card(c56053,int1)
    & etype(c56053,int0)
    & fact(c56053,real)
    & gener(c56053,sp)
    & quant(c56053,one)
    & refer(c56053,det)
    & varia(c56053,con)
    & sort(c56062,io)
    & sort(c56062,oa)
    & card(c56062,int1)
    & etype(c56062,int0)
    & fact(c56062,real)
    & gener(c56062,sp)
    & quant(c56062,one)
    & refer(c56062,det)
    & varia(c56062,con)
    & sort(luxusmarke_1_1,io)
    & sort(luxusmarke_1_1,oa)
    & card(luxusmarke_1_1,int1)
    & etype(luxusmarke_1_1,int0)
    & fact(luxusmarke_1_1,real)
    & gener(luxusmarke_1_1,ge)
    & quant(luxusmarke_1_1,one)
    & refer(luxusmarke_1_1,refer_c)
    & varia(luxusmarke_1_1,varia_c)
    & sort(c56073,d)
    & card(c56073,int1)
    & etype(c56073,int0)
    & fact(c56073,real)
    & gener(c56073,sp)
    & quant(c56073,one)
    & refer(c56073,det)
    & varia(c56073,con)
    & sort(c56074,na)
    & card(c56074,int1)
    & etype(c56074,int0)
    & fact(c56074,real)
    & gener(c56074,sp)
    & quant(c56074,one)
    & refer(c56074,indet)
    & varia(c56074,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(roll_0,fe)
    & sort(c56078,d)
    & card(c56078,int1)
    & etype(c56078,int0)
    & fact(c56078,real)
    & gener(c56078,sp)
    & quant(c56078,one)
    & refer(c56078,det)
    & varia(c56078,con)
    & sort(c56079,na)
    & card(c56079,int1)
    & etype(c56079,int0)
    & fact(c56079,real)
    & gener(c56079,sp)
    & quant(c56079,one)
    & refer(c56079,indet)
    & varia(c56079,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(royce_0,fe)
    & sort(c56100,ent)
    & card(c56100,card_c)
    & etype(c56100,etype_c)
    & fact(c56100,real)
    & gener(c56100,gener_c)
    & quant(c56100,quant_c)
    & refer(c56100,refer_c)
    & varia(c56100,varia_c)
    & sort(luxus__1_1,io)
    & card(luxus__1_1,int1)
    & etype(luxus__1_1,int0)
    & fact(luxus__1_1,real)
    & gener(luxus__1_1,ge)
    & quant(luxus__1_1,one)
    & refer(luxus__1_1,refer_c)
    & varia(luxus__1_1,varia_c)
    & sort(marke_1_1,io)
    & sort(marke_1_1,oa)
    & card(marke_1_1,int1)
    & etype(marke_1_1,int0)
    & fact(marke_1_1,real)
    & gener(marke_1_1,ge)
    & quant(marke_1_1,one)
    & refer(marke_1_1,refer_c)
    & varia(marke_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
