%------------------------------------------------------------------------------
% File     : CSR115+93 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_wp_535_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.40 v9.1.0, 0.47 v9.0.0, 0.31 v8.2.0, 0.27 v8.1.0, 0.36 v7.5.0, 0.48 v7.4.0, 0.25 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.36 v6.4.0, 0.29 v6.3.0, 0.31 v6.2.0, 0.45 v6.1.0, 0.52 v6.0.0, 0.50 v5.5.0, 0.58 v5.4.0, 0.57 v5.3.0, 0.65 v5.2.0, 0.36 v5.0.0, 0.50 v4.1.0, 0.61 v4.0.1, 0.63 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 11248 (   0 equ)
%            Maximal formula atoms :  543 (   1 avg)
%            Number of connectives : 1059 (   0   ~;  18   |; 915   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  543 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-22 aty)
%            Number of functors    : 16699 (16699 usr;16698 con; 0-2 aty)
%            Number of variables   :  475 ( 405   !;  70   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_wp_535,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6] :
      ( attr(X0,X1)
      & attr(X3,X2)
      & attr(X5,X6)
      & obj(X4,X0)
      & sub(X1,name_1_1)
      & sub(X2,name_1_1)
      & sub(X6,jahr__1_1) ) ).

fof(ave07_era5_synth_qa07_007_mira_wp_535,hypothesis,
    ( tupl_p22(c1063,c671,c673,c698,c704,c710,c721,c729,c736,c741,c751,c756,c762,c768,c773,c780,c786,c729,c801,c809,c815,c729)
    & pred(c671,wesentliche_1_1)
    & preds(c673,entwicklung_1_1)
    & attr(c698,c699)
    & sub(c698,land_1_1)
    & sub(c699,name_1_1)
    & val(c699,frankreich_0)
    & subs(c704,motoreinbau_1_1)
    & sub(c710,rahmen__1_1)
    & attr(c721,c722)
    & pred(c721,gebr__374der_1_1)
    & sub(c722,eigenname_1_1)
    & val(c722,werner_0)
    & attr(c729,c730)
    & attr(c729,c795)
    & attr(c729,c824)
    & sub(c729,land_1_1)
    & sub(c730,name_1_1)
    & val(c730,belgien_0)
    & sub(c736,vierzylindermotorrad_1_1)
    & sub(c741,kardanwelle_1_1)
    & attch(c745,c741)
    & sub(c745,firma_1_1)
    & attr(c751,c752)
    & sub(c751,mensch_1_1)
    & sub(c752,eigenname_1_1)
    & val(c752,c753)
    & tupl(c753,initial_f_0,initial_n_0)
    & attr(c756,c757)
    & sub(c757,jahr__1_1)
    & val(c757,c754)
    & attr(c762,c763)
    & sub(c762,gebiet_1_1)
    & sub(c763,name_1_1)
    & val(c763,england_0)
    & sub(c768,kickstarter_1_1)
    & sub(c773,bremse_1_1)
    & sub(c780,zweitaktmotor_1_1)
    & attr(c786,c787)
    & sub(c786,mensch_1_1)
    & sub(c787,eigenname_1_1)
    & val(c787,scott_0)
    & sub(c795,name_1_1)
    & val(c795,usa_0)
    & prop(c801,elektrisch_1_1)
    & sub(c801,anlasser_1_1)
    & prop(c809,elektrisch_1_1)
    & subs(c809,beleuchtung_1_1)
    & attr(c815,c816)
    & sub(c815,erzeugnis_1_1)
    & sub(c816,name_1_1)
    & val(c816,indian_0)
    & sub(c824,name_1_1)
    & val(c824,bundesrepublik_0)
    & assoc(kickstarter_1_1,kicken_1_1)
    & sub(kickstarter_1_1,anlasser_1_1)
    & assoc(motoreinbau_1_1,motor__1_1)
    & subs(motoreinbau_1_1,einbau__1_1)
    & assoc(vierzylindermotorrad_1_1,vier_1_1)
    & assoc(vierzylindermotorrad_1_1,walze_1_1)
    & sub(vierzylindermotorrad_1_1,kraftrad_1_1)
    & assoc(zweitaktmotor_1_1,akte_1_1)
    & assoc(zweitaktmotor_1_1,zweit_1_1)
    & sub(zweitaktmotor_1_1,motor__1_1)
    & sort(c1063,ent)
    & card(c1063,card_c)
    & etype(c1063,etype_c)
    & fact(c1063,real)
    & gener(c1063,gener_c)
    & quant(c1063,quant_c)
    & refer(c1063,refer_c)
    & varia(c1063,varia_c)
    & sort(c671,io)
    & card(c671,cons(x_constant,cons(int1,nil)))
    & etype(c671,int1)
    & fact(c671,real)
    & gener(c671,gener_c)
    & quant(c671,mult)
    & refer(c671,indet)
    & varia(c671,varia_c)
    & sort(c673,ad)
    & card(c673,cons(x_constant,cons(int1,nil)))
    & etype(c673,int1)
    & fact(c673,real)
    & gener(c673,gener_c)
    & quant(c673,mult)
    & refer(c673,indet)
    & varia(c673,varia_c)
    & sort(c698,d)
    & sort(c698,io)
    & card(c698,int1)
    & etype(c698,int0)
    & fact(c698,real)
    & gener(c698,sp)
    & quant(c698,one)
    & refer(c698,det)
    & varia(c698,con)
    & sort(c704,ad)
    & card(c704,int1)
    & etype(c704,int0)
    & fact(c704,real)
    & gener(c704,sp)
    & quant(c704,one)
    & refer(c704,det)
    & varia(c704,con)
    & sort(c710,d)
    & card(c710,int1)
    & etype(c710,int0)
    & fact(c710,real)
    & gener(c710,sp)
    & quant(c710,one)
    & refer(c710,det)
    & varia(c710,con)
    & sort(c721,d)
    & card(c721,cons(x_constant,cons(int1,nil)))
    & etype(c721,int1)
    & fact(c721,real)
    & gener(c721,sp)
    & quant(c721,mult)
    & refer(c721,det)
    & varia(c721,con)
    & sort(c729,d)
    & sort(c729,io)
    & card(c729,int1)
    & etype(c729,int0)
    & fact(c729,real)
    & gener(c729,sp)
    & quant(c729,one)
    & refer(c729,det)
    & varia(c729,con)
    & sort(c736,d)
    & card(c736,int1)
    & etype(c736,int0)
    & fact(c736,real)
    & gener(c736,sp)
    & quant(c736,one)
    & refer(c736,det)
    & varia(c736,con)
    & sort(c741,o)
    & card(c741,int1)
    & etype(c741,int0)
    & fact(c741,real)
    & gener(c741,sp)
    & quant(c741,one)
    & refer(c741,det)
    & varia(c741,con)
    & sort(c751,d)
    & card(c751,int1)
    & etype(c751,int0)
    & fact(c751,real)
    & gener(c751,sp)
    & quant(c751,one)
    & refer(c751,det)
    & varia(c751,con)
    & sort(c756,t)
    & card(c756,int1)
    & etype(c756,int0)
    & fact(c756,real)
    & gener(c756,sp)
    & quant(c756,one)
    & refer(c756,det)
    & varia(c756,con)
    & sort(c762,d)
    & card(c762,int1)
    & etype(c762,int0)
    & fact(c762,real)
    & gener(c762,sp)
    & quant(c762,one)
    & refer(c762,det)
    & varia(c762,con)
    & sort(c768,d)
    & card(c768,int1)
    & etype(c768,int0)
    & fact(c768,real)
    & gener(c768,sp)
    & quant(c768,one)
    & refer(c768,det)
    & varia(c768,con)
    & sort(c773,d)
    & card(c773,int1)
    & etype(c773,int0)
    & fact(c773,real)
    & gener(c773,gener_c)
    & quant(c773,one)
    & refer(c773,refer_c)
    & varia(c773,varia_c)
    & sort(c780,d)
    & card(c780,int1)
    & etype(c780,int0)
    & fact(c780,real)
    & gener(c780,gener_c)
    & quant(c780,one)
    & refer(c780,refer_c)
    & varia(c780,varia_c)
    & sort(c786,d)
    & card(c786,int1)
    & etype(c786,int0)
    & fact(c786,real)
    & gener(c786,sp)
    & quant(c786,one)
    & refer(c786,det)
    & varia(c786,con)
    & sort(c801,o)
    & card(c801,int1)
    & etype(c801,int0)
    & fact(c801,real)
    & gener(c801,sp)
    & quant(c801,one)
    & refer(c801,det)
    & varia(c801,con)
    & sort(c809,ad)
    & card(c809,int1)
    & etype(c809,int0)
    & fact(c809,real)
    & gener(c809,sp)
    & quant(c809,one)
    & refer(c809,det)
    & varia(c809,con)
    & sort(c815,co)
    & card(c815,card_c)
    & etype(c815,etype_c)
    & fact(c815,real)
    & gener(c815,sp)
    & quant(c815,quant_c)
    & refer(c815,det)
    & varia(c815,con)
    & sort(wesentliche_1_1,io)
    & card(wesentliche_1_1,int1)
    & etype(wesentliche_1_1,int0)
    & fact(wesentliche_1_1,real)
    & gener(wesentliche_1_1,ge)
    & quant(wesentliche_1_1,one)
    & refer(wesentliche_1_1,refer_c)
    & varia(wesentliche_1_1,varia_c)
    & sort(entwicklung_1_1,ad)
    & card(entwicklung_1_1,int1)
    & etype(entwicklung_1_1,int0)
    & fact(entwicklung_1_1,real)
    & gener(entwicklung_1_1,ge)
    & quant(entwicklung_1_1,one)
    & refer(entwicklung_1_1,refer_c)
    & varia(entwicklung_1_1,varia_c)
    & sort(c699,na)
    & card(c699,int1)
    & etype(c699,int0)
    & fact(c699,real)
    & gener(c699,sp)
    & quant(c699,one)
    & refer(c699,indet)
    & varia(c699,varia_c)
    & sort(land_1_1,d)
    & sort(land_1_1,io)
    & card(land_1_1,int1)
    & etype(land_1_1,int0)
    & fact(land_1_1,real)
    & gener(land_1_1,ge)
    & quant(land_1_1,one)
    & refer(land_1_1,refer_c)
    & varia(land_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(frankreich_0,fe)
    & sort(motoreinbau_1_1,ad)
    & card(motoreinbau_1_1,int1)
    & etype(motoreinbau_1_1,int0)
    & fact(motoreinbau_1_1,real)
    & gener(motoreinbau_1_1,ge)
    & quant(motoreinbau_1_1,one)
    & refer(motoreinbau_1_1,refer_c)
    & varia(motoreinbau_1_1,varia_c)
    & sort(rahmen__1_1,d)
    & card(rahmen__1_1,int1)
    & etype(rahmen__1_1,int0)
    & fact(rahmen__1_1,real)
    & gener(rahmen__1_1,ge)
    & quant(rahmen__1_1,one)
    & refer(rahmen__1_1,refer_c)
    & varia(rahmen__1_1,varia_c)
    & sort(c722,na)
    & card(c722,int1)
    & etype(c722,int0)
    & fact(c722,real)
    & gener(c722,sp)
    & quant(c722,one)
    & refer(c722,indet)
    & varia(c722,varia_c)
    & sort(gebr__374der_1_1,d)
    & card(gebr__374der_1_1,int1)
    & etype(gebr__374der_1_1,int0)
    & fact(gebr__374der_1_1,real)
    & gener(gebr__374der_1_1,ge)
    & quant(gebr__374der_1_1,one)
    & refer(gebr__374der_1_1,refer_c)
    & varia(gebr__374der_1_1,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(werner_0,fe)
    & sort(c730,na)
    & card(c730,int1)
    & etype(c730,int0)
    & fact(c730,real)
    & gener(c730,sp)
    & quant(c730,one)
    & refer(c730,indet)
    & varia(c730,varia_c)
    & sort(c795,na)
    & card(c795,int1)
    & etype(c795,int0)
    & fact(c795,real)
    & gener(c795,sp)
    & quant(c795,one)
    & refer(c795,indet)
    & varia(c795,varia_c)
    & sort(c824,na)
    & card(c824,int1)
    & etype(c824,int0)
    & fact(c824,real)
    & gener(c824,sp)
    & quant(c824,one)
    & refer(c824,indet)
    & varia(c824,varia_c)
    & sort(belgien_0,fe)
    & sort(vierzylindermotorrad_1_1,d)
    & card(vierzylindermotorrad_1_1,int1)
    & etype(vierzylindermotorrad_1_1,int0)
    & fact(vierzylindermotorrad_1_1,real)
    & gener(vierzylindermotorrad_1_1,ge)
    & quant(vierzylindermotorrad_1_1,one)
    & refer(vierzylindermotorrad_1_1,refer_c)
    & varia(vierzylindermotorrad_1_1,varia_c)
    & sort(kardanwelle_1_1,o)
    & card(kardanwelle_1_1,int1)
    & etype(kardanwelle_1_1,int0)
    & fact(kardanwelle_1_1,real)
    & gener(kardanwelle_1_1,ge)
    & quant(kardanwelle_1_1,one)
    & refer(kardanwelle_1_1,refer_c)
    & varia(kardanwelle_1_1,varia_c)
    & sort(c745,d)
    & sort(c745,io)
    & card(c745,int1)
    & etype(c745,int0)
    & fact(c745,real)
    & gener(c745,sp)
    & quant(c745,one)
    & refer(c745,det)
    & varia(c745,con)
    & sort(firma_1_1,d)
    & sort(firma_1_1,io)
    & card(firma_1_1,int1)
    & etype(firma_1_1,int0)
    & fact(firma_1_1,real)
    & gener(firma_1_1,ge)
    & quant(firma_1_1,one)
    & refer(firma_1_1,refer_c)
    & varia(firma_1_1,varia_c)
    & sort(c752,na)
    & card(c752,int1)
    & etype(c752,int0)
    & fact(c752,real)
    & gener(c752,sp)
    & quant(c752,one)
    & refer(c752,indet)
    & varia(c752,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(c753,fe)
    & sort(initial_f_0,fe)
    & sort(initial_n_0,fe)
    & sort(c757,me)
    & sort(c757,oa)
    & sort(c757,ta)
    & card(c757,card_c)
    & etype(c757,etype_c)
    & fact(c757,real)
    & gener(c757,sp)
    & quant(c757,quant_c)
    & refer(c757,refer_c)
    & varia(c757,varia_c)
    & sort(jahr__1_1,me)
    & sort(jahr__1_1,oa)
    & sort(jahr__1_1,ta)
    & card(jahr__1_1,card_c)
    & etype(jahr__1_1,etype_c)
    & fact(jahr__1_1,real)
    & gener(jahr__1_1,ge)
    & quant(jahr__1_1,quant_c)
    & refer(jahr__1_1,refer_c)
    & varia(jahr__1_1,varia_c)
    & sort(c754,nu)
    & card(c754,int1904)
    & sort(c763,na)
    & card(c763,int1)
    & etype(c763,int0)
    & fact(c763,real)
    & gener(c763,sp)
    & quant(c763,one)
    & refer(c763,indet)
    & varia(c763,varia_c)
    & sort(gebiet_1_1,d)
    & card(gebiet_1_1,int1)
    & etype(gebiet_1_1,int0)
    & fact(gebiet_1_1,real)
    & gener(gebiet_1_1,ge)
    & quant(gebiet_1_1,one)
    & refer(gebiet_1_1,refer_c)
    & varia(gebiet_1_1,varia_c)
    & sort(england_0,fe)
    & sort(kickstarter_1_1,d)
    & card(kickstarter_1_1,int1)
    & etype(kickstarter_1_1,int0)
    & fact(kickstarter_1_1,real)
    & gener(kickstarter_1_1,ge)
    & quant(kickstarter_1_1,one)
    & refer(kickstarter_1_1,refer_c)
    & varia(kickstarter_1_1,varia_c)
    & sort(bremse_1_1,d)
    & card(bremse_1_1,int1)
    & etype(bremse_1_1,int0)
    & fact(bremse_1_1,real)
    & gener(bremse_1_1,ge)
    & quant(bremse_1_1,one)
    & refer(bremse_1_1,refer_c)
    & varia(bremse_1_1,varia_c)
    & sort(zweitaktmotor_1_1,d)
    & card(zweitaktmotor_1_1,int1)
    & etype(zweitaktmotor_1_1,int0)
    & fact(zweitaktmotor_1_1,real)
    & gener(zweitaktmotor_1_1,ge)
    & quant(zweitaktmotor_1_1,one)
    & refer(zweitaktmotor_1_1,refer_c)
    & varia(zweitaktmotor_1_1,varia_c)
    & sort(c787,na)
    & card(c787,int1)
    & etype(c787,int0)
    & fact(c787,real)
    & gener(c787,sp)
    & quant(c787,one)
    & refer(c787,indet)
    & varia(c787,varia_c)
    & sort(scott_0,fe)
    & sort(usa_0,fe)
    & sort(elektrisch_1_1,tq)
    & sort(anlasser_1_1,o)
    & card(anlasser_1_1,int1)
    & etype(anlasser_1_1,int0)
    & fact(anlasser_1_1,real)
    & gener(anlasser_1_1,ge)
    & quant(anlasser_1_1,one)
    & refer(anlasser_1_1,refer_c)
    & varia(anlasser_1_1,varia_c)
    & sort(beleuchtung_1_1,ad)
    & card(beleuchtung_1_1,int1)
    & etype(beleuchtung_1_1,int0)
    & fact(beleuchtung_1_1,real)
    & gener(beleuchtung_1_1,ge)
    & quant(beleuchtung_1_1,one)
    & refer(beleuchtung_1_1,refer_c)
    & varia(beleuchtung_1_1,varia_c)
    & sort(c816,na)
    & card(c816,int1)
    & etype(c816,int0)
    & fact(c816,real)
    & gener(c816,sp)
    & quant(c816,one)
    & refer(c816,indet)
    & varia(c816,varia_c)
    & sort(erzeugnis_1_1,co)
    & card(erzeugnis_1_1,card_c)
    & etype(erzeugnis_1_1,etype_c)
    & fact(erzeugnis_1_1,real)
    & gener(erzeugnis_1_1,ge)
    & quant(erzeugnis_1_1,quant_c)
    & refer(erzeugnis_1_1,refer_c)
    & varia(erzeugnis_1_1,varia_c)
    & sort(indian_0,fe)
    & sort(bundesrepublik_0,fe)
    & sort(kicken_1_1,da)
    & fact(kicken_1_1,real)
    & gener(kicken_1_1,ge)
    & sort(motor__1_1,d)
    & card(motor__1_1,int1)
    & etype(motor__1_1,int0)
    & fact(motor__1_1,real)
    & gener(motor__1_1,ge)
    & quant(motor__1_1,one)
    & refer(motor__1_1,refer_c)
    & varia(motor__1_1,varia_c)
    & sort(einbau__1_1,ad)
    & card(einbau__1_1,int1)
    & etype(einbau__1_1,int0)
    & fact(einbau__1_1,real)
    & gener(einbau__1_1,ge)
    & quant(einbau__1_1,one)
    & refer(einbau__1_1,refer_c)
    & varia(einbau__1_1,varia_c)
    & sort(vier_1_1,nu)
    & card(vier_1_1,int4)
    & sort(walze_1_1,d)
    & card(walze_1_1,int1)
    & etype(walze_1_1,int0)
    & fact(walze_1_1,real)
    & gener(walze_1_1,ge)
    & quant(walze_1_1,one)
    & refer(walze_1_1,refer_c)
    & varia(walze_1_1,varia_c)
    & sort(kraftrad_1_1,d)
    & card(kraftrad_1_1,int1)
    & etype(kraftrad_1_1,int0)
    & fact(kraftrad_1_1,real)
    & gener(kraftrad_1_1,ge)
    & quant(kraftrad_1_1,one)
    & refer(kraftrad_1_1,refer_c)
    & varia(kraftrad_1_1,varia_c)
    & sort(akte_1_1,d)
    & sort(akte_1_1,io)
    & card(akte_1_1,int1)
    & etype(akte_1_1,int0)
    & fact(akte_1_1,real)
    & gener(akte_1_1,ge)
    & quant(akte_1_1,one)
    & refer(akte_1_1,refer_c)
    & varia(akte_1_1,varia_c)
    & sort(zweit_1_1,oq)
    & card(zweit_1_1,int2) ) ).

%------------------------------------------------------------------------------
