%------------------------------------------------------------------------------
% File     : CSR115+92 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_wp_532_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.40 v9.0.0, 0.25 v8.2.0, 0.27 v8.1.0, 0.29 v7.5.0, 0.38 v7.4.0, 0.25 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.23 v6.2.0, 0.36 v6.1.0, 0.44 v6.0.0, 0.50 v5.5.0, 0.46 v5.4.0, 0.43 v5.3.0, 0.48 v5.2.0, 0.36 v5.0.0, 0.35 v4.1.0, 0.44 v4.0.1, 0.47 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10803 (   0 equ)
%            Maximal formula atoms :   96 (   1 avg)
%            Number of connectives :  614 (   0   ~;  18   |; 470   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   96 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-4 aty)
%            Number of functors    : 16646 (16646 usr;16645 con; 0-2 aty)
%            Number of variables   :  475 ( 405   !;  70   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_wp_532,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6] :
      ( attr(X0,X1)
      & attr(X3,X2)
      & attr(X5,X6)
      & obj(X4,X0)
      & sub(X1,name_1_1)
      & sub(X0,firma_1_1)
      & sub(X2,name_1_1)
      & val(X1,bmw_0)
      & val(X2,bmw_0) ) ).

fof(ave07_era5_synth_qa07_007_mira_wp_532,hypothesis,
    ( attr(c17728,c17729)
    & attr(c17728,c17760)
    & sub(c17728,firma_1_1)
    & sub(c17729,name_1_1)
    & val(c17729,bmw_0)
    & sub(c17760,name_1_1)
    & val(c17760,bmw_0)
    & attr(c17769,c17770)
    & sub(c17769,mensch_1_1)
    & sub(c17770,familiename_1_1)
    & val(c17770,sauber_0)
    & tupl_p4(c17915,c17728,c17728,c17769)
    & sort(c17728,d)
    & sort(c17728,io)
    & card(c17728,int1)
    & etype(c17728,int0)
    & fact(c17728,real)
    & gener(c17728,sp)
    & quant(c17728,one)
    & refer(c17728,det)
    & varia(c17728,con)
    & sort(c17729,na)
    & card(c17729,int1)
    & etype(c17729,int0)
    & fact(c17729,real)
    & gener(c17729,sp)
    & quant(c17729,one)
    & refer(c17729,indet)
    & varia(c17729,varia_c)
    & sort(c17760,na)
    & card(c17760,int1)
    & etype(c17760,int0)
    & fact(c17760,real)
    & gener(c17760,sp)
    & quant(c17760,one)
    & refer(c17760,indet)
    & varia(c17760,varia_c)
    & sort(firma_1_1,d)
    & sort(firma_1_1,io)
    & card(firma_1_1,int1)
    & etype(firma_1_1,int0)
    & fact(firma_1_1,real)
    & gener(firma_1_1,ge)
    & quant(firma_1_1,one)
    & refer(firma_1_1,refer_c)
    & varia(firma_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(bmw_0,fe)
    & sort(c17769,d)
    & card(c17769,int1)
    & etype(c17769,int0)
    & fact(c17769,real)
    & gener(c17769,sp)
    & quant(c17769,one)
    & refer(c17769,det)
    & varia(c17769,con)
    & sort(c17770,na)
    & card(c17770,int1)
    & etype(c17770,int0)
    & fact(c17770,real)
    & gener(c17770,sp)
    & quant(c17770,one)
    & refer(c17770,indet)
    & varia(c17770,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(sauber_0,fe)
    & sort(c17915,ent)
    & card(c17915,card_c)
    & etype(c17915,etype_c)
    & fact(c17915,real)
    & gener(c17915,gener_c)
    & quant(c17915,quant_c)
    & refer(c17915,refer_c)
    & varia(c17915,varia_c) ) ).

%------------------------------------------------------------------------------
