%------------------------------------------------------------------------------
% File     : CSR115+91 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_wp_529_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.40 v9.1.0, 0.33 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.21 v7.5.0, 0.29 v7.4.0, 0.25 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.23 v6.2.0, 0.36 v6.1.0, 0.44 v6.0.0, 0.50 v5.5.0, 0.54 v5.4.0, 0.48 v5.2.0, 0.36 v5.0.0, 0.40 v4.1.0, 0.44 v4.0.1, 0.37 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 11098 (   0 equ)
%            Maximal formula atoms :  391 (   1 avg)
%            Number of connectives :  909 (   0   ~;  18   |; 765   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  391 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-20 aty)
%            Number of functors    : 16682 (16682 usr;16681 con; 0-2 aty)
%            Number of variables   :  475 ( 405   !;  70   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_wp_529,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6] :
      ( attr(X0,X1)
      & attr(X3,X2)
      & attr(X5,X6)
      & sub(X1,name_1_1)
      & sub(X0,firma_1_1)
      & sub(X2,name_1_1)
      & subs(X4,n374bernehmen_1_1)
      & val(X1,bmw_0)
      & val(X2,bmw_0) ) ).

fof(ave07_era5_synth_qa07_007_mira_wp_529,hypothesis,
    ( sub(c47352,aera_1_1)
    & pred(c47356,luxusfahrzeug_1_1)
    & sub(c47360,bmw_1_1)
    & sub(c47366,abschlu__337_1_1)
    & prop(c47374,kurz_1_1)
    & sub(c47374,inter_mezzo_1_1)
    & sub(c47379,abschlu__337_1_1)
    & pred(c47385,jahr__1_1)
    & prop(c47385,n1960er_1_1)
    & subs(c47391,annahme_1_1)
    & sub(c47395,firma_1_1)
    & sub(c47399,glas_1_1)
    & attr(c47406,c47407)
    & sub(c47406,stadt__1_1)
    & sub(c47407,name_1_1)
    & val(c47407,dingolfing_0)
    & pred(c47416,v8er_1_1)
    & prop(c47416,luxuri__366s_1_1)
    & subr(c47452,ehe_2_1)
    & subs(c47465,annahme_1_1)
    & prop(c47476,kurz_1_1)
    & sub(c47476,zeit_1_1)
    & sub(c47482,propeller_1_1)
    & sub(c47485,abzeichen_1_1)
    & attr(c47502,c47503)
    & sub(c47502,firma_1_1)
    & sub(c47503,name_1_1)
    & val(c47503,bmw_0)
    & attr(c47512,c47513)
    & sub(c47512,erzeugnis_1_1)
    & sub(c47513,name_1_1)
    & val(c47513,v8_0)
    & tupl_p20(c50663,c47352,c47356,c47360,c47366,c47374,c47379,c47385,c47391,c47395,c47399,c47406,c47416,c47452,c47465,c47476,c47482,c47485,c47502,c47512)
    & assoc(luxusfahrzeug_1_1,luxus__1_1)
    & sub(luxusfahrzeug_1_1,fahrzeug__1_1)
    & sort(c47352,ta)
    & card(c47352,int1)
    & etype(c47352,int0)
    & fact(c47352,real)
    & gener(c47352,sp)
    & quant(c47352,one)
    & refer(c47352,det)
    & varia(c47352,con)
    & sort(aera_1_1,ta)
    & card(aera_1_1,int1)
    & etype(aera_1_1,int0)
    & fact(aera_1_1,real)
    & gener(aera_1_1,ge)
    & quant(aera_1_1,one)
    & refer(aera_1_1,refer_c)
    & varia(aera_1_1,varia_c)
    & sort(c47356,d)
    & card(c47356,cons(x_constant,cons(int1,nil)))
    & etype(c47356,int1)
    & fact(c47356,real)
    & gener(c47356,sp)
    & quant(c47356,mult)
    & refer(c47356,det)
    & varia(c47356,con)
    & sort(luxusfahrzeug_1_1,d)
    & card(luxusfahrzeug_1_1,int1)
    & etype(luxusfahrzeug_1_1,int0)
    & fact(luxusfahrzeug_1_1,real)
    & gener(luxusfahrzeug_1_1,ge)
    & quant(luxusfahrzeug_1_1,one)
    & refer(luxusfahrzeug_1_1,refer_c)
    & varia(luxusfahrzeug_1_1,varia_c)
    & sort(c47360,d)
    & card(c47360,int1)
    & etype(c47360,int0)
    & fact(c47360,real)
    & gener(c47360,gener_c)
    & quant(c47360,one)
    & refer(c47360,refer_c)
    & varia(c47360,varia_c)
    & sort(bmw_1_1,d)
    & card(bmw_1_1,int1)
    & etype(bmw_1_1,int0)
    & fact(bmw_1_1,real)
    & gener(bmw_1_1,ge)
    & quant(bmw_1_1,one)
    & refer(bmw_1_1,refer_c)
    & varia(bmw_1_1,varia_c)
    & sort(c47366,ad)
    & sort(c47366,io)
    & card(c47366,int1)
    & etype(c47366,int0)
    & fact(c47366,real)
    & gener(c47366,gener_c)
    & quant(c47366,one)
    & refer(c47366,refer_c)
    & varia(c47366,varia_c)
    & sort(abschlu__337_1_1,ad)
    & sort(abschlu__337_1_1,io)
    & card(abschlu__337_1_1,int1)
    & etype(abschlu__337_1_1,int0)
    & fact(abschlu__337_1_1,real)
    & gener(abschlu__337_1_1,ge)
    & quant(abschlu__337_1_1,one)
    & refer(abschlu__337_1_1,refer_c)
    & varia(abschlu__337_1_1,varia_c)
    & sort(c47374,o)
    & card(c47374,int1)
    & etype(c47374,int0)
    & fact(c47374,real)
    & gener(c47374,sp)
    & quant(c47374,one)
    & refer(c47374,det)
    & varia(c47374,con)
    & sort(kurz_1_1,mq)
    & sort(inter_mezzo_1_1,o)
    & card(inter_mezzo_1_1,int1)
    & etype(inter_mezzo_1_1,int0)
    & fact(inter_mezzo_1_1,real)
    & gener(inter_mezzo_1_1,ge)
    & quant(inter_mezzo_1_1,one)
    & refer(inter_mezzo_1_1,refer_c)
    & varia(inter_mezzo_1_1,varia_c)
    & sort(c47379,ad)
    & sort(c47379,io)
    & card(c47379,int1)
    & etype(c47379,int0)
    & fact(c47379,real)
    & gener(c47379,sp)
    & quant(c47379,one)
    & refer(c47379,det)
    & varia(c47379,con)
    & sort(c47385,me)
    & sort(c47385,oa)
    & sort(c47385,ta)
    & card(c47385,card_c)
    & etype(c47385,etype_c)
    & fact(c47385,real)
    & gener(c47385,sp)
    & quant(c47385,quant_c)
    & refer(c47385,det)
    & varia(c47385,con)
    & sort(jahr__1_1,me)
    & sort(jahr__1_1,oa)
    & sort(jahr__1_1,ta)
    & card(jahr__1_1,card_c)
    & etype(jahr__1_1,etype_c)
    & fact(jahr__1_1,real)
    & gener(jahr__1_1,ge)
    & quant(jahr__1_1,quant_c)
    & refer(jahr__1_1,refer_c)
    & varia(jahr__1_1,varia_c)
    & sort(n1960er_1_1,gq)
    & sort(c47391,ad)
    & card(c47391,int1)
    & etype(c47391,int0)
    & fact(c47391,real)
    & gener(c47391,sp)
    & quant(c47391,one)
    & refer(c47391,det)
    & varia(c47391,con)
    & sort(annahme_1_1,ad)
    & card(annahme_1_1,int1)
    & etype(annahme_1_1,int0)
    & fact(annahme_1_1,real)
    & gener(annahme_1_1,ge)
    & quant(annahme_1_1,one)
    & refer(annahme_1_1,refer_c)
    & varia(annahme_1_1,varia_c)
    & sort(c47395,d)
    & sort(c47395,io)
    & card(c47395,int1)
    & etype(c47395,int0)
    & fact(c47395,real)
    & gener(c47395,sp)
    & quant(c47395,one)
    & refer(c47395,det)
    & varia(c47395,con)
    & sort(firma_1_1,d)
    & sort(firma_1_1,io)
    & card(firma_1_1,int1)
    & etype(firma_1_1,int0)
    & fact(firma_1_1,real)
    & gener(firma_1_1,ge)
    & quant(firma_1_1,one)
    & refer(firma_1_1,refer_c)
    & varia(firma_1_1,varia_c)
    & sort(c47399,s)
    & card(c47399,int1)
    & etype(c47399,int0)
    & fact(c47399,real)
    & gener(c47399,gener_c)
    & quant(c47399,one)
    & refer(c47399,refer_c)
    & varia(c47399,varia_c)
    & sort(glas_1_1,s)
    & card(glas_1_1,int1)
    & etype(glas_1_1,int0)
    & fact(glas_1_1,real)
    & gener(glas_1_1,ge)
    & quant(glas_1_1,one)
    & refer(glas_1_1,refer_c)
    & varia(glas_1_1,varia_c)
    & sort(c47406,d)
    & sort(c47406,io)
    & card(c47406,int1)
    & etype(c47406,int0)
    & fact(c47406,real)
    & gener(c47406,sp)
    & quant(c47406,one)
    & refer(c47406,det)
    & varia(c47406,con)
    & sort(c47407,na)
    & card(c47407,int1)
    & etype(c47407,int0)
    & fact(c47407,real)
    & gener(c47407,sp)
    & quant(c47407,one)
    & refer(c47407,indet)
    & varia(c47407,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(dingolfing_0,fe)
    & sort(c47416,o)
    & card(c47416,cons(x_constant,cons(int1,nil)))
    & etype(c47416,int1)
    & fact(c47416,real)
    & gener(c47416,gener_c)
    & quant(c47416,mult)
    & refer(c47416,refer_c)
    & varia(c47416,varia_c)
    & sort(v8er_1_1,o)
    & card(v8er_1_1,int1)
    & etype(v8er_1_1,int0)
    & fact(v8er_1_1,real)
    & gener(v8er_1_1,ge)
    & quant(v8er_1_1,one)
    & refer(v8er_1_1,refer_c)
    & varia(v8er_1_1,varia_c)
    & sort(luxuri__366s_1_1,nq)
    & sort(c47452,as)
    & sort(c47452,re)
    & card(c47452,int1)
    & etype(c47452,int0)
    & fact(c47452,real)
    & gener(c47452,sp)
    & quant(c47452,one)
    & refer(c47452,det)
    & varia(c47452,con)
    & sort(ehe_2_1,as)
    & sort(ehe_2_1,re)
    & card(ehe_2_1,int1)
    & etype(ehe_2_1,int0)
    & fact(ehe_2_1,real)
    & gener(ehe_2_1,ge)
    & quant(ehe_2_1,one)
    & refer(ehe_2_1,refer_c)
    & varia(ehe_2_1,varia_c)
    & sort(c47465,ad)
    & card(c47465,int1)
    & etype(c47465,int0)
    & fact(c47465,real)
    & gener(c47465,gener_c)
    & quant(c47465,one)
    & refer(c47465,refer_c)
    & varia(c47465,varia_c)
    & sort(c47476,ta)
    & card(c47476,int1)
    & etype(c47476,int0)
    & fact(c47476,real)
    & gener(c47476,gener_c)
    & quant(c47476,one)
    & refer(c47476,refer_c)
    & varia(c47476,varia_c)
    & sort(zeit_1_1,ta)
    & card(zeit_1_1,int1)
    & etype(zeit_1_1,int0)
    & fact(zeit_1_1,real)
    & gener(zeit_1_1,ge)
    & quant(zeit_1_1,one)
    & refer(zeit_1_1,refer_c)
    & varia(zeit_1_1,varia_c)
    & sort(c47482,d)
    & card(c47482,int1)
    & etype(c47482,int0)
    & fact(c47482,real)
    & gener(c47482,sp)
    & quant(c47482,one)
    & refer(c47482,det)
    & varia(c47482,con)
    & sort(propeller_1_1,d)
    & card(propeller_1_1,int1)
    & etype(propeller_1_1,int0)
    & fact(propeller_1_1,real)
    & gener(propeller_1_1,ge)
    & quant(propeller_1_1,one)
    & refer(propeller_1_1,refer_c)
    & varia(propeller_1_1,varia_c)
    & sort(c47485,d)
    & card(c47485,int1)
    & etype(c47485,int0)
    & fact(c47485,real)
    & gener(c47485,gener_c)
    & quant(c47485,one)
    & refer(c47485,refer_c)
    & varia(c47485,varia_c)
    & sort(abzeichen_1_1,d)
    & card(abzeichen_1_1,int1)
    & etype(abzeichen_1_1,int0)
    & fact(abzeichen_1_1,real)
    & gener(abzeichen_1_1,ge)
    & quant(abzeichen_1_1,one)
    & refer(abzeichen_1_1,refer_c)
    & varia(abzeichen_1_1,varia_c)
    & sort(c47502,d)
    & sort(c47502,io)
    & card(c47502,int1)
    & etype(c47502,int0)
    & fact(c47502,real)
    & gener(c47502,sp)
    & quant(c47502,one)
    & refer(c47502,det)
    & varia(c47502,con)
    & sort(c47503,na)
    & card(c47503,int1)
    & etype(c47503,int0)
    & fact(c47503,real)
    & gener(c47503,sp)
    & quant(c47503,one)
    & refer(c47503,indet)
    & varia(c47503,varia_c)
    & sort(bmw_0,fe)
    & sort(c47512,co)
    & card(c47512,card_c)
    & etype(c47512,etype_c)
    & fact(c47512,real)
    & gener(c47512,sp)
    & quant(c47512,quant_c)
    & refer(c47512,det)
    & varia(c47512,con)
    & sort(c47513,na)
    & card(c47513,int1)
    & etype(c47513,int0)
    & fact(c47513,real)
    & gener(c47513,sp)
    & quant(c47513,one)
    & refer(c47513,indet)
    & varia(c47513,varia_c)
    & sort(erzeugnis_1_1,co)
    & card(erzeugnis_1_1,card_c)
    & etype(erzeugnis_1_1,etype_c)
    & fact(erzeugnis_1_1,real)
    & gener(erzeugnis_1_1,ge)
    & quant(erzeugnis_1_1,quant_c)
    & refer(erzeugnis_1_1,refer_c)
    & varia(erzeugnis_1_1,varia_c)
    & sort(v8_0,fe)
    & sort(c50663,ent)
    & card(c50663,card_c)
    & etype(c50663,etype_c)
    & fact(c50663,real)
    & gener(c50663,gener_c)
    & quant(c50663,quant_c)
    & refer(c50663,refer_c)
    & varia(c50663,varia_c)
    & sort(luxus__1_1,io)
    & card(luxus__1_1,int1)
    & etype(luxus__1_1,int0)
    & fact(luxus__1_1,real)
    & gener(luxus__1_1,ge)
    & quant(luxus__1_1,one)
    & refer(luxus__1_1,refer_c)
    & varia(luxus__1_1,varia_c)
    & sort(fahrzeug__1_1,d)
    & card(fahrzeug__1_1,int1)
    & etype(fahrzeug__1_1,int0)
    & fact(fahrzeug__1_1,real)
    & gener(fahrzeug__1_1,ge)
    & quant(fahrzeug__1_1,one)
    & refer(fahrzeug__1_1,refer_c)
    & varia(fahrzeug__1_1,varia_c) ) ).

%------------------------------------------------------------------------------
