%------------------------------------------------------------------------------
% File     : CSR115+90 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_wp_514_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.40 v9.0.0, 0.25 v8.2.0, 0.27 v8.1.0, 0.29 v7.5.0, 0.38 v7.4.0, 0.31 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.36 v6.4.0, 0.29 v6.3.0, 0.31 v6.2.0, 0.45 v6.1.0, 0.56 v6.0.0, 0.50 v5.5.0, 0.54 v5.4.0, 0.52 v5.3.0, 0.61 v5.2.0, 0.43 v5.0.0, 0.40 v4.1.0, 0.50 v4.0.1, 0.53 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 11014 (   0 equ)
%            Maximal formula atoms :  310 (   1 avg)
%            Number of connectives :  825 (   0   ~;  18   |; 681   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  310 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   88 (  88 usr;   0 prp; 2-14 aty)
%            Number of functors    : 16681 (16681 usr;16680 con; 0-2 aty)
%            Number of variables   :  475 ( 405   !;  70   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_wp_514,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6] :
      ( attr(X0,X1)
      & attr(X3,X2)
      & attr(X5,X6)
      & obj(X4,X0)
      & sub(X1,name_1_1)
      & sub(X2,name_1_1) ) ).

fof(ave07_era5_synth_qa07_007_mira_wp_514,hypothesis,
    ( assoc(boxermotor_1_1,boxer_2_1)
    & sub(boxermotor_1_1,motor__1_1)
    & assoc(bundeswehrausf__374hrung_1_1,bundeswehr_1_1)
    & sub(bundeswehrausf__374hrung_1_1,ausf__374hrung_1_1)
    & sub(c37238,faun_1_1)
    & attr(c37245,c37246)
    & sub(c37245,stadt__1_1)
    & sub(c37246,name_1_1)
    & val(c37246,n__374rnberg_0)
    & sub(c37268,c37272)
    & pmod(c37272,ackerbautreibend_1_1,einsatz_1_1)
    & sub(c37274,fahrzeug__1_1)
    & sub(c37284,bundeswehrausf__374hrung_1_1)
    & pred(c37291,reifen__1_1)
    & attch(c37298,c37291)
    & pred(c37298,lypsoid_1_1)
    & prop(c37298,n22x12_1_1)
    & quant_p3(c37339,c37331,pferdest__344rke_1_1)
    & prop(c37341,c37229)
    & sub(c37341,bmw_1_1)
    & sub(c37345,boxermotor_1_1)
    & sub(c37359,last_1_1)
    & quant_p3(c37361,c37356,kilo__1_1)
    & tupl_p14(c37402,c37233,c37238,c37245,c37268,c37274,c37284,c37291,c37313,c37339,c37341,c37345,c37361,c37359)
    & chsp2(drosseln_1_1,c37229)
    & sort(boxermotor_1_1,d)
    & card(boxermotor_1_1,int1)
    & etype(boxermotor_1_1,int0)
    & fact(boxermotor_1_1,real)
    & gener(boxermotor_1_1,ge)
    & quant(boxermotor_1_1,one)
    & refer(boxermotor_1_1,refer_c)
    & varia(boxermotor_1_1,varia_c)
    & sort(boxer_2_1,d)
    & card(boxer_2_1,int1)
    & etype(boxer_2_1,int0)
    & fact(boxer_2_1,real)
    & gener(boxer_2_1,ge)
    & quant(boxer_2_1,one)
    & refer(boxer_2_1,refer_c)
    & varia(boxer_2_1,varia_c)
    & sort(motor__1_1,d)
    & card(motor__1_1,int1)
    & etype(motor__1_1,int0)
    & fact(motor__1_1,real)
    & gener(motor__1_1,ge)
    & quant(motor__1_1,one)
    & refer(motor__1_1,refer_c)
    & varia(motor__1_1,varia_c)
    & sort(bundeswehrausf__374hrung_1_1,ad)
    & sort(bundeswehrausf__374hrung_1_1,d)
    & sort(bundeswehrausf__374hrung_1_1,io)
    & card(bundeswehrausf__374hrung_1_1,int1)
    & etype(bundeswehrausf__374hrung_1_1,int0)
    & fact(bundeswehrausf__374hrung_1_1,real)
    & gener(bundeswehrausf__374hrung_1_1,ge)
    & quant(bundeswehrausf__374hrung_1_1,one)
    & refer(bundeswehrausf__374hrung_1_1,refer_c)
    & varia(bundeswehrausf__374hrung_1_1,varia_c)
    & sort(bundeswehr_1_1,d)
    & sort(bundeswehr_1_1,io)
    & card(bundeswehr_1_1,card_c)
    & etype(bundeswehr_1_1,int1)
    & fact(bundeswehr_1_1,real)
    & gener(bundeswehr_1_1,ge)
    & quant(bundeswehr_1_1,quant_c)
    & refer(bundeswehr_1_1,refer_c)
    & varia(bundeswehr_1_1,varia_c)
    & sort(ausf__374hrung_1_1,ad)
    & sort(ausf__374hrung_1_1,d)
    & sort(ausf__374hrung_1_1,io)
    & card(ausf__374hrung_1_1,int1)
    & etype(ausf__374hrung_1_1,int0)
    & fact(ausf__374hrung_1_1,real)
    & gener(ausf__374hrung_1_1,ge)
    & quant(ausf__374hrung_1_1,one)
    & refer(ausf__374hrung_1_1,refer_c)
    & varia(ausf__374hrung_1_1,varia_c)
    & sort(c37238,o)
    & card(c37238,int1)
    & etype(c37238,int0)
    & fact(c37238,real)
    & gener(c37238,gener_c)
    & quant(c37238,one)
    & refer(c37238,refer_c)
    & varia(c37238,varia_c)
    & sort(faun_1_1,o)
    & card(faun_1_1,int1)
    & etype(faun_1_1,int0)
    & fact(faun_1_1,real)
    & gener(faun_1_1,ge)
    & quant(faun_1_1,one)
    & refer(faun_1_1,refer_c)
    & varia(faun_1_1,varia_c)
    & sort(c37245,d)
    & sort(c37245,io)
    & card(c37245,int1)
    & etype(c37245,int0)
    & fact(c37245,real)
    & gener(c37245,sp)
    & quant(c37245,one)
    & refer(c37245,det)
    & varia(c37245,con)
    & sort(c37246,na)
    & card(c37246,int1)
    & etype(c37246,int0)
    & fact(c37246,real)
    & gener(c37246,sp)
    & quant(c37246,one)
    & refer(c37246,indet)
    & varia(c37246,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(n__374rnberg_0,fe)
    & sort(c37268,ad)
    & sort(c37268,io)
    & card(c37268,int1)
    & etype(c37268,int0)
    & fact(c37268,real)
    & gener(c37268,sp)
    & quant(c37268,one)
    & refer(c37268,det)
    & varia(c37268,con)
    & sort(c37272,ad)
    & sort(c37272,io)
    & card(c37272,int1)
    & etype(c37272,int0)
    & fact(c37272,real)
    & gener(c37272,ge)
    & quant(c37272,one)
    & refer(c37272,refer_c)
    & varia(c37272,varia_c)
    & sort(ackerbautreibend_1_1,aq)
    & sort(einsatz_1_1,ad)
    & sort(einsatz_1_1,io)
    & card(einsatz_1_1,int1)
    & etype(einsatz_1_1,int0)
    & fact(einsatz_1_1,real)
    & gener(einsatz_1_1,ge)
    & quant(einsatz_1_1,one)
    & refer(einsatz_1_1,refer_c)
    & varia(einsatz_1_1,varia_c)
    & sort(c37274,d)
    & card(c37274,int1)
    & etype(c37274,int0)
    & fact(c37274,real)
    & gener(c37274,gener_c)
    & quant(c37274,one)
    & refer(c37274,refer_c)
    & varia(c37274,varia_c)
    & sort(fahrzeug__1_1,d)
    & card(fahrzeug__1_1,int1)
    & etype(fahrzeug__1_1,int0)
    & fact(fahrzeug__1_1,real)
    & gener(fahrzeug__1_1,ge)
    & quant(fahrzeug__1_1,one)
    & refer(fahrzeug__1_1,refer_c)
    & varia(fahrzeug__1_1,varia_c)
    & sort(c37284,ad)
    & sort(c37284,d)
    & sort(c37284,io)
    & card(c37284,int1)
    & etype(c37284,int0)
    & fact(c37284,real)
    & gener(c37284,sp)
    & quant(c37284,one)
    & refer(c37284,det)
    & varia(c37284,con)
    & sort(c37291,d)
    & card(c37291,int4)
    & etype(c37291,int1)
    & fact(c37291,real)
    & gener(c37291,sp)
    & quant(c37291,nfquant)
    & refer(c37291,det)
    & varia(c37291,varia_c)
    & sort(reifen__1_1,d)
    & card(reifen__1_1,int1)
    & etype(reifen__1_1,int0)
    & fact(reifen__1_1,real)
    & gener(reifen__1_1,ge)
    & quant(reifen__1_1,one)
    & refer(reifen__1_1,refer_c)
    & varia(reifen__1_1,varia_c)
    & sort(c37298,o)
    & card(c37298,cons(x_constant,cons(int1,nil)))
    & etype(c37298,int1)
    & fact(c37298,real)
    & gener(c37298,gener_c)
    & quant(c37298,mult)
    & refer(c37298,refer_c)
    & varia(c37298,varia_c)
    & sort(lypsoid_1_1,o)
    & card(lypsoid_1_1,int1)
    & etype(lypsoid_1_1,int0)
    & fact(lypsoid_1_1,real)
    & gener(lypsoid_1_1,ge)
    & quant(lypsoid_1_1,one)
    & refer(lypsoid_1_1,refer_c)
    & varia(lypsoid_1_1,varia_c)
    & sort(n22x12_1_1,gq)
    & sort(c37339,co)
    & sort(c37339,m)
    & card(c37339,card_c)
    & etype(c37339,etype_c)
    & fact(c37339,real)
    & gener(c37339,gener_c)
    & quant(c37339,quant_c)
    & refer(c37339,refer_c)
    & varia(c37339,con)
    & sort(c37331,nu)
    & card(c37331,int26)
    & sort(pferdest__344rke_1_1,me)
    & gener(pferdest__344rke_1_1,ge)
    & sort(c37341,d)
    & card(c37341,int1)
    & etype(c37341,int0)
    & fact(c37341,real)
    & gener(c37341,gener_c)
    & quant(c37341,one)
    & refer(c37341,refer_c)
    & varia(c37341,varia_c)
    & sort(c37229,tq)
    & sort(bmw_1_1,d)
    & card(bmw_1_1,int1)
    & etype(bmw_1_1,int0)
    & fact(bmw_1_1,real)
    & gener(bmw_1_1,ge)
    & quant(bmw_1_1,one)
    & refer(bmw_1_1,refer_c)
    & varia(bmw_1_1,varia_c)
    & sort(c37345,d)
    & card(c37345,int1)
    & etype(c37345,int0)
    & fact(c37345,real)
    & gener(c37345,gener_c)
    & quant(c37345,one)
    & refer(c37345,refer_c)
    & varia(c37345,varia_c)
    & sort(c37359,io)
    & card(c37359,int1)
    & etype(c37359,int0)
    & fact(c37359,real)
    & gener(c37359,gener_c)
    & quant(c37359,one)
    & refer(c37359,refer_c)
    & varia(c37359,varia_c)
    & sort(last_1_1,io)
    & card(last_1_1,int1)
    & etype(last_1_1,int0)
    & fact(last_1_1,real)
    & gener(last_1_1,ge)
    & quant(last_1_1,one)
    & refer(last_1_1,refer_c)
    & varia(last_1_1,varia_c)
    & sort(c37361,co)
    & sort(c37361,m)
    & card(c37361,card_c)
    & etype(c37361,etype_c)
    & fact(c37361,real)
    & gener(c37361,gener_c)
    & quant(c37361,quant_c)
    & refer(c37361,refer_c)
    & varia(c37361,con)
    & sort(c37356,nu)
    & card(c37356,int750)
    & sort(kilo__1_1,me)
    & gener(kilo__1_1,ge)
    & sort(c37402,ent)
    & card(c37402,card_c)
    & etype(c37402,etype_c)
    & fact(c37402,real)
    & gener(c37402,gener_c)
    & quant(c37402,quant_c)
    & refer(c37402,refer_c)
    & varia(c37402,varia_c)
    & sort(c37233,o)
    & card(c37233,int1)
    & etype(c37233,int0)
    & fact(c37233,real)
    & gener(c37233,sp)
    & quant(c37233,one)
    & refer(c37233,det)
    & varia(c37233,varia_c)
    & sort(c37313,o)
    & card(c37313,int1)
    & etype(c37313,int0)
    & fact(c37313,real)
    & gener(c37313,gener_c)
    & quant(c37313,one)
    & refer(c37313,refer_c)
    & varia(c37313,varia_c)
    & sort(drosseln_1_1,da)
    & fact(drosseln_1_1,real)
    & gener(drosseln_1_1,ge) ) ).

%------------------------------------------------------------------------------
