%------------------------------------------------------------------------------
% File     : CSR115+89 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_wp_511_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.40 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.29 v7.5.0, 0.38 v7.4.0, 0.25 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.31 v6.2.0, 0.45 v6.1.0, 0.52 v6.0.0, 0.50 v5.5.0, 0.58 v5.4.0, 0.57 v5.3.0, 0.61 v5.2.0, 0.36 v5.0.0, 0.45 v4.1.0, 0.50 v4.0.1, 0.58 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 11097 (   0 equ)
%            Maximal formula atoms :  390 (   1 avg)
%            Number of connectives :  908 (   0   ~;  18   |; 764   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  390 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-17 aty)
%            Number of functors    : 16683 (16683 usr;16682 con; 0-2 aty)
%            Number of variables   :  475 ( 405   !;  70   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_wp_511,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6] :
      ( attr(X0,X1)
      & attr(X3,X2)
      & attr(X5,X6)
      & obj(X4,X0)
      & sub(X1,name_1_1)
      & sub(X0,firma_1_1)
      & sub(X2,name_1_1)
      & val(X1,bmw_0)
      & val(X2,bmw_0) ) ).

fof(ave07_era5_synth_qa07_007_mira_wp_511,hypothesis,
    ( sub(c11126,zweit_weltkrieg_1_1)
    & sub(c11133,man_1_1)
    & sub(c11137,firma_1_1)
    & attr(c11144,c11145)
    & sub(c11144,mensch_1_1)
    & sub(c11145,familiename_1_1)
    & val(c11145,frazer_0)
    & attr(c11150,c11151)
    & sub(c11150,mensch_1_1)
    & sub(c11151,familiename_1_1)
    & val(c11151,nash_0)
    & attr(c11171,c11172)
    & sub(c11171,stadt__1_1)
    & sub(c11172,name_1_1)
    & val(c11172,bristol_0)
    & pred(c11175,artefakt_1_1)
    & sub(c11181,man_1_1)
    & attr(c12259,c12260)
    & sub(c12259,firma_1_1)
    & sub(c12260,name_1_1)
    & val(c12260,bmw_0)
    & sub(c12261,motor__1_1)
    & pred(c12274,wagen_1_1)
    & pred(c12278,fahrer__1_1)
    & attr(c12286,c12287)
    & attr(c12286,c12288)
    & sub(c12286,mensch_1_1)
    & sub(c12287,eigenname_1_1)
    & val(c12287,roy_0)
    & sub(c12288,familiename_1_1)
    & val(c12288,salvadori_0)
    & attr(c12293,c12294)
    & attr(c12293,c12295)
    & sub(c12293,mensch_1_1)
    & sub(c12294,eigenname_1_1)
    & val(c12294,tony_0)
    & sub(c12295,familiename_1_1)
    & val(c12295,crook_0)
    & preds(c12297,erfolg__1_1)
    & prop(c12297,achtbar_1_1)
    & pred(c12300,sportwagenrennen_1_1)
    & tupl_p17(c12390,c11126,c11133,c11137,c11144,c11150,c11171,c11175,c11181,c12259,c12261,c12274,c12278,c12286,c12293,c12297,c12300)
    & assoc(sportwagenrennen_1_1,sport__1_1)
    & sub(sportwagenrennen_1_1,wagenrennen_1_1)
    & sort(c11126,ad)
    & sort(c11126,ta)
    & card(c11126,int1)
    & etype(c11126,int0)
    & fact(c11126,real)
    & gener(c11126,sp)
    & quant(c11126,one)
    & refer(c11126,det)
    & varia(c11126,con)
    & sort(zweit_weltkrieg_1_1,ad)
    & sort(zweit_weltkrieg_1_1,ta)
    & card(zweit_weltkrieg_1_1,int1)
    & etype(zweit_weltkrieg_1_1,int0)
    & fact(zweit_weltkrieg_1_1,real)
    & gener(zweit_weltkrieg_1_1,sp)
    & quant(zweit_weltkrieg_1_1,one)
    & refer(zweit_weltkrieg_1_1,det)
    & varia(zweit_weltkrieg_1_1,con)
    & sort(c11133,d)
    & card(c11133,int1)
    & etype(c11133,int0)
    & fact(c11133,real)
    & gener(c11133,ge)
    & quant(c11133,one)
    & refer(c11133,refer_c)
    & varia(c11133,varia_c)
    & sort(man_1_1,d)
    & card(man_1_1,int1)
    & etype(man_1_1,int0)
    & fact(man_1_1,real)
    & gener(man_1_1,ge)
    & quant(man_1_1,one)
    & refer(man_1_1,refer_c)
    & varia(man_1_1,varia_c)
    & sort(c11137,d)
    & sort(c11137,io)
    & card(c11137,int1)
    & etype(c11137,int0)
    & fact(c11137,real)
    & gener(c11137,sp)
    & quant(c11137,one)
    & refer(c11137,det)
    & varia(c11137,con)
    & sort(firma_1_1,d)
    & sort(firma_1_1,io)
    & card(firma_1_1,int1)
    & etype(firma_1_1,int0)
    & fact(firma_1_1,real)
    & gener(firma_1_1,ge)
    & quant(firma_1_1,one)
    & refer(firma_1_1,refer_c)
    & varia(firma_1_1,varia_c)
    & sort(c11144,d)
    & card(c11144,int1)
    & etype(c11144,int0)
    & fact(c11144,real)
    & gener(c11144,sp)
    & quant(c11144,one)
    & refer(c11144,det)
    & varia(c11144,con)
    & sort(c11145,na)
    & card(c11145,int1)
    & etype(c11145,int0)
    & fact(c11145,real)
    & gener(c11145,sp)
    & quant(c11145,one)
    & refer(c11145,indet)
    & varia(c11145,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(frazer_0,fe)
    & sort(c11150,d)
    & card(c11150,int1)
    & etype(c11150,int0)
    & fact(c11150,real)
    & gener(c11150,sp)
    & quant(c11150,one)
    & refer(c11150,det)
    & varia(c11150,con)
    & sort(c11151,na)
    & card(c11151,int1)
    & etype(c11151,int0)
    & fact(c11151,real)
    & gener(c11151,sp)
    & quant(c11151,one)
    & refer(c11151,indet)
    & varia(c11151,varia_c)
    & sort(nash_0,fe)
    & sort(c11171,d)
    & sort(c11171,io)
    & card(c11171,int1)
    & etype(c11171,int0)
    & fact(c11171,real)
    & gener(c11171,sp)
    & quant(c11171,one)
    & refer(c11171,det)
    & varia(c11171,con)
    & sort(c11172,na)
    & card(c11172,int1)
    & etype(c11172,int0)
    & fact(c11172,real)
    & gener(c11172,sp)
    & quant(c11172,one)
    & refer(c11172,indet)
    & varia(c11172,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(bristol_0,fe)
    & sort(c11175,d)
    & sort(c11175,io)
    & card(c11175,cons(x_constant,cons(int1,nil)))
    & etype(c11175,int1)
    & fact(c11175,real)
    & gener(c11175,gener_c)
    & quant(c11175,mult)
    & refer(c11175,indet)
    & varia(c11175,varia_c)
    & sort(artefakt_1_1,d)
    & sort(artefakt_1_1,io)
    & card(artefakt_1_1,int1)
    & etype(artefakt_1_1,int0)
    & fact(artefakt_1_1,real)
    & gener(artefakt_1_1,ge)
    & quant(artefakt_1_1,one)
    & refer(artefakt_1_1,refer_c)
    & varia(artefakt_1_1,varia_c)
    & sort(c11181,d)
    & card(c11181,int1)
    & etype(c11181,int0)
    & fact(c11181,real)
    & gener(c11181,ge)
    & quant(c11181,one)
    & refer(c11181,refer_c)
    & varia(c11181,varia_c)
    & sort(c12259,d)
    & sort(c12259,io)
    & card(c12259,int1)
    & etype(c12259,int0)
    & fact(c12259,real)
    & gener(c12259,sp)
    & quant(c12259,one)
    & refer(c12259,det)
    & varia(c12259,con)
    & sort(c12260,na)
    & card(c12260,int1)
    & etype(c12260,int0)
    & fact(c12260,real)
    & gener(c12260,sp)
    & quant(c12260,one)
    & refer(c12260,indet)
    & varia(c12260,varia_c)
    & sort(bmw_0,fe)
    & sort(c12261,d)
    & card(c12261,int1)
    & etype(c12261,int0)
    & fact(c12261,real)
    & gener(c12261,gener_c)
    & quant(c12261,one)
    & refer(c12261,refer_c)
    & varia(c12261,varia_c)
    & sort(motor__1_1,d)
    & card(motor__1_1,int1)
    & etype(motor__1_1,int0)
    & fact(motor__1_1,real)
    & gener(motor__1_1,ge)
    & quant(motor__1_1,one)
    & refer(motor__1_1,refer_c)
    & varia(motor__1_1,varia_c)
    & sort(c12274,d)
    & card(c12274,cons(x_constant,cons(int1,nil)))
    & etype(c12274,int1)
    & fact(c12274,real)
    & gener(c12274,sp)
    & quant(c12274,mult)
    & refer(c12274,det)
    & varia(c12274,con)
    & sort(wagen_1_1,d)
    & card(wagen_1_1,int1)
    & etype(wagen_1_1,int0)
    & fact(wagen_1_1,real)
    & gener(wagen_1_1,ge)
    & quant(wagen_1_1,one)
    & refer(wagen_1_1,refer_c)
    & varia(wagen_1_1,varia_c)
    & sort(c12278,d)
    & card(c12278,cons(x_constant,cons(int1,nil)))
    & etype(c12278,int1)
    & fact(c12278,real)
    & gener(c12278,gener_c)
    & quant(c12278,mult)
    & refer(c12278,indet)
    & varia(c12278,varia_c)
    & sort(fahrer__1_1,d)
    & card(fahrer__1_1,int1)
    & etype(fahrer__1_1,int0)
    & fact(fahrer__1_1,real)
    & gener(fahrer__1_1,ge)
    & quant(fahrer__1_1,one)
    & refer(fahrer__1_1,refer_c)
    & varia(fahrer__1_1,varia_c)
    & sort(c12286,d)
    & card(c12286,int1)
    & etype(c12286,int0)
    & fact(c12286,real)
    & gener(c12286,sp)
    & quant(c12286,one)
    & refer(c12286,det)
    & varia(c12286,con)
    & sort(c12287,na)
    & card(c12287,int1)
    & etype(c12287,int0)
    & fact(c12287,real)
    & gener(c12287,sp)
    & quant(c12287,one)
    & refer(c12287,indet)
    & varia(c12287,varia_c)
    & sort(c12288,na)
    & card(c12288,int1)
    & etype(c12288,int0)
    & fact(c12288,real)
    & gener(c12288,sp)
    & quant(c12288,one)
    & refer(c12288,indet)
    & varia(c12288,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(roy_0,fe)
    & sort(salvadori_0,fe)
    & sort(c12293,d)
    & card(c12293,int1)
    & etype(c12293,int0)
    & fact(c12293,real)
    & gener(c12293,sp)
    & quant(c12293,one)
    & refer(c12293,det)
    & varia(c12293,con)
    & sort(c12294,na)
    & card(c12294,int1)
    & etype(c12294,int0)
    & fact(c12294,real)
    & gener(c12294,sp)
    & quant(c12294,one)
    & refer(c12294,indet)
    & varia(c12294,varia_c)
    & sort(c12295,na)
    & card(c12295,int1)
    & etype(c12295,int0)
    & fact(c12295,real)
    & gener(c12295,sp)
    & quant(c12295,one)
    & refer(c12295,indet)
    & varia(c12295,varia_c)
    & sort(tony_0,fe)
    & sort(crook_0,fe)
    & sort(c12297,as)
    & card(c12297,cons(x_constant,cons(int1,nil)))
    & etype(c12297,int1)
    & fact(c12297,real)
    & gener(c12297,gener_c)
    & quant(c12297,mult)
    & refer(c12297,refer_c)
    & varia(c12297,varia_c)
    & sort(erfolg__1_1,as)
    & card(erfolg__1_1,int1)
    & etype(erfolg__1_1,int0)
    & fact(erfolg__1_1,real)
    & gener(erfolg__1_1,ge)
    & quant(erfolg__1_1,one)
    & refer(erfolg__1_1,refer_c)
    & varia(erfolg__1_1,varia_c)
    & sort(achtbar_1_1,nq)
    & sort(c12300,o)
    & card(c12300,cons(x_constant,cons(int1,nil)))
    & etype(c12300,int1)
    & fact(c12300,real)
    & gener(c12300,gener_c)
    & quant(c12300,mult)
    & refer(c12300,indet)
    & varia(c12300,varia_c)
    & sort(sportwagenrennen_1_1,o)
    & card(sportwagenrennen_1_1,int1)
    & etype(sportwagenrennen_1_1,int0)
    & fact(sportwagenrennen_1_1,real)
    & gener(sportwagenrennen_1_1,ge)
    & quant(sportwagenrennen_1_1,one)
    & refer(sportwagenrennen_1_1,refer_c)
    & varia(sportwagenrennen_1_1,varia_c)
    & sort(c12390,ent)
    & card(c12390,card_c)
    & etype(c12390,etype_c)
    & fact(c12390,real)
    & gener(c12390,gener_c)
    & quant(c12390,quant_c)
    & refer(c12390,refer_c)
    & varia(c12390,varia_c)
    & sort(sport__1_1,ad)
    & card(sport__1_1,int1)
    & etype(sport__1_1,int0)
    & fact(sport__1_1,real)
    & gener(sport__1_1,ge)
    & quant(sport__1_1,one)
    & refer(sport__1_1,refer_c)
    & varia(sport__1_1,varia_c)
    & sort(wagenrennen_1_1,o)
    & card(wagenrennen_1_1,int1)
    & etype(wagenrennen_1_1,int0)
    & fact(wagenrennen_1_1,real)
    & gener(wagenrennen_1_1,ge)
    & quant(wagenrennen_1_1,one)
    & refer(wagenrennen_1_1,refer_c)
    & varia(wagenrennen_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
