%------------------------------------------------------------------------------
% File     : CSR115+88 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_wp_510_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.33 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.21 v7.5.0, 0.33 v7.4.0, 0.25 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.31 v6.2.0, 0.45 v6.1.0, 0.52 v6.0.0, 0.50 v5.5.0, 0.58 v5.4.0, 0.57 v5.3.0, 0.65 v5.2.0, 0.36 v5.0.0, 0.45 v4.1.0, 0.56 v4.0.1, 0.58 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10872 (   0 equ)
%            Maximal formula atoms :  165 (   1 avg)
%            Number of connectives :  683 (   0   ~;  18   |; 539   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  165 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-10 aty)
%            Number of functors    : 16657 (16657 usr;16656 con; 0-2 aty)
%            Number of variables   :  475 ( 405   !;  70   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_wp_510,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6] :
      ( attr(X0,X1)
      & attr(X3,X2)
      & attr(X5,X6)
      & obj(X4,X0)
      & sub(X1,name_1_1)
      & sub(X0,firma_1_1)
      & sub(X2,name_1_1)
      & val(X1,bmw_0)
      & val(X2,bmw_0) ) ).

fof(ave07_era5_synth_qa07_007_mira_wp_510,hypothesis,
    ( sub(c150,firma_1_1)
    & attr(c155,c156)
    & sub(c155,mensch_1_1)
    & sub(c156,familiename_1_1)
    & val(c156,schulz_0)
    & pred(c159,e28_1_1)
    & subs(c164,touring_1_1)
    & pred(c167,version_1_1)
    & sub(c182,e28_1_1)
    & attr(c197,c198)
    & sub(c197,firma_1_1)
    & sub(c198,name_1_1)
    & val(c198,bmw_0)
    & tupl_p10(c318,c150,c155,c159,c164,c167,c172,c164,c182,c197)
    & sort(c150,d)
    & sort(c150,io)
    & card(c150,int1)
    & etype(c150,int0)
    & fact(c150,real)
    & gener(c150,sp)
    & quant(c150,one)
    & refer(c150,det)
    & varia(c150,con)
    & sort(firma_1_1,d)
    & sort(firma_1_1,io)
    & card(firma_1_1,int1)
    & etype(firma_1_1,int0)
    & fact(firma_1_1,real)
    & gener(firma_1_1,ge)
    & quant(firma_1_1,one)
    & refer(firma_1_1,refer_c)
    & varia(firma_1_1,varia_c)
    & sort(c155,d)
    & card(c155,int1)
    & etype(c155,int0)
    & fact(c155,real)
    & gener(c155,sp)
    & quant(c155,one)
    & refer(c155,det)
    & varia(c155,con)
    & sort(c156,na)
    & card(c156,int1)
    & etype(c156,int0)
    & fact(c156,real)
    & gener(c156,sp)
    & quant(c156,one)
    & refer(c156,indet)
    & varia(c156,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(schulz_0,fe)
    & sort(c159,o)
    & card(c159,cons(x_constant,cons(int1,nil)))
    & etype(c159,int1)
    & fact(c159,real)
    & gener(c159,gener_c)
    & quant(c159,several)
    & refer(c159,refer_c)
    & varia(c159,varia_c)
    & sort(e28_1_1,o)
    & card(e28_1_1,int1)
    & etype(e28_1_1,int0)
    & fact(e28_1_1,real)
    & gener(e28_1_1,ge)
    & quant(e28_1_1,one)
    & refer(e28_1_1,refer_c)
    & varia(e28_1_1,varia_c)
    & sort(c164,ad)
    & card(c164,int1)
    & etype(c164,int0)
    & fact(c164,real)
    & gener(c164,gener_c)
    & quant(c164,one)
    & refer(c164,refer_c)
    & varia(c164,varia_c)
    & sort(touring_1_1,ad)
    & card(touring_1_1,int1)
    & etype(touring_1_1,int0)
    & fact(touring_1_1,real)
    & gener(touring_1_1,ge)
    & quant(touring_1_1,one)
    & refer(touring_1_1,refer_c)
    & varia(touring_1_1,varia_c)
    & sort(c167,d)
    & sort(c167,io)
    & card(c167,cons(x_constant,cons(int1,nil)))
    & etype(c167,int1)
    & fact(c167,real)
    & gener(c167,gener_c)
    & quant(c167,mult)
    & refer(c167,indet)
    & varia(c167,varia_c)
    & sort(version_1_1,d)
    & sort(version_1_1,io)
    & card(version_1_1,int1)
    & etype(version_1_1,int0)
    & fact(version_1_1,real)
    & gener(version_1_1,ge)
    & quant(version_1_1,one)
    & refer(version_1_1,refer_c)
    & varia(version_1_1,varia_c)
    & sort(c182,o)
    & card(c182,int1)
    & etype(c182,int0)
    & fact(c182,real)
    & gener(c182,sp)
    & quant(c182,one)
    & refer(c182,det)
    & varia(c182,con)
    & sort(c197,d)
    & sort(c197,io)
    & card(c197,int1)
    & etype(c197,int0)
    & fact(c197,real)
    & gener(c197,sp)
    & quant(c197,one)
    & refer(c197,det)
    & varia(c197,con)
    & sort(c198,na)
    & card(c198,int1)
    & etype(c198,int0)
    & fact(c198,real)
    & gener(c198,sp)
    & quant(c198,one)
    & refer(c198,indet)
    & varia(c198,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(bmw_0,fe)
    & sort(c318,ent)
    & card(c318,card_c)
    & etype(c318,etype_c)
    & fact(c318,real)
    & gener(c318,gener_c)
    & quant(c318,quant_c)
    & refer(c318,refer_c)
    & varia(c318,varia_c)
    & sort(c172,o)
    & card(c172,int1)
    & etype(c172,int0)
    & fact(c172,real)
    & gener(c172,sp)
    & quant(c172,one)
    & refer(c172,det)
    & varia(c172,varia_c) ) ).

%------------------------------------------------------------------------------
