%------------------------------------------------------------------------------
% File     : CSR115+87 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_wp_508_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.33 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.21 v7.5.0, 0.38 v7.4.0, 0.25 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.23 v6.2.0, 0.36 v6.1.0, 0.56 v6.0.0, 0.50 v5.5.0, 0.58 v5.4.0, 0.57 v5.3.0, 0.65 v5.2.0, 0.36 v5.0.0, 0.45 v4.1.0, 0.56 v4.0.1, 0.58 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10890 (   0 equ)
%            Maximal formula atoms :  183 (   1 avg)
%            Number of connectives :  701 (   0   ~;  18   |; 557   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  183 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-8 aty)
%            Number of functors    : 16658 (16658 usr;16657 con; 0-2 aty)
%            Number of variables   :  475 ( 405   !;  70   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_wp_508,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6] :
      ( attr(X0,X1)
      & attr(X3,X2)
      & attr(X5,X6)
      & obj(X4,X0)
      & sub(X1,name_1_1)
      & sub(X0,firma_1_1)
      & sub(X2,name_1_1)
      & val(X1,bmw_0)
      & val(X2,bmw_0) ) ).

fof(ave07_era5_synth_qa07_007_mira_wp_508,hypothesis,
    ( attr(c109,c110)
    & sub(c109,firma_1_1)
    & sub(c110,name_1_1)
    & val(c110,porsche_0)
    & attr(c125,c126)
    & sub(c125,firma_1_1)
    & sub(c126,name_1_1)
    & val(c126,bmw_0)
    & tupl_p8(c222,c57,c58,c68,c73,c68,c109,c125)
    & pred(c57,zasada_1_1)
    & pred(c58,fabrikat_1_1)
    & attch(c63,c58)
    & sub(c63,firma_1_1)
    & attr(c68,c69)
    & sub(c68,stadt__1_1)
    & sub(c69,name_1_1)
    & val(c69,steyr_0)
    & attr(c73,c74)
    & sub(c73,mensch_1_1)
    & sub(c74,familiename_1_1)
    & val(c74,puch_0)
    & sort(c109,d)
    & sort(c109,io)
    & card(c109,int1)
    & etype(c109,int0)
    & fact(c109,real)
    & gener(c109,sp)
    & quant(c109,one)
    & refer(c109,det)
    & varia(c109,con)
    & sort(c110,na)
    & card(c110,int1)
    & etype(c110,int0)
    & fact(c110,real)
    & gener(c110,sp)
    & quant(c110,one)
    & refer(c110,indet)
    & varia(c110,varia_c)
    & sort(firma_1_1,d)
    & sort(firma_1_1,io)
    & card(firma_1_1,int1)
    & etype(firma_1_1,int0)
    & fact(firma_1_1,real)
    & gener(firma_1_1,ge)
    & quant(firma_1_1,one)
    & refer(firma_1_1,refer_c)
    & varia(firma_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(porsche_0,fe)
    & sort(c125,d)
    & sort(c125,io)
    & card(c125,int1)
    & etype(c125,int0)
    & fact(c125,real)
    & gener(c125,sp)
    & quant(c125,one)
    & refer(c125,det)
    & varia(c125,con)
    & sort(c126,na)
    & card(c126,int1)
    & etype(c126,int0)
    & fact(c126,real)
    & gener(c126,sp)
    & quant(c126,one)
    & refer(c126,indet)
    & varia(c126,varia_c)
    & sort(bmw_0,fe)
    & sort(c222,ent)
    & card(c222,card_c)
    & etype(c222,etype_c)
    & fact(c222,real)
    & gener(c222,gener_c)
    & quant(c222,quant_c)
    & refer(c222,refer_c)
    & varia(c222,varia_c)
    & sort(c57,o)
    & card(c57,cons(x_constant,cons(int1,nil)))
    & etype(c57,int1)
    & fact(c57,real)
    & gener(c57,gener_c)
    & quant(c57,mult)
    & refer(c57,indet)
    & varia(c57,varia_c)
    & sort(c58,o)
    & card(c58,cons(x_constant,cons(int1,nil)))
    & etype(c58,int1)
    & fact(c58,real)
    & gener(c58,sp)
    & quant(c58,mult)
    & refer(c58,indet)
    & varia(c58,varia_c)
    & sort(c68,d)
    & sort(c68,io)
    & card(c68,int1)
    & etype(c68,int0)
    & fact(c68,real)
    & gener(c68,sp)
    & quant(c68,one)
    & refer(c68,det)
    & varia(c68,con)
    & sort(c73,d)
    & card(c73,int1)
    & etype(c73,int0)
    & fact(c73,real)
    & gener(c73,sp)
    & quant(c73,one)
    & refer(c73,det)
    & varia(c73,con)
    & sort(zasada_1_1,o)
    & card(zasada_1_1,int1)
    & etype(zasada_1_1,int0)
    & fact(zasada_1_1,real)
    & gener(zasada_1_1,ge)
    & quant(zasada_1_1,one)
    & refer(zasada_1_1,refer_c)
    & varia(zasada_1_1,varia_c)
    & sort(fabrikat_1_1,o)
    & card(fabrikat_1_1,int1)
    & etype(fabrikat_1_1,int0)
    & fact(fabrikat_1_1,real)
    & gener(fabrikat_1_1,ge)
    & quant(fabrikat_1_1,one)
    & refer(fabrikat_1_1,refer_c)
    & varia(fabrikat_1_1,varia_c)
    & sort(c63,d)
    & sort(c63,io)
    & card(c63,int1)
    & etype(c63,int0)
    & fact(c63,real)
    & gener(c63,sp)
    & quant(c63,one)
    & refer(c63,det)
    & varia(c63,con)
    & sort(c69,na)
    & card(c69,int1)
    & etype(c69,int0)
    & fact(c69,real)
    & gener(c69,sp)
    & quant(c69,one)
    & refer(c69,indet)
    & varia(c69,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(steyr_0,fe)
    & sort(c74,na)
    & card(c74,int1)
    & etype(c74,int0)
    & fact(c74,real)
    & gener(c74,sp)
    & quant(c74,one)
    & refer(c74,indet)
    & varia(c74,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(puch_0,fe) ) ).

%------------------------------------------------------------------------------
