%------------------------------------------------------------------------------
% File     : CSR115+86 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_wp_506_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.40 v9.0.0, 0.25 v8.2.0, 0.27 v8.1.0, 0.29 v7.5.0, 0.38 v7.4.0, 0.31 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.31 v6.2.0, 0.45 v6.1.0, 0.56 v6.0.0, 0.50 v5.4.0, 0.48 v5.3.0, 0.57 v5.2.0, 0.43 v5.0.0, 0.40 v4.1.0, 0.50 v4.0.1, 0.53 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10883 (   0 equ)
%            Maximal formula atoms :  176 (   1 avg)
%            Number of connectives :  694 (   0   ~;  18   |; 550   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  176 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-7 aty)
%            Number of functors    : 16658 (16658 usr;16657 con; 0-2 aty)
%            Number of variables   :  475 ( 405   !;  70   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_wp_506,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6] :
      ( attr(X0,X1)
      & attr(X3,X2)
      & attr(X5,X6)
      & obj(X4,X0)
      & sub(X1,name_1_1)
      & sub(X0,firma_1_1)
      & sub(X2,name_1_1)
      & val(X1,bmw_0)
      & val(X2,bmw_0) ) ).

fof(ave07_era5_synth_qa07_007_mira_wp_506,hypothesis,
    ( subr(c1561,zusammenhang_1_1)
    & sub(c1581,zweit_weltkrieg_1_1)
    & rslt(c1587,c1592)
    & subs(c1587,entwicklung_1_1)
    & prop(c1592,luftgek__374hlt_1_1)
    & sub(c1592,flugdieselmotor_1_1)
    & sub(c1598,lanova_1_1)
    & preds(c1602,verfahren_2_1)
    & attr(c1621,c1622)
    & sub(c1621,firma_1_1)
    & sub(c1622,name_1_1)
    & val(c1622,bmw_0)
    & tupl_p7(c1839,c1561,c1581,c1587,c1598,c1602,c1621)
    & assoc(flugdieselmotor_1_1,flug_1_1)
    & sub(flugdieselmotor_1_1,dieselmotor_1_1)
    & sort(c1561,as)
    & sort(c1561,re)
    & card(c1561,int1)
    & etype(c1561,int0)
    & fact(c1561,real)
    & gener(c1561,sp)
    & quant(c1561,one)
    & refer(c1561,det)
    & varia(c1561,varia_c)
    & sort(zusammenhang_1_1,as)
    & sort(zusammenhang_1_1,re)
    & card(zusammenhang_1_1,int1)
    & etype(zusammenhang_1_1,int0)
    & fact(zusammenhang_1_1,real)
    & gener(zusammenhang_1_1,ge)
    & quant(zusammenhang_1_1,one)
    & refer(zusammenhang_1_1,refer_c)
    & varia(zusammenhang_1_1,varia_c)
    & sort(c1581,ad)
    & sort(c1581,ta)
    & card(c1581,int1)
    & etype(c1581,int0)
    & fact(c1581,real)
    & gener(c1581,sp)
    & quant(c1581,one)
    & refer(c1581,det)
    & varia(c1581,con)
    & sort(zweit_weltkrieg_1_1,ad)
    & sort(zweit_weltkrieg_1_1,ta)
    & card(zweit_weltkrieg_1_1,int1)
    & etype(zweit_weltkrieg_1_1,int0)
    & fact(zweit_weltkrieg_1_1,real)
    & gener(zweit_weltkrieg_1_1,sp)
    & quant(zweit_weltkrieg_1_1,one)
    & refer(zweit_weltkrieg_1_1,det)
    & varia(zweit_weltkrieg_1_1,con)
    & sort(c1587,ad)
    & card(c1587,int1)
    & etype(c1587,int0)
    & fact(c1587,real)
    & gener(c1587,sp)
    & quant(c1587,one)
    & refer(c1587,det)
    & varia(c1587,con)
    & sort(c1592,d)
    & card(c1592,int1)
    & etype(c1592,int0)
    & fact(c1592,real)
    & gener(c1592,sp)
    & quant(c1592,one)
    & refer(c1592,indet)
    & varia(c1592,varia_c)
    & sort(entwicklung_1_1,ad)
    & card(entwicklung_1_1,int1)
    & etype(entwicklung_1_1,int0)
    & fact(entwicklung_1_1,real)
    & gener(entwicklung_1_1,ge)
    & quant(entwicklung_1_1,one)
    & refer(entwicklung_1_1,refer_c)
    & varia(entwicklung_1_1,varia_c)
    & sort(luftgek__374hlt_1_1,gq)
    & sort(flugdieselmotor_1_1,d)
    & card(flugdieselmotor_1_1,int1)
    & etype(flugdieselmotor_1_1,int0)
    & fact(flugdieselmotor_1_1,real)
    & gener(flugdieselmotor_1_1,ge)
    & quant(flugdieselmotor_1_1,one)
    & refer(flugdieselmotor_1_1,refer_c)
    & varia(flugdieselmotor_1_1,varia_c)
    & sort(c1598,o)
    & card(c1598,int1)
    & etype(c1598,int0)
    & fact(c1598,real)
    & gener(c1598,sp)
    & quant(c1598,one)
    & refer(c1598,det)
    & varia(c1598,con)
    & sort(lanova_1_1,o)
    & card(lanova_1_1,int1)
    & etype(lanova_1_1,int0)
    & fact(lanova_1_1,real)
    & gener(lanova_1_1,ge)
    & quant(lanova_1_1,one)
    & refer(lanova_1_1,refer_c)
    & varia(lanova_1_1,varia_c)
    & sort(c1602,ad)
    & card(c1602,cons(x_constant,cons(int1,nil)))
    & etype(c1602,int1)
    & fact(c1602,real)
    & gener(c1602,gener_c)
    & quant(c1602,mult)
    & refer(c1602,indet)
    & varia(c1602,varia_c)
    & sort(verfahren_2_1,ad)
    & card(verfahren_2_1,int1)
    & etype(verfahren_2_1,int0)
    & fact(verfahren_2_1,real)
    & gener(verfahren_2_1,ge)
    & quant(verfahren_2_1,one)
    & refer(verfahren_2_1,refer_c)
    & varia(verfahren_2_1,varia_c)
    & sort(c1621,d)
    & sort(c1621,io)
    & card(c1621,int1)
    & etype(c1621,int0)
    & fact(c1621,real)
    & gener(c1621,sp)
    & quant(c1621,one)
    & refer(c1621,det)
    & varia(c1621,con)
    & sort(c1622,na)
    & card(c1622,int1)
    & etype(c1622,int0)
    & fact(c1622,real)
    & gener(c1622,sp)
    & quant(c1622,one)
    & refer(c1622,indet)
    & varia(c1622,varia_c)
    & sort(firma_1_1,d)
    & sort(firma_1_1,io)
    & card(firma_1_1,int1)
    & etype(firma_1_1,int0)
    & fact(firma_1_1,real)
    & gener(firma_1_1,ge)
    & quant(firma_1_1,one)
    & refer(firma_1_1,refer_c)
    & varia(firma_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(bmw_0,fe)
    & sort(c1839,ent)
    & card(c1839,card_c)
    & etype(c1839,etype_c)
    & fact(c1839,real)
    & gener(c1839,gener_c)
    & quant(c1839,quant_c)
    & refer(c1839,refer_c)
    & varia(c1839,varia_c)
    & sort(flug_1_1,ad)
    & sort(flug_1_1,io)
    & card(flug_1_1,int1)
    & etype(flug_1_1,int0)
    & fact(flug_1_1,real)
    & gener(flug_1_1,ge)
    & quant(flug_1_1,one)
    & refer(flug_1_1,refer_c)
    & varia(flug_1_1,varia_c)
    & sort(dieselmotor_1_1,d)
    & card(dieselmotor_1_1,int1)
    & etype(dieselmotor_1_1,int0)
    & fact(dieselmotor_1_1,real)
    & gener(dieselmotor_1_1,ge)
    & quant(dieselmotor_1_1,one)
    & refer(dieselmotor_1_1,refer_c)
    & varia(dieselmotor_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
