%------------------------------------------------------------------------------
% File     : CSR115+85 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_wp_504_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.40 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.29 v7.5.0, 0.43 v7.4.0, 0.25 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.23 v6.2.0, 0.36 v6.1.0, 0.52 v6.0.0, 0.50 v5.5.0, 0.58 v5.4.0, 0.57 v5.3.0, 0.65 v5.2.0, 0.36 v5.0.0, 0.50 v4.1.0, 0.56 v4.0.1, 0.63 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10935 (   0 equ)
%            Maximal formula atoms :  227 (   1 avg)
%            Number of connectives :  746 (   0   ~;  18   |; 602   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  227 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-12 aty)
%            Number of functors    : 16663 (16663 usr;16662 con; 0-2 aty)
%            Number of variables   :  475 ( 405   !;  70   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_wp_504,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6] :
      ( attr(X0,X1)
      & attr(X3,X2)
      & attr(X5,X6)
      & obj(X4,X0)
      & sub(X1,name_1_1)
      & sub(X0,firma_1_1)
      & sub(X2,name_1_1)
      & sub(X6,jahr__1_1)
      & val(X1,bmw_0)
      & val(X2,bmw_0) ) ).

fof(ave07_era5_synth_qa07_007_mira_wp_504,hypothesis,
    ( sub(c2174,lizenz__1_1)
    & attr(c2181,c2182)
    & sub(c2181,mensch_1_1)
    & sub(c2182,familiename_1_1)
    & val(c2182,frazer_0)
    & attr(c2186,c2187)
    & sub(c2186,mensch_1_1)
    & sub(c2187,familiename_1_1)
    & val(c2187,nash_0)
    & sub(c2196,firma_1_1)
    & attr(c2204,c2205)
    & sub(c2205,jahr__1_1)
    & val(c2205,c2201)
    & attr(c2212,c2213)
    & sub(c2212,firma_1_1)
    & sub(c2213,name_1_1)
    & val(c2213,bmw_0)
    & pred(c2214,motor__1_1)
    & tupl_p12(c2326,c948,c954,c2169,c954,c2174,c2181,c2186,c2196,c2204,c2212,c2214)
    & sub(c948,brite_1_1)
    & sub(c954,wagen_1_1)
    & sort(c2174,d)
    & sort(c2174,io)
    & card(c2174,int1)
    & etype(c2174,int0)
    & fact(c2174,real)
    & gener(c2174,gener_c)
    & quant(c2174,one)
    & refer(c2174,refer_c)
    & varia(c2174,varia_c)
    & sort(lizenz__1_1,d)
    & sort(lizenz__1_1,io)
    & card(lizenz__1_1,int1)
    & etype(lizenz__1_1,int0)
    & fact(lizenz__1_1,real)
    & gener(lizenz__1_1,ge)
    & quant(lizenz__1_1,one)
    & refer(lizenz__1_1,refer_c)
    & varia(lizenz__1_1,varia_c)
    & sort(c2181,d)
    & card(c2181,int1)
    & etype(c2181,int0)
    & fact(c2181,real)
    & gener(c2181,sp)
    & quant(c2181,one)
    & refer(c2181,det)
    & varia(c2181,con)
    & sort(c2182,na)
    & card(c2182,int1)
    & etype(c2182,int0)
    & fact(c2182,real)
    & gener(c2182,sp)
    & quant(c2182,one)
    & refer(c2182,indet)
    & varia(c2182,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(frazer_0,fe)
    & sort(c2186,d)
    & card(c2186,int1)
    & etype(c2186,int0)
    & fact(c2186,real)
    & gener(c2186,sp)
    & quant(c2186,one)
    & refer(c2186,det)
    & varia(c2186,con)
    & sort(c2187,na)
    & card(c2187,int1)
    & etype(c2187,int0)
    & fact(c2187,real)
    & gener(c2187,sp)
    & quant(c2187,one)
    & refer(c2187,indet)
    & varia(c2187,varia_c)
    & sort(nash_0,fe)
    & sort(c2196,d)
    & sort(c2196,io)
    & card(c2196,int1)
    & etype(c2196,int0)
    & fact(c2196,real)
    & gener(c2196,sp)
    & quant(c2196,one)
    & refer(c2196,det)
    & varia(c2196,varia_c)
    & sort(firma_1_1,d)
    & sort(firma_1_1,io)
    & card(firma_1_1,int1)
    & etype(firma_1_1,int0)
    & fact(firma_1_1,real)
    & gener(firma_1_1,ge)
    & quant(firma_1_1,one)
    & refer(firma_1_1,refer_c)
    & varia(firma_1_1,varia_c)
    & sort(c2204,t)
    & card(c2204,int1)
    & etype(c2204,int0)
    & fact(c2204,real)
    & gener(c2204,sp)
    & quant(c2204,one)
    & refer(c2204,det)
    & varia(c2204,con)
    & sort(c2205,me)
    & sort(c2205,oa)
    & sort(c2205,ta)
    & card(c2205,card_c)
    & etype(c2205,etype_c)
    & fact(c2205,real)
    & gener(c2205,sp)
    & quant(c2205,quant_c)
    & refer(c2205,refer_c)
    & varia(c2205,varia_c)
    & sort(jahr__1_1,me)
    & sort(jahr__1_1,oa)
    & sort(jahr__1_1,ta)
    & card(jahr__1_1,card_c)
    & etype(jahr__1_1,etype_c)
    & fact(jahr__1_1,real)
    & gener(jahr__1_1,ge)
    & quant(jahr__1_1,quant_c)
    & refer(jahr__1_1,refer_c)
    & varia(jahr__1_1,varia_c)
    & sort(c2201,nu)
    & card(c2201,int1934)
    & sort(c2212,d)
    & sort(c2212,io)
    & card(c2212,int1)
    & etype(c2212,int0)
    & fact(c2212,real)
    & gener(c2212,sp)
    & quant(c2212,one)
    & refer(c2212,det)
    & varia(c2212,con)
    & sort(c2213,na)
    & card(c2213,int1)
    & etype(c2213,int0)
    & fact(c2213,real)
    & gener(c2213,sp)
    & quant(c2213,one)
    & refer(c2213,indet)
    & varia(c2213,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(bmw_0,fe)
    & sort(c2214,d)
    & card(c2214,cons(x_constant,cons(int1,nil)))
    & etype(c2214,int1)
    & fact(c2214,real)
    & gener(c2214,gener_c)
    & quant(c2214,mult)
    & refer(c2214,indet)
    & varia(c2214,varia_c)
    & sort(motor__1_1,d)
    & card(motor__1_1,int1)
    & etype(motor__1_1,int0)
    & fact(motor__1_1,real)
    & gener(motor__1_1,ge)
    & quant(motor__1_1,one)
    & refer(motor__1_1,refer_c)
    & varia(motor__1_1,varia_c)
    & sort(c2326,ent)
    & card(c2326,card_c)
    & etype(c2326,etype_c)
    & fact(c2326,real)
    & gener(c2326,gener_c)
    & quant(c2326,quant_c)
    & refer(c2326,refer_c)
    & varia(c2326,varia_c)
    & sort(c948,d)
    & card(c948,int1)
    & etype(c948,int0)
    & fact(c948,real)
    & gener(c948,sp)
    & quant(c948,one)
    & refer(c948,det)
    & varia(c948,con)
    & sort(c954,o)
    & card(c954,int1)
    & etype(c954,int0)
    & fact(c954,real)
    & gener(c954,sp)
    & quant(c954,one)
    & refer(c954,det)
    & varia(c954,varia_c)
    & sort(c2169,o)
    & card(c2169,int1)
    & etype(c2169,int0)
    & fact(c2169,real)
    & gener(c2169,sp)
    & quant(c2169,one)
    & refer(c2169,det)
    & varia(c2169,varia_c)
    & sort(brite_1_1,d)
    & card(brite_1_1,int1)
    & etype(brite_1_1,int0)
    & fact(brite_1_1,real)
    & gener(brite_1_1,ge)
    & quant(brite_1_1,one)
    & refer(brite_1_1,refer_c)
    & varia(brite_1_1,varia_c)
    & sort(wagen_1_1,d)
    & card(wagen_1_1,int1)
    & etype(wagen_1_1,int0)
    & fact(wagen_1_1,real)
    & gener(wagen_1_1,ge)
    & quant(wagen_1_1,one)
    & refer(wagen_1_1,refer_c)
    & varia(wagen_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
