%------------------------------------------------------------------------------
% File     : CSR115+82 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_wp_495_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.40 v9.0.0, 0.25 v8.2.0, 0.27 v8.1.0, 0.29 v7.5.0, 0.33 v7.4.0, 0.25 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.23 v6.2.0, 0.36 v6.1.0, 0.44 v6.0.0, 0.50 v5.5.0, 0.46 v5.4.0, 0.43 v5.3.0, 0.48 v5.2.0, 0.36 v5.0.0, 0.35 v4.1.0, 0.39 v4.0.1, 0.37 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10804 (   0 equ)
%            Maximal formula atoms :  101 (   1 avg)
%            Number of connectives :  615 (   0   ~;  18   |; 471   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  101 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   86 (  86 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16648 (16648 usr;16647 con; 0-2 aty)
%            Number of variables   :  474 ( 405   !;  69   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_wp_495,conjecture,
    ? [X0,X1,X2,X3,X4,X5] :
      ( attr(X0,X1)
      & attr(X3,X2)
      & attr(X4,X5)
      & sub(X1,name_1_1)
      & sub(X2,name_1_1) ) ).

fof(ave07_era5_synth_qa07_007_mira_wp_495,hypothesis,
    ( attr(c341,c342)
    & sub(c341,mensch_1_1)
    & sub(c342,familiename_1_1)
    & val(c342,marzocchi_0)
    & name(c358,freeride_____344ra_0)
    & sub(c362,mountain_bike_1_1)
    & sub(c364,bereich_1_1)
    & benf(c368,c364)
    & exp(c368,c341)
    & loc(c368,c373)
    & mcont(c368,c358)
    & subs(c368,einl__344uten_1_1)
    & in(c373,c362)
    & sort(c341,d)
    & card(c341,int1)
    & etype(c341,int0)
    & fact(c341,real)
    & gener(c341,sp)
    & quant(c341,one)
    & refer(c341,det)
    & varia(c341,con)
    & sort(c342,na)
    & card(c342,int1)
    & etype(c342,int0)
    & fact(c342,real)
    & gener(c342,sp)
    & quant(c342,one)
    & refer(c342,indet)
    & varia(c342,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(marzocchi_0,fe)
    & sort(c358,o)
    & card(c358,int1)
    & etype(c358,int0)
    & fact(c358,hypo)
    & gener(c358,sp)
    & quant(c358,one)
    & refer(c358,refer_c)
    & varia(c358,varia_c)
    & sort(freeride_____344ra_0,fe)
    & sort(c362,d)
    & card(c362,int1)
    & etype(c362,int0)
    & fact(c362,real)
    & gener(c362,sp)
    & quant(c362,one)
    & refer(c362,det)
    & varia(c362,con)
    & sort(mountain_bike_1_1,d)
    & card(mountain_bike_1_1,int1)
    & etype(mountain_bike_1_1,int0)
    & fact(mountain_bike_1_1,real)
    & gener(mountain_bike_1_1,ge)
    & quant(mountain_bike_1_1,one)
    & refer(mountain_bike_1_1,refer_c)
    & varia(mountain_bike_1_1,varia_c)
    & sort(c364,d)
    & card(c364,int1)
    & etype(c364,int0)
    & fact(c364,real)
    & gener(c364,sp)
    & quant(c364,one)
    & refer(c364,refer_c)
    & varia(c364,varia_c)
    & sort(bereich_1_1,d)
    & card(bereich_1_1,int1)
    & etype(bereich_1_1,int0)
    & fact(bereich_1_1,real)
    & gener(bereich_1_1,ge)
    & quant(bereich_1_1,one)
    & refer(bereich_1_1,refer_c)
    & varia(bereich_1_1,varia_c)
    & sort(c368,dn)
    & fact(c368,real)
    & gener(c368,sp)
    & sort(c373,l)
    & card(c373,int1)
    & etype(c373,int0)
    & fact(c373,real)
    & gener(c373,sp)
    & quant(c373,one)
    & refer(c373,det)
    & varia(c373,con)
    & sort(einl__344uten_1_1,dn)
    & fact(einl__344uten_1_1,real)
    & gener(einl__344uten_1_1,ge) ) ).

%------------------------------------------------------------------------------
