%------------------------------------------------------------------------------
% File     : CSR115+80 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_wp_490_a462_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.47 v9.0.0, 0.25 v8.2.0, 0.27 v8.1.0, 0.29 v7.5.0, 0.38 v7.4.0, 0.31 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.31 v6.2.0, 0.45 v6.1.0, 0.48 v6.0.0, 0.50 v5.4.0, 0.48 v5.3.0, 0.57 v5.2.0, 0.43 v5.0.0, 0.40 v4.1.0, 0.50 v4.0.1, 0.53 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10880 (   0 equ)
%            Maximal formula atoms :  175 (   1 avg)
%            Number of connectives :  691 (   0   ~;  18   |; 547   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  175 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-9 aty)
%            Number of functors    : 16659 (16659 usr;16658 con; 0-2 aty)
%            Number of variables   :  475 ( 405   !;  70   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_wp_490_a462,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6] :
      ( attr(X0,X1)
      & attr(X3,X2)
      & attr(X5,X6)
      & obj(X4,X0)
      & sub(X1,name_1_1)
      & sub(X0,firma_1_1)
      & sub(X2,name_1_1) ) ).

fof(ave07_era5_synth_qa07_007_mira_wp_490_a462,hypothesis,
    ( sub(c36629,firma_1_1)
    & sub(c36633,linde_1_1)
    & pred(c36646,gas__1_1)
    & prop(c36646,technisch__1_1)
    & sub(c36652,teil_1_1)
    & sub(c36657,bmw_1_1)
    & pred(c36709,kabelbaum_1_1)
    & attr(c36711,c36712)
    & sub(c36711,firma_1_1)
    & sub(c36712,name_1_1)
    & val(c36712,audi_0)
    & sub(c36719,timi_1_1)
    & tupl_p9(c36870,c36629,c36633,c36646,c36652,c36657,c36711,c36709,c36719)
    & assoc(kabelbaum_1_1,kabeln_1_1)
    & sub(kabelbaum_1_1,baum_1_1)
    & sort(c36629,d)
    & sort(c36629,io)
    & card(c36629,int1)
    & etype(c36629,int0)
    & fact(c36629,real)
    & gener(c36629,sp)
    & quant(c36629,one)
    & refer(c36629,det)
    & varia(c36629,con)
    & sort(firma_1_1,d)
    & sort(firma_1_1,io)
    & card(firma_1_1,int1)
    & etype(firma_1_1,int0)
    & fact(firma_1_1,real)
    & gener(firma_1_1,ge)
    & quant(firma_1_1,one)
    & refer(firma_1_1,refer_c)
    & varia(firma_1_1,varia_c)
    & sort(c36633,d)
    & card(c36633,int1)
    & etype(c36633,int0)
    & fact(c36633,real)
    & gener(c36633,gener_c)
    & quant(c36633,one)
    & refer(c36633,refer_c)
    & varia(c36633,varia_c)
    & sort(linde_1_1,d)
    & card(linde_1_1,int1)
    & etype(linde_1_1,int0)
    & fact(linde_1_1,real)
    & gener(linde_1_1,ge)
    & quant(linde_1_1,one)
    & refer(linde_1_1,refer_c)
    & varia(linde_1_1,varia_c)
    & sort(c36646,s)
    & card(c36646,cons(x_constant,cons(int1,nil)))
    & etype(c36646,int1)
    & fact(c36646,real)
    & gener(c36646,gener_c)
    & quant(c36646,mult)
    & refer(c36646,refer_c)
    & varia(c36646,varia_c)
    & sort(gas__1_1,s)
    & card(gas__1_1,int1)
    & etype(gas__1_1,int0)
    & fact(gas__1_1,real)
    & gener(gas__1_1,ge)
    & quant(gas__1_1,one)
    & refer(gas__1_1,refer_c)
    & varia(gas__1_1,varia_c)
    & sort(technisch__1_1,nq)
    & sort(c36652,co)
    & card(c36652,card_c)
    & etype(c36652,etype_c)
    & fact(c36652,real)
    & gener(c36652,sp)
    & quant(c36652,quant_c)
    & refer(c36652,indet)
    & varia(c36652,varia_c)
    & sort(teil_1_1,co)
    & card(teil_1_1,card_c)
    & etype(teil_1_1,etype_c)
    & fact(teil_1_1,real)
    & gener(teil_1_1,ge)
    & quant(teil_1_1,quant_c)
    & refer(teil_1_1,refer_c)
    & varia(teil_1_1,varia_c)
    & sort(c36657,d)
    & card(c36657,int1)
    & etype(c36657,int0)
    & fact(c36657,real)
    & gener(c36657,sp)
    & quant(c36657,one)
    & refer(c36657,det)
    & varia(c36657,con)
    & sort(bmw_1_1,d)
    & card(bmw_1_1,int1)
    & etype(bmw_1_1,int0)
    & fact(bmw_1_1,real)
    & gener(bmw_1_1,ge)
    & quant(bmw_1_1,one)
    & refer(bmw_1_1,refer_c)
    & varia(bmw_1_1,varia_c)
    & sort(c36709,d)
    & card(c36709,cons(x_constant,cons(int1,nil)))
    & etype(c36709,int1)
    & fact(c36709,real)
    & gener(c36709,gener_c)
    & quant(c36709,mult)
    & refer(c36709,indet)
    & varia(c36709,varia_c)
    & sort(kabelbaum_1_1,d)
    & card(kabelbaum_1_1,int1)
    & etype(kabelbaum_1_1,int0)
    & fact(kabelbaum_1_1,real)
    & gener(kabelbaum_1_1,ge)
    & quant(kabelbaum_1_1,one)
    & refer(kabelbaum_1_1,refer_c)
    & varia(kabelbaum_1_1,varia_c)
    & sort(c36711,d)
    & sort(c36711,io)
    & card(c36711,int1)
    & etype(c36711,int0)
    & fact(c36711,real)
    & gener(c36711,sp)
    & quant(c36711,one)
    & refer(c36711,det)
    & varia(c36711,con)
    & sort(c36712,na)
    & card(c36712,int1)
    & etype(c36712,int0)
    & fact(c36712,real)
    & gener(c36712,sp)
    & quant(c36712,one)
    & refer(c36712,indet)
    & varia(c36712,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(audi_0,fe)
    & sort(c36719,o)
    & card(c36719,int1)
    & etype(c36719,int0)
    & fact(c36719,real)
    & gener(c36719,gener_c)
    & quant(c36719,one)
    & refer(c36719,refer_c)
    & varia(c36719,varia_c)
    & sort(timi_1_1,o)
    & card(timi_1_1,int1)
    & etype(timi_1_1,int0)
    & fact(timi_1_1,real)
    & gener(timi_1_1,ge)
    & quant(timi_1_1,one)
    & refer(timi_1_1,refer_c)
    & varia(timi_1_1,varia_c)
    & sort(c36870,ent)
    & card(c36870,card_c)
    & etype(c36870,etype_c)
    & fact(c36870,real)
    & gener(c36870,gener_c)
    & quant(c36870,quant_c)
    & refer(c36870,refer_c)
    & varia(c36870,varia_c)
    & sort(kabeln_1_1,dn)
    & fact(kabeln_1_1,real)
    & gener(kabeln_1_1,ge)
    & sort(baum_1_1,d)
    & card(baum_1_1,int1)
    & etype(baum_1_1,int0)
    & fact(baum_1_1,real)
    & gener(baum_1_1,ge)
    & quant(baum_1_1,one)
    & refer(baum_1_1,refer_c)
    & varia(baum_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
