%------------------------------------------------------------------------------
% File     : CSR115+8 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_news_1099_a19984_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.40 v9.1.0, 0.47 v9.0.0, 0.25 v8.2.0, 0.27 v8.1.0, 0.36 v7.5.0, 0.48 v7.4.0, 0.25 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.36 v6.4.0, 0.29 v6.3.0, 0.31 v6.2.0, 0.45 v6.1.0, 0.56 v6.0.0, 0.50 v5.5.0, 0.62 v5.4.0, 0.61 v5.3.0, 0.74 v5.2.0, 0.50 v4.1.0, 0.61 v4.0.1, 0.63 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10966 (   0 equ)
%            Maximal formula atoms :  259 (   1 avg)
%            Number of connectives :  777 (   0   ~;  18   |; 633   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  259 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   90 (  90 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16667 (16667 usr;16666 con; 0-2 aty)
%            Number of variables   :  474 ( 405   !;  69   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_news_1099_a19984,conjecture,
    ? [X0,X1,X2,X3,X4,X5] :
      ( agt(X3,X2)
      & attr(X2,X1)
      & attr(X4,X5)
      & obj(X3,X0)
      & prop(X0,britisch__1_1)
      & sub(X0,firma_1_1)
      & sub(X1,name_1_1)
      & subs(X3,n374bernehmen_1_1)
      & val(X1,bmw_0) ) ).

fof(ave07_era5_synth_qa07_007_mira_news_1099_a19984,hypothesis,
    ( assoc(autobauer_1_1,auto__1_1)
    & sub(autobauer_1_1,fabrikant_1_1)
    & assoc(autokonzern_1_1,auto__1_1)
    & sub(autokonzern_1_1,firmengruppe_1_1)
    & attr(c1724,c1725)
    & poss(c1724,c2008)
    & prop(c1724,japanisch__1_1)
    & sub(c1724,autokonzern_1_1)
    & sub(c1725,name_1_1)
    & val(c1725,honda_0)
    & agt(c1730,c2006)
    & ante(c1730,c2016)
    & obj(c1730,c1912)
    & subs(c1730,annahme_1_1)
    & attr(c18,c19)
    & sub(c18,stadt__1_1)
    & sub(c19,name_1_1)
    & val(c19,tokio_0)
    & attr(c1912,c1913)
    & prop(c1912,britisch__1_1)
    & sub(c1912,firma_1_1)
    & sub(c1913,name_1_1)
    & val(c1913,rover_0)
    & attr(c2006,c2007)
    & prop(c2006,bundesdeutsch_1_1)
    & sub(c2006,autobauer_1_1)
    & sub(c2007,name_1_1)
    & val(c2007,bmw_0)
    & attch(c2008,c2036)
    & sub(c2008,anteil_1_1)
    & agt(c2016,c1724)
    & modl(c2016,wollen_0)
    & obj(c2016,c2008)
    & subs(c2016,abziehen_1_2)
    & quant_p3(c2036,c2013,hundertstel__1_1)
    & sub(c21,feb_1_1)
    & tupl(c34,c18,c21)
    & sort(autobauer_1_1,d)
    & sort(autobauer_1_1,io)
    & card(autobauer_1_1,int1)
    & etype(autobauer_1_1,int0)
    & fact(autobauer_1_1,real)
    & gener(autobauer_1_1,ge)
    & quant(autobauer_1_1,one)
    & refer(autobauer_1_1,refer_c)
    & varia(autobauer_1_1,varia_c)
    & sort(auto__1_1,d)
    & card(auto__1_1,int1)
    & etype(auto__1_1,int0)
    & fact(auto__1_1,real)
    & gener(auto__1_1,ge)
    & quant(auto__1_1,one)
    & refer(auto__1_1,refer_c)
    & varia(auto__1_1,varia_c)
    & sort(fabrikant_1_1,d)
    & sort(fabrikant_1_1,io)
    & card(fabrikant_1_1,int1)
    & etype(fabrikant_1_1,int0)
    & fact(fabrikant_1_1,real)
    & gener(fabrikant_1_1,ge)
    & quant(fabrikant_1_1,one)
    & refer(fabrikant_1_1,refer_c)
    & varia(fabrikant_1_1,varia_c)
    & sort(autokonzern_1_1,d)
    & sort(autokonzern_1_1,io)
    & card(autokonzern_1_1,int1)
    & etype(autokonzern_1_1,int0)
    & fact(autokonzern_1_1,real)
    & gener(autokonzern_1_1,ge)
    & quant(autokonzern_1_1,one)
    & refer(autokonzern_1_1,refer_c)
    & varia(autokonzern_1_1,varia_c)
    & sort(firmengruppe_1_1,d)
    & sort(firmengruppe_1_1,io)
    & card(firmengruppe_1_1,int1)
    & etype(firmengruppe_1_1,int0)
    & fact(firmengruppe_1_1,real)
    & gener(firmengruppe_1_1,ge)
    & quant(firmengruppe_1_1,one)
    & refer(firmengruppe_1_1,refer_c)
    & varia(firmengruppe_1_1,varia_c)
    & sort(c1724,d)
    & sort(c1724,io)
    & card(c1724,int1)
    & etype(c1724,int0)
    & fact(c1724,real)
    & gener(c1724,sp)
    & quant(c1724,one)
    & refer(c1724,det)
    & varia(c1724,con)
    & sort(c1725,na)
    & card(c1725,int1)
    & etype(c1725,int0)
    & fact(c1725,real)
    & gener(c1725,sp)
    & quant(c1725,one)
    & refer(c1725,indet)
    & varia(c1725,varia_c)
    & sort(c2008,co)
    & card(c2008,card_c)
    & etype(c2008,etype_c)
    & fact(c2008,real)
    & gener(c2008,sp)
    & quant(c2008,quant_c)
    & refer(c2008,det)
    & varia(c2008,varia_c)
    & sort(japanisch__1_1,nq)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(honda_0,fe)
    & sort(c1730,ad)
    & card(c1730,int1)
    & etype(c1730,int0)
    & fact(c1730,real)
    & gener(c1730,sp)
    & quant(c1730,one)
    & refer(c1730,det)
    & varia(c1730,con)
    & sort(c2006,d)
    & sort(c2006,io)
    & card(c2006,int1)
    & etype(c2006,int0)
    & fact(c2006,real)
    & gener(c2006,sp)
    & quant(c2006,one)
    & refer(c2006,det)
    & varia(c2006,con)
    & sort(c2016,da)
    & fact(c2016,real)
    & gener(c2016,sp)
    & sort(c1912,d)
    & sort(c1912,io)
    & card(c1912,int1)
    & etype(c1912,int0)
    & fact(c1912,real)
    & gener(c1912,sp)
    & quant(c1912,one)
    & refer(c1912,det)
    & varia(c1912,con)
    & sort(annahme_1_1,ad)
    & card(annahme_1_1,int1)
    & etype(annahme_1_1,int0)
    & fact(annahme_1_1,real)
    & gener(annahme_1_1,ge)
    & quant(annahme_1_1,one)
    & refer(annahme_1_1,refer_c)
    & varia(annahme_1_1,varia_c)
    & sort(c18,d)
    & sort(c18,io)
    & card(c18,int1)
    & etype(c18,int0)
    & fact(c18,real)
    & gener(c18,sp)
    & quant(c18,one)
    & refer(c18,det)
    & varia(c18,con)
    & sort(c19,na)
    & card(c19,int1)
    & etype(c19,int0)
    & fact(c19,real)
    & gener(c19,sp)
    & quant(c19,one)
    & refer(c19,indet)
    & varia(c19,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(tokio_0,fe)
    & sort(c1913,na)
    & card(c1913,int1)
    & etype(c1913,int0)
    & fact(c1913,real)
    & gener(c1913,sp)
    & quant(c1913,one)
    & refer(c1913,indet)
    & varia(c1913,varia_c)
    & sort(britisch__1_1,nq)
    & sort(firma_1_1,d)
    & sort(firma_1_1,io)
    & card(firma_1_1,int1)
    & etype(firma_1_1,int0)
    & fact(firma_1_1,real)
    & gener(firma_1_1,ge)
    & quant(firma_1_1,one)
    & refer(firma_1_1,refer_c)
    & varia(firma_1_1,varia_c)
    & sort(rover_0,fe)
    & sort(c2007,na)
    & card(c2007,int1)
    & etype(c2007,int0)
    & fact(c2007,real)
    & gener(c2007,sp)
    & quant(c2007,one)
    & refer(c2007,indet)
    & varia(c2007,varia_c)
    & sort(bundesdeutsch_1_1,tq)
    & sort(bmw_0,fe)
    & sort(c2036,co)
    & card(c2036,card_c)
    & etype(c2036,etype_c)
    & fact(c2036,real)
    & gener(c2036,gener_c)
    & quant(c2036,quant_c)
    & refer(c2036,refer_c)
    & varia(c2036,con)
    & sort(anteil_1_1,co)
    & card(anteil_1_1,card_c)
    & etype(anteil_1_1,etype_c)
    & fact(anteil_1_1,real)
    & gener(anteil_1_1,ge)
    & quant(anteil_1_1,quant_c)
    & refer(anteil_1_1,refer_c)
    & varia(anteil_1_1,varia_c)
    & sort(wollen_0,md)
    & fact(wollen_0,real)
    & gener(wollen_0,gener_c)
    & sort(abziehen_1_2,da)
    & fact(abziehen_1_2,real)
    & gener(abziehen_1_2,ge)
    & sort(c2013,nu)
    & card(c2013,int20)
    & sort(hundertstel__1_1,me)
    & gener(hundertstel__1_1,ge)
    & sort(c21,o)
    & card(c21,int1)
    & etype(c21,int0)
    & fact(c21,real)
    & gener(c21,gener_c)
    & quant(c21,one)
    & refer(c21,refer_c)
    & varia(c21,varia_c)
    & sort(feb_1_1,o)
    & card(feb_1_1,int1)
    & etype(feb_1_1,int0)
    & fact(feb_1_1,real)
    & gener(feb_1_1,ge)
    & quant(feb_1_1,one)
    & refer(feb_1_1,refer_c)
    & varia(feb_1_1,varia_c)
    & sort(c34,ent)
    & card(c34,card_c)
    & etype(c34,etype_c)
    & fact(c34,real)
    & gener(c34,gener_c)
    & quant(c34,quant_c)
    & refer(c34,refer_c)
    & varia(c34,varia_c) ) ).

%------------------------------------------------------------------------------
