%------------------------------------------------------------------------------
% File     : CSR115+77 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_wp_487_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.40 v9.0.0, 0.25 v8.2.0, 0.27 v8.1.0, 0.29 v7.5.0, 0.38 v7.4.0, 0.31 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.31 v6.2.0, 0.45 v6.1.0, 0.56 v6.0.0, 0.50 v5.5.0, 0.54 v5.4.0, 0.52 v5.3.0, 0.61 v5.2.0, 0.43 v5.0.0, 0.45 v4.1.0, 0.50 v4.0.1, 0.53 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10861 (   0 equ)
%            Maximal formula atoms :  154 (   1 avg)
%            Number of connectives :  672 (   0   ~;  18   |; 528   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  154 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-6 aty)
%            Number of functors    : 16655 (16655 usr;16654 con; 0-2 aty)
%            Number of variables   :  475 ( 405   !;  70   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_wp_487,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6] :
      ( attr(X0,X1)
      & attr(X3,X2)
      & attr(X5,X6)
      & obj(X4,X0)
      & sub(X1,name_1_1)
      & sub(X0,firma_1_1)
      & sub(X2,name_1_1)
      & val(X1,bmw_0)
      & val(X2,bmw_0) ) ).

fof(ave07_era5_synth_qa07_007_mira_wp_487,hypothesis,
    ( sub(c4679,computersystem_1_1)
    & attr(c4782,c4783)
    & sub(c4782,firma_1_1)
    & sub(c4783,name_1_1)
    & val(c4783,bmw_0)
    & sub(c4788,leistung_1_1)
    & attch(c4792,c4788)
    & pred(c4792,motor__1_1)
    & preds(c4809,emission_1_1)
    & pred(c4812,luftschadstoff_1_1)
    & tupl_p6(c5051,c4679,c4782,c4788,c4809,c4812)
    & assoc(luftschadstoff_1_1,luft__1_1)
    & sub(luftschadstoff_1_1,schadstoff_1_1)
    & sort(c4679,io)
    & card(c4679,int1)
    & etype(c4679,int0)
    & fact(c4679,real)
    & gener(c4679,sp)
    & quant(c4679,one)
    & refer(c4679,det)
    & varia(c4679,varia_c)
    & sort(computersystem_1_1,io)
    & card(computersystem_1_1,int1)
    & etype(computersystem_1_1,int0)
    & fact(computersystem_1_1,real)
    & gener(computersystem_1_1,ge)
    & quant(computersystem_1_1,one)
    & refer(computersystem_1_1,refer_c)
    & varia(computersystem_1_1,varia_c)
    & sort(c4782,d)
    & sort(c4782,io)
    & card(c4782,int1)
    & etype(c4782,int0)
    & fact(c4782,real)
    & gener(c4782,sp)
    & quant(c4782,one)
    & refer(c4782,det)
    & varia(c4782,con)
    & sort(c4783,na)
    & card(c4783,int1)
    & etype(c4783,int0)
    & fact(c4783,real)
    & gener(c4783,sp)
    & quant(c4783,one)
    & refer(c4783,indet)
    & varia(c4783,varia_c)
    & sort(firma_1_1,d)
    & sort(firma_1_1,io)
    & card(firma_1_1,int1)
    & etype(firma_1_1,int0)
    & fact(firma_1_1,real)
    & gener(firma_1_1,ge)
    & quant(firma_1_1,one)
    & refer(firma_1_1,refer_c)
    & varia(firma_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(bmw_0,fe)
    & sort(c4788,ad)
    & sort(c4788,io)
    & card(c4788,int1)
    & etype(c4788,int0)
    & fact(c4788,real)
    & gener(c4788,sp)
    & quant(c4788,one)
    & refer(c4788,det)
    & varia(c4788,con)
    & sort(leistung_1_1,ad)
    & sort(leistung_1_1,io)
    & card(leistung_1_1,int1)
    & etype(leistung_1_1,int0)
    & fact(leistung_1_1,real)
    & gener(leistung_1_1,ge)
    & quant(leistung_1_1,one)
    & refer(leistung_1_1,refer_c)
    & varia(leistung_1_1,varia_c)
    & sort(c4792,d)
    & card(c4792,cons(x_constant,cons(int1,nil)))
    & etype(c4792,int1)
    & fact(c4792,real)
    & gener(c4792,sp)
    & quant(c4792,mult)
    & refer(c4792,det)
    & varia(c4792,con)
    & sort(motor__1_1,d)
    & card(motor__1_1,int1)
    & etype(motor__1_1,int0)
    & fact(motor__1_1,real)
    & gener(motor__1_1,ge)
    & quant(motor__1_1,one)
    & refer(motor__1_1,refer_c)
    & varia(motor__1_1,varia_c)
    & sort(c4809,ad)
    & card(c4809,cons(x_constant,cons(int1,nil)))
    & etype(c4809,int1)
    & fact(c4809,real)
    & gener(c4809,sp)
    & quant(c4809,mult)
    & refer(c4809,det)
    & varia(c4809,con)
    & sort(emission_1_1,ad)
    & card(emission_1_1,int1)
    & etype(emission_1_1,int0)
    & fact(emission_1_1,real)
    & gener(emission_1_1,ge)
    & quant(emission_1_1,one)
    & refer(emission_1_1,refer_c)
    & varia(emission_1_1,varia_c)
    & sort(c4812,o)
    & card(c4812,cons(x_constant,cons(int1,nil)))
    & etype(c4812,int1)
    & fact(c4812,real)
    & gener(c4812,gener_c)
    & quant(c4812,mult)
    & refer(c4812,indet)
    & varia(c4812,varia_c)
    & sort(luftschadstoff_1_1,o)
    & card(luftschadstoff_1_1,int1)
    & etype(luftschadstoff_1_1,int0)
    & fact(luftschadstoff_1_1,real)
    & gener(luftschadstoff_1_1,ge)
    & quant(luftschadstoff_1_1,one)
    & refer(luftschadstoff_1_1,refer_c)
    & varia(luftschadstoff_1_1,varia_c)
    & sort(c5051,ent)
    & card(c5051,card_c)
    & etype(c5051,etype_c)
    & fact(c5051,real)
    & gener(c5051,gener_c)
    & quant(c5051,quant_c)
    & refer(c5051,refer_c)
    & varia(c5051,varia_c)
    & sort(luft__1_1,s)
    & card(luft__1_1,int1)
    & etype(luft__1_1,int0)
    & fact(luft__1_1,real)
    & gener(luft__1_1,ge)
    & quant(luft__1_1,one)
    & refer(luft__1_1,refer_c)
    & varia(luft__1_1,varia_c)
    & sort(schadstoff_1_1,s)
    & card(schadstoff_1_1,int1)
    & etype(schadstoff_1_1,int0)
    & fact(schadstoff_1_1,real)
    & gener(schadstoff_1_1,ge)
    & quant(schadstoff_1_1,one)
    & refer(schadstoff_1_1,refer_c)
    & varia(schadstoff_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
