%------------------------------------------------------------------------------
% File     : CSR115+76 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_wp_486_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.25 v9.1.0, 0.20 v9.0.0, 0.19 v8.2.0, 0.13 v8.1.0, 0.14 v7.5.0, 0.24 v7.4.0, 0.19 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.21 v6.4.0, 0.14 v6.3.0, 0.23 v6.2.0, 0.27 v6.1.0, 0.52 v6.0.0, 0.50 v5.4.0, 0.48 v5.3.0, 0.52 v5.2.0, 0.36 v5.0.0, 0.40 v4.1.0, 0.50 v4.0.1, 0.47 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10906 (   0 equ)
%            Maximal formula atoms :  197 (   1 avg)
%            Number of connectives :  717 (   0   ~;  18   |; 573   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  197 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   89 (  89 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16664 (16664 usr;16663 con; 0-2 aty)
%            Number of variables   :  475 ( 405   !;  70   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_wp_486,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6] :
      ( agt(X4,X3)
      & attr(X0,X1)
      & attr(X3,X2)
      & attr(X5,X6)
      & sub(X1,name_1_1)
      & sub(X0,firma_1_1)
      & sub(X2,name_1_1)
      & sub(X6,jahr__1_1)
      & temp(X4,X5)
      & val(X1,bmw_0)
      & val(X2,bmw_0) ) ).

fof(ave07_era5_synth_qa07_007_mira_wp_486,hypothesis,
    ( attr(c401,c402)
    & prop(c401,aufmerksam_1_1)
    & sub(c401,firma_1_1)
    & sub(c402,name_1_1)
    & val(c402,bmw_0)
    & agt(c410,c401)
    & obj(c410,c403)
    & rslt(c410,c497)
    & semrel(c410,c8)
    & subs(c410,verpflichten_2_2)
    & temp(c410,c490)
    & attr(c490,c491)
    & sub(c491,jahr__1_1)
    & val(c491,c486)
    & sub(c493,werksfahrer_1_1)
    & arg1(c497,c403)
    & arg2(c497,c493)
    & subr(c497,rprs_0)
    & agt(c498,c493)
    & subs(c498,fahren_1_2)
    & arg1(c500,c401)
    & arg2(c500,aufmerksam_1_1)
    & subr(c500,prop_0)
    & ante(c6,c8)
    & preds(c6,rennerfolg_1_1)
    & prop(c6,weit_1_1)
    & dur(c8,c403)
    & rslt(c8,c500)
    & subs(c8,werden_1_1)
    & assoc(rennerfolg_1_1,rennen_1_1)
    & subs(rennerfolg_1_1,erfolg__1_1)
    & assoc(werksfahrer_1_1,kunstwerk_1_1)
    & sub(werksfahrer_1_1,fahrer__1_1)
    & sort(c401,d)
    & sort(c401,io)
    & card(c401,int1)
    & etype(c401,int0)
    & fact(c401,real)
    & gener(c401,sp)
    & quant(c401,one)
    & refer(c401,det)
    & varia(c401,con)
    & sort(c402,na)
    & card(c402,int1)
    & etype(c402,int0)
    & fact(c402,real)
    & gener(c402,sp)
    & quant(c402,one)
    & refer(c402,indet)
    & varia(c402,varia_c)
    & sort(aufmerksam_1_1,nq)
    & sort(firma_1_1,d)
    & sort(firma_1_1,io)
    & card(firma_1_1,int1)
    & etype(firma_1_1,int0)
    & fact(firma_1_1,real)
    & gener(firma_1_1,ge)
    & quant(firma_1_1,one)
    & refer(firma_1_1,refer_c)
    & varia(firma_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(bmw_0,fe)
    & sort(c410,da)
    & fact(c410,real)
    & gener(c410,sp)
    & sort(c403,o)
    & card(c403,int1)
    & etype(c403,int0)
    & fact(c403,real)
    & gener(c403,sp)
    & quant(c403,one)
    & refer(c403,det)
    & varia(c403,varia_c)
    & sort(c497,st)
    & fact(c497,real)
    & gener(c497,sp)
    & sort(c8,dn)
    & fact(c8,real)
    & gener(c8,sp)
    & sort(verpflichten_2_2,da)
    & fact(verpflichten_2_2,real)
    & gener(verpflichten_2_2,ge)
    & sort(c490,t)
    & card(c490,int1)
    & etype(c490,int0)
    & fact(c490,real)
    & gener(c490,sp)
    & quant(c490,one)
    & refer(c490,det)
    & varia(c490,con)
    & sort(c491,me)
    & sort(c491,oa)
    & sort(c491,ta)
    & card(c491,card_c)
    & etype(c491,etype_c)
    & fact(c491,real)
    & gener(c491,sp)
    & quant(c491,quant_c)
    & refer(c491,refer_c)
    & varia(c491,varia_c)
    & sort(jahr__1_1,me)
    & sort(jahr__1_1,oa)
    & sort(jahr__1_1,ta)
    & card(jahr__1_1,card_c)
    & etype(jahr__1_1,etype_c)
    & fact(jahr__1_1,real)
    & gener(jahr__1_1,ge)
    & quant(jahr__1_1,quant_c)
    & refer(jahr__1_1,refer_c)
    & varia(jahr__1_1,varia_c)
    & sort(c486,nu)
    & card(c486,int1926)
    & sort(c493,d)
    & card(c493,int1)
    & etype(c493,int0)
    & fact(c493,real)
    & gener(c493,sp)
    & quant(c493,one)
    & refer(c493,indet)
    & varia(c493,varia_c)
    & sort(werksfahrer_1_1,d)
    & card(werksfahrer_1_1,int1)
    & etype(werksfahrer_1_1,int0)
    & fact(werksfahrer_1_1,real)
    & gener(werksfahrer_1_1,ge)
    & quant(werksfahrer_1_1,one)
    & refer(werksfahrer_1_1,refer_c)
    & varia(werksfahrer_1_1,varia_c)
    & sort(rprs_0,st)
    & fact(rprs_0,real)
    & gener(rprs_0,gener_c)
    & sort(c498,da)
    & fact(c498,real)
    & gener(c498,sp)
    & sort(fahren_1_2,da)
    & fact(fahren_1_2,real)
    & gener(fahren_1_2,ge)
    & sort(c500,st)
    & fact(c500,real)
    & gener(c500,sp)
    & sort(prop_0,st)
    & fact(prop_0,real)
    & gener(prop_0,gener_c)
    & sort(c6,as)
    & card(c6,cons(x_constant,cons(int1,nil)))
    & etype(c6,int1)
    & fact(c6,real)
    & gener(c6,gener_c)
    & quant(c6,mult)
    & refer(c6,refer_c)
    & varia(c6,varia_c)
    & sort(rennerfolg_1_1,as)
    & card(rennerfolg_1_1,int1)
    & etype(rennerfolg_1_1,int0)
    & fact(rennerfolg_1_1,real)
    & gener(rennerfolg_1_1,ge)
    & quant(rennerfolg_1_1,one)
    & refer(rennerfolg_1_1,refer_c)
    & varia(rennerfolg_1_1,varia_c)
    & sort(weit_1_1,mq)
    & sort(werden_1_1,dn)
    & fact(werden_1_1,real)
    & gener(werden_1_1,ge)
    & sort(rennen_1_1,da)
    & fact(rennen_1_1,real)
    & gener(rennen_1_1,ge)
    & sort(erfolg__1_1,as)
    & card(erfolg__1_1,int1)
    & etype(erfolg__1_1,int0)
    & fact(erfolg__1_1,real)
    & gener(erfolg__1_1,ge)
    & quant(erfolg__1_1,one)
    & refer(erfolg__1_1,refer_c)
    & varia(erfolg__1_1,varia_c)
    & sort(kunstwerk_1_1,io)
    & card(kunstwerk_1_1,card_c)
    & etype(kunstwerk_1_1,int1)
    & fact(kunstwerk_1_1,real)
    & gener(kunstwerk_1_1,ge)
    & quant(kunstwerk_1_1,quant_c)
    & refer(kunstwerk_1_1,refer_c)
    & varia(kunstwerk_1_1,varia_c)
    & sort(fahrer__1_1,d)
    & card(fahrer__1_1,int1)
    & etype(fahrer__1_1,int0)
    & fact(fahrer__1_1,real)
    & gener(fahrer__1_1,ge)
    & quant(fahrer__1_1,one)
    & refer(fahrer__1_1,refer_c)
    & varia(fahrer__1_1,varia_c) ) ).

%------------------------------------------------------------------------------
