%------------------------------------------------------------------------------
% File     : CSR115+75 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_wp_485_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.40 v9.0.0, 0.25 v8.2.0, 0.27 v8.1.0, 0.29 v7.5.0, 0.38 v7.4.0, 0.31 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.31 v6.2.0, 0.45 v6.1.0, 0.60 v6.0.0, 0.50 v5.5.0, 0.54 v5.4.0, 0.52 v5.3.0, 0.61 v5.2.0, 0.43 v5.0.0, 0.45 v4.1.0, 0.50 v4.0.1, 0.47 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10811 (   0 equ)
%            Maximal formula atoms :  104 (   1 avg)
%            Number of connectives :  622 (   0   ~;  18   |; 478   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  104 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   88 (  88 usr;   0 prp; 2-4 aty)
%            Number of functors    : 16654 (16654 usr;16653 con; 0-2 aty)
%            Number of variables   :  475 ( 405   !;  70   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_wp_485,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6] :
      ( attr(X0,X1)
      & attr(X3,X2)
      & attr(X5,X6)
      & obj(X4,X0)
      & sub(X1,name_1_1)
      & sub(X0,firma_1_1)
      & sub(X2,name_1_1)
      & val(X1,bmw_0)
      & val(X2,bmw_0) ) ).

fof(ave07_era5_synth_qa07_007_mira_wp_485,hypothesis,
    ( tupl_p4(c269,c62,c69,c72)
    & pred(c62,beid_2_1)
    & pred(c69,l6_1_1)
    & propr(c69,gleich_1_1)
    & pred(c72,motor__1_1)
    & attch(c85,c72)
    & attr(c85,c86)
    & sub(c85,firma_1_1)
    & sub(c86,name_1_1)
    & val(c86,bmw_0)
    & sort(c269,ent)
    & card(c269,card_c)
    & etype(c269,etype_c)
    & fact(c269,real)
    & gener(c269,gener_c)
    & quant(c269,quant_c)
    & refer(c269,refer_c)
    & varia(c269,varia_c)
    & sort(c62,o)
    & card(c62,int2)
    & etype(c62,int1)
    & etype(c62,int2)
    & etype(c62,int3)
    & fact(c62,real)
    & gener(c62,gener_c)
    & quant(c62,both)
    & refer(c62,refer_c)
    & varia(c62,varia_c)
    & sort(c69,o)
    & card(c69,cons(x_constant,cons(int1,nil)))
    & etype(c69,int1)
    & fact(c69,real)
    & gener(c69,gener_c)
    & quant(c69,mult)
    & refer(c69,refer_c)
    & varia(c69,varia_c)
    & sort(c72,d)
    & card(c72,cons(x_constant,cons(int1,nil)))
    & etype(c72,int1)
    & fact(c72,real)
    & gener(c72,sp)
    & quant(c72,mult)
    & refer(c72,indet)
    & varia(c72,varia_c)
    & sort(beid_2_1,o)
    & card(beid_2_1,int2)
    & etype(beid_2_1,int1)
    & fact(beid_2_1,real)
    & gener(beid_2_1,gener_c)
    & quant(beid_2_1,both)
    & refer(beid_2_1,refer_c)
    & varia(beid_2_1,varia_c)
    & sort(l6_1_1,o)
    & card(l6_1_1,int1)
    & etype(l6_1_1,int0)
    & fact(l6_1_1,real)
    & gener(l6_1_1,ge)
    & quant(l6_1_1,one)
    & refer(l6_1_1,refer_c)
    & varia(l6_1_1,varia_c)
    & sort(gleich_1_1,rq)
    & sort(motor__1_1,d)
    & card(motor__1_1,int1)
    & etype(motor__1_1,int0)
    & fact(motor__1_1,real)
    & gener(motor__1_1,ge)
    & quant(motor__1_1,one)
    & refer(motor__1_1,refer_c)
    & varia(motor__1_1,varia_c)
    & sort(c85,d)
    & sort(c85,io)
    & card(c85,int1)
    & etype(c85,int0)
    & fact(c85,real)
    & gener(c85,sp)
    & quant(c85,one)
    & refer(c85,det)
    & varia(c85,con)
    & sort(c86,na)
    & card(c86,int1)
    & etype(c86,int0)
    & fact(c86,real)
    & gener(c86,sp)
    & quant(c86,one)
    & refer(c86,indet)
    & varia(c86,varia_c)
    & sort(firma_1_1,d)
    & sort(firma_1_1,io)
    & card(firma_1_1,int1)
    & etype(firma_1_1,int0)
    & fact(firma_1_1,real)
    & gener(firma_1_1,ge)
    & quant(firma_1_1,one)
    & refer(firma_1_1,refer_c)
    & varia(firma_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(bmw_0,fe) ) ).

%------------------------------------------------------------------------------
