%------------------------------------------------------------------------------
% File     : CSR115+74 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_wp_484_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.40 v9.0.0, 0.25 v8.2.0, 0.27 v8.1.0, 0.29 v7.5.0, 0.38 v7.4.0, 0.31 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.31 v6.2.0, 0.45 v6.1.0, 0.52 v6.0.0, 0.50 v5.5.0, 0.54 v5.4.0, 0.52 v5.3.0, 0.61 v5.2.0, 0.43 v5.0.0, 0.40 v4.1.0, 0.44 v4.0.1, 0.53 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10816 (   0 equ)
%            Maximal formula atoms :  109 (   1 avg)
%            Number of connectives :  627 (   0   ~;  18   |; 483   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  109 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-6 aty)
%            Number of functors    : 16651 (16651 usr;16650 con; 0-2 aty)
%            Number of variables   :  475 ( 405   !;  70   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_wp_484,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6] :
      ( attr(X0,X1)
      & attr(X3,X2)
      & attr(X5,X6)
      & obj(X4,X0)
      & sub(X1,name_1_1)
      & sub(X0,firma_1_1)
      & sub(X2,name_1_1)
      & val(X1,bmw_0)
      & val(X2,bmw_0) ) ).

fof(ave07_era5_synth_qa07_007_mira_wp_484,hypothesis,
    ( tupl_p6(c112,c56,c62,c66,c78,c80)
    & sub(c56,bekanntheit_1_1)
    & sub(c62,firma_1_1)
    & preds(c66,umbau__1_1)
    & attr(c78,c79)
    & sub(c78,firma_1_1)
    & sub(c79,name_1_1)
    & val(c79,bmw_0)
    & pred(c80,fahrzeug__1_1)
    & sort(c112,ent)
    & card(c112,card_c)
    & etype(c112,etype_c)
    & fact(c112,real)
    & gener(c112,gener_c)
    & quant(c112,quant_c)
    & refer(c112,refer_c)
    & varia(c112,varia_c)
    & sort(c56,na)
    & card(c56,int1)
    & etype(c56,int0)
    & fact(c56,real)
    & gener(c56,gener_c)
    & quant(c56,one)
    & refer(c56,refer_c)
    & varia(c56,varia_c)
    & sort(c62,d)
    & sort(c62,io)
    & card(c62,int1)
    & etype(c62,int0)
    & fact(c62,real)
    & gener(c62,sp)
    & quant(c62,one)
    & refer(c62,det)
    & varia(c62,con)
    & sort(c66,ad)
    & card(c66,cons(x_constant,cons(int1,nil)))
    & etype(c66,int1)
    & fact(c66,real)
    & gener(c66,gener_c)
    & quant(c66,mult)
    & refer(c66,indet)
    & varia(c66,varia_c)
    & sort(c78,d)
    & sort(c78,io)
    & card(c78,int1)
    & etype(c78,int0)
    & fact(c78,real)
    & gener(c78,sp)
    & quant(c78,one)
    & refer(c78,det)
    & varia(c78,con)
    & sort(c80,d)
    & card(c80,cons(x_constant,cons(int1,nil)))
    & etype(c80,int1)
    & fact(c80,real)
    & gener(c80,gener_c)
    & quant(c80,mult)
    & refer(c80,indet)
    & varia(c80,varia_c)
    & sort(bekanntheit_1_1,na)
    & card(bekanntheit_1_1,int1)
    & etype(bekanntheit_1_1,int0)
    & fact(bekanntheit_1_1,real)
    & gener(bekanntheit_1_1,ge)
    & quant(bekanntheit_1_1,one)
    & refer(bekanntheit_1_1,refer_c)
    & varia(bekanntheit_1_1,varia_c)
    & sort(firma_1_1,d)
    & sort(firma_1_1,io)
    & card(firma_1_1,int1)
    & etype(firma_1_1,int0)
    & fact(firma_1_1,real)
    & gener(firma_1_1,ge)
    & quant(firma_1_1,one)
    & refer(firma_1_1,refer_c)
    & varia(firma_1_1,varia_c)
    & sort(umbau__1_1,ad)
    & card(umbau__1_1,int1)
    & etype(umbau__1_1,int0)
    & fact(umbau__1_1,real)
    & gener(umbau__1_1,ge)
    & quant(umbau__1_1,one)
    & refer(umbau__1_1,refer_c)
    & varia(umbau__1_1,varia_c)
    & sort(c79,na)
    & card(c79,int1)
    & etype(c79,int0)
    & fact(c79,real)
    & gener(c79,sp)
    & quant(c79,one)
    & refer(c79,indet)
    & varia(c79,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(bmw_0,fe)
    & sort(fahrzeug__1_1,d)
    & card(fahrzeug__1_1,int1)
    & etype(fahrzeug__1_1,int0)
    & fact(fahrzeug__1_1,real)
    & gener(fahrzeug__1_1,ge)
    & quant(fahrzeug__1_1,one)
    & refer(fahrzeug__1_1,refer_c)
    & varia(fahrzeug__1_1,varia_c) ) ).

%------------------------------------------------------------------------------
