%------------------------------------------------------------------------------
% File     : CSR115+72 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_wp_482_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.40 v9.0.0, 0.25 v8.2.0, 0.27 v8.1.0, 0.29 v7.5.0, 0.38 v7.4.0, 0.25 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.23 v6.2.0, 0.36 v6.1.0, 0.56 v6.0.0, 0.50 v5.5.0, 0.58 v5.4.0, 0.57 v5.3.0, 0.61 v5.2.0, 0.36 v5.0.0, 0.50 v4.1.0, 0.61 v4.0.1, 0.53 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10901 (   0 equ)
%            Maximal formula atoms :  194 (   1 avg)
%            Number of connectives :  712 (   0   ~;  18   |; 568   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  194 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   88 (  88 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16658 (16658 usr;16657 con; 0-2 aty)
%            Number of variables   :  475 ( 405   !;  70   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_wp_482,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6] :
      ( attr(X0,X1)
      & attr(X3,X2)
      & attr(X5,X6)
      & obj(X4,X0)
      & sub(X1,name_1_1)
      & sub(X0,firma_1_1)
      & sub(X2,name_1_1)
      & val(X1,bmw_0)
      & val(X2,bmw_0) ) ).

fof(ave07_era5_synth_qa07_007_mira_wp_482,hypothesis,
    ( agt(c2,c1)
    & avrt(c2,c456)
    & benf(c2,c451)
    & subs(c2,verlassen_1_3)
    & attr(c451,c452)
    & attr(c451,c453)
    & sub(c451,hauptaktion__344r_1_1)
    & sub(c452,eigenname_1_1)
    & val(c452,camillo_0)
    & sub(c453,familiename_1_1)
    & val(c453,castiglioni_0)
    & sub(c456,firma_1_1)
    & sub(c528,namensrechte_1_1)
    & attr(c595,c596)
    & sub(c595,firma_1_1)
    & sub(c596,name_1_1)
    & val(c596,bmw_0)
    & agt(c598,c1)
    & dircl(c598,c601)
    & obj(c598,c528)
    & semrel(c598,c2)
    & subs(c598,mitnehmen_1_1)
    & flp(c601,c595)
    & assoc(hauptaktion__344r_1_1,haupt_1_1)
    & sub(hauptaktion__344r_1_1,aktion__344r_1_1)
    & assoc(namensrechte_1_1,name_1_1)
    & sub(namensrechte_1_1,rechte_1_1)
    & sort(c2,da)
    & fact(c2,real)
    & gener(c2,sp)
    & sort(c1,co)
    & card(c1,card_c)
    & etype(c1,etype_c)
    & fact(c1,real)
    & gener(c1,sp)
    & quant(c1,quant_c)
    & refer(c1,refer_c)
    & varia(c1,varia_c)
    & sort(c456,d)
    & sort(c456,io)
    & card(c456,int1)
    & etype(c456,int0)
    & fact(c456,real)
    & gener(c456,sp)
    & quant(c456,one)
    & refer(c456,det)
    & varia(c456,con)
    & sort(c451,d)
    & card(c451,int1)
    & etype(c451,int0)
    & fact(c451,real)
    & gener(c451,sp)
    & quant(c451,one)
    & refer(c451,det)
    & varia(c451,varia_c)
    & sort(verlassen_1_3,da)
    & fact(verlassen_1_3,real)
    & gener(verlassen_1_3,ge)
    & sort(c452,na)
    & card(c452,int1)
    & etype(c452,int0)
    & fact(c452,real)
    & gener(c452,sp)
    & quant(c452,one)
    & refer(c452,indet)
    & varia(c452,varia_c)
    & sort(c453,na)
    & card(c453,int1)
    & etype(c453,int0)
    & fact(c453,real)
    & gener(c453,sp)
    & quant(c453,one)
    & refer(c453,det)
    & varia(c453,varia_c)
    & sort(hauptaktion__344r_1_1,d)
    & sort(hauptaktion__344r_1_1,io)
    & card(hauptaktion__344r_1_1,int1)
    & etype(hauptaktion__344r_1_1,int0)
    & fact(hauptaktion__344r_1_1,real)
    & gener(hauptaktion__344r_1_1,ge)
    & quant(hauptaktion__344r_1_1,one)
    & refer(hauptaktion__344r_1_1,refer_c)
    & varia(hauptaktion__344r_1_1,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(camillo_0,fe)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(castiglioni_0,fe)
    & sort(firma_1_1,d)
    & sort(firma_1_1,io)
    & card(firma_1_1,int1)
    & etype(firma_1_1,int0)
    & fact(firma_1_1,real)
    & gener(firma_1_1,ge)
    & quant(firma_1_1,one)
    & refer(firma_1_1,refer_c)
    & varia(firma_1_1,varia_c)
    & sort(c528,d)
    & sort(c528,io)
    & card(c528,int1)
    & etype(c528,int1)
    & fact(c528,real)
    & gener(c528,sp)
    & quant(c528,one)
    & refer(c528,det)
    & varia(c528,con)
    & sort(namensrechte_1_1,d)
    & sort(namensrechte_1_1,io)
    & card(namensrechte_1_1,card_c)
    & etype(namensrechte_1_1,int1)
    & fact(namensrechte_1_1,real)
    & gener(namensrechte_1_1,ge)
    & quant(namensrechte_1_1,quant_c)
    & refer(namensrechte_1_1,refer_c)
    & varia(namensrechte_1_1,varia_c)
    & sort(c595,d)
    & sort(c595,io)
    & card(c595,int1)
    & etype(c595,int0)
    & fact(c595,real)
    & gener(c595,sp)
    & quant(c595,one)
    & refer(c595,det)
    & varia(c595,con)
    & sort(c596,na)
    & card(c596,int1)
    & etype(c596,int0)
    & fact(c596,real)
    & gener(c596,sp)
    & quant(c596,one)
    & refer(c596,indet)
    & varia(c596,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(bmw_0,fe)
    & sort(c598,da)
    & fact(c598,real)
    & gener(c598,sp)
    & sort(c601,l)
    & card(c601,int1)
    & etype(c601,int0)
    & fact(c601,real)
    & gener(c601,sp)
    & quant(c601,one)
    & refer(c601,det)
    & varia(c601,con)
    & sort(mitnehmen_1_1,da)
    & fact(mitnehmen_1_1,real)
    & gener(mitnehmen_1_1,ge)
    & sort(haupt_1_1,d)
    & card(haupt_1_1,int1)
    & etype(haupt_1_1,int0)
    & fact(haupt_1_1,real)
    & gener(haupt_1_1,ge)
    & quant(haupt_1_1,one)
    & refer(haupt_1_1,refer_c)
    & varia(haupt_1_1,varia_c)
    & sort(aktion__344r_1_1,d)
    & sort(aktion__344r_1_1,io)
    & card(aktion__344r_1_1,int1)
    & etype(aktion__344r_1_1,int0)
    & fact(aktion__344r_1_1,real)
    & gener(aktion__344r_1_1,ge)
    & quant(aktion__344r_1_1,one)
    & refer(aktion__344r_1_1,refer_c)
    & varia(aktion__344r_1_1,varia_c)
    & sort(rechte_1_1,d)
    & sort(rechte_1_1,io)
    & card(rechte_1_1,card_c)
    & etype(rechte_1_1,int1)
    & fact(rechte_1_1,real)
    & gener(rechte_1_1,ge)
    & quant(rechte_1_1,quant_c)
    & refer(rechte_1_1,refer_c)
    & varia(rechte_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
