%------------------------------------------------------------------------------
% File     : CSR115+71 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_wp_481_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.40 v9.0.0, 0.25 v8.2.0, 0.27 v8.1.0, 0.29 v7.5.0, 0.38 v7.4.0, 0.31 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.31 v6.2.0, 0.45 v6.1.0, 0.52 v6.0.0, 0.50 v5.4.0, 0.48 v5.3.0, 0.52 v5.2.0, 0.43 v5.0.0, 0.45 v4.1.0, 0.50 v4.0.1, 0.53 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10832 (   0 equ)
%            Maximal formula atoms :  125 (   1 avg)
%            Number of connectives :  643 (   0   ~;  18   |; 499   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  125 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   88 (  88 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16651 (16651 usr;16650 con; 0-2 aty)
%            Number of variables   :  475 ( 405   !;  70   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_wp_481,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6] :
      ( attr(X0,X1)
      & attr(X3,X2)
      & attr(X5,X6)
      & obj(X4,X0)
      & sub(X1,name_1_1)
      & sub(X0,firma_1_1)
      & sub(X2,name_1_1)
      & val(X1,bmw_0)
      & val(X2,bmw_0) ) ).

fof(ave07_era5_synth_qa07_007_mira_wp_481,hypothesis,
    ( aff(c1371,c1565)
    & init(c1371,c1569)
    & prop(c1371,technisch__1_1)
    & subs(c1371,entwicklung_1_2)
    & temp(c1371,c1576)
    & attr(c1565,c1566)
    & sub(c1565,firma_1_1)
    & sub(c1566,name_1_1)
    & val(c1566,bmw_0)
    & sub(c1569,historie_1_1)
    & sub(c1576,gegenwart__1_1)
    & sub(c1585,vorzeitigkeit_1_1)
    & modl(c21,sollen_0)
    & obj(c21,c1371)
    & subs(c21,darlegen_1_1)
    & temp(c21,c1585)
    & sort(c1371,ad)
    & card(c1371,int1)
    & etype(c1371,int0)
    & fact(c1371,real)
    & gener(c1371,sp)
    & quant(c1371,one)
    & refer(c1371,det)
    & varia(c1371,con)
    & sort(c1565,d)
    & sort(c1565,io)
    & card(c1565,int1)
    & etype(c1565,int0)
    & fact(c1565,real)
    & gener(c1565,sp)
    & quant(c1565,one)
    & refer(c1565,det)
    & varia(c1565,con)
    & sort(c1569,ta)
    & card(c1569,int1)
    & etype(c1569,int0)
    & fact(c1569,real)
    & gener(c1569,sp)
    & quant(c1569,one)
    & refer(c1569,det)
    & varia(c1569,con)
    & sort(technisch__1_1,nq)
    & sort(entwicklung_1_2,ad)
    & card(entwicklung_1_2,int1)
    & etype(entwicklung_1_2,int0)
    & fact(entwicklung_1_2,real)
    & gener(entwicklung_1_2,ge)
    & quant(entwicklung_1_2,one)
    & refer(entwicklung_1_2,refer_c)
    & varia(entwicklung_1_2,varia_c)
    & sort(c1576,ta)
    & card(c1576,int1)
    & etype(c1576,int0)
    & fact(c1576,real)
    & gener(c1576,sp)
    & quant(c1576,one)
    & refer(c1576,det)
    & varia(c1576,con)
    & sort(c1566,na)
    & card(c1566,int1)
    & etype(c1566,int0)
    & fact(c1566,real)
    & gener(c1566,sp)
    & quant(c1566,one)
    & refer(c1566,indet)
    & varia(c1566,varia_c)
    & sort(firma_1_1,d)
    & sort(firma_1_1,io)
    & card(firma_1_1,int1)
    & etype(firma_1_1,int0)
    & fact(firma_1_1,real)
    & gener(firma_1_1,ge)
    & quant(firma_1_1,one)
    & refer(firma_1_1,refer_c)
    & varia(firma_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(bmw_0,fe)
    & sort(historie_1_1,ta)
    & card(historie_1_1,int1)
    & etype(historie_1_1,int0)
    & fact(historie_1_1,real)
    & gener(historie_1_1,ge)
    & quant(historie_1_1,one)
    & refer(historie_1_1,refer_c)
    & varia(historie_1_1,varia_c)
    & sort(gegenwart__1_1,ta)
    & card(gegenwart__1_1,int1)
    & etype(gegenwart__1_1,int0)
    & fact(gegenwart__1_1,real)
    & gener(gegenwart__1_1,ge)
    & quant(gegenwart__1_1,one)
    & refer(gegenwart__1_1,refer_c)
    & varia(gegenwart__1_1,varia_c)
    & sort(c1585,ta)
    & card(c1585,int1)
    & etype(c1585,int0)
    & fact(c1585,real)
    & gener(c1585,sp)
    & quant(c1585,one)
    & refer(c1585,det)
    & varia(c1585,con)
    & sort(vorzeitigkeit_1_1,ta)
    & card(vorzeitigkeit_1_1,int1)
    & etype(vorzeitigkeit_1_1,int0)
    & fact(vorzeitigkeit_1_1,real)
    & gener(vorzeitigkeit_1_1,ge)
    & quant(vorzeitigkeit_1_1,one)
    & refer(vorzeitigkeit_1_1,refer_c)
    & varia(vorzeitigkeit_1_1,varia_c)
    & sort(c21,da)
    & fact(c21,real)
    & gener(c21,sp)
    & sort(sollen_0,md)
    & fact(sollen_0,real)
    & gener(sollen_0,gener_c)
    & sort(darlegen_1_1,da)
    & fact(darlegen_1_1,real)
    & gener(darlegen_1_1,ge) ) ).

%------------------------------------------------------------------------------
