%------------------------------------------------------------------------------
% File     : CSR115+70 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_wp_480_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.40 v9.0.0, 0.25 v8.2.0, 0.27 v8.1.0, 0.29 v7.5.0, 0.38 v7.4.0, 0.31 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.31 v6.2.0, 0.45 v6.1.0, 0.56 v6.0.0, 0.50 v5.5.0, 0.54 v5.4.0, 0.52 v5.3.0, 0.61 v5.2.0, 0.43 v5.0.0, 0.45 v4.1.0, 0.50 v4.0.1, 0.53 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10786 (   0 equ)
%            Maximal formula atoms :   79 (   1 avg)
%            Number of connectives :  597 (   0   ~;  18   |; 453   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   79 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   86 (  86 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16646 (16646 usr;16645 con; 0-2 aty)
%            Number of variables   :  475 ( 405   !;  70   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_wp_480,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6] :
      ( attr(X0,X1)
      & attr(X3,X2)
      & attr(X5,X6)
      & obj(X4,X0)
      & sub(X1,name_1_1)
      & sub(X0,firma_1_1)
      & sub(X2,name_1_1)
      & val(X1,bmw_0)
      & val(X2,bmw_0) ) ).

fof(ave07_era5_synth_qa07_007_mira_wp_480,hypothesis,
    ( arg1(c11,c3)
    & arg2(c11,c25)
    & subs(c11,behandeln_1_1)
    & sub(c25,geschichte_1_1)
    & mcont(c3,c25)
    & attch(c40,c25)
    & attr(c40,c41)
    & sub(c40,firma_1_1)
    & sub(c41,name_1_1)
    & val(c41,bmw_0)
    & sort(c11,st)
    & fact(c11,real)
    & gener(c11,sp)
    & sort(c3,o)
    & card(c3,int1)
    & etype(c3,int0)
    & fact(c3,real)
    & gener(c3,sp)
    & quant(c3,one)
    & refer(c3,det)
    & varia(c3,varia_c)
    & sort(c25,ad)
    & sort(c25,d)
    & sort(c25,io)
    & card(c25,int1)
    & etype(c25,int0)
    & fact(c25,hypo)
    & gener(c25,sp)
    & quant(c25,one)
    & refer(c25,det)
    & varia(c25,con)
    & sort(behandeln_1_1,st)
    & fact(behandeln_1_1,real)
    & gener(behandeln_1_1,ge)
    & sort(geschichte_1_1,ad)
    & sort(geschichte_1_1,d)
    & sort(geschichte_1_1,io)
    & card(geschichte_1_1,int1)
    & etype(geschichte_1_1,int0)
    & fact(geschichte_1_1,real)
    & gener(geschichte_1_1,ge)
    & quant(geschichte_1_1,one)
    & refer(geschichte_1_1,refer_c)
    & varia(geschichte_1_1,varia_c)
    & sort(c40,d)
    & sort(c40,io)
    & card(c40,int1)
    & etype(c40,int0)
    & fact(c40,real)
    & gener(c40,sp)
    & quant(c40,one)
    & refer(c40,det)
    & varia(c40,con)
    & sort(c41,na)
    & card(c41,int1)
    & etype(c41,int0)
    & fact(c41,real)
    & gener(c41,sp)
    & quant(c41,one)
    & refer(c41,indet)
    & varia(c41,varia_c)
    & sort(firma_1_1,d)
    & sort(firma_1_1,io)
    & card(firma_1_1,int1)
    & etype(firma_1_1,int0)
    & fact(firma_1_1,real)
    & gener(firma_1_1,ge)
    & quant(firma_1_1,one)
    & refer(firma_1_1,refer_c)
    & varia(firma_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(bmw_0,fe) ) ).

%------------------------------------------------------------------------------
