%------------------------------------------------------------------------------
% File     : CSR115+69 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_wp_479_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.40 v9.0.0, 0.25 v8.2.0, 0.27 v8.1.0, 0.29 v7.5.0, 0.38 v7.4.0, 0.31 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.36 v6.4.0, 0.21 v6.3.0, 0.31 v6.2.0, 0.45 v6.1.0, 0.52 v6.0.0, 0.50 v5.4.0, 0.52 v5.3.0, 0.57 v5.2.0, 0.43 v5.0.0, 0.40 v4.1.0, 0.50 v4.0.1, 0.53 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10845 (   0 equ)
%            Maximal formula atoms :  138 (   1 avg)
%            Number of connectives :  656 (   0   ~;  18   |; 512   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  138 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-6 aty)
%            Number of functors    : 16654 (16654 usr;16653 con; 0-2 aty)
%            Number of variables   :  475 ( 405   !;  70   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_wp_479,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6] :
      ( attr(X0,X1)
      & attr(X3,X2)
      & attr(X5,X6)
      & obj(X4,X0)
      & sub(X1,name_1_1)
      & sub(X0,firma_1_1)
      & sub(X2,name_1_1)
      & val(X1,bmw_0)
      & val(X2,bmw_0) ) ).

fof(ave07_era5_synth_qa07_007_mira_wp_479,hypothesis,
    ( sub(c124,firma_1_1)
    & pred(c137,tuningteil_1_1)
    & pred(c140,komplettfahrzeug_1_1)
    & attr(c163,c164)
    & sub(c163,firma_1_1)
    & sub(c164,name_1_1)
    & val(c164,bmw_0)
    & sub(c168,basis_1_1)
    & tupl_p6(c307,c124,c137,c140,c163,c168)
    & assoc(komplettfahrzeug_1_1,ganz_1_1)
    & sub(komplettfahrzeug_1_1,fahrzeug__1_1)
    & assoc(tuningteil_1_1,tuning_1_1)
    & sub(tuningteil_1_1,teil_1_1)
    & sort(c124,d)
    & sort(c124,io)
    & card(c124,int1)
    & etype(c124,int0)
    & fact(c124,real)
    & gener(c124,sp)
    & quant(c124,one)
    & refer(c124,det)
    & varia(c124,con)
    & sort(firma_1_1,d)
    & sort(firma_1_1,io)
    & card(firma_1_1,int1)
    & etype(firma_1_1,int0)
    & fact(firma_1_1,real)
    & gener(firma_1_1,ge)
    & quant(firma_1_1,one)
    & refer(firma_1_1,refer_c)
    & varia(firma_1_1,varia_c)
    & sort(c137,co)
    & card(c137,card_c)
    & etype(c137,etype_c)
    & fact(c137,real)
    & gener(c137,gener_c)
    & quant(c137,quant_c)
    & refer(c137,indet)
    & varia(c137,varia_c)
    & sort(tuningteil_1_1,co)
    & card(tuningteil_1_1,card_c)
    & etype(tuningteil_1_1,etype_c)
    & fact(tuningteil_1_1,real)
    & gener(tuningteil_1_1,ge)
    & quant(tuningteil_1_1,quant_c)
    & refer(tuningteil_1_1,refer_c)
    & varia(tuningteil_1_1,varia_c)
    & sort(c140,d)
    & card(c140,cons(x_constant,cons(int1,nil)))
    & etype(c140,int1)
    & fact(c140,real)
    & gener(c140,gener_c)
    & quant(c140,mult)
    & refer(c140,indet)
    & varia(c140,varia_c)
    & sort(komplettfahrzeug_1_1,d)
    & card(komplettfahrzeug_1_1,int1)
    & etype(komplettfahrzeug_1_1,int0)
    & fact(komplettfahrzeug_1_1,real)
    & gener(komplettfahrzeug_1_1,ge)
    & quant(komplettfahrzeug_1_1,one)
    & refer(komplettfahrzeug_1_1,refer_c)
    & varia(komplettfahrzeug_1_1,varia_c)
    & sort(c163,d)
    & sort(c163,io)
    & card(c163,int1)
    & etype(c163,int0)
    & fact(c163,real)
    & gener(c163,sp)
    & quant(c163,one)
    & refer(c163,det)
    & varia(c163,con)
    & sort(c164,na)
    & card(c164,int1)
    & etype(c164,int0)
    & fact(c164,real)
    & gener(c164,sp)
    & quant(c164,one)
    & refer(c164,indet)
    & varia(c164,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(bmw_0,fe)
    & sort(c168,io)
    & card(c168,int1)
    & etype(c168,int0)
    & fact(c168,real)
    & gener(c168,gener_c)
    & quant(c168,one)
    & refer(c168,refer_c)
    & varia(c168,varia_c)
    & sort(basis_1_1,io)
    & card(basis_1_1,int1)
    & etype(basis_1_1,int0)
    & fact(basis_1_1,real)
    & gener(basis_1_1,ge)
    & quant(basis_1_1,one)
    & refer(basis_1_1,refer_c)
    & varia(basis_1_1,varia_c)
    & sort(c307,ent)
    & card(c307,card_c)
    & etype(c307,etype_c)
    & fact(c307,real)
    & gener(c307,gener_c)
    & quant(c307,quant_c)
    & refer(c307,refer_c)
    & varia(c307,varia_c)
    & sort(ganz_1_1,nq)
    & sort(fahrzeug__1_1,d)
    & card(fahrzeug__1_1,int1)
    & etype(fahrzeug__1_1,int0)
    & fact(fahrzeug__1_1,real)
    & gener(fahrzeug__1_1,ge)
    & quant(fahrzeug__1_1,one)
    & refer(fahrzeug__1_1,refer_c)
    & varia(fahrzeug__1_1,varia_c)
    & sort(tuning_1_1,io)
    & card(tuning_1_1,int1)
    & etype(tuning_1_1,int0)
    & fact(tuning_1_1,real)
    & gener(tuning_1_1,ge)
    & quant(tuning_1_1,one)
    & refer(tuning_1_1,refer_c)
    & varia(tuning_1_1,varia_c)
    & sort(teil_1_1,co)
    & card(teil_1_1,card_c)
    & etype(teil_1_1,etype_c)
    & fact(teil_1_1,real)
    & gener(teil_1_1,ge)
    & quant(teil_1_1,quant_c)
    & refer(teil_1_1,refer_c)
    & varia(teil_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
