%------------------------------------------------------------------------------
% File     : CSR115+67 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_wp_477_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.40 v9.0.0, 0.25 v8.2.0, 0.27 v8.1.0, 0.29 v7.5.0, 0.38 v7.4.0, 0.31 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.31 v6.2.0, 0.45 v6.1.0, 0.56 v6.0.0, 0.50 v5.5.0, 0.58 v5.4.0, 0.57 v5.3.0, 0.61 v5.2.0, 0.43 v5.0.0, 0.50 v4.1.0, 0.56 v4.0.1, 0.68 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10928 (   0 equ)
%            Maximal formula atoms :  221 (   1 avg)
%            Number of connectives :  739 (   0   ~;  18   |; 595   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  221 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-10 aty)
%            Number of functors    : 16665 (16665 usr;16664 con; 0-2 aty)
%            Number of variables   :  475 ( 405   !;  70   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_wp_477,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6] :
      ( attr(X0,X1)
      & attr(X3,X2)
      & attr(X5,X6)
      & obj(X4,X0)
      & sub(X1,name_1_1)
      & sub(X0,firma_1_1)
      & sub(X2,name_1_1)
      & val(X1,bmw_0)
      & val(X2,bmw_0) ) ).

fof(ave07_era5_synth_qa07_007_mira_wp_477,hypothesis,
    ( assoc(bildsensor_1_1,bild_0)
    & sub(bildsensor_1_1,sensor_1_1)
    & sub(c1898,name_1_1)
    & pred(c1899,x3_1_1)
    & attr(c1998,c1999)
    & sub(c1998,einrichtung_1_2)
    & sub(c1999,name_1_1)
    & val(c1999,suv_0)
    & attr(c2002,c2003)
    & sub(c2002,firma_1_1)
    & sub(c2003,name_1_1)
    & val(c2003,bmw_0)
    & attch(c2063,c1899)
    & attr(c2063,c2064)
    & attr(c2063,c2069)
    & sub(c2063,firma_1_1)
    & sub(c2064,name_1_1)
    & val(c2064,bmw_0)
    & pred(c2066,x3_1_1)
    & sub(c2069,name_1_1)
    & val(c2069,foveon_0)
    & sub(c2070,direkt_2_1)
    & sub(c2075,bildsensor_1_1)
    & sub(c2082,digitalphotographie_2_1)
    & tupl_p10(c2101,c1898,c1899,c1998,c2002,c1899,c2066,c2070,c2075,c2082)
    & assoc(digitalphotographie_2_1,digital_1_1)
    & sub(digitalphotographie_2_1,photographie_2_1)
    & sort(bildsensor_1_1,d)
    & card(bildsensor_1_1,int1)
    & etype(bildsensor_1_1,int0)
    & fact(bildsensor_1_1,real)
    & gener(bildsensor_1_1,ge)
    & quant(bildsensor_1_1,one)
    & refer(bildsensor_1_1,refer_c)
    & varia(bildsensor_1_1,varia_c)
    & sort(bild_0,fe)
    & sort(sensor_1_1,d)
    & card(sensor_1_1,int1)
    & etype(sensor_1_1,int0)
    & fact(sensor_1_1,real)
    & gener(sensor_1_1,ge)
    & quant(sensor_1_1,one)
    & refer(sensor_1_1,refer_c)
    & varia(sensor_1_1,varia_c)
    & sort(c1898,na)
    & card(c1898,int1)
    & etype(c1898,int0)
    & fact(c1898,real)
    & gener(c1898,sp)
    & quant(c1898,one)
    & refer(c1898,det)
    & varia(c1898,con)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(c1899,o)
    & card(c1899,cons(x_constant,cons(int1,nil)))
    & etype(c1899,int1)
    & fact(c1899,real)
    & gener(c1899,gener_c)
    & quant(c1899,mult)
    & refer(c1899,indet)
    & varia(c1899,varia_c)
    & sort(x3_1_1,o)
    & card(x3_1_1,int1)
    & etype(x3_1_1,int0)
    & fact(x3_1_1,real)
    & gener(x3_1_1,ge)
    & quant(x3_1_1,one)
    & refer(x3_1_1,refer_c)
    & varia(x3_1_1,varia_c)
    & sort(c1998,d)
    & sort(c1998,io)
    & card(c1998,int1)
    & etype(c1998,int1)
    & fact(c1998,real)
    & gener(c1998,sp)
    & quant(c1998,one)
    & refer(c1998,det)
    & varia(c1998,con)
    & sort(c1999,na)
    & card(c1999,int1)
    & etype(c1999,int0)
    & fact(c1999,real)
    & gener(c1999,sp)
    & quant(c1999,one)
    & refer(c1999,indet)
    & varia(c1999,varia_c)
    & sort(einrichtung_1_2,d)
    & sort(einrichtung_1_2,io)
    & card(einrichtung_1_2,card_c)
    & etype(einrichtung_1_2,int1)
    & fact(einrichtung_1_2,real)
    & gener(einrichtung_1_2,ge)
    & quant(einrichtung_1_2,quant_c)
    & refer(einrichtung_1_2,refer_c)
    & varia(einrichtung_1_2,varia_c)
    & sort(suv_0,fe)
    & sort(c2002,d)
    & sort(c2002,io)
    & card(c2002,int1)
    & etype(c2002,int0)
    & fact(c2002,real)
    & gener(c2002,sp)
    & quant(c2002,one)
    & refer(c2002,det)
    & varia(c2002,con)
    & sort(c2003,na)
    & card(c2003,int1)
    & etype(c2003,int0)
    & fact(c2003,real)
    & gener(c2003,sp)
    & quant(c2003,one)
    & refer(c2003,indet)
    & varia(c2003,varia_c)
    & sort(firma_1_1,d)
    & sort(firma_1_1,io)
    & card(firma_1_1,int1)
    & etype(firma_1_1,int0)
    & fact(firma_1_1,real)
    & gener(firma_1_1,ge)
    & quant(firma_1_1,one)
    & refer(firma_1_1,refer_c)
    & varia(firma_1_1,varia_c)
    & sort(bmw_0,fe)
    & sort(c2063,d)
    & sort(c2063,io)
    & card(c2063,int1)
    & etype(c2063,int0)
    & fact(c2063,real)
    & gener(c2063,sp)
    & quant(c2063,one)
    & refer(c2063,det)
    & varia(c2063,con)
    & sort(c2064,na)
    & card(c2064,int1)
    & etype(c2064,int0)
    & fact(c2064,real)
    & gener(c2064,sp)
    & quant(c2064,one)
    & refer(c2064,indet)
    & varia(c2064,varia_c)
    & sort(c2069,na)
    & card(c2069,int1)
    & etype(c2069,int0)
    & fact(c2069,real)
    & gener(c2069,sp)
    & quant(c2069,one)
    & refer(c2069,indet)
    & varia(c2069,varia_c)
    & sort(c2066,o)
    & card(c2066,cons(x_constant,cons(int1,nil)))
    & etype(c2066,int1)
    & fact(c2066,real)
    & gener(c2066,gener_c)
    & quant(c2066,mult)
    & refer(c2066,indet)
    & varia(c2066,varia_c)
    & sort(foveon_0,fe)
    & sort(c2070,o)
    & card(c2070,int1)
    & etype(c2070,int0)
    & fact(c2070,real)
    & gener(c2070,gener_c)
    & quant(c2070,one)
    & refer(c2070,refer_c)
    & varia(c2070,varia_c)
    & sort(direkt_2_1,o)
    & card(direkt_2_1,int1)
    & etype(direkt_2_1,int0)
    & fact(direkt_2_1,real)
    & gener(direkt_2_1,ge)
    & quant(direkt_2_1,one)
    & refer(direkt_2_1,refer_c)
    & varia(direkt_2_1,varia_c)
    & sort(c2075,d)
    & card(c2075,int1)
    & etype(c2075,int0)
    & fact(c2075,real)
    & gener(c2075,gener_c)
    & quant(c2075,one)
    & refer(c2075,refer_c)
    & varia(c2075,varia_c)
    & sort(c2082,io)
    & card(c2082,int1)
    & etype(c2082,int0)
    & fact(c2082,real)
    & gener(c2082,sp)
    & quant(c2082,one)
    & refer(c2082,det)
    & varia(c2082,con)
    & sort(digitalphotographie_2_1,io)
    & card(digitalphotographie_2_1,int1)
    & etype(digitalphotographie_2_1,int0)
    & fact(digitalphotographie_2_1,real)
    & gener(digitalphotographie_2_1,ge)
    & quant(digitalphotographie_2_1,one)
    & refer(digitalphotographie_2_1,refer_c)
    & varia(digitalphotographie_2_1,varia_c)
    & sort(c2101,ent)
    & card(c2101,card_c)
    & etype(c2101,etype_c)
    & fact(c2101,real)
    & gener(c2101,gener_c)
    & quant(c2101,quant_c)
    & refer(c2101,refer_c)
    & varia(c2101,varia_c)
    & sort(digital_1_1,tq)
    & sort(photographie_2_1,io)
    & card(photographie_2_1,int1)
    & etype(photographie_2_1,int0)
    & fact(photographie_2_1,real)
    & gener(photographie_2_1,ge)
    & quant(photographie_2_1,one)
    & refer(photographie_2_1,refer_c)
    & varia(photographie_2_1,varia_c) ) ).

%------------------------------------------------------------------------------
