%------------------------------------------------------------------------------
% File     : CSR115+66 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_wp_475_a19984_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.40 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.21 v7.5.0, 0.29 v7.4.0, 0.25 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.23 v6.2.0, 0.36 v6.1.0, 0.44 v6.0.0, 0.50 v5.4.0, 0.48 v5.3.0, 0.52 v5.2.0, 0.36 v5.0.0, 0.40 v4.1.0, 0.50 v4.0.1, 0.53 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10836 (   0 equ)
%            Maximal formula atoms :  127 (   1 avg)
%            Number of connectives :  647 (   0   ~;  18   |; 503   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  127 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   86 (  86 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16650 (16650 usr;16649 con; 0-2 aty)
%            Number of variables   :  475 ( 405   !;  70   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_wp_475_a19984,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6] :
      ( agt(X3,X2)
      & attr(X2,X1)
      & attr(X4,X5)
      & has_card_leq(X6,int1994)
      & sub(X0,firma_1_1)
      & sub(X1,name_1_1)
      & sub(X5,jahr__1_1)
      & subs(X3,n374bernehmen_1_1)
      & temp(X3,X4)
      & val(X1,bmw_0)
      & val(X5,X6) ) ).

fof(ave07_era5_synth_qa07_007_mira_wp_475_a19984,hypothesis,
    ( assoc(autobauer_1_1,automobil_1_1)
    & sub(autobauer_1_1,fabrikant_1_1)
    & attr(c103,c104)
    & prop(c103,britisch__1_1)
    & sub(c103,autobauer_1_1)
    & sub(c104,name_1_1)
    & val(c104,rover_0)
    & agt(c3,c86)
    & obj(c3,c103)
    & subs(c3,n374bernehmen_1_1)
    & temp(c3,c4)
    & attr(c4,c5)
    & sub(c5,jahr__1_1)
    & val(c5,c1)
    & attr(c86,c87)
    & sub(c86,firma_1_1)
    & sub(c87,name_1_1)
    & val(c87,bmw_0)
    & sort(autobauer_1_1,d)
    & sort(autobauer_1_1,io)
    & card(autobauer_1_1,int1)
    & etype(autobauer_1_1,int0)
    & fact(autobauer_1_1,real)
    & gener(autobauer_1_1,ge)
    & quant(autobauer_1_1,one)
    & refer(autobauer_1_1,refer_c)
    & varia(autobauer_1_1,varia_c)
    & sort(automobil_1_1,tq)
    & sort(fabrikant_1_1,d)
    & sort(fabrikant_1_1,io)
    & card(fabrikant_1_1,int1)
    & etype(fabrikant_1_1,int0)
    & fact(fabrikant_1_1,real)
    & gener(fabrikant_1_1,ge)
    & quant(fabrikant_1_1,one)
    & refer(fabrikant_1_1,refer_c)
    & varia(fabrikant_1_1,varia_c)
    & sort(c103,d)
    & sort(c103,io)
    & card(c103,int1)
    & etype(c103,int0)
    & fact(c103,real)
    & gener(c103,sp)
    & quant(c103,one)
    & refer(c103,det)
    & varia(c103,con)
    & sort(c104,na)
    & card(c104,int1)
    & etype(c104,int0)
    & fact(c104,real)
    & gener(c104,sp)
    & quant(c104,one)
    & refer(c104,indet)
    & varia(c104,varia_c)
    & sort(britisch__1_1,nq)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(rover_0,fe)
    & sort(c3,da)
    & fact(c3,real)
    & gener(c3,sp)
    & sort(c86,d)
    & sort(c86,io)
    & card(c86,int1)
    & etype(c86,int0)
    & fact(c86,real)
    & gener(c86,sp)
    & quant(c86,one)
    & refer(c86,det)
    & varia(c86,con)
    & sort(n374bernehmen_1_1,da)
    & fact(n374bernehmen_1_1,real)
    & gener(n374bernehmen_1_1,ge)
    & sort(c4,t)
    & card(c4,int1)
    & etype(c4,int0)
    & fact(c4,real)
    & gener(c4,sp)
    & quant(c4,one)
    & refer(c4,det)
    & varia(c4,con)
    & sort(c5,me)
    & sort(c5,oa)
    & sort(c5,ta)
    & card(c5,card_c)
    & etype(c5,etype_c)
    & fact(c5,real)
    & gener(c5,sp)
    & quant(c5,quant_c)
    & refer(c5,refer_c)
    & varia(c5,varia_c)
    & sort(jahr__1_1,me)
    & sort(jahr__1_1,oa)
    & sort(jahr__1_1,ta)
    & card(jahr__1_1,card_c)
    & etype(jahr__1_1,etype_c)
    & fact(jahr__1_1,real)
    & gener(jahr__1_1,ge)
    & quant(jahr__1_1,quant_c)
    & refer(jahr__1_1,refer_c)
    & varia(jahr__1_1,varia_c)
    & sort(c1,nu)
    & card(c1,int1994)
    & sort(c87,na)
    & card(c87,int1)
    & etype(c87,int0)
    & fact(c87,real)
    & gener(c87,sp)
    & quant(c87,one)
    & refer(c87,indet)
    & varia(c87,varia_c)
    & sort(firma_1_1,d)
    & sort(firma_1_1,io)
    & card(firma_1_1,int1)
    & etype(firma_1_1,int0)
    & fact(firma_1_1,real)
    & gener(firma_1_1,ge)
    & quant(firma_1_1,one)
    & refer(firma_1_1,refer_c)
    & varia(firma_1_1,varia_c)
    & sort(bmw_0,fe) ) ).

%------------------------------------------------------------------------------
