%------------------------------------------------------------------------------
% File     : CSR115+65 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_wp_474_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.40 v9.0.0, 0.25 v8.2.0, 0.27 v8.1.0, 0.29 v7.5.0, 0.38 v7.4.0, 0.31 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.31 v6.2.0, 0.45 v6.1.0, 0.48 v6.0.0, 0.50 v5.5.0, 0.46 v5.4.0, 0.43 v5.2.0, 0.36 v5.0.0, 0.40 v4.1.0, 0.50 v4.0.1, 0.42 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 11030 (   0 equ)
%            Maximal formula atoms :  328 (   1 avg)
%            Number of connectives :  841 (   0   ~;  18   |; 697   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  328 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-17 aty)
%            Number of functors    : 16678 (16678 usr;16677 con; 0-2 aty)
%            Number of variables   :  475 ( 405   !;  70   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_wp_474,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6] :
      ( attr(X0,X1)
      & attr(X3,X2)
      & attr(X5,X6)
      & obj(X4,X0) ) ).

fof(ave07_era5_synth_qa07_007_mira_wp_474,hypothesis,
    ( sub(c34818,limousine_1_1)
    & pred(c34823,einla__337_1_1)
    & pred(c34837,einla__337_1_1)
    & sub(c34846,cabrio__1_1)
    & sub(c34855,roadster_1_1)
    & sub(c34864,kombi__1_1)
    & sub(c34881,cabriovariante_1_1)
    & sub(c34888,artefakt_1_1)
    & sub(c34895,bmw_1_1)
    & pred(c34906,e30_1_1)
    & prop(c34914,klein_1_1)
    & sub(c34914,st__374ckzahl_1_1)
    & sub(c34920,firma_1_1)
    & attr(c34925,c34926)
    & sub(c34925,mensch_1_1)
    & sub(c34926,familiename_1_1)
    & val(c34926,baur_0)
    & sub(c34937,bmw_1_1)
    & sub(c34941,h__344ndlernetz_1_1)
    & tupl_p17(c34978,c34818,c34823,c34837,c34846,c34855,c34864,c34881,c34888,c34895,c34906,c34914,c34920,c34925,c34846,c34937,c34941)
    & assoc(cabriovariante_1_1,cabrio__1_1)
    & sub(cabriovariante_1_1,spielart_1_1)
    & assoc(h__344ndlernetz_1_1,anbieter_1_1)
    & sub(h__344ndlernetz_1_1,netz_1_1)
    & assoc(st__374ckzahl_1_1,st__374ck_2_1)
    & sub(st__374ckzahl_1_1,zahl_1_1)
    & sort(c34818,d)
    & card(c34818,int1)
    & etype(c34818,int0)
    & fact(c34818,real)
    & gener(c34818,gener_c)
    & quant(c34818,one)
    & refer(c34818,refer_c)
    & varia(c34818,varia_c)
    & sort(limousine_1_1,d)
    & card(limousine_1_1,int1)
    & etype(limousine_1_1,int0)
    & fact(limousine_1_1,real)
    & gener(limousine_1_1,ge)
    & quant(limousine_1_1,one)
    & refer(limousine_1_1,refer_c)
    & varia(limousine_1_1,varia_c)
    & sort(c34823,d)
    & card(c34823,int2)
    & etype(c34823,int1)
    & fact(c34823,real)
    & gener(c34823,gener_c)
    & quant(c34823,nfquant)
    & refer(c34823,refer_c)
    & varia(c34823,varia_c)
    & sort(einla__337_1_1,d)
    & card(einla__337_1_1,int1)
    & etype(einla__337_1_1,int0)
    & fact(einla__337_1_1,real)
    & gener(einla__337_1_1,ge)
    & quant(einla__337_1_1,one)
    & refer(einla__337_1_1,refer_c)
    & varia(einla__337_1_1,varia_c)
    & sort(c34837,d)
    & card(c34837,int4)
    & etype(c34837,int1)
    & fact(c34837,real)
    & gener(c34837,gener_c)
    & quant(c34837,nfquant)
    & refer(c34837,refer_c)
    & varia(c34837,varia_c)
    & sort(c34846,d)
    & card(c34846,int1)
    & etype(c34846,int0)
    & fact(c34846,real)
    & gener(c34846,gener_c)
    & quant(c34846,one)
    & refer(c34846,refer_c)
    & varia(c34846,varia_c)
    & sort(cabrio__1_1,d)
    & card(cabrio__1_1,int1)
    & etype(cabrio__1_1,int0)
    & fact(cabrio__1_1,real)
    & gener(cabrio__1_1,ge)
    & quant(cabrio__1_1,one)
    & refer(cabrio__1_1,refer_c)
    & varia(cabrio__1_1,varia_c)
    & sort(c34855,d)
    & card(c34855,int1)
    & etype(c34855,int0)
    & fact(c34855,real)
    & gener(c34855,gener_c)
    & quant(c34855,one)
    & refer(c34855,refer_c)
    & varia(c34855,varia_c)
    & sort(roadster_1_1,d)
    & card(roadster_1_1,int1)
    & etype(roadster_1_1,int0)
    & fact(roadster_1_1,real)
    & gener(roadster_1_1,ge)
    & quant(roadster_1_1,one)
    & refer(roadster_1_1,refer_c)
    & varia(roadster_1_1,varia_c)
    & sort(c34864,d)
    & card(c34864,int1)
    & etype(c34864,int0)
    & fact(c34864,real)
    & gener(c34864,gener_c)
    & quant(c34864,one)
    & refer(c34864,refer_c)
    & varia(c34864,varia_c)
    & sort(kombi__1_1,d)
    & card(kombi__1_1,int1)
    & etype(kombi__1_1,int0)
    & fact(kombi__1_1,real)
    & gener(kombi__1_1,ge)
    & quant(kombi__1_1,one)
    & refer(kombi__1_1,refer_c)
    & varia(kombi__1_1,varia_c)
    & sort(c34881,io)
    & sort(c34881,re)
    & card(c34881,int1)
    & etype(c34881,int0)
    & fact(c34881,real)
    & gener(c34881,sp)
    & quant(c34881,one)
    & refer(c34881,det)
    & varia(c34881,con)
    & sort(cabriovariante_1_1,io)
    & sort(cabriovariante_1_1,re)
    & card(cabriovariante_1_1,int1)
    & etype(cabriovariante_1_1,int0)
    & fact(cabriovariante_1_1,real)
    & gener(cabriovariante_1_1,ge)
    & quant(cabriovariante_1_1,one)
    & refer(cabriovariante_1_1,refer_c)
    & varia(cabriovariante_1_1,varia_c)
    & sort(c34888,d)
    & sort(c34888,io)
    & card(c34888,int1)
    & etype(c34888,int0)
    & fact(c34888,real)
    & gener(c34888,gener_c)
    & quant(c34888,one)
    & refer(c34888,refer_c)
    & varia(c34888,varia_c)
    & sort(artefakt_1_1,d)
    & sort(artefakt_1_1,io)
    & card(artefakt_1_1,int1)
    & etype(artefakt_1_1,int0)
    & fact(artefakt_1_1,real)
    & gener(artefakt_1_1,ge)
    & quant(artefakt_1_1,one)
    & refer(artefakt_1_1,refer_c)
    & varia(artefakt_1_1,varia_c)
    & sort(c34895,d)
    & card(c34895,int1)
    & etype(c34895,int0)
    & fact(c34895,real)
    & gener(c34895,sp)
    & quant(c34895,one)
    & refer(c34895,det)
    & varia(c34895,con)
    & sort(bmw_1_1,d)
    & card(bmw_1_1,int1)
    & etype(bmw_1_1,int0)
    & fact(bmw_1_1,real)
    & gener(bmw_1_1,ge)
    & quant(bmw_1_1,one)
    & refer(bmw_1_1,refer_c)
    & varia(bmw_1_1,varia_c)
    & sort(c34906,o)
    & card(c34906,cons(x_constant,cons(int1,nil)))
    & etype(c34906,int1)
    & fact(c34906,real)
    & gener(c34906,gener_c)
    & quant(c34906,mult)
    & refer(c34906,indet)
    & varia(c34906,varia_c)
    & sort(e30_1_1,o)
    & card(e30_1_1,int1)
    & etype(e30_1_1,int0)
    & fact(e30_1_1,real)
    & gener(e30_1_1,ge)
    & quant(e30_1_1,one)
    & refer(e30_1_1,refer_c)
    & varia(e30_1_1,varia_c)
    & sort(c34914,io)
    & sort(c34914,oa)
    & card(c34914,int1)
    & etype(c34914,int0)
    & fact(c34914,real)
    & gener(c34914,gener_c)
    & quant(c34914,one)
    & refer(c34914,refer_c)
    & varia(c34914,varia_c)
    & sort(klein_1_1,mq)
    & sort(st__374ckzahl_1_1,io)
    & sort(st__374ckzahl_1_1,oa)
    & card(st__374ckzahl_1_1,int1)
    & etype(st__374ckzahl_1_1,int0)
    & fact(st__374ckzahl_1_1,real)
    & gener(st__374ckzahl_1_1,ge)
    & quant(st__374ckzahl_1_1,one)
    & refer(st__374ckzahl_1_1,refer_c)
    & varia(st__374ckzahl_1_1,varia_c)
    & sort(c34920,d)
    & sort(c34920,io)
    & card(c34920,int1)
    & etype(c34920,int0)
    & fact(c34920,real)
    & gener(c34920,sp)
    & quant(c34920,one)
    & refer(c34920,det)
    & varia(c34920,con)
    & sort(firma_1_1,d)
    & sort(firma_1_1,io)
    & card(firma_1_1,int1)
    & etype(firma_1_1,int0)
    & fact(firma_1_1,real)
    & gener(firma_1_1,ge)
    & quant(firma_1_1,one)
    & refer(firma_1_1,refer_c)
    & varia(firma_1_1,varia_c)
    & sort(c34925,d)
    & card(c34925,int1)
    & etype(c34925,int0)
    & fact(c34925,real)
    & gener(c34925,sp)
    & quant(c34925,one)
    & refer(c34925,det)
    & varia(c34925,con)
    & sort(c34926,na)
    & card(c34926,int1)
    & etype(c34926,int0)
    & fact(c34926,real)
    & gener(c34926,sp)
    & quant(c34926,one)
    & refer(c34926,indet)
    & varia(c34926,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(baur_0,fe)
    & sort(c34937,d)
    & card(c34937,int1)
    & etype(c34937,int0)
    & fact(c34937,real)
    & gener(c34937,sp)
    & quant(c34937,one)
    & refer(c34937,det)
    & varia(c34937,con)
    & sort(c34941,d)
    & card(c34941,int1)
    & etype(c34941,int0)
    & fact(c34941,real)
    & gener(c34941,gener_c)
    & quant(c34941,one)
    & refer(c34941,refer_c)
    & varia(c34941,varia_c)
    & sort(h__344ndlernetz_1_1,d)
    & card(h__344ndlernetz_1_1,int1)
    & etype(h__344ndlernetz_1_1,int0)
    & fact(h__344ndlernetz_1_1,real)
    & gener(h__344ndlernetz_1_1,ge)
    & quant(h__344ndlernetz_1_1,one)
    & refer(h__344ndlernetz_1_1,refer_c)
    & varia(h__344ndlernetz_1_1,varia_c)
    & sort(c34978,ent)
    & card(c34978,card_c)
    & etype(c34978,etype_c)
    & fact(c34978,real)
    & gener(c34978,gener_c)
    & quant(c34978,quant_c)
    & refer(c34978,refer_c)
    & varia(c34978,varia_c)
    & sort(spielart_1_1,io)
    & sort(spielart_1_1,re)
    & card(spielart_1_1,int1)
    & etype(spielart_1_1,int0)
    & fact(spielart_1_1,real)
    & gener(spielart_1_1,ge)
    & quant(spielart_1_1,one)
    & refer(spielart_1_1,refer_c)
    & varia(spielart_1_1,varia_c)
    & sort(anbieter_1_1,d)
    & sort(anbieter_1_1,io)
    & card(anbieter_1_1,int1)
    & etype(anbieter_1_1,int0)
    & fact(anbieter_1_1,real)
    & gener(anbieter_1_1,ge)
    & quant(anbieter_1_1,one)
    & refer(anbieter_1_1,refer_c)
    & varia(anbieter_1_1,varia_c)
    & sort(netz_1_1,d)
    & card(netz_1_1,int1)
    & etype(netz_1_1,int0)
    & fact(netz_1_1,real)
    & gener(netz_1_1,ge)
    & quant(netz_1_1,one)
    & refer(netz_1_1,refer_c)
    & varia(netz_1_1,varia_c)
    & sort(st__374ck_2_1,d)
    & sort(st__374ck_2_1,io)
    & card(st__374ck_2_1,int1)
    & etype(st__374ck_2_1,int0)
    & fact(st__374ck_2_1,real)
    & gener(st__374ck_2_1,ge)
    & quant(st__374ck_2_1,one)
    & refer(st__374ck_2_1,refer_c)
    & varia(st__374ck_2_1,varia_c)
    & sort(zahl_1_1,io)
    & sort(zahl_1_1,oa)
    & card(zahl_1_1,int1)
    & etype(zahl_1_1,int0)
    & fact(zahl_1_1,real)
    & gener(zahl_1_1,ge)
    & quant(zahl_1_1,one)
    & refer(zahl_1_1,refer_c)
    & varia(zahl_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
