%------------------------------------------------------------------------------
% File     : CSR115+62 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_wp_469_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.33 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.21 v7.5.0, 0.33 v7.4.0, 0.31 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.23 v6.2.0, 0.36 v6.1.0, 0.48 v6.0.0, 0.50 v5.4.0, 0.48 v5.2.0, 0.36 v5.0.0, 0.40 v4.1.0, 0.50 v4.0.1, 0.53 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10871 (   0 equ)
%            Maximal formula atoms :  159 (   1 avg)
%            Number of connectives :  682 (   0   ~;  18   |; 538   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  159 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   86 (  86 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16655 (16655 usr;16654 con; 0-2 aty)
%            Number of variables   :  476 ( 405   !;  71   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_wp_469,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7] :
      ( agt(X4,X3)
      & attr(X0,X1)
      & attr(X3,X2)
      & attr(X5,X6)
      & has_card_leq(X7,int1994)
      & sub(X1,name_1_1)
      & sub(X0,firma_1_1)
      & sub(X2,name_1_1)
      & sub(X6,jahr__1_1)
      & subs(X4,n374bernehmen_1_1)
      & temp(X4,X5)
      & val(X1,bmw_0)
      & val(X2,bmw_0)
      & val(X6,X7) ) ).

fof(ave07_era5_synth_qa07_007_mira_wp_469,hypothesis,
    ( sub(c12,eisenbahn__1_1)
    & agt(c126,c128)
    & loc(c126,c132)
    & obj(c126,c26)
    & subs(c126,n374bernehmen_1_1)
    & temp(c126,c7)
    & attr(c128,c129)
    & sub(c128,firma_1_1)
    & sub(c129,name_1_1)
    & val(c129,bmw_0)
    & in(c132,c12)
    & aff(c16,c22)
    & attch(c16,c12)
    & subs(c16,deregulation_1_1)
    & pred(c22,unternehmen_1_1)
    & prop(c22,staatlich__1_1)
    & sub(c26,firma_1_1)
    & attr(c7,c8)
    & sub(c8,jahr__1_1)
    & val(c8,c4)
    & sort(c12,d)
    & card(c12,int1)
    & etype(c12,int0)
    & fact(c12,real)
    & gener(c12,sp)
    & quant(c12,one)
    & refer(c12,det)
    & varia(c12,con)
    & sort(eisenbahn__1_1,d)
    & card(eisenbahn__1_1,int1)
    & etype(eisenbahn__1_1,int0)
    & fact(eisenbahn__1_1,real)
    & gener(eisenbahn__1_1,ge)
    & quant(eisenbahn__1_1,one)
    & refer(eisenbahn__1_1,refer_c)
    & varia(eisenbahn__1_1,varia_c)
    & sort(c126,da)
    & fact(c126,real)
    & gener(c126,sp)
    & sort(c128,d)
    & sort(c128,io)
    & card(c128,int1)
    & etype(c128,int0)
    & fact(c128,real)
    & gener(c128,sp)
    & quant(c128,one)
    & refer(c128,det)
    & varia(c128,con)
    & sort(c132,l)
    & card(c132,int1)
    & etype(c132,int0)
    & fact(c132,real)
    & gener(c132,sp)
    & quant(c132,one)
    & refer(c132,det)
    & varia(c132,con)
    & sort(c26,d)
    & sort(c26,io)
    & card(c26,int1)
    & etype(c26,int0)
    & fact(c26,real)
    & gener(c26,sp)
    & quant(c26,one)
    & refer(c26,det)
    & varia(c26,con)
    & sort(n374bernehmen_1_1,da)
    & fact(n374bernehmen_1_1,real)
    & gener(n374bernehmen_1_1,ge)
    & sort(c7,t)
    & card(c7,int1)
    & etype(c7,int0)
    & fact(c7,real)
    & gener(c7,sp)
    & quant(c7,one)
    & refer(c7,det)
    & varia(c7,con)
    & sort(c129,na)
    & card(c129,int1)
    & etype(c129,int0)
    & fact(c129,real)
    & gener(c129,sp)
    & quant(c129,one)
    & refer(c129,indet)
    & varia(c129,varia_c)
    & sort(firma_1_1,d)
    & sort(firma_1_1,io)
    & card(firma_1_1,int1)
    & etype(firma_1_1,int0)
    & fact(firma_1_1,real)
    & gener(firma_1_1,ge)
    & quant(firma_1_1,one)
    & refer(firma_1_1,refer_c)
    & varia(firma_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(bmw_0,fe)
    & sort(c16,ad)
    & card(c16,int1)
    & etype(c16,int0)
    & fact(c16,real)
    & gener(c16,sp)
    & quant(c16,one)
    & refer(c16,det)
    & varia(c16,con)
    & sort(c22,d)
    & sort(c22,io)
    & card(c22,cons(x_constant,cons(int1,nil)))
    & etype(c22,int1)
    & fact(c22,real)
    & gener(c22,sp)
    & quant(c22,mult)
    & refer(c22,indet)
    & varia(c22,varia_c)
    & sort(deregulation_1_1,ad)
    & card(deregulation_1_1,int1)
    & etype(deregulation_1_1,int0)
    & fact(deregulation_1_1,real)
    & gener(deregulation_1_1,ge)
    & quant(deregulation_1_1,one)
    & refer(deregulation_1_1,refer_c)
    & varia(deregulation_1_1,varia_c)
    & sort(unternehmen_1_1,d)
    & sort(unternehmen_1_1,io)
    & card(unternehmen_1_1,int1)
    & etype(unternehmen_1_1,int0)
    & fact(unternehmen_1_1,real)
    & gener(unternehmen_1_1,ge)
    & quant(unternehmen_1_1,one)
    & refer(unternehmen_1_1,refer_c)
    & varia(unternehmen_1_1,varia_c)
    & sort(staatlich__1_1,tq)
    & sort(c8,me)
    & sort(c8,oa)
    & sort(c8,ta)
    & card(c8,card_c)
    & etype(c8,etype_c)
    & fact(c8,real)
    & gener(c8,sp)
    & quant(c8,quant_c)
    & refer(c8,refer_c)
    & varia(c8,varia_c)
    & sort(jahr__1_1,me)
    & sort(jahr__1_1,oa)
    & sort(jahr__1_1,ta)
    & card(jahr__1_1,card_c)
    & etype(jahr__1_1,etype_c)
    & fact(jahr__1_1,real)
    & gener(jahr__1_1,ge)
    & quant(jahr__1_1,quant_c)
    & refer(jahr__1_1,refer_c)
    & varia(jahr__1_1,varia_c)
    & sort(c4,nu)
    & card(c4,int1994) ) ).

%------------------------------------------------------------------------------
