%------------------------------------------------------------------------------
% File     : CSR115+61 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_news_1334_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.40 v9.0.0, 0.25 v8.2.0, 0.27 v8.1.0, 0.29 v7.5.0, 0.38 v7.4.0, 0.31 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.31 v6.2.0, 0.45 v6.1.0, 0.60 v6.0.0, 0.50 v5.5.0, 0.54 v5.4.0, 0.52 v5.3.0, 0.61 v5.2.0, 0.43 v5.0.0, 0.45 v4.1.0, 0.50 v4.0.1, 0.53 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10854 (   0 equ)
%            Maximal formula atoms :  147 (   1 avg)
%            Number of connectives :  665 (   0   ~;  18   |; 521   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  147 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   88 (  88 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16655 (16655 usr;16654 con; 0-2 aty)
%            Number of variables   :  475 ( 405   !;  70   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_news_1334,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6] :
      ( attr(X0,X1)
      & attr(X3,X2)
      & attr(X5,X6)
      & obj(X4,X0)
      & sub(X1,name_1_1)
      & sub(X0,firma_1_1)
      & sub(X2,name_1_1)
      & val(X1,bmw_0)
      & val(X2,bmw_0) ) ).

fof(ave07_era5_synth_qa07_007_mira_news_1334,hypothesis,
    ( attr(c11682,c11683)
    & sub(c11682,firma_1_1)
    & sub(c11683,name_1_1)
    & val(c11683,bmw_0)
    & prop(c11687,britisch__1_1)
    & sub(c11687,marke_1_1)
    & agt(c11873,c11965)
    & benf(c11873,c11682)
    & obj(c11873,c11687)
    & subs(c11873,nehmen_1_7)
    & attr(c11965,c11966)
    & sub(c11965,firma_1_1)
    & sub(c11966,name_1_1)
    & val(c11966,rover_0)
    & modl(c11981,so_1_1)
    & scar(c11981,c11682)
    & semrel(c11981,c11873)
    & subs(c11981,befinden_1_2)
    & temp(c11981,bald_1_1)
    & temp(c11981,future_0)
    & temp(c11981,re_1_1)
    & modl(c5,so_1_1)
    & scar(c5,c10386)
    & subs(c5,befinden_1_2)
    & temp(c5,c11873)
    & sort(c11682,d)
    & sort(c11682,io)
    & card(c11682,int1)
    & etype(c11682,int0)
    & fact(c11682,real)
    & gener(c11682,sp)
    & quant(c11682,one)
    & refer(c11682,det)
    & varia(c11682,con)
    & sort(c11683,na)
    & card(c11683,int1)
    & etype(c11683,int0)
    & fact(c11683,real)
    & gener(c11683,sp)
    & quant(c11683,one)
    & refer(c11683,indet)
    & varia(c11683,varia_c)
    & sort(firma_1_1,d)
    & sort(firma_1_1,io)
    & card(firma_1_1,int1)
    & etype(firma_1_1,int0)
    & fact(firma_1_1,real)
    & gener(firma_1_1,ge)
    & quant(firma_1_1,one)
    & refer(firma_1_1,refer_c)
    & varia(firma_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(bmw_0,fe)
    & sort(c11687,io)
    & sort(c11687,oa)
    & card(c11687,int1)
    & etype(c11687,int0)
    & fact(c11687,real)
    & gener(c11687,sp)
    & quant(c11687,one)
    & refer(c11687,det)
    & varia(c11687,con)
    & sort(britisch__1_1,nq)
    & sort(marke_1_1,io)
    & sort(marke_1_1,oa)
    & card(marke_1_1,int1)
    & etype(marke_1_1,int0)
    & fact(marke_1_1,real)
    & gener(marke_1_1,ge)
    & quant(marke_1_1,one)
    & refer(marke_1_1,refer_c)
    & varia(marke_1_1,varia_c)
    & sort(c11873,da)
    & fact(c11873,real)
    & gener(c11873,sp)
    & sort(c11965,d)
    & sort(c11965,io)
    & card(c11965,int1)
    & etype(c11965,int0)
    & fact(c11965,real)
    & gener(c11965,sp)
    & quant(c11965,one)
    & refer(c11965,det)
    & varia(c11965,con)
    & sort(nehmen_1_7,da)
    & fact(nehmen_1_7,real)
    & gener(nehmen_1_7,ge)
    & sort(c11966,na)
    & card(c11966,int1)
    & etype(c11966,int0)
    & fact(c11966,real)
    & gener(c11966,sp)
    & quant(c11966,one)
    & refer(c11966,indet)
    & varia(c11966,varia_c)
    & sort(rover_0,fe)
    & sort(c11981,st)
    & fact(c11981,real)
    & gener(c11981,sp)
    & sort(so_1_1,md)
    & fact(so_1_1,real)
    & gener(so_1_1,gener_c)
    & sort(befinden_1_2,st)
    & fact(befinden_1_2,real)
    & gener(befinden_1_2,ge)
    & sort(bald_1_1,t)
    & card(bald_1_1,int1)
    & etype(bald_1_1,int0)
    & fact(bald_1_1,real)
    & gener(bald_1_1,sp)
    & quant(bald_1_1,one)
    & refer(bald_1_1,refer_c)
    & varia(bald_1_1,varia_c)
    & sort(future_0,t)
    & card(future_0,int1)
    & etype(future_0,int0)
    & fact(future_0,real)
    & gener(future_0,sp)
    & quant(future_0,one)
    & refer(future_0,refer_c)
    & varia(future_0,varia_c)
    & sort(re_1_1,t)
    & card(re_1_1,int1)
    & etype(re_1_1,int0)
    & fact(re_1_1,real)
    & gener(re_1_1,sp)
    & quant(re_1_1,one)
    & refer(re_1_1,refer_c)
    & varia(re_1_1,varia_c)
    & sort(c5,st)
    & fact(c5,real)
    & gener(c5,sp)
    & sort(c10386,co)
    & card(c10386,card_c)
    & etype(c10386,etype_c)
    & fact(c10386,real)
    & gener(c10386,sp)
    & quant(c10386,quant_c)
    & refer(c10386,det)
    & varia(c10386,varia_c) ) ).

%------------------------------------------------------------------------------
