%------------------------------------------------------------------------------
% File     : CSR115+6 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_news_1094_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.33 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.21 v7.5.0, 0.33 v7.4.0, 0.25 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.36 v6.4.0, 0.29 v6.3.0, 0.31 v6.2.0, 0.45 v6.1.0, 0.60 v6.0.0, 0.50 v5.5.0, 0.58 v5.4.0, 0.57 v5.3.0, 0.61 v5.2.0, 0.36 v5.0.0, 0.50 v4.1.0, 0.61 v4.0.1, 0.58 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 11047 (   0 equ)
%            Maximal formula atoms :  341 (   1 avg)
%            Number of connectives :  858 (   0   ~;  18   |; 714   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  341 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-8 aty)
%            Number of functors    : 16672 (16672 usr;16671 con; 0-2 aty)
%            Number of variables   :  475 ( 405   !;  70   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_news_1094,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6] :
      ( attr(X0,X1)
      & attr(X3,X2)
      & attr(X5,X6)
      & obj(X4,X0)
      & sub(X1,name_1_1)
      & sub(X2,name_1_1)
      & val(X1,bmw_0)
      & val(X2,bmw_0) ) ).

fof(ave07_era5_synth_qa07_007_mira_news_1094,hypothesis,
    ( assoc(autokonzern_1_1,auto__1_1)
    & sub(autokonzern_1_1,firmengruppe_1_1)
    & attr(c18,c19)
    & sub(c18,stadt__1_1)
    & sub(c19,name_1_1)
    & val(c19,london_0)
    & sub(c21,feb_1_1)
    & tupl(c34,c18,c21)
    & attr(c55667,c55668)
    & prop(c55667,bundesdeutsch_1_1)
    & sub(c55667,autokonzern_1_1)
    & sub(c55668,name_1_1)
    & val(c55668,bmw_0)
    & prop(c55687,pass__351_1_1)
    & sub(c55687,woche_1_1)
    & subs(c55693,ankauf__1_1)
    & attch(c55986,c55693)
    & attr(c55986,c55987)
    & prop(c55986,britisch__1_1)
    & sub(c55986,firma_1_1)
    & sub(c55987,name_1_1)
    & val(c55987,rover_0)
    & subs(c55995,interesse_1_1)
    & subs(c55999,ankauf__1_1)
    & attch(c56008,c55999)
    & prop(c56008,britisch__1_1)
    & sub(c56008,luxusmarke_1_1)
    & attr(c56019,c56008)
    & attr(c56019,c56020)
    & sub(c56019,mensch_1_1)
    & sub(c56020,familiename_1_1)
    & val(c56020,roll_0)
    & attr(c56024,c56025)
    & sub(c56024,mensch_1_1)
    & sub(c56025,eigenname_1_1)
    & val(c56025,royce_0)
    & tupl_p8(c56046,c55667,c55669,c55687,c55693,c55995,c55999,c56024)
    & assoc(luxusmarke_1_1,luxus__1_1)
    & sub(luxusmarke_1_1,marke_1_1)
    & sort(autokonzern_1_1,d)
    & sort(autokonzern_1_1,io)
    & card(autokonzern_1_1,int1)
    & etype(autokonzern_1_1,int0)
    & fact(autokonzern_1_1,real)
    & gener(autokonzern_1_1,ge)
    & quant(autokonzern_1_1,one)
    & refer(autokonzern_1_1,refer_c)
    & varia(autokonzern_1_1,varia_c)
    & sort(auto__1_1,d)
    & card(auto__1_1,int1)
    & etype(auto__1_1,int0)
    & fact(auto__1_1,real)
    & gener(auto__1_1,ge)
    & quant(auto__1_1,one)
    & refer(auto__1_1,refer_c)
    & varia(auto__1_1,varia_c)
    & sort(firmengruppe_1_1,d)
    & sort(firmengruppe_1_1,io)
    & card(firmengruppe_1_1,int1)
    & etype(firmengruppe_1_1,int0)
    & fact(firmengruppe_1_1,real)
    & gener(firmengruppe_1_1,ge)
    & quant(firmengruppe_1_1,one)
    & refer(firmengruppe_1_1,refer_c)
    & varia(firmengruppe_1_1,varia_c)
    & sort(c18,d)
    & sort(c18,io)
    & card(c18,int1)
    & etype(c18,int0)
    & fact(c18,real)
    & gener(c18,sp)
    & quant(c18,one)
    & refer(c18,det)
    & varia(c18,con)
    & sort(c19,na)
    & card(c19,int1)
    & etype(c19,int0)
    & fact(c19,real)
    & gener(c19,sp)
    & quant(c19,one)
    & refer(c19,indet)
    & varia(c19,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(london_0,fe)
    & sort(c21,o)
    & card(c21,int1)
    & etype(c21,int0)
    & fact(c21,real)
    & gener(c21,gener_c)
    & quant(c21,one)
    & refer(c21,refer_c)
    & varia(c21,varia_c)
    & sort(feb_1_1,o)
    & card(feb_1_1,int1)
    & etype(feb_1_1,int0)
    & fact(feb_1_1,real)
    & gener(feb_1_1,ge)
    & quant(feb_1_1,one)
    & refer(feb_1_1,refer_c)
    & varia(feb_1_1,varia_c)
    & sort(c34,ent)
    & card(c34,card_c)
    & etype(c34,etype_c)
    & fact(c34,real)
    & gener(c34,gener_c)
    & quant(c34,quant_c)
    & refer(c34,refer_c)
    & varia(c34,varia_c)
    & sort(c55667,d)
    & sort(c55667,io)
    & card(c55667,int1)
    & etype(c55667,int0)
    & fact(c55667,real)
    & gener(c55667,sp)
    & quant(c55667,one)
    & refer(c55667,det)
    & varia(c55667,con)
    & sort(c55668,na)
    & card(c55668,int1)
    & etype(c55668,int0)
    & fact(c55668,real)
    & gener(c55668,sp)
    & quant(c55668,one)
    & refer(c55668,indet)
    & varia(c55668,varia_c)
    & sort(bundesdeutsch_1_1,tq)
    & sort(bmw_0,fe)
    & sort(c55687,me)
    & sort(c55687,oa)
    & sort(c55687,ta)
    & card(c55687,card_c)
    & etype(c55687,etype_c)
    & fact(c55687,real)
    & gener(c55687,sp)
    & quant(c55687,quant_c)
    & refer(c55687,det)
    & varia(c55687,con)
    & sort(pass__351_1_1,tq)
    & sort(woche_1_1,me)
    & sort(woche_1_1,oa)
    & sort(woche_1_1,ta)
    & card(woche_1_1,card_c)
    & etype(woche_1_1,etype_c)
    & fact(woche_1_1,real)
    & gener(woche_1_1,ge)
    & quant(woche_1_1,quant_c)
    & refer(woche_1_1,refer_c)
    & varia(woche_1_1,varia_c)
    & sort(c55693,ad)
    & card(c55693,int1)
    & etype(c55693,int0)
    & fact(c55693,real)
    & gener(c55693,sp)
    & quant(c55693,one)
    & refer(c55693,det)
    & varia(c55693,con)
    & sort(ankauf__1_1,ad)
    & card(ankauf__1_1,int1)
    & etype(ankauf__1_1,int0)
    & fact(ankauf__1_1,real)
    & gener(ankauf__1_1,ge)
    & quant(ankauf__1_1,one)
    & refer(ankauf__1_1,refer_c)
    & varia(ankauf__1_1,varia_c)
    & sort(c55986,d)
    & sort(c55986,io)
    & card(c55986,int1)
    & etype(c55986,int0)
    & fact(c55986,real)
    & gener(c55986,sp)
    & quant(c55986,one)
    & refer(c55986,det)
    & varia(c55986,con)
    & sort(c55987,na)
    & card(c55987,int1)
    & etype(c55987,int0)
    & fact(c55987,real)
    & gener(c55987,sp)
    & quant(c55987,one)
    & refer(c55987,indet)
    & varia(c55987,varia_c)
    & sort(britisch__1_1,nq)
    & sort(firma_1_1,d)
    & sort(firma_1_1,io)
    & card(firma_1_1,int1)
    & etype(firma_1_1,int0)
    & fact(firma_1_1,real)
    & gener(firma_1_1,ge)
    & quant(firma_1_1,one)
    & refer(firma_1_1,refer_c)
    & varia(firma_1_1,varia_c)
    & sort(rover_0,fe)
    & sort(c55995,as)
    & card(c55995,int1)
    & etype(c55995,int0)
    & fact(c55995,real)
    & gener(c55995,gener_c)
    & quant(c55995,one)
    & refer(c55995,refer_c)
    & varia(c55995,varia_c)
    & sort(interesse_1_1,as)
    & card(interesse_1_1,int1)
    & etype(interesse_1_1,int0)
    & fact(interesse_1_1,real)
    & gener(interesse_1_1,ge)
    & quant(interesse_1_1,one)
    & refer(interesse_1_1,refer_c)
    & varia(interesse_1_1,varia_c)
    & sort(c55999,ad)
    & card(c55999,int1)
    & etype(c55999,int0)
    & fact(c55999,real)
    & gener(c55999,sp)
    & quant(c55999,one)
    & refer(c55999,det)
    & varia(c55999,con)
    & sort(c56008,io)
    & sort(c56008,oa)
    & card(c56008,int1)
    & etype(c56008,int0)
    & fact(c56008,real)
    & gener(c56008,sp)
    & quant(c56008,one)
    & refer(c56008,det)
    & varia(c56008,con)
    & sort(luxusmarke_1_1,io)
    & sort(luxusmarke_1_1,oa)
    & card(luxusmarke_1_1,int1)
    & etype(luxusmarke_1_1,int0)
    & fact(luxusmarke_1_1,real)
    & gener(luxusmarke_1_1,ge)
    & quant(luxusmarke_1_1,one)
    & refer(luxusmarke_1_1,refer_c)
    & varia(luxusmarke_1_1,varia_c)
    & sort(c56019,d)
    & card(c56019,int1)
    & etype(c56019,int0)
    & fact(c56019,real)
    & gener(c56019,sp)
    & quant(c56019,one)
    & refer(c56019,det)
    & varia(c56019,con)
    & sort(c56020,na)
    & card(c56020,int1)
    & etype(c56020,int0)
    & fact(c56020,real)
    & gener(c56020,sp)
    & quant(c56020,one)
    & refer(c56020,indet)
    & varia(c56020,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(roll_0,fe)
    & sort(c56024,d)
    & card(c56024,int1)
    & etype(c56024,int0)
    & fact(c56024,real)
    & gener(c56024,sp)
    & quant(c56024,one)
    & refer(c56024,det)
    & varia(c56024,con)
    & sort(c56025,na)
    & card(c56025,int1)
    & etype(c56025,int0)
    & fact(c56025,real)
    & gener(c56025,sp)
    & quant(c56025,one)
    & refer(c56025,indet)
    & varia(c56025,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(royce_0,fe)
    & sort(c56046,ent)
    & card(c56046,card_c)
    & etype(c56046,etype_c)
    & fact(c56046,real)
    & gener(c56046,gener_c)
    & quant(c56046,quant_c)
    & refer(c56046,refer_c)
    & varia(c56046,varia_c)
    & sort(c55669,o)
    & card(c55669,int1)
    & etype(c55669,int0)
    & fact(c55669,real)
    & gener(c55669,sp)
    & quant(c55669,one)
    & refer(c55669,det)
    & varia(c55669,varia_c)
    & sort(luxus__1_1,io)
    & card(luxus__1_1,int1)
    & etype(luxus__1_1,int0)
    & fact(luxus__1_1,real)
    & gener(luxus__1_1,ge)
    & quant(luxus__1_1,one)
    & refer(luxus__1_1,refer_c)
    & varia(luxus__1_1,varia_c)
    & sort(marke_1_1,io)
    & sort(marke_1_1,oa)
    & card(marke_1_1,int1)
    & etype(marke_1_1,int0)
    & fact(marke_1_1,real)
    & gener(marke_1_1,ge)
    & quant(marke_1_1,one)
    & refer(marke_1_1,refer_c)
    & varia(marke_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
