%------------------------------------------------------------------------------
% File     : CSR115+59 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_news_1319_a19984_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.40 v9.0.0, 0.31 v8.2.0, 0.27 v8.1.0, 0.36 v7.5.0, 0.48 v7.4.0, 0.25 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.36 v6.4.0, 0.29 v6.3.0, 0.31 v6.2.0, 0.45 v6.1.0, 0.56 v6.0.0, 0.50 v5.5.0, 0.54 v5.4.0, 0.57 v5.3.0, 0.61 v5.2.0, 0.43 v5.0.0, 0.50 v4.1.0, 0.56 v4.0.1, 0.58 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10922 (   0 equ)
%            Maximal formula atoms :  218 (   1 avg)
%            Number of connectives :  733 (   0   ~;  18   |; 589   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  218 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-7 aty)
%            Number of functors    : 16660 (16660 usr;16659 con; 0-2 aty)
%            Number of variables   :  474 ( 405   !;  69   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_news_1319_a19984,conjecture,
    ? [X0,X1,X2,X3,X4,X5] :
      ( attr(X2,X1)
      & attr(X4,X5)
      & obj(X3,X0)
      & prop(X0,britisch__1_1)
      & sub(X1,name_1_1)
      & subs(X3,n374bernehmen_1_1) ) ).

fof(ave07_era5_synth_qa07_007_mira_news_1319_a19984,hypothesis,
    ( assoc(autobauer_1_1,auto__1_1)
    & sub(autobauer_1_1,fabrikant_1_1)
    & assoc(b__366rsenparkett_1_1,b__366rse_1_1)
    & sub(b__366rsenparkett_1_1,parkett_1_1)
    & attr(c103,c104)
    & sub(c103,stadt__1_1)
    & sub(c104,name_1_1)
    & val(c104,frankfurt_0)
    & obj(c113,c117)
    & subs(c113,annahme_1_1)
    & prop(c117,britisch__1_1)
    & sub(c117,autobauer_1_1)
    & sub(c122,rover_1_1)
    & prop(c130,bairisch_1_1)
    & sub(c130,bmw_1_1)
    & sub(c134,firmengruppe_1_1)
    & prop(c145,frankfurter_1_1)
    & sub(c145,b__366rsenparkett_1_1)
    & prop(c157,kr__344ftig_1_1)
    & sub(c157,get__366se_1_1)
    & tupl_p7(c2161,c113,c122,c130,c134,c145,c157)
    & assoc(frankfurter_1_1,c103)
    & sort(autobauer_1_1,d)
    & sort(autobauer_1_1,io)
    & card(autobauer_1_1,int1)
    & etype(autobauer_1_1,int0)
    & fact(autobauer_1_1,real)
    & gener(autobauer_1_1,ge)
    & quant(autobauer_1_1,one)
    & refer(autobauer_1_1,refer_c)
    & varia(autobauer_1_1,varia_c)
    & sort(auto__1_1,d)
    & card(auto__1_1,int1)
    & etype(auto__1_1,int0)
    & fact(auto__1_1,real)
    & gener(auto__1_1,ge)
    & quant(auto__1_1,one)
    & refer(auto__1_1,refer_c)
    & varia(auto__1_1,varia_c)
    & sort(fabrikant_1_1,d)
    & sort(fabrikant_1_1,io)
    & card(fabrikant_1_1,int1)
    & etype(fabrikant_1_1,int0)
    & fact(fabrikant_1_1,real)
    & gener(fabrikant_1_1,ge)
    & quant(fabrikant_1_1,one)
    & refer(fabrikant_1_1,refer_c)
    & varia(fabrikant_1_1,varia_c)
    & sort(b__366rsenparkett_1_1,d)
    & card(b__366rsenparkett_1_1,int1)
    & etype(b__366rsenparkett_1_1,int0)
    & fact(b__366rsenparkett_1_1,real)
    & gener(b__366rsenparkett_1_1,ge)
    & quant(b__366rsenparkett_1_1,one)
    & refer(b__366rsenparkett_1_1,refer_c)
    & varia(b__366rsenparkett_1_1,varia_c)
    & sort(b__366rse_1_1,d)
    & sort(b__366rse_1_1,io)
    & card(b__366rse_1_1,int1)
    & etype(b__366rse_1_1,int0)
    & fact(b__366rse_1_1,real)
    & gener(b__366rse_1_1,ge)
    & quant(b__366rse_1_1,one)
    & refer(b__366rse_1_1,refer_c)
    & varia(b__366rse_1_1,varia_c)
    & sort(parkett_1_1,d)
    & card(parkett_1_1,int1)
    & etype(parkett_1_1,int0)
    & fact(parkett_1_1,real)
    & gener(parkett_1_1,ge)
    & quant(parkett_1_1,one)
    & refer(parkett_1_1,refer_c)
    & varia(parkett_1_1,varia_c)
    & sort(c103,d)
    & sort(c103,io)
    & card(c103,int1)
    & etype(c103,int0)
    & fact(c103,real)
    & gener(c103,sp)
    & quant(c103,one)
    & refer(c103,det)
    & varia(c103,varia_c)
    & sort(c104,na)
    & card(c104,int1)
    & etype(c104,int0)
    & fact(c104,real)
    & gener(c104,sp)
    & quant(c104,one)
    & refer(c104,det)
    & varia(c104,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(frankfurt_0,fe)
    & sort(c113,ad)
    & card(c113,int1)
    & etype(c113,int0)
    & fact(c113,real)
    & gener(c113,sp)
    & quant(c113,one)
    & refer(c113,det)
    & varia(c113,con)
    & sort(c117,d)
    & card(c117,int1)
    & etype(c117,int0)
    & fact(c117,real)
    & gener(c117,sp)
    & quant(c117,one)
    & refer(c117,det)
    & varia(c117,con)
    & sort(annahme_1_1,ad)
    & card(annahme_1_1,int1)
    & etype(annahme_1_1,int0)
    & fact(annahme_1_1,real)
    & gener(annahme_1_1,ge)
    & quant(annahme_1_1,one)
    & refer(annahme_1_1,refer_c)
    & varia(annahme_1_1,varia_c)
    & sort(britisch__1_1,nq)
    & sort(c122,d)
    & card(c122,int1)
    & etype(c122,int0)
    & fact(c122,real)
    & gener(c122,gener_c)
    & quant(c122,one)
    & refer(c122,refer_c)
    & varia(c122,varia_c)
    & sort(rover_1_1,d)
    & card(rover_1_1,int1)
    & etype(rover_1_1,int0)
    & fact(rover_1_1,real)
    & gener(rover_1_1,ge)
    & quant(rover_1_1,one)
    & refer(rover_1_1,refer_c)
    & varia(rover_1_1,varia_c)
    & sort(c130,d)
    & card(c130,int1)
    & etype(c130,int0)
    & fact(c130,real)
    & gener(c130,sp)
    & quant(c130,one)
    & refer(c130,det)
    & varia(c130,con)
    & sort(bairisch_1_1,nq)
    & sort(bmw_1_1,d)
    & card(bmw_1_1,int1)
    & etype(bmw_1_1,int0)
    & fact(bmw_1_1,real)
    & gener(bmw_1_1,ge)
    & quant(bmw_1_1,one)
    & refer(bmw_1_1,refer_c)
    & varia(bmw_1_1,varia_c)
    & sort(c134,d)
    & sort(c134,io)
    & card(c134,int1)
    & etype(c134,int0)
    & fact(c134,real)
    & gener(c134,gener_c)
    & quant(c134,one)
    & refer(c134,refer_c)
    & varia(c134,varia_c)
    & sort(firmengruppe_1_1,d)
    & sort(firmengruppe_1_1,io)
    & card(firmengruppe_1_1,int1)
    & etype(firmengruppe_1_1,int0)
    & fact(firmengruppe_1_1,real)
    & gener(firmengruppe_1_1,ge)
    & quant(firmengruppe_1_1,one)
    & refer(firmengruppe_1_1,refer_c)
    & varia(firmengruppe_1_1,varia_c)
    & sort(c145,d)
    & card(c145,int1)
    & etype(c145,int0)
    & fact(c145,real)
    & gener(c145,sp)
    & quant(c145,one)
    & refer(c145,det)
    & varia(c145,con)
    & sort(frankfurter_1_1,gq)
    & sort(c157,d)
    & card(c157,int1)
    & etype(c157,int0)
    & fact(c157,real)
    & gener(c157,gener_c)
    & quant(c157,one)
    & refer(c157,refer_c)
    & varia(c157,varia_c)
    & sort(kr__344ftig_1_1,nq)
    & sort(get__366se_1_1,d)
    & card(get__366se_1_1,int1)
    & etype(get__366se_1_1,int0)
    & fact(get__366se_1_1,real)
    & gener(get__366se_1_1,ge)
    & quant(get__366se_1_1,one)
    & refer(get__366se_1_1,refer_c)
    & varia(get__366se_1_1,varia_c)
    & sort(c2161,ent)
    & card(c2161,card_c)
    & etype(c2161,etype_c)
    & fact(c2161,real)
    & gener(c2161,gener_c)
    & quant(c2161,quant_c)
    & refer(c2161,refer_c)
    & varia(c2161,varia_c) ) ).

%------------------------------------------------------------------------------
