%------------------------------------------------------------------------------
% File     : CSR115+55 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_news_1312_a19984_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.33 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.21 v7.5.0, 0.38 v7.4.0, 0.31 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.31 v6.2.0, 0.45 v6.1.0, 0.60 v6.0.0, 0.50 v5.5.0, 0.62 v5.4.0, 0.57 v5.3.0, 0.65 v5.2.0, 0.43 v5.0.0, 0.45 v4.1.0, 0.56 v4.0.1, 0.63 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10863 (   0 equ)
%            Maximal formula atoms :  159 (   1 avg)
%            Number of connectives :  674 (   0   ~;  18   |; 530   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  159 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-9 aty)
%            Number of functors    : 16655 (16655 usr;16654 con; 0-2 aty)
%            Number of variables   :  474 ( 405   !;  69   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_news_1312_a19984,conjecture,
    ? [X0,X1,X2,X3,X4,X5] :
      ( attr(X2,X1)
      & attr(X4,X5)
      & obj(X3,X0)
      & prop(X0,britisch__1_1)
      & sub(X0,firma_1_1)
      & sub(X1,name_1_1) ) ).

fof(ave07_era5_synth_qa07_007_mira_news_1312_a19984,hypothesis,
    ( sub(c50787,sich_1_1)
    & attr(c50825,c50826)
    & sub(c50825,firma_1_1)
    & sub(c50826,name_1_1)
    & val(c50826,rover_0)
    & prop(c50830,britisch__1_1)
    & sub(c50830,firma_1_1)
    & pred(c50848,abwart_1_1)
    & sub(c50852,tee__1_1)
    & prop(c50864,negativ_1_1)
    & sub(c50864,rat_1_1)
    & pred(c50870,aktion__344r_1_1)
    & tupl_p9(c51219,c50786,c50787,c50825,c50830,c50848,c50852,c50864,c50870)
    & sort(c50787,o)
    & card(c50787,int1)
    & etype(c50787,int0)
    & fact(c50787,real)
    & gener(c50787,gener_c)
    & quant(c50787,one)
    & refer(c50787,refer_c)
    & varia(c50787,varia_c)
    & sort(sich_1_1,o)
    & card(sich_1_1,int1)
    & etype(sich_1_1,int0)
    & fact(sich_1_1,real)
    & gener(sich_1_1,gener_c)
    & quant(sich_1_1,one)
    & refer(sich_1_1,refer_c)
    & varia(sich_1_1,varia_c)
    & sort(c50825,d)
    & sort(c50825,io)
    & card(c50825,int1)
    & etype(c50825,int0)
    & fact(c50825,real)
    & gener(c50825,sp)
    & quant(c50825,one)
    & refer(c50825,det)
    & varia(c50825,con)
    & sort(c50826,na)
    & card(c50826,int1)
    & etype(c50826,int0)
    & fact(c50826,real)
    & gener(c50826,sp)
    & quant(c50826,one)
    & refer(c50826,indet)
    & varia(c50826,varia_c)
    & sort(firma_1_1,d)
    & sort(firma_1_1,io)
    & card(firma_1_1,int1)
    & etype(firma_1_1,int0)
    & fact(firma_1_1,real)
    & gener(firma_1_1,ge)
    & quant(firma_1_1,one)
    & refer(firma_1_1,refer_c)
    & varia(firma_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(rover_0,fe)
    & sort(c50830,d)
    & sort(c50830,io)
    & card(c50830,int1)
    & etype(c50830,int0)
    & fact(c50830,real)
    & gener(c50830,sp)
    & quant(c50830,one)
    & refer(c50830,indet)
    & varia(c50830,varia_c)
    & sort(britisch__1_1,nq)
    & sort(c50848,o)
    & card(c50848,cons(x_constant,cons(int1,nil)))
    & etype(c50848,int1)
    & fact(c50848,real)
    & gener(c50848,gener_c)
    & quant(c50848,mult)
    & refer(c50848,indet)
    & varia(c50848,varia_c)
    & sort(abwart_1_1,o)
    & card(abwart_1_1,int1)
    & etype(abwart_1_1,int0)
    & fact(abwart_1_1,real)
    & gener(abwart_1_1,ge)
    & quant(abwart_1_1,one)
    & refer(abwart_1_1,refer_c)
    & varia(abwart_1_1,varia_c)
    & sort(c50852,s)
    & card(c50852,int1)
    & etype(c50852,int0)
    & fact(c50852,real)
    & gener(c50852,gener_c)
    & quant(c50852,one)
    & refer(c50852,refer_c)
    & varia(c50852,varia_c)
    & sort(tee__1_1,s)
    & card(tee__1_1,int1)
    & etype(tee__1_1,int0)
    & fact(tee__1_1,real)
    & gener(tee__1_1,ge)
    & quant(tee__1_1,one)
    & refer(tee__1_1,refer_c)
    & varia(tee__1_1,varia_c)
    & sort(c50864,ad)
    & sort(c50864,io)
    & card(c50864,int1)
    & etype(c50864,int0)
    & fact(c50864,nonreal)
    & gener(c50864,sp)
    & quant(c50864,one)
    & refer(c50864,refer_c)
    & varia(c50864,varia_c)
    & sort(negativ_1_1,nq)
    & sort(rat_1_1,ad)
    & sort(rat_1_1,io)
    & card(rat_1_1,int1)
    & etype(rat_1_1,int0)
    & fact(rat_1_1,real)
    & gener(rat_1_1,ge)
    & quant(rat_1_1,one)
    & refer(rat_1_1,refer_c)
    & varia(rat_1_1,varia_c)
    & sort(c50870,d)
    & sort(c50870,io)
    & card(c50870,cons(x_constant,cons(int1,nil)))
    & etype(c50870,int1)
    & fact(c50870,real)
    & gener(c50870,sp)
    & quant(c50870,mult)
    & refer(c50870,det)
    & varia(c50870,con)
    & sort(aktion__344r_1_1,d)
    & sort(aktion__344r_1_1,io)
    & card(aktion__344r_1_1,int1)
    & etype(aktion__344r_1_1,int0)
    & fact(aktion__344r_1_1,real)
    & gener(aktion__344r_1_1,ge)
    & quant(aktion__344r_1_1,one)
    & refer(aktion__344r_1_1,refer_c)
    & varia(aktion__344r_1_1,varia_c)
    & sort(c51219,ent)
    & card(c51219,card_c)
    & etype(c51219,etype_c)
    & fact(c51219,real)
    & gener(c51219,gener_c)
    & quant(c51219,quant_c)
    & refer(c51219,refer_c)
    & varia(c51219,varia_c)
    & sort(c50786,o)
    & card(c50786,int1)
    & etype(c50786,int0)
    & fact(c50786,real)
    & gener(c50786,sp)
    & quant(c50786,one)
    & refer(c50786,det)
    & varia(c50786,varia_c) ) ).

%------------------------------------------------------------------------------
