%------------------------------------------------------------------------------
% File     : CSR115+54 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_news_1309_a19984_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.40 v9.0.0, 0.25 v8.2.0, 0.27 v8.1.0, 0.29 v7.5.0, 0.43 v7.4.0, 0.31 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.31 v6.2.0, 0.45 v6.1.0, 0.64 v6.0.0, 0.50 v5.5.0, 0.62 v5.4.0, 0.61 v5.3.0, 0.70 v5.2.0, 0.43 v5.0.0, 0.55 v4.1.0, 0.67 v4.0.1, 0.63 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10845 (   0 equ)
%            Maximal formula atoms :  141 (   1 avg)
%            Number of connectives :  656 (   0   ~;  18   |; 512   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  141 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   88 (  88 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16656 (16656 usr;16655 con; 0-2 aty)
%            Number of variables   :  474 ( 405   !;  69   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_news_1309_a19984,conjecture,
    ? [X0,X1,X2,X3,X4,X5] :
      ( attr(X2,X1)
      & attr(X4,X5)
      & obj(X3,X0)
      & sub(X0,firma_1_1)
      & sub(X1,name_1_1)
      & val(X1,bmw_0) ) ).

fof(ave07_era5_synth_qa07_007_mira_news_1309_a19984,hypothesis,
    ( attr(c1341,c1342)
    & sub(c1341,firma_1_1)
    & sub(c1342,name_1_1)
    & val(c1342,rover_0)
    & attr(c1516,c1517)
    & sub(c1516,firma_1_1)
    & sub(c1517,name_1_1)
    & val(c1517,bmw_0)
    & pmod(c1524,zweit_1_1,engagement_1_1)
    & prop(c1532,britisch__1_1)
    & sub(c1532,gesellschaft_1_1)
    & bei(c1536,c1341)
    & equ(c3,c3)
    & loc(c3,c1536)
    & mode(c3,c1532)
    & prop(c3,gro__337_1_1)
    & subs(c3,c1524)
    & subs(c3,einstieg_1_1)
    & arg1(c855,c3)
    & arg2(c855,c3)
    & benf(c855,c1516)
    & subr(c855,equ_0)
    & sort(c1341,d)
    & sort(c1341,io)
    & card(c1341,int1)
    & etype(c1341,int0)
    & fact(c1341,real)
    & gener(c1341,sp)
    & quant(c1341,one)
    & refer(c1341,det)
    & varia(c1341,con)
    & sort(c1342,na)
    & card(c1342,int1)
    & etype(c1342,int0)
    & fact(c1342,real)
    & gener(c1342,sp)
    & quant(c1342,one)
    & refer(c1342,indet)
    & varia(c1342,varia_c)
    & sort(firma_1_1,d)
    & sort(firma_1_1,io)
    & card(firma_1_1,int1)
    & etype(firma_1_1,int0)
    & fact(firma_1_1,real)
    & gener(firma_1_1,ge)
    & quant(firma_1_1,one)
    & refer(firma_1_1,refer_c)
    & varia(firma_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(rover_0,fe)
    & sort(c1516,d)
    & sort(c1516,io)
    & card(c1516,int1)
    & etype(c1516,int0)
    & fact(c1516,real)
    & gener(c1516,sp)
    & quant(c1516,one)
    & refer(c1516,det)
    & varia(c1516,con)
    & sort(c1517,na)
    & card(c1517,int1)
    & etype(c1517,int0)
    & fact(c1517,real)
    & gener(c1517,sp)
    & quant(c1517,one)
    & refer(c1517,indet)
    & varia(c1517,varia_c)
    & sort(bmw_0,fe)
    & sort(c1524,ad)
    & card(c1524,int1)
    & etype(c1524,int0)
    & fact(c1524,real)
    & gener(c1524,ge)
    & quant(c1524,one)
    & refer(c1524,refer_c)
    & varia(c1524,varia_c)
    & sort(zweit_1_1,oq)
    & card(zweit_1_1,int2)
    & sort(engagement_1_1,ad)
    & card(engagement_1_1,int1)
    & etype(engagement_1_1,int0)
    & fact(engagement_1_1,real)
    & gener(engagement_1_1,ge)
    & quant(engagement_1_1,one)
    & refer(engagement_1_1,refer_c)
    & varia(engagement_1_1,varia_c)
    & sort(c1532,io)
    & card(c1532,int1)
    & etype(c1532,int1)
    & fact(c1532,real)
    & gener(c1532,sp)
    & quant(c1532,one)
    & refer(c1532,indet)
    & varia(c1532,varia_c)
    & sort(britisch__1_1,nq)
    & sort(gesellschaft_1_1,io)
    & card(gesellschaft_1_1,card_c)
    & etype(gesellschaft_1_1,int1)
    & fact(gesellschaft_1_1,real)
    & gener(gesellschaft_1_1,ge)
    & quant(gesellschaft_1_1,quant_c)
    & refer(gesellschaft_1_1,refer_c)
    & varia(gesellschaft_1_1,varia_c)
    & sort(c1536,l)
    & card(c1536,int1)
    & etype(c1536,int0)
    & fact(c1536,real)
    & gener(c1536,sp)
    & quant(c1536,one)
    & refer(c1536,det)
    & varia(c1536,con)
    & sort(c3,ad)
    & card(c3,int1)
    & etype(c3,int0)
    & fact(c3,real)
    & gener(c3,sp)
    & quant(c3,one)
    & refer(c3,det)
    & varia(c3,con)
    & sort(gro__337_1_1,mq)
    & sort(einstieg_1_1,ad)
    & card(einstieg_1_1,int1)
    & etype(einstieg_1_1,int0)
    & fact(einstieg_1_1,real)
    & gener(einstieg_1_1,ge)
    & quant(einstieg_1_1,one)
    & refer(einstieg_1_1,refer_c)
    & varia(einstieg_1_1,varia_c)
    & sort(c855,st)
    & fact(c855,real)
    & gener(c855,sp)
    & sort(equ_0,st)
    & fact(equ_0,real)
    & gener(equ_0,gener_c) ) ).

%------------------------------------------------------------------------------
