%------------------------------------------------------------------------------
% File     : CSR115+50 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_news_1295_a19984_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.40 v9.1.0, 0.33 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.21 v7.5.0, 0.29 v7.4.0, 0.25 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.23 v6.2.0, 0.36 v6.1.0, 0.56 v6.0.0, 0.50 v5.5.0, 0.58 v5.4.0, 0.52 v5.3.0, 0.61 v5.2.0, 0.36 v5.0.0, 0.45 v4.1.0, 0.50 v4.0.1, 0.53 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10884 (   0 equ)
%            Maximal formula atoms :  180 (   1 avg)
%            Number of connectives :  695 (   0   ~;  18   |; 551   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  180 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-5 aty)
%            Number of functors    : 16653 (16653 usr;16652 con; 0-2 aty)
%            Number of variables   :  474 ( 405   !;  69   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_news_1295_a19984,conjecture,
    ? [X0,X1,X2,X3,X4,X5] :
      ( attr(X2,X1)
      & attr(X4,X5)
      & sub(X0,firma_1_1)
      & sub(X1,name_1_1)
      & subs(X3,n374bernehmen_1_1)
      & val(X1,bmw_0) ) ).

fof(ave07_era5_synth_qa07_007_mira_news_1295_a19984,hypothesis,
    ( assoc(autobauer_1_1,auto__1_1)
    & sub(autobauer_1_1,fabrikant_1_1)
    & tupl_p5(c171,c18,c25,c73,c86)
    & attr(c18,c19)
    & sub(c18,kommission_1_1)
    & sub(c19,name_1_1)
    & val(c19,eu_0)
    & obj(c25,c55)
    & subs(c25,annahme_1_1)
    & attr(c55,c56)
    & prop(c55,britisch__1_1)
    & sub(c55,autobauer_1_1)
    & sub(c56,name_1_1)
    & val(c56,rover_0)
    & attr(c73,c74)
    & sub(c73,firma_1_1)
    & sub(c74,name_1_1)
    & val(c74,bmw_0)
    & attr(c86,c87)
    & sub(c86,stadt__1_1)
    & sub(c87,name_1_1)
    & val(c87,m__374nchen_0)
    & sort(autobauer_1_1,d)
    & sort(autobauer_1_1,io)
    & card(autobauer_1_1,int1)
    & etype(autobauer_1_1,int0)
    & fact(autobauer_1_1,real)
    & gener(autobauer_1_1,ge)
    & quant(autobauer_1_1,one)
    & refer(autobauer_1_1,refer_c)
    & varia(autobauer_1_1,varia_c)
    & sort(auto__1_1,d)
    & card(auto__1_1,int1)
    & etype(auto__1_1,int0)
    & fact(auto__1_1,real)
    & gener(auto__1_1,ge)
    & quant(auto__1_1,one)
    & refer(auto__1_1,refer_c)
    & varia(auto__1_1,varia_c)
    & sort(fabrikant_1_1,d)
    & sort(fabrikant_1_1,io)
    & card(fabrikant_1_1,int1)
    & etype(fabrikant_1_1,int0)
    & fact(fabrikant_1_1,real)
    & gener(fabrikant_1_1,ge)
    & quant(fabrikant_1_1,one)
    & refer(fabrikant_1_1,refer_c)
    & varia(fabrikant_1_1,varia_c)
    & sort(c171,ent)
    & card(c171,card_c)
    & etype(c171,etype_c)
    & fact(c171,real)
    & gener(c171,gener_c)
    & quant(c171,quant_c)
    & refer(c171,refer_c)
    & varia(c171,varia_c)
    & sort(c18,d)
    & sort(c18,io)
    & card(c18,int1)
    & etype(c18,int1)
    & fact(c18,real)
    & gener(c18,sp)
    & quant(c18,one)
    & refer(c18,det)
    & varia(c18,varia_c)
    & sort(c25,ad)
    & card(c25,int1)
    & etype(c25,int0)
    & fact(c25,real)
    & gener(c25,sp)
    & quant(c25,one)
    & refer(c25,det)
    & varia(c25,con)
    & sort(c73,d)
    & sort(c73,io)
    & card(c73,int1)
    & etype(c73,int0)
    & fact(c73,real)
    & gener(c73,sp)
    & quant(c73,one)
    & refer(c73,det)
    & varia(c73,con)
    & sort(c86,d)
    & sort(c86,io)
    & card(c86,int1)
    & etype(c86,int0)
    & fact(c86,real)
    & gener(c86,sp)
    & quant(c86,one)
    & refer(c86,det)
    & varia(c86,con)
    & sort(c19,na)
    & card(c19,int1)
    & etype(c19,int0)
    & fact(c19,real)
    & gener(c19,sp)
    & quant(c19,one)
    & refer(c19,det)
    & varia(c19,varia_c)
    & sort(kommission_1_1,d)
    & sort(kommission_1_1,io)
    & card(kommission_1_1,card_c)
    & etype(kommission_1_1,int1)
    & fact(kommission_1_1,real)
    & gener(kommission_1_1,ge)
    & quant(kommission_1_1,quant_c)
    & refer(kommission_1_1,refer_c)
    & varia(kommission_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(eu_0,fe)
    & sort(c55,d)
    & sort(c55,io)
    & card(c55,int1)
    & etype(c55,int0)
    & fact(c55,real)
    & gener(c55,sp)
    & quant(c55,one)
    & refer(c55,det)
    & varia(c55,con)
    & sort(annahme_1_1,ad)
    & card(annahme_1_1,int1)
    & etype(annahme_1_1,int0)
    & fact(annahme_1_1,real)
    & gener(annahme_1_1,ge)
    & quant(annahme_1_1,one)
    & refer(annahme_1_1,refer_c)
    & varia(annahme_1_1,varia_c)
    & sort(c56,na)
    & card(c56,int1)
    & etype(c56,int0)
    & fact(c56,real)
    & gener(c56,sp)
    & quant(c56,one)
    & refer(c56,indet)
    & varia(c56,varia_c)
    & sort(britisch__1_1,nq)
    & sort(rover_0,fe)
    & sort(c74,na)
    & card(c74,int1)
    & etype(c74,int0)
    & fact(c74,real)
    & gener(c74,sp)
    & quant(c74,one)
    & refer(c74,indet)
    & varia(c74,varia_c)
    & sort(firma_1_1,d)
    & sort(firma_1_1,io)
    & card(firma_1_1,int1)
    & etype(firma_1_1,int0)
    & fact(firma_1_1,real)
    & gener(firma_1_1,ge)
    & quant(firma_1_1,one)
    & refer(firma_1_1,refer_c)
    & varia(firma_1_1,varia_c)
    & sort(bmw_0,fe)
    & sort(c87,na)
    & card(c87,int1)
    & etype(c87,int0)
    & fact(c87,real)
    & gener(c87,sp)
    & quant(c87,one)
    & refer(c87,indet)
    & varia(c87,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(m__374nchen_0,fe) ) ).

%------------------------------------------------------------------------------
