%------------------------------------------------------------------------------
% File     : CSR115+44 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_news_1253_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.33 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.21 v7.5.0, 0.33 v7.4.0, 0.25 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.31 v6.2.0, 0.45 v6.1.0, 0.48 v6.0.0, 0.50 v5.4.0, 0.48 v5.3.0, 0.57 v5.2.0, 0.36 v5.0.0, 0.40 v4.1.0, 0.44 v4.0.1, 0.53 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10902 (   0 equ)
%            Maximal formula atoms :  195 (   1 avg)
%            Number of connectives :  713 (   0   ~;  18   |; 569   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  195 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-8 aty)
%            Number of functors    : 16660 (16660 usr;16659 con; 0-2 aty)
%            Number of variables   :  475 ( 405   !;  70   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_news_1253,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6] :
      ( attr(X0,X1)
      & attr(X3,X2)
      & attr(X5,X6)
      & obj(X4,X0)
      & sub(X1,name_1_1)
      & sub(X0,firma_1_1)
      & sub(X2,name_1_1)
      & val(X1,bmw_0)
      & val(X2,bmw_0) ) ).

fof(ave07_era5_synth_qa07_007_mira_news_1253,hypothesis,
    ( attr(c557,c558)
    & sub(c557,firma_1_1)
    & sub(c558,name_1_1)
    & val(c558,bmw_0)
    & attr(c564,c565)
    & sub(c564,mensch_1_1)
    & sub(c565,familiename_1_1)
    & val(c565,roll_0)
    & attr(c570,c571)
    & sub(c570,mensch_1_1)
    & sub(c571,familiename_1_1)
    & val(c571,royce_0)
    & pred(c572,kei_1_1)
    & subs(c573,einstieg_1_1)
    & prop(c582,britisch__1_1)
    & sub(c582,nobelfirma_1_1)
    & attr(c590,c591)
    & sub(c590,stadt__1_1)
    & sub(c591,name_1_1)
    & val(c591,london_0)
    & tupl_p8(c699,c557,c564,c570,c572,c573,c582,c590)
    & assoc(nobelfirma_1_1,gro__337m__374tig_1_1)
    & sub(nobelfirma_1_1,firma_1_1)
    & sort(c557,d)
    & sort(c557,io)
    & card(c557,int1)
    & etype(c557,int0)
    & fact(c557,real)
    & gener(c557,sp)
    & quant(c557,one)
    & refer(c557,det)
    & varia(c557,con)
    & sort(c558,na)
    & card(c558,int1)
    & etype(c558,int0)
    & fact(c558,real)
    & gener(c558,sp)
    & quant(c558,one)
    & refer(c558,indet)
    & varia(c558,varia_c)
    & sort(firma_1_1,d)
    & sort(firma_1_1,io)
    & card(firma_1_1,int1)
    & etype(firma_1_1,int0)
    & fact(firma_1_1,real)
    & gener(firma_1_1,ge)
    & quant(firma_1_1,one)
    & refer(firma_1_1,refer_c)
    & varia(firma_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(bmw_0,fe)
    & sort(c564,d)
    & card(c564,int1)
    & etype(c564,int0)
    & fact(c564,real)
    & gener(c564,sp)
    & quant(c564,one)
    & refer(c564,det)
    & varia(c564,con)
    & sort(c565,na)
    & card(c565,int1)
    & etype(c565,int0)
    & fact(c565,real)
    & gener(c565,sp)
    & quant(c565,one)
    & refer(c565,indet)
    & varia(c565,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(roll_0,fe)
    & sort(c570,d)
    & card(c570,int1)
    & etype(c570,int0)
    & fact(c570,real)
    & gener(c570,sp)
    & quant(c570,one)
    & refer(c570,det)
    & varia(c570,con)
    & sort(c571,na)
    & card(c571,int1)
    & etype(c571,int0)
    & fact(c571,real)
    & gener(c571,sp)
    & quant(c571,one)
    & refer(c571,indet)
    & varia(c571,varia_c)
    & sort(royce_0,fe)
    & sort(c572,o)
    & card(c572,cons(x_constant,cons(int1,nil)))
    & etype(c572,int1)
    & fact(c572,real)
    & gener(c572,gener_c)
    & quant(c572,mult)
    & refer(c572,indet)
    & varia(c572,varia_c)
    & sort(kei_1_1,o)
    & card(kei_1_1,int1)
    & etype(kei_1_1,int0)
    & fact(kei_1_1,real)
    & gener(kei_1_1,ge)
    & quant(kei_1_1,one)
    & refer(kei_1_1,refer_c)
    & varia(kei_1_1,varia_c)
    & sort(c573,ad)
    & card(c573,int1)
    & etype(c573,int0)
    & fact(c573,real)
    & gener(c573,gener_c)
    & quant(c573,one)
    & refer(c573,refer_c)
    & varia(c573,varia_c)
    & sort(einstieg_1_1,ad)
    & card(einstieg_1_1,int1)
    & etype(einstieg_1_1,int0)
    & fact(einstieg_1_1,real)
    & gener(einstieg_1_1,ge)
    & quant(einstieg_1_1,one)
    & refer(einstieg_1_1,refer_c)
    & varia(einstieg_1_1,varia_c)
    & sort(c582,d)
    & sort(c582,io)
    & card(c582,int1)
    & etype(c582,int0)
    & fact(c582,real)
    & gener(c582,sp)
    & quant(c582,one)
    & refer(c582,det)
    & varia(c582,con)
    & sort(britisch__1_1,nq)
    & sort(nobelfirma_1_1,d)
    & sort(nobelfirma_1_1,io)
    & card(nobelfirma_1_1,int1)
    & etype(nobelfirma_1_1,int0)
    & fact(nobelfirma_1_1,real)
    & gener(nobelfirma_1_1,ge)
    & quant(nobelfirma_1_1,one)
    & refer(nobelfirma_1_1,refer_c)
    & varia(nobelfirma_1_1,varia_c)
    & sort(c590,d)
    & sort(c590,io)
    & card(c590,int1)
    & etype(c590,int0)
    & fact(c590,real)
    & gener(c590,sp)
    & quant(c590,one)
    & refer(c590,det)
    & varia(c590,con)
    & sort(c591,na)
    & card(c591,int1)
    & etype(c591,int0)
    & fact(c591,real)
    & gener(c591,sp)
    & quant(c591,one)
    & refer(c591,indet)
    & varia(c591,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(london_0,fe)
    & sort(c699,ent)
    & card(c699,card_c)
    & etype(c699,etype_c)
    & fact(c699,real)
    & gener(c699,gener_c)
    & quant(c699,quant_c)
    & refer(c699,refer_c)
    & varia(c699,varia_c)
    & sort(gro__337m__374tig_1_1,nq) ) ).

%------------------------------------------------------------------------------
