%------------------------------------------------------------------------------
% File     : CSR115+39 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_news_1241_a19984_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.25 v9.1.0, 0.20 v9.0.0, 0.19 v8.2.0, 0.13 v8.1.0, 0.14 v7.5.0, 0.24 v7.4.0, 0.19 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.21 v6.4.0, 0.14 v6.3.0, 0.23 v6.2.0, 0.27 v6.1.0, 0.48 v6.0.0, 0.50 v5.4.0, 0.48 v5.3.0, 0.57 v5.2.0, 0.36 v5.0.0, 0.40 v4.1.0, 0.44 v4.0.1, 0.42 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10860 (   0 equ)
%            Maximal formula atoms :  156 (   1 avg)
%            Number of connectives :  671 (   0   ~;  18   |; 527   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  156 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   86 (  86 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16653 (16653 usr;16652 con; 0-2 aty)
%            Number of variables   :  474 ( 405   !;  69   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_news_1241_a19984,conjecture,
    ? [X0,X1,X2,X3,X4,X5] :
      ( agt(X3,X2)
      & attr(X2,X1)
      & attr(X4,X5)
      & sub(X0,firma_1_1)
      & sub(X1,name_1_1)
      & val(X1,bmw_0) ) ).

fof(ave07_era5_synth_qa07_007_mira_news_1241_a19984,hypothesis,
    ( assoc(autobauer_1_1,auto__1_1)
    & sub(autobauer_1_1,fabrikant_1_1)
    & attr(c788,c789)
    & sub(c788,firma_1_1)
    & sub(c789,name_1_1)
    & val(c789,bmw_0)
    & sub(c791,abschlu__337_1_1)
    & assoc(c792,c791)
    & sub(c792,ja_nuar_1_1)
    & subs(c799,ankauf__1_1)
    & agt(c840,c788)
    & mcont(c840,c799)
    & subs(c840,bekanntgeben_1_1)
    & temp(c840,c792)
    & attch(c842,c799)
    & attr(c842,c843)
    & prop(c842,britisch__1_1)
    & sub(c842,autobauer_1_1)
    & sub(c843,name_1_1)
    & val(c843,rover_0)
    & sort(autobauer_1_1,d)
    & sort(autobauer_1_1,io)
    & card(autobauer_1_1,int1)
    & etype(autobauer_1_1,int0)
    & fact(autobauer_1_1,real)
    & gener(autobauer_1_1,ge)
    & quant(autobauer_1_1,one)
    & refer(autobauer_1_1,refer_c)
    & varia(autobauer_1_1,varia_c)
    & sort(auto__1_1,d)
    & card(auto__1_1,int1)
    & etype(auto__1_1,int0)
    & fact(auto__1_1,real)
    & gener(auto__1_1,ge)
    & quant(auto__1_1,one)
    & refer(auto__1_1,refer_c)
    & varia(auto__1_1,varia_c)
    & sort(fabrikant_1_1,d)
    & sort(fabrikant_1_1,io)
    & card(fabrikant_1_1,int1)
    & etype(fabrikant_1_1,int0)
    & fact(fabrikant_1_1,real)
    & gener(fabrikant_1_1,ge)
    & quant(fabrikant_1_1,one)
    & refer(fabrikant_1_1,refer_c)
    & varia(fabrikant_1_1,varia_c)
    & sort(c788,d)
    & sort(c788,io)
    & card(c788,int1)
    & etype(c788,int0)
    & fact(c788,real)
    & gener(c788,sp)
    & quant(c788,one)
    & refer(c788,det)
    & varia(c788,con)
    & sort(c789,na)
    & card(c789,int1)
    & etype(c789,int0)
    & fact(c789,real)
    & gener(c789,sp)
    & quant(c789,one)
    & refer(c789,indet)
    & varia(c789,varia_c)
    & sort(firma_1_1,d)
    & sort(firma_1_1,io)
    & card(firma_1_1,int1)
    & etype(firma_1_1,int0)
    & fact(firma_1_1,real)
    & gener(firma_1_1,ge)
    & quant(firma_1_1,one)
    & refer(firma_1_1,refer_c)
    & varia(firma_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(bmw_0,fe)
    & sort(c791,ad)
    & sort(c791,io)
    & card(c791,int1)
    & etype(c791,int0)
    & fact(c791,real)
    & gener(c791,gener_c)
    & quant(c791,one)
    & refer(c791,refer_c)
    & varia(c791,varia_c)
    & sort(abschlu__337_1_1,ad)
    & sort(abschlu__337_1_1,io)
    & card(abschlu__337_1_1,int1)
    & etype(abschlu__337_1_1,int0)
    & fact(abschlu__337_1_1,real)
    & gener(abschlu__337_1_1,ge)
    & quant(abschlu__337_1_1,one)
    & refer(abschlu__337_1_1,refer_c)
    & varia(abschlu__337_1_1,varia_c)
    & sort(c792,ta)
    & card(c792,int1)
    & etype(c792,int0)
    & fact(c792,real)
    & gener(c792,sp)
    & quant(c792,one)
    & refer(c792,refer_c)
    & varia(c792,varia_c)
    & sort(ja_nuar_1_1,ta)
    & card(ja_nuar_1_1,int1)
    & etype(ja_nuar_1_1,int0)
    & fact(ja_nuar_1_1,real)
    & gener(ja_nuar_1_1,ge)
    & quant(ja_nuar_1_1,one)
    & refer(ja_nuar_1_1,refer_c)
    & varia(ja_nuar_1_1,varia_c)
    & sort(c799,ad)
    & card(c799,int1)
    & etype(c799,int0)
    & fact(c799,hypo)
    & gener(c799,sp)
    & quant(c799,one)
    & refer(c799,det)
    & varia(c799,con)
    & sort(ankauf__1_1,ad)
    & card(ankauf__1_1,int1)
    & etype(ankauf__1_1,int0)
    & fact(ankauf__1_1,real)
    & gener(ankauf__1_1,ge)
    & quant(ankauf__1_1,one)
    & refer(ankauf__1_1,refer_c)
    & varia(ankauf__1_1,varia_c)
    & sort(c840,da)
    & fact(c840,real)
    & gener(c840,sp)
    & sort(bekanntgeben_1_1,da)
    & fact(bekanntgeben_1_1,real)
    & gener(bekanntgeben_1_1,ge)
    & sort(c842,d)
    & sort(c842,io)
    & card(c842,int1)
    & etype(c842,int0)
    & fact(c842,real)
    & gener(c842,sp)
    & quant(c842,one)
    & refer(c842,det)
    & varia(c842,con)
    & sort(c843,na)
    & card(c843,int1)
    & etype(c843,int0)
    & fact(c843,real)
    & gener(c843,sp)
    & quant(c843,one)
    & refer(c843,indet)
    & varia(c843,varia_c)
    & sort(britisch__1_1,nq)
    & sort(rover_0,fe) ) ).

%------------------------------------------------------------------------------
