%------------------------------------------------------------------------------
% File     : CSR115+38 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_news_1233_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.33 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.21 v7.5.0, 0.33 v7.4.0, 0.25 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.23 v6.2.0, 0.36 v6.1.0, 0.56 v6.0.0, 0.50 v5.5.0, 0.58 v5.4.0, 0.57 v5.3.0, 0.65 v5.2.0, 0.36 v5.0.0, 0.50 v4.1.0, 0.56 v4.0.1, 0.63 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10993 (   0 equ)
%            Maximal formula atoms :  286 (   1 avg)
%            Number of connectives :  804 (   0   ~;  18   |; 660   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  286 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   88 (  88 usr;   0 prp; 2-8 aty)
%            Number of functors    : 16672 (16672 usr;16671 con; 0-2 aty)
%            Number of variables   :  475 ( 405   !;  70   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_news_1233,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6] :
      ( attr(X0,X1)
      & attr(X3,X2)
      & attr(X5,X6)
      & obj(X4,X0)
      & sub(X1,name_1_1)
      & sub(X0,firma_1_1)
      & sub(X2,name_1_1)
      & val(X1,bmw_0)
      & val(X2,bmw_0) ) ).

fof(ave07_era5_synth_qa07_007_mira_news_1233,hypothesis,
    ( attr(c11,c12)
    & sub(c11,stadt__1_1)
    & sub(c12,name_1_1)
    & val(c12,m__374nchen_0)
    & attr(c17,c18)
    & attr(c17,c19)
    & sub(c18,tag_1_1)
    & val(c18,c15)
    & sub(c19,monat_1_1)
    & val(c19,c16)
    & prop(c2226,c2204)
    & pred(c2230,maschinenfabrikant_1_1)
    & prop(c2230,britisch__1_1)
    & attr(c2836,c2837)
    & sub(c2836,firma_1_1)
    & sub(c2837,name_1_1)
    & val(c2837,bmw_0)
    & attr(c2840,c2841)
    & sub(c2840,mensch_1_1)
    & sub(c2841,familiename_1_1)
    & val(c2841,roll_0)
    & sub(c2842,gmbh__1_1)
    & attr(c2844,c2845)
    & sub(c2844,mensch_1_1)
    & sub(c2845,familiename_1_1)
    & val(c2845,royce_0)
    & comp(c2868,fix_1_2,c2206)
    & tupl(c31,c11,c17)
    & tupl_p8(c3436,c2226,c2230,c2836,c2840,c2844,c2842,c2868)
    & chsp2(gr__374nden_1_2,c2204)
    & assoc(maschinenfabrikant_1_1,aggregat_1_1)
    & sub(maschinenfabrikant_1_1,fabrikant_1_1)
    & chsp2(planen_1_1,c2206)
    & sort(c11,d)
    & sort(c11,io)
    & card(c11,int1)
    & etype(c11,int0)
    & fact(c11,real)
    & gener(c11,sp)
    & quant(c11,one)
    & refer(c11,det)
    & varia(c11,con)
    & sort(c12,na)
    & card(c12,int1)
    & etype(c12,int0)
    & fact(c12,real)
    & gener(c12,sp)
    & quant(c12,one)
    & refer(c12,indet)
    & varia(c12,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(m__374nchen_0,fe)
    & sort(c17,t)
    & card(c17,int1)
    & etype(c17,int0)
    & fact(c17,real)
    & gener(c17,sp)
    & quant(c17,one)
    & refer(c17,det)
    & varia(c17,con)
    & sort(c18,me)
    & sort(c18,oa)
    & sort(c18,ta)
    & card(c18,card_c)
    & etype(c18,etype_c)
    & fact(c18,real)
    & gener(c18,sp)
    & quant(c18,quant_c)
    & refer(c18,refer_c)
    & varia(c18,varia_c)
    & sort(c19,me)
    & sort(c19,oa)
    & sort(c19,ta)
    & card(c19,card_c)
    & etype(c19,etype_c)
    & fact(c19,real)
    & gener(c19,sp)
    & quant(c19,quant_c)
    & refer(c19,refer_c)
    & varia(c19,varia_c)
    & sort(tag_1_1,me)
    & sort(tag_1_1,oa)
    & sort(tag_1_1,ta)
    & card(tag_1_1,card_c)
    & etype(tag_1_1,etype_c)
    & fact(tag_1_1,real)
    & gener(tag_1_1,ge)
    & quant(tag_1_1,quant_c)
    & refer(tag_1_1,refer_c)
    & varia(tag_1_1,varia_c)
    & sort(c15,nu)
    & card(c15,int3)
    & sort(monat_1_1,me)
    & sort(monat_1_1,oa)
    & sort(monat_1_1,ta)
    & card(monat_1_1,card_c)
    & etype(monat_1_1,etype_c)
    & fact(monat_1_1,real)
    & gener(monat_1_1,ge)
    & quant(monat_1_1,quant_c)
    & refer(monat_1_1,refer_c)
    & varia(monat_1_1,varia_c)
    & sort(c16,nu)
    & card(c16,int5)
    & sort(c2226,ab)
    & card(c2226,int1990)
    & etype(c2226,int1)
    & fact(c2226,real)
    & gener(c2226,gener_c)
    & quant(c2226,nfquant)
    & refer(c2226,refer_c)
    & varia(c2226,varia_c)
    & sort(c2204,tq)
    & sort(c2230,d)
    & sort(c2230,io)
    & card(c2230,cons(x_constant,cons(int1,nil)))
    & etype(c2230,int1)
    & fact(c2230,real)
    & gener(c2230,gener_c)
    & quant(c2230,mult)
    & refer(c2230,refer_c)
    & varia(c2230,varia_c)
    & sort(maschinenfabrikant_1_1,d)
    & sort(maschinenfabrikant_1_1,io)
    & card(maschinenfabrikant_1_1,int1)
    & etype(maschinenfabrikant_1_1,int0)
    & fact(maschinenfabrikant_1_1,real)
    & gener(maschinenfabrikant_1_1,ge)
    & quant(maschinenfabrikant_1_1,one)
    & refer(maschinenfabrikant_1_1,refer_c)
    & varia(maschinenfabrikant_1_1,varia_c)
    & sort(britisch__1_1,nq)
    & sort(c2836,d)
    & sort(c2836,io)
    & card(c2836,int1)
    & etype(c2836,int0)
    & fact(c2836,real)
    & gener(c2836,sp)
    & quant(c2836,one)
    & refer(c2836,det)
    & varia(c2836,con)
    & sort(c2837,na)
    & card(c2837,int1)
    & etype(c2837,int0)
    & fact(c2837,real)
    & gener(c2837,sp)
    & quant(c2837,one)
    & refer(c2837,indet)
    & varia(c2837,varia_c)
    & sort(firma_1_1,d)
    & sort(firma_1_1,io)
    & card(firma_1_1,int1)
    & etype(firma_1_1,int0)
    & fact(firma_1_1,real)
    & gener(firma_1_1,ge)
    & quant(firma_1_1,one)
    & refer(firma_1_1,refer_c)
    & varia(firma_1_1,varia_c)
    & sort(bmw_0,fe)
    & sort(c2840,d)
    & card(c2840,int1)
    & etype(c2840,int0)
    & fact(c2840,real)
    & gener(c2840,sp)
    & quant(c2840,one)
    & refer(c2840,det)
    & varia(c2840,con)
    & sort(c2841,na)
    & card(c2841,int1)
    & etype(c2841,int0)
    & fact(c2841,real)
    & gener(c2841,sp)
    & quant(c2841,one)
    & refer(c2841,indet)
    & varia(c2841,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(roll_0,fe)
    & sort(c2842,d)
    & sort(c2842,io)
    & card(c2842,int1)
    & etype(c2842,int1)
    & fact(c2842,real)
    & gener(c2842,gener_c)
    & quant(c2842,one)
    & refer(c2842,refer_c)
    & varia(c2842,varia_c)
    & sort(gmbh__1_1,d)
    & sort(gmbh__1_1,io)
    & card(gmbh__1_1,card_c)
    & etype(gmbh__1_1,int1)
    & fact(gmbh__1_1,real)
    & gener(gmbh__1_1,ge)
    & quant(gmbh__1_1,quant_c)
    & refer(gmbh__1_1,refer_c)
    & varia(gmbh__1_1,varia_c)
    & sort(c2844,d)
    & card(c2844,int1)
    & etype(c2844,int0)
    & fact(c2844,real)
    & gener(c2844,sp)
    & quant(c2844,one)
    & refer(c2844,det)
    & varia(c2844,con)
    & sort(c2845,na)
    & card(c2845,int1)
    & etype(c2845,int0)
    & fact(c2845,real)
    & gener(c2845,sp)
    & quant(c2845,one)
    & refer(c2845,indet)
    & varia(c2845,varia_c)
    & sort(royce_0,fe)
    & sort(c2868,tq)
    & sort(fix_1_2,mq)
    & sort(c2206,tq)
    & sort(c31,ent)
    & card(c31,card_c)
    & etype(c31,etype_c)
    & fact(c31,real)
    & gener(c31,gener_c)
    & quant(c31,quant_c)
    & refer(c31,refer_c)
    & varia(c31,varia_c)
    & sort(c3436,ent)
    & card(c3436,card_c)
    & etype(c3436,etype_c)
    & fact(c3436,real)
    & gener(c3436,gener_c)
    & quant(c3436,quant_c)
    & refer(c3436,refer_c)
    & varia(c3436,varia_c)
    & sort(gr__374nden_1_2,da)
    & fact(gr__374nden_1_2,real)
    & gener(gr__374nden_1_2,ge)
    & sort(aggregat_1_1,d)
    & sort(aggregat_1_1,io)
    & card(aggregat_1_1,int1)
    & etype(aggregat_1_1,int0)
    & fact(aggregat_1_1,real)
    & gener(aggregat_1_1,ge)
    & quant(aggregat_1_1,one)
    & refer(aggregat_1_1,refer_c)
    & varia(aggregat_1_1,varia_c)
    & sort(fabrikant_1_1,d)
    & sort(fabrikant_1_1,io)
    & card(fabrikant_1_1,int1)
    & etype(fabrikant_1_1,int0)
    & fact(fabrikant_1_1,real)
    & gener(fabrikant_1_1,ge)
    & quant(fabrikant_1_1,one)
    & refer(fabrikant_1_1,refer_c)
    & varia(fabrikant_1_1,varia_c)
    & sort(planen_1_1,da)
    & fact(planen_1_1,real)
    & gener(planen_1_1,ge) ) ).

%------------------------------------------------------------------------------
